/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.rmi.cluster;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.Member;
import jet.server.api.rmi.cluster.RemoteClusterService;
import jet.server.api.rmi.cluster.RemoteLoadBalancer;
import jet.server.jrrmisvr.cluster.JRLoadBalancer;
import jet.server.jrserver.rmi.cluster.JRRemoteLoadBalancer;

public class JRRemoteClusterService
extends UnicastRemoteObject
implements RemoteClusterService {
    private ClusterService SEDU = null;

    public JRRemoteClusterService(ClusterService clusterService) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.SEDU = clusterService;
    }

    @Override
    public String getClusterName() throws RemoteException {
        if (this.SEDU != null) {
            return this.SEDU.getClusterName();
        }
        return null;
    }

    @Override
    public Member[] getAllMembers() throws RemoteException, ClusterException {
        if (this.SEDU != null) {
            return this.SEDU.getAllMembers();
        }
        return null;
    }

    @Override
    public Member getLocalMember() throws RemoteException {
        if (this.SEDU != null) {
            return this.SEDU.getLocalMember();
        }
        return null;
    }

    @Override
    public Member getAdminMember() throws RemoteException, ClusterException {
        if (this.SEDU != null) {
            return this.SEDU.getAdminMember();
        }
        return null;
    }

    @Override
    public RemoteLoadBalancer getDefaultLoadBalancer() throws RemoteException {
        if (this.SEDU != null) {
            return new JRRemoteLoadBalancer(this.SEDU.getDefaultLoadBalancer());
        }
        return null;
    }

    @Override
    public void setDefaultLoadBalancer(RemoteLoadBalancer remoteLoadBalancer) throws RemoteException {
        if (this.SEDU != null) {
            this.SEDU.setDefaultLoadBalancer(new JRLoadBalancer(remoteLoadBalancer));
        }
    }

    @Override
    public synchronized Member getMember() throws RemoteException {
        if (this.SEDU != null) {
            return this.SEDU.getMember();
        }
        return null;
    }

    @Override
    public void registerLocalMember() throws RemoteException, ClusterException {
        if (this.SEDU != null) {
            this.SEDU.registerLocalMember();
        }
    }

    @Override
    public void removeLocalMember() throws RemoteException, ClusterException {
        if (this.SEDU != null) {
            this.SEDU.removeLocalMember();
        }
    }

    @Override
    public boolean isAdminServerCrashed() throws RemoteException {
        if (this.SEDU != null) {
            return this.SEDU.isAdminServerCrashed();
        }
        return false;
    }

    @Override
    public boolean isTaskQueueFull(int n) throws RemoteException {
        if (this.SEDU != null) {
            return this.SEDU.isTaskQueueFull(n);
        }
        return false;
    }
}

