/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.service;

import com.jinfonet.common.impl.DriverConfigFactory;
import com.jinfonet.web.service.WebOSServiceImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jet.dataengine.api.DSException;
import jet.dataservice.api.ManagedServiceFactory;
import jet.server.ServerEnv;
import jet.server.api.admin.security.JOrganization;
import jet.server.intf.security.PrincipalListener;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.resstore.impl.JRServerResourceStoreFactory;
import jet.server.service.ManagedService;
import jet.server.service.ServiceEnv;
import jet.server.service.ServiceManager;

public class JRServiceManager
implements ServiceManager,
PrincipalListener {
    private JRRptServer SEDU;
    private String add;
    private ServiceEnv addPrincipalListener;
    private Map append = new HashMap();

    public JRServiceManager(JRRptServer jRRptServer) {
        this.SEDU = jRRptServer;
        this.createManagedDataService();
    }

    public void start() {
        for (List list : this.append.values()) {
            for (ManagedService managedService : list) {
                managedService.start();
            }
        }
    }

    public void quit() {
        for (List list : this.append.values()) {
            for (ManagedService managedService : list) {
                managedService.stop();
            }
        }
    }

    private List SEDU(String string) {
        return (List)this.append.get(string);
    }

    @Override
    public List listServices(String string) {
        return this.listServices(null, string);
    }

    @Override
    public List listServices(String string, String string2) {
        List list;
        ServiceLogger.logDebug("JRServiceManager: listServices(" + string + ", " + string2 + ")......", 6);
        if (string != null) {
            string2 = string + "$" + string2;
        }
        if ((list = this.SEDU(string2)) == null) {
            ServiceLogger.logDebug("JRServiceManager: return null.(type is " + string2 + ")", 6);
            return null;
        }
        ArrayList<ManagedService> arrayList = new ArrayList<ManagedService>();
        for (ManagedService managedService : list) {
            arrayList.add(managedService);
        }
        ServiceLogger.logDebug("JRServiceManager: return list size is " + arrayList.size() + ".(type is " + string2 + ")", 6);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ManagedService managedService, final Properties properties, String string) {
        ServiceLogger.logDebug("ServiceManager: regsterService[" + managedService + "], .", 6);
        try {
            ServiceLogger.logDebug("ServiceManager: regsterService[type=" + managedService.getType() + ", org=" + string + "].", 6);
            ServiceEnv serviceEnv = new ServiceEnv(){

                @Override
                public Properties getConfig() {
                    Object object;
                    Properties properties3 = new Properties();
                    Properties properties2 = JRServiceManager.this.addPrincipalListener.getConfig();
                    if (properties2 != null) {
                        for (Object object2 : properties2.keySet()) {
                            object = properties2.get(object2);
                            if (object == null) continue;
                            properties3.put(object2, object);
                        }
                    }
                    if (properties != null) {
                        for (Object object2 : properties.keySet()) {
                            object = properties.get(object2);
                            if (object == null) continue;
                            properties3.put(object2, object);
                        }
                    }
                    return properties3;
                }

                @Override
                public JRRptServer getRptServer() {
                    return JRServiceManager.this.addPrincipalListener.getRptServer();
                }

                @Override
                public String getTempPath() {
                    return JRServiceManager.this.addPrincipalListener.getTempPath();
                }

                @Override
                public String getReportHome() {
                    return JRServiceManager.this.addPrincipalListener.getReportHome();
                }
            };
            managedService.init(serviceEnv);
            Map map = this.append;
            synchronized (map) {
                ArrayList<ManagedService> arrayList;
                String string2 = managedService.getType();
                if (string2 == null || string2.trim().length() == 0) {
                    ServiceLogger.logError("ServiceManager: managed service type is null or empty string.", 2);
                    return;
                }
                if (string != null) {
                    string2 = string + "$" + string2;
                }
                if ((arrayList = (ArrayList<ManagedService>)this.append.get(string2)) == null) {
                    arrayList = new ArrayList<ManagedService>();
                    this.append.put(string2, arrayList);
                }
                arrayList.add(managedService);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 2);
        }
    }

    private void addPrincipalListener(String string) {
        ServiceLogger.logDebug("ServiceManager: regesterDataService..... org: " + string, 6);
        Properties properties = new Properties();
        properties.put("CacheZip", String.valueOf(string == null ? ServerEnv.getCompressIO() : this.SEDU.getAdminService().getConfigService().getOrgConfiguration(string).isCompressSwapFiles()));
        properties.put("SingleTread", String.valueOf(ServerEnv.getEngineSingleThread()));
        properties.put("ThreadPriority", String.valueOf(ServerEnv.getEnginePriority()));
        properties.put("JdbcDriversConfig", DriverConfigFactory.getJdbcDriversConfig());
        JRServerResourceStoreFactory jRServerResourceStoreFactory = JRServerResourceStoreFactory.getInstance();
        properties.put("ResourceStore", jRServerResourceStoreFactory.getResourceStore(string));
        int n = -1;
        try {
            n = ServerEnv.getServerProps().getProperty("engine.sort.buffer_size", -1);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        properties.put("SortMemorySize", (Object)n);
        try {
            this.add(ManagedServiceFactory.createManagedDataService(), properties, string);
        }
        catch (DSException dSException) {
            ServiceLogger.logError(dSException, 3);
        }
        ServiceLogger.logDebug("ServiceManager: regesterDataService end.", 6);
    }

    private void append() {
        ServiceLogger.logDebug("ServiceManager: registerWebOSService.....", 6);
        Properties properties = new Properties();
        this.add(WebOSServiceImpl.getInstance(), properties, null);
        ServiceLogger.logDebug("ServiceManager: registerWebOSService end.", 6);
    }

    private void createManagedDataService() {
        this.add = ServerEnv.getReportHome();
        this.addPrincipalListener = new ServiceEnv(){

            @Override
            public Properties getConfig() {
                return System.getProperties();
            }

            @Override
            public JRRptServer getRptServer() {
                return JRServiceManager.this.SEDU;
            }

            @Override
            public String getTempPath() {
                return ServerEnv.isSharedTempDir() ? ServerEnv.getSharedTempDir() : JRServiceManager.this.add + "temp" + File.separator;
            }

            @Override
            public String getReportHome() {
                return JRServiceManager.this.add;
            }
        };
        this.addPrincipalListener(null);
        SecurityService securityService = UserDataToolkit.getSecurityService(ServerEnv.getActiveRealm());
        for (JOrganization jOrganization : securityService.getOrganizations()) {
            this.addPrincipalListener(jOrganization.getName());
        }
        this.append();
        securityService.addPrincipalListener(this);
    }

    @Override
    public void removePrincipal(String string, int n) {
    }

    @Override
    public void addOrganization(String string) {
        this.addPrincipalListener(string);
    }

    @Override
    public void removeOrganization(String string) {
    }
}

