/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.event;

import java.util.Properties;
import jet.server.event.EventHandler;
import jet.server.event.TopicEvent;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.MonitorService;
import jet.server.monitor.event.EventType;
import jet.server.monitor.jrmon.cluster.JRClusterMonitor;
import jet.server.monitor.jrmon.intf.ClusterMonitor;
import jet.server.monitor.jrmon.task.JRTaskMonitor;

public class MonitorEventHandler
implements EventHandler,
EventType {
    private MonitorService SEDU = null;
    private ClusterMonitor addServerStatus = null;

    public MonitorEventHandler() {
    }

    public MonitorEventHandler(MonitorService monitorService) {
        this.SEDU = monitorService;
    }

    public MonitorEventHandler(ClusterMonitor clusterMonitor) {
        this.addServerStatus = clusterMonitor;
    }

    @Override
    public void process(TopicEvent topicEvent) {
        String string = topicEvent.getTopic();
        ServiceLogger.print("EventSystem:: MonitorEventHandler, process " + topicEvent);
        if (string != null) {
            int n = topicEvent.getType();
            if (string.equals("TaskAuditor")) {
                ((JRTaskMonitor)this.SEDU.getTaskMonitor()).addTask(n, (Properties)topicEvent.getData());
            } else if (string.equals("ClusterService")) {
                ((JRClusterMonitor)this.addServerStatus).addServerStatus(n, (Properties)topicEvent.getData());
            } else {
                ServiceLogger.logEvent(6660021, new Object[]{topicEvent, string}, 6);
            }
        } else {
            ServiceLogger.logEvent(6660022, topicEvent, 6);
        }
    }
}

