/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.UserSession;
import jet.server.monitor.api.UserSessionManager;
import jet.server.monitor.jrmon.JRUserSession;
import jet.server.monitor.jrmon.LoginQueue;
import jet.server.monitor.jrmon.MonitorEnv;

public class JRUserSessionManager
implements UserSessionManager {
    protected Hashtable sessions = null;
    private static Hashtable I = new Hashtable();
    private static Properties SEDU = new Properties();
    String loginFileName = MonitorEnv.getHomePath() + "bin" + File.separator + "login.properties";
    String logoutFileName = MonitorEnv.getHomePath() + "bin" + File.separator + "logout.properties";

    public JRUserSessionManager() {
        this.setDefaultMaxInactiveInterval(14400000);
        this.sessions = new Hashtable();
        this.TIMEOUT();
    }

    @Override
    public Vector getAllUserSessions() {
        Vector vector = new Vector();
        Enumeration enumeration = this.sessions.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    @Override
    public UserSession getUserSession(String string) {
        if (string != null) {
            return (UserSession)this.sessions.get(string);
        }
        return null;
    }

    @Override
    public void setDefaultMaxInactiveInterval(int n) {
        JRUserSession.TIMEOUT = n;
    }

    @Override
    public int getDefaultMaxInactiveInterval() {
        return JRUserSession.TIMEOUT;
    }

    public void removeAll() {
        UserSession userSession = null;
        String string = null;
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            userSession = (UserSession)this.sessions.get(string);
            userSession.invalidate();
            this.sessions.remove(string);
        }
    }

    @Override
    public UserSession login(String string, String string2, String string3) {
        JRUserSession jRUserSession = null;
        if (MonitorEnv.isAdminUser(string, string2, string3)) {
            jRUserSession = new JRUserSession(string, string2);
            this.sessions.put(jRUserSession.getID(), jRUserSession);
        }
        this.I(string2, System.currentTimeMillis());
        return jRUserSession;
    }

    public void logout(UserSession userSession) {
        String string = null;
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.equals(userSession.getID())) continue;
            this.sessions.remove(string);
        }
        userSession.invalidate();
    }

    public void putUsersessions(UserSession userSession) {
        this.sessions.put(userSession.getID(), userSession);
    }

    private void I(String string, long l) {
        if (!I.containsKey(string)) {
            LoginQueue loginQueue = new LoginQueue();
            loginQueue.addItem(l);
            I.put(string, loginQueue);
        } else {
            LoginQueue loginQueue = (LoginQueue)I.get(string);
            loginQueue.addItem(l);
        }
    }

    private void SEDU(String string, long l) {
        SEDU.put(string, Long.toString(l));
    }

    @Override
    public long getLastLoginTime(String string) {
        if (!I.containsKey(string)) {
            return 0L;
        }
        LoginQueue loginQueue = (LoginQueue)I.get(string);
        return loginQueue.getLastItem();
    }

    public long getLastLogoutTime(String string) {
        if (!SEDU.containsKey(string)) {
            return 0L;
        }
        return Long.parseLong((String)SEDU.get(string));
    }

    public void saveLoginTime() {
        Object object;
        Properties properties = new Properties();
        Object object2 = I.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            LoginQueue loginQueue = (LoginQueue)I.get(object);
            properties.setProperty((String)object, Long.toString(loginQueue.getCurItem()));
        }
        object2 = null;
        try {
            object = new File(this.loginFileName);
            if (((File)object).exists()) {
                ((File)object).createNewFile();
            }
            object2 = new FileOutputStream(this.loginFileName);
            properties.store((OutputStream)object2, null);
            ((FileOutputStream)object2).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServiceLogger.logError(fileNotFoundException, 3);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
        }
    }

    public void saveLogoutTime() {
        try {
            File file = new File(this.loginFileName);
            if (file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.logoutFileName);
            SEDU.store(fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServiceLogger.logError(fileNotFoundException, 3);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
        }
    }

    private void TIMEOUT() {
        File file = new File(this.loginFileName);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.I(string, Long.parseLong(properties.getProperty(string)));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServiceLogger.logError(fileNotFoundException, 3);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
    }

    private void addElement() {
        File file = new File(this.logoutFileName);
        if (file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.logoutFileName);
                SEDU.load(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServiceLogger.logError(fileNotFoundException, 3);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
    }
}

