/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.adhoc;

import jet.server.monitor.api.MonitorService;
import jet.server.monitor.api.adhoc.AdhocMonitor;
import jet.server.monitor.jrmon.JRMonitorService;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.adhoc.JRAdhocMonitor;

class AdhocMonitorThread
extends Thread {
    AdhocMonitor monitor = null;
    MonitorService monService = null;
    int interval = 2000;
    boolean stop = false;

    AdhocMonitorThread(AdhocMonitor adhocMonitor) {
        this.monitor = adhocMonitor;
        this.interval = adhocMonitor.getInterval();
        this.monService = ((JRAdhocMonitor)adhocMonitor).getMonitorService();
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.interval = MonitorEnv.getDefaultRefreshInterval();
            if (this.interval < 2000) {
                this.interval = 2000;
            } else if (this.interval > 10000) {
                this.interval = 10000;
            }
            if (((JRMonitorService)this.monService).getJRMonitorServer().isStarting(this.monService.getHost(), this.monService.getPort())) {
                this.monitor.update();
                continue;
            }
            this.monitor.stop();
        }
    }

    public void stopRun() {
        this.stop = true;
    }
}

