/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.cluster;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.server.api.cluster.Member;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.MonitorServer;
import jet.server.monitor.api.ServerStatus;
import jet.server.monitor.event.EventSubscriber;
import jet.server.monitor.event.MonitorEventHandler;
import jet.server.monitor.jrmon.JRMonitorServer;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.cluster.ClusterMonitorThread;
import jet.server.monitor.jrmon.cluster.JRServerStatus;
import jet.server.monitor.jrmon.intf.ClusterMonitor;

public class JRClusterMonitor
implements ClusterMonitor {
    private static final String SEDU = "serverName";
    private static final String Server_Type = "serverID";
    private static final String activate = "serverHost";
    private static final String addElement = "serverPort";
    private static final String addSelector = "serverType";
    private static final String addSubscriber = "startTime";
    private static final String append = "closeTime";
    private static final String createSubscriber = "crashReason";
    private int createSubscribers = 0;
    private int currentTimeMillis = 0;
    private ClusterMonitorThread deleteRemoteMonitorService = null;
    private Hashtable destroy = new Hashtable();
    private MonitorServer elementAt = null;
    private static boolean elements = false;

    public JRClusterMonitor() {
    }

    public JRClusterMonitor(MonitorServer monitorServer) {
        this();
        this.elementAt = monitorServer;
    }

    public JRClusterMonitor(MonitorServer monitorServer, int n) {
        this(monitorServer);
        this.createSubscribers = n;
    }

    @Override
    public void resolveClusterServers() {
        Member[] memberArray = this.elementAt.getClusteredServers();
        JRServerStatus jRServerStatus = null;
        String string = null;
        String string2 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < memberArray.length; ++i) {
            string = memberArray[i].getServerName();
            string2 = memberArray[i].getHost();
            n = Integer.parseInt(memberArray[i].getPort());
            n2 = memberArray[i].getID();
            jRServerStatus = new JRServerStatus(string, n2, string2, n, 1);
            if (this.elementAt.isStarted(string2, n)) {
                jRServerStatus.setStatus(1);
                jRServerStatus.setStartTime(System.currentTimeMillis());
            }
            this.destroy.put(string2 + ":" + n, jRServerStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllServerStatus() {
        Vector vector = new Vector();
        Hashtable hashtable = this.destroy;
        synchronized (hashtable) {
            Enumeration enumeration = this.destroy.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SEDU(String[] stringArray) {
        Hashtable hashtable = this.destroy;
        synchronized (hashtable) {
            Enumeration enumeration = this.destroy.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.equals(stringArray[i])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                if (ServiceLogger.isLoggable(4, 6)) {
                    ServiceLogger.logDebug(6660034, string, 6);
                }
                this.destroy.remove(string);
            }
        }
    }

    @Override
    public ServerStatus getServerStatus(String string, int n) {
        ServerStatus serverStatus = (ServerStatus)this.destroy.get(string + ":" + n);
        if (serverStatus == null) {
            Member[] memberArray = this.elementAt.getClusteredServers();
            String[] stringArray = new String[memberArray.length];
            for (int i = 0; i < memberArray.length; ++i) {
                String string2 = memberArray[i].getHost();
                String string3 = memberArray[i].getPort();
                stringArray[i] = string2 + ":" + string3;
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
                if (!string.equals(string2) || n != n2) continue;
                serverStatus = new JRServerStatus(memberArray[i].getServerName(), memberArray[i].getID(), string, n, 1);
                if (this.elementAt.isStarting(string, n)) {
                    ((JRServerStatus)serverStatus).setStatus(1);
                    ((JRServerStatus)serverStatus).setStartTime(System.currentTimeMillis());
                }
                this.destroy.put(string + ":" + n, serverStatus);
            }
            this.SEDU(stringArray);
        }
        return serverStatus;
    }

    @Override
    public ServerStatus getAdminServer() {
        ServerStatus serverStatus = null;
        Enumeration enumeration = this.destroy.elements();
        while (enumeration.hasMoreElements() && ((serverStatus = (ServerStatus)enumeration.nextElement()) == null || !serverStatus.getType().equals(JRServerStatus.Server_Type[1]))) {
            serverStatus = null;
        }
        return serverStatus;
    }

    @Override
    public Vector getAllBackupServers() {
        Vector<ServerStatus> vector = new Vector<ServerStatus>();
        ServerStatus serverStatus = null;
        Enumeration enumeration = this.destroy.elements();
        while (enumeration.hasMoreElements()) {
            serverStatus = (ServerStatus)enumeration.nextElement();
            if (serverStatus == null || !serverStatus.getType().equals(JRServerStatus.Server_Type[2])) continue;
            vector.addElement(serverStatus);
        }
        return vector;
    }

    @Override
    public Vector getAllSlaveServers() {
        Vector<ServerStatus> vector = new Vector<ServerStatus>();
        ServerStatus serverStatus = null;
        Enumeration enumeration = this.destroy.elements();
        while (enumeration.hasMoreElements()) {
            serverStatus = (ServerStatus)enumeration.nextElement();
            if (serverStatus == null || !serverStatus.getType().equals(JRServerStatus.Server_Type[3])) continue;
            vector.addElement(serverStatus);
        }
        return vector;
    }

    @Override
    public void setInterval(int n) {
        this.createSubscribers = n;
    }

    @Override
    public int getInterval() {
        return this.createSubscribers;
    }

    @Override
    public void setDuration(int n) {
        this.currentTimeMillis = n;
    }

    @Override
    public int getDuration() {
        return this.currentTimeMillis;
    }

    @Override
    public void start() {
        this.deleteRemoteMonitorService = new ClusterMonitorThread(this);
        this.resolveClusterServers();
        this.createSubscribers("ClusterService", -1);
        this.deleteRemoteMonitorService.start();
    }

    @Override
    public void restart() {
        this.deleteRemoteMonitorService.destroy();
        this.start();
    }

    @Override
    public void stop() {
        this.deleteRemoteMonitorService.stopRun();
    }

    public void addServerStatus(int n, Properties properties) {
        ServerStatus serverStatus = null;
        String string = properties.getProperty(activate) + ":" + properties.getProperty(addElement);
        switch (n) {
            case 0: {
                String string2 = properties.getProperty(activate);
                int n2 = Integer.parseInt(properties.getProperty(addElement));
                int n3 = Integer.parseInt(properties.getProperty(addSelector)) + 1;
                if (MonitorEnv.isAdminServer(string2, n2)) {
                    n3 = 1;
                } else if (n3 == 1) {
                    n3 = 2;
                }
                int n4 = Integer.parseInt(properties.getProperty(Server_Type));
                serverStatus = (ServerStatus)this.destroy.get(string);
                if (serverStatus != null) {
                    ((JRServerStatus)serverStatus).setStatus(1);
                    ((JRServerStatus)serverStatus).setType(n3);
                    ((JRServerStatus)serverStatus).setClosedTime(-1L);
                    break;
                }
                serverStatus = new JRServerStatus(properties.getProperty(SEDU), n4, string2, n2, n3);
                ((JRServerStatus)serverStatus).setStartTime(Long.parseLong(properties.getProperty(addSubscriber)));
                ((JRServerStatus)serverStatus).setStatus(1);
                this.destroy.put(string, serverStatus);
                break;
            }
            case 1: {
                serverStatus = (ServerStatus)this.destroy.get(string);
                ((JRServerStatus)serverStatus).setClosedTime(Long.parseLong(properties.getProperty(append)));
                break;
            }
            case 2: {
                serverStatus = (ServerStatus)this.destroy.get(string);
                ((JRServerStatus)serverStatus).setClosedTime(Long.parseLong(properties.getProperty(append)));
                ((JRServerStatus)serverStatus).setReason(properties.getProperty(createSubscriber));
                break;
            }
            default: {
                if (!ServiceLogger.isLoggable(3, 6)) break;
                ServiceLogger.logEvent(6660035, String.valueOf(n), 6);
            }
        }
    }

    @Override
    public void update() {
        JRServerStatus jRServerStatus = null;
        Object object = this.destroy.elements();
        while (object.hasMoreElements()) {
            jRServerStatus = (JRServerStatus)object.nextElement();
            if (jRServerStatus == null) continue;
            boolean bl = this.elementAt.isStarting(jRServerStatus.getHost(), jRServerStatus.getPort());
            if (bl) {
                if (!jRServerStatus.isStarted()) {
                    jRServerStatus.setStatus(1);
                    jRServerStatus.setStartTime(System.currentTimeMillis());
                    jRServerStatus.setClosedTime(-1L);
                }
                this.elementAt.getMonitorService(jRServerStatus.getHost(), jRServerStatus.getPort());
                this.createSubscribers("ClusterService", -1);
                continue;
            }
            if (!jRServerStatus.isStarted() || this.elementAt.isStarted(jRServerStatus.getHost(), jRServerStatus.getPort())) continue;
            jRServerStatus.setStatus(5);
            jRServerStatus.setClosedTime(System.currentTimeMillis());
            ((JRMonitorServer)this.elementAt).stopMonitorService(jRServerStatus.getHost(), jRServerStatus.getPort());
            ((JRMonitorServer)this.elementAt).deleteRemoteMonitorService(jRServerStatus.getHost(), jRServerStatus.getPort());
        }
        if (!this.elementAt.isStarting(MonitorEnv.getAdminHost(), MonitorEnv.getAdminPort())) {
            MonitorEnv.setAdminRemoteMonService(null);
            elements = true;
            object = null;
            ServerStatus serverStatus = this.getAdminServer();
            if (serverStatus != null && serverStatus.isStarted()) {
                ((JRServerStatus)serverStatus).setStatus(6);
                ((JRServerStatus)serverStatus).setClosedTime(System.currentTimeMillis());
                ((JRServerStatus)serverStatus).setReason("Admin Server crashed!");
            }
            ((JRMonitorServer)this.elementAt).deleteRemoteMonitorService(MonitorEnv.getAdminHost(), MonitorEnv.getAdminPort());
            RemoteMonitorService remoteMonitorService = null;
            Vector vector = this.getAllBackupServers();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                object = (ServerStatus)vector.elementAt(i);
                try {
                    remoteMonitorService = ((JRMonitorServer)this.elementAt).getRemoteMonitorService(object.getHost(), object.getPort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (remoteMonitorService == null) continue;
                try {
                    if (!remoteMonitorService.isAdminServer()) continue;
                    elements = false;
                    ((JRServerStatus)serverStatus).setType(2);
                    MonitorEnv.setAdminHost(object.getHost());
                    MonitorEnv.setAdminPort(object.getPort());
                    MonitorEnv.setAdminRemoteMonService(remoteMonitorService);
                    ((JRServerStatus)object).setType(1);
                    return;
                }
                catch (RemoteException remoteException) {
                    if (!ServiceLogger.isLoggable(2, 3)) continue;
                    ServiceLogger.logError(3660037, new Object[]{object.getHost(), String.valueOf(object.getPort()), remoteException.getMessage()}, 3);
                }
            }
        } else if (elements) {
            try {
                MonitorEnv.setAdminRemoteMonService(((JRMonitorServer)this.elementAt).getRemoteMonitorService(MonitorEnv.getAdminHost(), MonitorEnv.getAdminPort()));
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            elements = false;
        }
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    public void createSubscribers(String string, int n) {
        String string2 = MonitorEnv.getAdminHost();
        int n2 = MonitorEnv.getAdminPort();
        Subscriber subscriber = EventSubscriber.getEventSubscriber().getSubscriber(string2 + ":" + n2 + "_" + string);
        if (subscriber == null) {
            subscriber = EventSubscriber.getEventSubscriber().getEventService().createSubscriber(string2, n2, new MonitorEventHandler(this));
            EventSubscriber.getEventSubscriber().addSubscriber(string2 + ":" + n2 + "_" + string, subscriber);
        }
        SelectorImpl selectorImpl = new SelectorImpl(string, 3);
        if (n >= 0) {
            selectorImpl.enable(n);
        } else {
            selectorImpl.enableAll();
        }
        subscriber.addSelector(selectorImpl);
        try {
            subscriber.activate();
            subscriber.update();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

