/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.cluster;

import java.io.Serializable;
import jet.server.monitor.api.ServerStatus;

public class JRServerStatus
implements ServerStatus,
Serializable {
    private static final long serialVersionUID = -333456370151448661L;
    public static final int ADMIN_SERVER = 1;
    public static final int BACKUP_SERVER = 2;
    public static final int SLAVE_SERVER = 3;
    public static final String[] Server_Type = new String[]{"", "Admin", "Backup", "Slave"};
    public static final int SERVER_STARTED = 1;
    public static final int SERVER_IDLE = 2;
    public static final int SERVER_WORKING = 3;
    public static final int SERVER_BUSY = 4;
    public static final int SERVER_SHUT = 5;
    public static final int SERVER_CRASHED = 6;
    public static final String[] Server_Status = new String[]{"Inactive", "Active", "Idle", "Working", "Busy", "Shut Down", "Inactive"};
    private String name = null;
    private int memberID = -1;
    private String host = null;
    private int port = -1;
    private int type = 0;
    private int status = 0;
    private String reason = null;
    private long closeTime = -1L;
    private long startTime = -1L;
    private boolean monitored = false;

    public JRServerStatus() {
        this(null, null, -1);
    }

    public JRServerStatus(String string, String string2, int n) {
        this(string, -1, string2, n, -1);
    }

    public JRServerStatus(String string, int n, String string2, int n2, int n3) {
        this.name = string;
        this.host = string2;
        this.port = n2;
        this.type = n3;
        this.memberID = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMemberID() {
        return this.memberID;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getStatus() {
        return Server_Status[this.status];
    }

    public void setStatus(int n) {
        this.status = n;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    @Override
    public String getType() {
        return Server_Type[this.type];
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean isMonitored() {
        return this.monitored;
    }

    public void setMonitored(boolean bl) {
        this.monitored = bl;
    }

    @Override
    public boolean isStarted() {
        if (this.status == 0) {
            return false;
        }
        return this.status < 5;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isAdminServer() {
        return this.type == 1;
    }

    public boolean isBackupServer() {
        return this.type == 2;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public void setClosedTime(long l) {
        this.closeTime = l;
    }

    public long getClosedTime() {
        return this.closeTime;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Server status [server name:").append(this.name);
        stringBuffer.append(";host:").append(this.host);
        stringBuffer.append(";port:").append(this.port);
        stringBuffer.append(";type:").append(this.getType());
        stringBuffer.append(";status:").append(this.getStatus());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

