/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.http;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.server.api.exception.InvalidUserException;
import jet.server.api.http.BaseHttpUtil;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.InvalidUserSessionException;
import jet.server.monitor.api.UserSession;
import jet.server.monitor.api.http.HttpUserSessionManager;
import jet.server.monitor.jrmon.JRUserSessionManager;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.http.AuthInfo;
import jet.server.monitor.jrmon.http.MD5Info;
import jet.server.monitor.jrmon.http.RawUserSession;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;
import jet.server.util.nls.PropertyMessageResourcesFactory;
import jet.server.util.nls.PropertyMessageResourcesFactoryUtils;
import jet.util.Base64;

public class JRHttpUserSessionManager
extends JRUserSessionManager
implements HttpUserSessionManager {
    private static final String SEDU = "jrm.user.session";
    private static final String append = "Unauthorized";
    public static final String JRM_RAW_SESSION = "jrm.raw.session";
    private int checkLoginEx = 5;

    @Override
    public UserSession getUserSession(HttpServletRequest httpServletRequest) {
        UserSession userSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            userSession = this.getUserSession((String)httpSession.getValue(SEDU));
        }
        return userSession;
    }

    private void SEDU(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        if (string != null && string.indexOf("index.jsp") >= 0) {
            MonitorEnv.setMonitorWebEntry("http://" + MonitorEnv.getHostAddress(httpServletRequest.getServerName()) + ":" + httpServletRequest.getServerPort() + string);
        }
    }

    private void append(HttpServletRequest httpServletRequest, UserSession userSession) {
        HttpSession httpSession = httpServletRequest.getSession(true);
        try {
            httpSession.putValue(SEDU, (Object)userSession.getID());
            httpSession.removeValue(JRM_RAW_SESSION);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    @Override
    public boolean checkLogin(HttpServletRequest httpServletRequest, String string, Properties properties) throws IOException, InvalidUserSessionException {
        try {
            return this.checkLoginEx(httpServletRequest, string, properties);
        }
        catch (InvalidUserException invalidUserException) {
            return false;
        }
    }

    @Override
    public boolean checkLoginEx(HttpServletRequest httpServletRequest, String string, Properties properties) throws IOException, InvalidUserSessionException, InvalidUserException {
        UserSession userSession = this.getUserSession(httpServletRequest);
        if (userSession == null) {
            RawUserSession rawUserSession = this.equalsIgnoreCase(httpServletRequest);
            if (rawUserSession != null && rawUserSession.times > this.checkLoginEx) {
                throw new InvalidUserSessionException(630090);
            }
            userSession = this.currentTimeMillis(httpServletRequest, string, properties);
            if (userSession != null) {
                AuthInfo authInfo = this.decode(httpServletRequest, string, properties);
                if (MonitorEnv.isAdminUser(string, authInfo.userID, authInfo.password)) {
                    this.append(httpServletRequest, userSession);
                    this.SEDU(httpServletRequest);
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private UserSession currentTimeMillis(HttpServletRequest httpServletRequest, String string, Properties properties) throws InvalidUserSessionException, IOException, InvalidUserException {
        UserSession userSession = null;
        AuthInfo authInfo = this.decode(httpServletRequest, string, properties);
        if (authInfo != null) {
            RawUserSession rawUserSession = this.equalsIgnoreCase(httpServletRequest);
            if (rawUserSession != null && authInfo.md5 != null && rawUserSession.md5 != null && authInfo.userID != null && authInfo.md5.response != null && authInfo.md5.nonce != null && authInfo.md5.nonce.equals(rawUserSession.md5.nonce) && (authInfo.md5.opaque == null || authInfo.md5.opaque.equals(rawUserSession.md5.opaque))) {
                return this.loginMD5(rawUserSession.realm, authInfo.userID, authInfo.md5.response, authInfo.md5.nonce, rawUserSession.md5.uri, httpServletRequest.getMethod());
            }
            boolean bl = MonitorEnv.isValidAdminUserEx(string, authInfo.userID, authInfo.password);
            if (!bl) {
                return null;
            }
            userSession = this.login(string, authInfo.userID, authInfo.password);
        }
        return userSession;
    }

    private AuthInfo decode(HttpServletRequest httpServletRequest, String string, Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string2 = httpServletRequest.getHeader("Authorization");
        if (string2 != null && string2.length() > 0) {
            int n;
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession == null || httpSession.isNew()) {
                authInfo = this.elementAt(properties);
            }
            if ((n = (string2 = string2.trim()).indexOf(" ")) > 0) {
                if (string2.startsWith("Basic")) {
                    string2 = string2.substring(n).trim();
                    String string3 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string2), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string2), "ISO-8859-1");
                    n = string3.indexOf(":");
                    if (n > 0) {
                        authInfo = new AuthInfo();
                        authInfo.userID = string3.substring(0, n);
                        authInfo.password = string3.substring(n + 1);
                    }
                } else if (string2.startsWith("Digest")) {
                    Object object;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    string2 = string2.substring("Digest".length() + 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken().trim();
                        int n2 = ((String)object).indexOf("=");
                        if (n2 <= 0) continue;
                        String string9 = ((String)object).substring(0, n2).trim();
                        String string10 = ((String)object).substring(n2 + 1).trim();
                        if (string9.equalsIgnoreCase("username")) {
                            string4 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("realm")) {
                            string5 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("nonce")) {
                            string6 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (string9.equalsIgnoreCase("response")) {
                            string7 = CSUtil.removeQuotes(string10);
                            continue;
                        }
                        if (!string9.equalsIgnoreCase("opaque")) continue;
                        string8 = CSUtil.removeQuotes(string10);
                    }
                    object = new MD5Info();
                    ((MD5Info)object).nonce = string6;
                    ((MD5Info)object).opaque = string8;
                    ((MD5Info)object).response = string7;
                    authInfo = new AuthInfo();
                    authInfo.userID = string4;
                    authInfo.md5 = object;
                }
            }
        } else {
            authInfo = this.elementAt(properties);
        }
        return authInfo;
    }

    private AuthInfo elementAt(Properties properties) throws IOException {
        AuthInfo authInfo = null;
        String string = null;
        String string2 = null;
        String string3 = (String)properties.get("jrs.authorization");
        if (string3 != null && string3.trim().length() > 0) {
            String string4 = CSUtil.getUrlEncoding() != null ? new String(Base64.decode((String)string3), CSUtil.getUrlEncoding()) : new String(Base64.decode((String)string3), "ISO-8859-1");
            int n = string4.indexOf(":");
            if (n > 0) {
                string = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            }
        } else {
            string = (String)properties.get("jrs.auth_uid");
            string2 = (String)properties.get("jrs.auth_pwd");
            if (string2 == null) {
                string2 = "";
            }
        }
        if (string != null) {
            authInfo = new AuthInfo();
            authInfo.userID = string;
            authInfo.password = string2;
        }
        return authInfo;
    }

    private void equals(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        Object object;
        Object object2;
        String string2;
        Object object3;
        PropertyMessageResourcesFactory propertyMessageResourcesFactory = null;
        propertyMessageResourcesFactory = (PropertyMessageResourcesFactory)httpServletRequest.getSession(true).getAttribute("monitorResource");
        if (propertyMessageResourcesFactory == null) {
            object3 = null;
            string2 = httpServletRequest.getHeader("Accept-Language");
            if (string2 != null) {
                object2 = string2.split(",");
                object3 = object2[0];
                object = NLSUtil.parseLanguageTagToLocale((String)object3);
                if (null != object) {
                    object3 = ((Locale)object).toString().replaceAll("_", "-");
                }
            } else {
                object3 = "EN";
            }
            propertyMessageResourcesFactory = PropertyMessageResourcesFactoryUtils.getMonitorResourceFactory((String)object3);
            object2 = MonitorEnv.getHomePath() + "resources" + File.separator + "server" + File.separator + "languages" + File.separator;
            propertyMessageResourcesFactory.setLanguagePath((String)object2);
            httpServletRequest.getSession(true).setAttribute("monitorResource", (Object)propertyMessageResourcesFactory);
        }
        httpServletResponse.setContentType("text/html");
        object3 = ServerUtil.getResponseWriter(httpServletResponse);
        string2 = httpServletRequest.getParameter("loginCode");
        if (string2 == null || string2.trim().length() == 0) {
            ((PrintWriter)object3).println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
            ((PrintWriter)object3).println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            ((PrintWriter)object3).println("<head>");
            ((PrintWriter)object3).println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
            ((PrintWriter)object3).println("<title>" + JCliResource.getMessage("CS_MSG_110") + "</title>");
            ((PrintWriter)object3).println("<link href=\"./style/jrServer/jrServer.min.css\" rel=\"stylesheet\" type=\"text/css\" media=\"screen\" />");
            ((PrintWriter)object3).println("<script language=\"javascript\">");
            ((PrintWriter)object3).println("var NLSResources = new Object();");
            ((PrintWriter)object3).println("NLSResources[\"ERR_MSG_001\"] = \"" + propertyMessageResourcesFactory.getMessage("JS_MSG_001") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"DIALOG_TITLE_001\"] = \"" + propertyMessageResourcesFactory.getMessage("4220078") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"DIALOG_TITLE_002\"] = \"" + propertyMessageResourcesFactory.getMessage("4220078") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"DIALOG_TITLE_003\"] = \"" + propertyMessageResourcesFactory.getMessage("4220078") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"DIALOG_TITLE_004\"] = \"" + propertyMessageResourcesFactory.getMessage("4220078") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"DIALOG_BUTTON_001\"] = \"" + propertyMessageResourcesFactory.getMessage("91000007") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"DIALOG_BUTTON_002\"] = \"" + propertyMessageResourcesFactory.getMessage("91000026") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"DIALOG_BUTTON_003\"] = \"" + propertyMessageResourcesFactory.getMessage("91000004") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"DIALOG_BUTTON_004\"] = \"" + propertyMessageResourcesFactory.getMessage("91000006") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"LOAD_MSG_001\"] = \"" + propertyMessageResourcesFactory.getMessage("22221467") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"ERR_MSG_002\"] = \"" + propertyMessageResourcesFactory.getMessage("JS_MSG_004") + "\";");
            ((PrintWriter)object3).println("NLSResources[\"ERR_MSG_003\"] = \"" + propertyMessageResourcesFactory.getMessage("JS_MSG_005") + "\";");
            ((PrintWriter)object3).println("</script>");
            ((PrintWriter)object3).println("<script type=\"text/javascript\" src=\"./javascript/jquery-1.5.2.min.js\"></script>");
            ((PrintWriter)object3).println("<script type=\"text/javascript\" src=\"./javascript/jquery.base64.js\"></script>");
            ((PrintWriter)object3).println("<script type=\"text/javascript\" src=\"./javascript/jrServer/jrServer.min.js\"></script>");
            ((PrintWriter)object3).println("</head>");
            ((PrintWriter)object3).println("<body>");
        }
        if (string2 == null || !string2.trim().equals("ajaxLogin")) {
            object2 = httpServletRequest.getRequestURI();
            if (((String)object2).indexOf("?") != -1) {
                object2 = ((String)object2).substring(0, ((String)object2).indexOf("?"));
            }
            object = httpServletRequest.getParameterNames();
            if (string2 == null || string2.trim().length() == 0) {
                ((PrintWriter)object3).println("<div class=\"jrServer-ui jrServer-dialog\"  draggable=\"false\" style=\"width:420px;height:222px;\" data-options=\"");
                ((PrintWriter)object3).println("closed: false,");
                ((PrintWriter)object3).println("styleName: 'logindialog', ");
                ((PrintWriter)object3).println("minimizable: false,");
                ((PrintWriter)object3).println("maximizable: false,");
                ((PrintWriter)object3).println("closable: false, ");
                ((PrintWriter)object3).println("shadow: false\">");
            }
            ((PrintWriter)object3).println("<form action=\"" + (String)object2 + "\" method=\"POST\"");
            ((PrintWriter)object3).println("class=\"jrServer-ui jrServer-loginform\"");
            ((PrintWriter)object3).println(">");
            String string3 = "";
            String string4 = "";
            while (object.hasMoreElements()) {
                String string5 = (String)object.nextElement();
                String[] stringArray = httpServletRequest.getParameterValues(string5);
                if (stringArray == null || string5.equals("loginCode")) continue;
                for (String string6 : stringArray) {
                    if (null != string5 && "jrs.auth_uid".equalsIgnoreCase(string5)) {
                        string3 = string6;
                        continue;
                    }
                    if (null != string5 && "jrs.auth_pwd".equalsIgnoreCase(string5)) {
                        string4 = string6;
                        continue;
                    }
                    ((PrintWriter)object3).println("<input type=\"hidden\" name=\"" + string5 + "\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(string6) + "\" />");
                }
            }
            ((PrintWriter)object3).println("<div class=\"headerTitle\">" + propertyMessageResourcesFactory.getMessage("22221136") + "</div>");
            ((PrintWriter)object3).println("<div class=\"headerSubTitle\">" + propertyMessageResourcesFactory.getMessage("22221137") + "</div>");
            ((PrintWriter)object3).println("<table border=0 cellspacing=0 cellpadding=0 >");
            ((PrintWriter)object3).println("<tr>");
            ((PrintWriter)object3).println("<td colspan=2 style=\"height: 20px;\">");
            ((PrintWriter)object3).println("<div class=\"message\"></div>");
            ((PrintWriter)object3).println("</td>");
            ((PrintWriter)object3).println("</tr>");
            ((PrintWriter)object3).println("<tr>");
            ((PrintWriter)object3).println("<td class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221132") + "</td>");
            ((PrintWriter)object3).println("<td class=\"input\"><input type=\"text\" name=\"jrs.auth_uid\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(string3) + "\" /></td>");
            ((PrintWriter)object3).println("</tr>");
            ((PrintWriter)object3).println("<tr>");
            ((PrintWriter)object3).println("<td class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221133") + "</td>");
            ((PrintWriter)object3).println("<td class=\"input\"><input type=\"password\" name=\"jrs.auth_pwd\" value=\"" + WebSecurityUtil.escapeHTMLAttribute(string4) + "\" /></td>");
            ((PrintWriter)object3).println("</tr>");
            ((PrintWriter)object3).println("<tr>");
            ((PrintWriter)object3).println("<td></td><td>");
            ((PrintWriter)object3).println("<table border=0 cellspacing=0 cellpadding=0 style=\"width: 100%;\"><tr>");
            ((PrintWriter)object3).println("<td style=\"white-space:nowrap;padding-left: 3px;\">");
            ((PrintWriter)object3).println("<input name=\"Submit\" type=\"submit\" class=\"submit btn-red\" value=\"" + propertyMessageResourcesFactory.getMessage("22221519") + "\" /><input name=\"Reset\" type=\"button\" class=\"reset btn-gray\" value=\"" + propertyMessageResourcesFactory.getMessage("2220511") + "\" />");
            ((PrintWriter)object3).println("</td>");
            ((PrintWriter)object3).println("<td id=\"rememberMecheckboxTd\"><input type=\"checkbox\" style=\"padding: 0; margin: 0;\" class=\"rememberMe\" /></td>");
            ((PrintWriter)object3).println("<td id=\"rememberMeLabelTd\" class=\"label\">" + propertyMessageResourcesFactory.getMessage("22221134") + "</td>");
            ((PrintWriter)object3).println("</tr></table>");
            ((PrintWriter)object3).println("</td>");
            ((PrintWriter)object3).println("</tr>");
            ((PrintWriter)object3).println("</table>");
            ((PrintWriter)object3).println("</form>");
            if (string2 == null || string2.trim().length() == 0) {
                ((PrintWriter)object3).println("</div>");
            }
        }
        if (string2 == null || string2.trim().length() == 0) {
            ((PrintWriter)object3).println("</body>");
            ((PrintWriter)object3).println("</html>");
        }
    }

    @Override
    public void sendUnauthorizedResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        if (!BaseHttpUtil.isJRClient(httpServletRequest, null)) {
            this.equals(httpServletRequest, httpServletResponse, string2);
            return;
        }
        this.escapeHTMLAttribute(httpServletRequest);
        RawUserSession rawUserSession = this.equalsIgnoreCase(httpServletRequest);
        rawUserSession.realm = string2;
        if (string.equals("Digest")) {
            rawUserSession.md5 = new MD5Info(httpServletRequest);
        }
        httpServletResponse.setStatus(401);
        httpServletResponse.setHeader("WWW-Authenticate", WebSecurityUtil.validateResponseHeader(rawUserSession.makeAuthHeader()));
        httpServletResponse.setHeader("MonitoredTo", WebSecurityUtil.validateResponseHeader(MonitorEnv.getAdminAddress()));
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>Unauthorized</title>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<h1>401 Unauthorized</h1>");
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpiredUserSessions(HttpServletRequest httpServletRequest) {
        UserSession userSession = null;
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            Vector vector = this.getAllUserSessions();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                userSession = (UserSession)vector.elementAt(i);
                if (System.currentTimeMillis() - userSession.getLastAccessTime() <= (long)userSession.getMaxInactiveInterval()) continue;
                this.logout(httpServletRequest, userSession);
            }
        }
        userSession = this.getUserSession(httpServletRequest);
        if (userSession != null) {
            this.putUsersessions(userSession);
        }
    }

    @Override
    public void logout(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            UserSession userSession = this.getUserSession(httpServletRequest);
            this.logout(httpServletRequest, userSession);
        }
    }

    public void logout(HttpServletRequest httpServletRequest, UserSession userSession) {
        if (userSession != null) {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                try {
                    httpSession.removeValue(SEDU);
                    httpSession.invalidate();
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            super.logout(userSession);
        }
    }

    @Override
    public UserSession loginMD5(String string, String string2, String string3, String string4, String string5, String string6) throws InvalidUserSessionException {
        UserSession userSession = null;
        String string7 = MonitorEnv.getPassword(string, string2);
        if (string7 == null) {
            string7 = "";
        }
        if (string3.equals(CSUtil.getH(CSUtil.getH(string2 + ":" + string + ":", string7) + ":" + string4 + ":" + CSUtil.getH(string6 + ":" + string5, null), null))) {
            userSession = this.login(string, string2, string7);
        }
        return userSession;
    }

    private RawUserSession equalsIgnoreCase(HttpServletRequest httpServletRequest) {
        RawUserSession rawUserSession = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            rawUserSession = (RawUserSession)httpSession.getValue(JRM_RAW_SESSION);
        }
        return rawUserSession;
    }

    private void escapeHTMLAttribute(HttpServletRequest httpServletRequest) {
        if (this.equalsIgnoreCase(httpServletRequest) == null) {
            HttpSession httpSession = httpServletRequest.getSession(true);
            try {
                httpSession.putValue(JRM_RAW_SESSION, (Object)new RawUserSession());
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }
}

