/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.task;

import jet.server.monitor.api.MonitorService;
import jet.server.monitor.api.task.TaskMonitor;
import jet.server.monitor.jrmon.JRMonitorService;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.task.JRTaskMonitor;

class TaskMonitorThread
extends Thread {
    TaskMonitor monitor = null;
    MonitorService monService = null;
    int interval = 2000;
    boolean stop = false;

    TaskMonitorThread(TaskMonitor taskMonitor) {
        this.monitor = taskMonitor;
        this.interval = taskMonitor.getInterval();
        this.monService = ((JRTaskMonitor)taskMonitor).getMonitorService();
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.interval = MonitorEnv.getDefaultRefreshInterval();
            if (this.interval < 2000) {
                this.interval = 2000;
            } else if (this.interval > 10000) {
                this.interval = 10000;
            }
            if (((JRMonitorService)this.monService).getJRMonitorServer().isStarting(this.monService.getHost(), this.monService.getPort())) {
                this.monitor.update();
                continue;
            }
            this.monitor.stop();
        }
    }

    public void stopRun() {
        this.stop = true;
    }
}

