/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.standalone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.log.ServiceLogger;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.standalone.HttpMonitorServerHandler;
import jet.server.util.ServerUtil;
import jet.util.AsciiProperties;
import server.servlet.ServletLoader;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServerBase;

public class HttpMonitorServer
extends HttpServerBase {
    private Properties C = null;
    static boolean bRestart = false;

    public HttpMonitorServer(ExProperties exProperties, boolean bl) {
        super(exProperties, true);
        this.maxHandlers = 100;
        this.maxConnections = 150;
        this.loadProperties(exProperties, bl);
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", 100);
        this.maxConnections = this.serverProps.getProperty("httpserver.max.connections", 150);
        if (this.maxHandlers > this.maxConnections) {
            this.maxHandlers = this.maxConnections;
        }
        this.mimeTypeTable = MonitorEnv.getMimeTypeTable();
        this.htmlPath = MonitorEnv.getWebPath();
        HttpResponse.outputEncoding = MonitorEnv.getOutputEncoding();
    }

    public Properties getMappings() {
        if (this.C == null) {
            this.C = new AsciiProperties();
            try {
                String string = MonitorEnv.getHomePath() + "bin" + File.separator + "mapping.properties";
                this.C.load(new FileInputStream(string));
            }
            catch (IOException iOException) {
                ServiceLogger.logError(3660039, 3);
                ServiceLogger.logError(iOException);
            }
        }
        return this.C;
    }

    public void loadProperties(ExProperties exProperties, boolean bl) {
        if (!bl) {
            MonitorEnv.check();
        }
        this.servPropName = MonitorEnv.getServPropName();
        this.serverProps = MonitorEnv.getProperties();
        this.serverProps.merge(exProperties);
        this.useAllHosts = this.serverProps.getProperty("httpserver.host.all", true);
        this.hostName = this.serverProps.getProperty("httpserver.host.name");
        if (this.hostName == null || this.hostName.trim().length() == 0) {
            this.hostName = "*";
        }
        if (this.useAllHosts || this.hostName.equals("*")) {
            try {
                this.hostAddrs = ServerUtil.getAllLocalAddresses().toArray(new InetAddress[0]);
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("Unknown host address " + unknownHostException.getMessage());
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.hostName, " \t;");
            Vector<InetAddress> vector = new Vector<InetAddress>();
            while (stringTokenizer.hasMoreElements()) {
                String string = stringTokenizer.nextToken();
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    if (!vector.contains(inetAddress)) {
                        vector.addElement(inetAddress);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host address " + string);
                }
                this.hostAddrs = new InetAddress[vector.size()];
                vector.copyInto(this.hostAddrs);
            }
        }
        this.port = this.serverProps.getProperty("monitor.service.port", 8848);
        this.serverProps.setProperty("monitor.service.port", this.port);
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", this.maxHandlers);
        this.timeout = this.serverProps.getProperty("httpserver.timeout", this.timeout);
        this.servletPropFile = this.serverProps.getProperty("servlet.property", System.getProperty("monitor.home", ".") + File.separator + "bin" + File.separator + "servlet.properties");
        if (this.servletPropFile.indexOf(File.separator) == -1) {
            this.servletPropFile = System.getProperty("monitor.home", ".") + File.separator + "bin" + File.separator + this.servletPropFile;
        }
        this.serverProps.setProperty("servlet.property", this.servletPropFile);
        this.loadServletProps();
        this.saveProperties();
    }

    @Override
    public void initLoader() {
        this.loader = new ServletLoader(".");
    }

    @Override
    protected int getServicePort() {
        return this.port;
    }

    @Override
    protected int getSecureServicePort() {
        return this.securePort;
    }

    @Override
    protected String getThreadGroupName() {
        return "Monitor Service";
    }

    @Override
    public void startHandler() {
        HttpMonitorServerHandler httpMonitorServerHandler = new HttpMonitorServerHandler(this);
        this.handlerThreads.addElement(httpMonitorServerHandler);
        new Thread(this.handlers, httpMonitorServerHandler).start();
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void quit() {
        super.quit();
        ServiceLogger.closeAll();
        System.exit(0);
    }

    public void quitWithoutExit() {
        super.quit();
        ServiceLogger.closeAll();
    }

    @Override
    public String getRealPath(String string) {
        String string2 = MonitorEnv.getWebPath();
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if ((string = string.replace('/', File.separatorChar)).startsWith(File.separator)) {
            string = string.substring(1);
        }
        return string2 + string;
    }

    public void restart() {
        this.shutdown();
        ExProperties exProperties = new ExProperties();
        HttpMonitorServer httpMonitorServer = new HttpMonitorServer(exProperties, true);
        httpMonitorServer.start();
        bRestart = false;
    }

    public void needRestart() {
        bRestart = true;
        RestartWaiter restartWaiter = new RestartWaiter(this);
        new Thread(restartWaiter).start();
    }

    class RestartWaiter
    implements Runnable {
        HttpMonitorServer server;

        RestartWaiter(HttpMonitorServer httpMonitorServer2) {
            this.server = httpMonitorServer2;
        }

        @Override
        public void run() {
            this.server.restart();
        }
    }
}

