/*
 * Decompiled with CFR 0.152.
 */
package jet.server.objectman;

import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import jet.JException;
import jet.cs.CSUtil;
import jet.objectman.Loader;
import jet.objectman.ObjectManager;
import jet.objectman.ResourceObject;
import jet.server.api.PathInfo;
import jet.server.api.ResourceManager;
import jet.server.api.ResultFiles;
import jet.server.api.ResultVersionRecord;
import jet.server.api.RptServerException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.UnknownResource;
import jet.server.log.ServiceLogger;
import jet.universe.JetUUniverse;

public final class ObjectManagerImpl
implements ObjectManager {
    private static ObjectManagerImpl SEDU;
    private static final long addObject = 1800000L;
    private Hashtable cancel = new Hashtable();
    private Hashtable clear = new Hashtable();
    private ResourceManager clone;
    private Timer decreaseReference;
    private Hashtable destroy;

    public static ObjectManager getObjectManager(ResourceManager resourceManager) {
        if (SEDU == null) {
            SEDU = new ObjectManagerImpl(resourceManager);
        }
        return SEDU;
    }

    public static void clear() {
        SEDU.destroy();
        SEDU = null;
    }

    private ObjectManagerImpl(ResourceManager resourceManager) {
        this.clone = resourceManager;
        this.decreaseReference = new Timer("ObjectManagerImplTimer", true);
        this.destroy = new Hashtable();
    }

    @Override
    public ResourceObject get(ResourceObject resourceObject) {
        Map map = resourceObject.getDependants();
        String string = (String)map.get("res.categorykey");
        String string2 = (String)map.get("res.rkey");
        Loader loader = (Loader)this.clear.get(resourceObject.getResourceType());
        try {
            Object object;
            if (string == null) {
                RemoveCategoryTask removeCategoryTask;
                String string3 = resourceObject.getResourceName();
                int n = CSUtil.parseInt((String)map.get("res.vers"), -1);
                String string4 = (String)map.get("res.user");
                PathInfo pathInfo = this.clone.getPathInfo(string4, string3);
                ResultVersionRecord resultVersionRecord = null;
                if (pathInfo.isReport()) {
                    resultVersionRecord = this.clone.getResultVersion(string4, string3, n);
                } else if (pathInfo.isResult()) {
                    resultVersionRecord = this.clone.getResultDocVersion(string4, string3, n);
                }
                Hashtable hashtable = resultVersionRecord.getAllReportResultFiles();
                ResultFiles resultFiles = (ResultFiles)hashtable.get("jrs.rsd_result");
                String string5 = this.clone.getHistFile(resultFiles.getRsdFileName());
                string = String.valueOf(string5.hashCode());
                resourceObject.putDependant("res.categorykey", string);
                Category category = (Category)this.cancel.get(string);
                if (category == null) {
                    object = loader.load(string5, map);
                    category = new Category(string, string5);
                    category.addObject(string2, object);
                    this.cancel.put(string, category);
                } else if (category.hasObject(string2)) {
                    object = category.getObject(string2);
                } else {
                    object = loader.load(string5, map);
                    category.addObject(string2, object);
                }
                if (category.increaseReference() == 1 && (removeCategoryTask = (RemoveCategoryTask)this.destroy.remove(string)) != null) {
                    removeCategoryTask.cancel();
                }
            } else {
                Category category = (Category)this.cancel.get(string);
                if (category.hasObject(string2)) {
                    object = category.getObject(string2);
                } else {
                    loader = (Loader)this.clear.get(resourceObject.getResourceType());
                    object = loader.load(category.getQualifiedName(), map);
                    category.addObject(string2, object);
                }
            }
            resourceObject.setObject(loader.clone(object));
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException));
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError((Throwable)((Object)noPrivilegeException));
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError((Throwable)((Object)unknownResource));
        }
        catch (JException jException) {
            ServiceLogger.logError(jException);
        }
        return resourceObject;
    }

    @Override
    public void registerLoader(String string, Loader loader) {
        this.clear.put(string, loader);
    }

    @Override
    public void destroy() {
        this.cancel.clear();
        this.clear.clear();
        this.decreaseReference.cancel();
        this.destroy.clear();
    }

    @Override
    public void remove(ResourceObject resourceObject) {
        String string = (String)resourceObject.getDependant("res.categorykey");
        Category category = (Category)this.cancel.get(string);
        if (category.decreaseReference() == 0) {
            RemoveCategoryTask removeCategoryTask = new RemoveCategoryTask(string, this.cancel);
            this.destroy.put(string, removeCategoryTask);
            this.decreaseReference.schedule((TimerTask)removeCategoryTask, 1800000L);
        }
    }

    class RemoveCategoryTask
    extends TimerTask {
        private String SEDU;
        private Hashtable access$000;

        RemoveCategoryTask(String string, Hashtable hashtable) {
            this.SEDU = string;
            this.access$000 = hashtable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Hashtable hashtable = this.access$000;
            synchronized (hashtable) {
                Category category = (Category)this.access$000.get(this.SEDU);
                if (category.free == 0) {
                    category.clear();
                    this.access$000.remove(this.SEDU);
                }
            }
        }
    }

    class Category {
        private String SEDU;
        private String add;
        private Hashtable clear;
        private Vector contains;
        private int free;

        Category(String string, String string2) {
            this.SEDU = string;
            this.add = string2;
            this.clear = new Hashtable();
            this.contains = new Vector();
            this.free = 0;
        }

        String getQualifiedName() {
            return this.add;
        }

        synchronized int increaseReference() {
            return ++this.free;
        }

        synchronized int decreaseReference() {
            return --this.free;
        }

        void addObject(String string, Object object) {
            if (!this.contains.contains(string)) {
                this.contains.add(string);
                if (object != null) {
                    this.clear.put(string, object);
                }
            }
        }

        boolean hasObject(String string) {
            return this.contains.contains(string);
        }

        Object getObject(String string) {
            return this.clear.get(string);
        }

        void clear() {
            this.contains.clear();
            for (Object v : this.clear.values()) {
                if (!(v instanceof JetUUniverse)) continue;
                ((JetUUniverse)v).free();
            }
            this.clear.clear();
        }
    }
}

