/*
 * Decompiled with CFR 0.152.
 */
package jet.server.objmanager;

import com.jinfonet.api.objectmanager.Cachable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import jet.server.objmanager.Cache;

public final class MemoryCache
implements Cache {
    private LinkedList SEDU = new LinkedList();
    private HashMap accessTime = new HashMap();
    private long addLast = 1024L;
    private long append;
    private int clear;
    private int containsKey;
    private boolean currentTimeMillis = false;

    public MemoryCache() {
    }

    public MemoryCache(long l) {
        this();
        this.setMaxSize(l);
    }

    public MemoryCache(long l, boolean bl) {
        this(l);
        this.currentTimeMillis = bl;
    }

    @Override
    public void put(Object object, Object object2) {
        CachedObject cachedObject = new CachedObject(object, object2);
        this.put(cachedObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object object) {
        Object object2 = null;
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            if (!this.accessTime.containsKey(object)) {
                ++this.containsKey;
            } else {
                ++this.clear;
                CachedObject cachedObject = this.accessTime(object);
                object2 = cachedObject.obj;
                this.put(cachedObject);
            }
        }
        return object2;
    }

    @Override
    public void remove(Object object) {
        CachedObject cachedObject = this.accessTime(object);
        if (cachedObject != null) {
            this.SEDU(cachedObject.obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object object) {
        boolean bl = false;
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            bl = this.accessTime.containsKey(object);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCachedCount() {
        int n = 0;
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            n = this.SEDU.size();
        }
        return n;
    }

    @Override
    public int getHitCount() {
        return this.clear;
    }

    @Override
    public int getMissCount() {
        return this.containsKey;
    }

    @Override
    public long getCurrentSize() {
        return this.append;
    }

    @Override
    public long getMaxSize() {
        return this.addLast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxSize(long l) {
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            this.addLast = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            Iterator iterator = this.SEDU.iterator();
            while (iterator.hasNext()) {
                CachedObject cachedObject = (CachedObject)iterator.next();
                this.SEDU(cachedObject.obj);
                iterator.remove();
            }
            this.accessTime.clear();
            this.append = 0L;
            this.clear = 0;
            this.containsKey = 0;
        }
    }

    public void destroy() {
        this.clear();
        this.SEDU = null;
        this.accessTime = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            stringBuilder.append("maxSize:").append(this.addLast).append(",");
            stringBuilder.append("curSize:").append(this.append).append(",");
            stringBuilder.append("hit:").append(this.clear).append(",");
            stringBuilder.append("miss:").append(this.containsKey).append(",");
            stringBuilder.append("count:").append(this.SEDU.size());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(CachedObject cachedObject) {
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            if (this.accessTime.containsKey(cachedObject.key)) {
                return;
            }
            if (this.addLast - this.append < (long)cachedObject.size) {
                this.addLast(cachedObject.size);
            }
            cachedObject.accessTime = System.currentTimeMillis();
            this.SEDU.addLast(cachedObject);
            this.accessTime.put(cachedObject.key, cachedObject.obj);
            this.append += (long)cachedObject.size;
        }
    }

    private void SEDU(Object object) {
        if (object instanceof Cachable) {
            ((Cachable)object).destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedObject accessTime(Object object) {
        CachedObject cachedObject = null;
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            if (this.accessTime.containsKey(object)) {
                int n = this.SEDU.size();
                for (int i = 0; i < n; ++i) {
                    CachedObject cachedObject2 = (CachedObject)this.SEDU.get(i);
                    if (!cachedObject2.key.equals(object)) continue;
                    cachedObject = cachedObject2;
                    this.SEDU.remove(i);
                    this.accessTime.remove(object);
                    this.append -= (long)cachedObject2.size;
                    break;
                }
            }
        }
        return cachedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLast(int n) {
        MemoryCache memoryCache = this;
        synchronized (memoryCache) {
            int n2;
            CachedObject cachedObject;
            for (n2 = 0; n2 < n; n2 += cachedObject.size) {
                cachedObject = (CachedObject)this.SEDU.remove(0);
                this.SEDU(cachedObject.obj);
                this.accessTime.remove(cachedObject.key);
            }
            this.append -= (long)n2;
        }
    }

    public static class SizeCalculator {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int calcObjectSize(Serializable serializable) {
            DumbBytesOutputStream dumbBytesOutputStream = new DumbBytesOutputStream();
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(dumbBytesOutputStream);
                objectOutputStream.writeObject(serializable);
            }
            catch (IOException iOException) {
                int n = 1;
                return n;
            }
            finally {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            return dumbBytesOutputStream.size();
        }

        public static class DumbBytesOutputStream
        extends OutputStream {
            private int SEDU = 0;

            @Override
            public void write(int n) throws IOException {
                ++this.SEDU;
            }

            public int size() {
                return this.SEDU;
            }
        }
    }

    private class CachedObject {
        Object key;
        Object obj;
        int size;
        long accessTime;
        int accessCont;

        public CachedObject(Object object, Object object2) {
            this.key = object;
            this.obj = object2;
            if (MemoryCache.this.currentTimeMillis && !(object2 instanceof Serializable)) {
                MemoryCache.this.currentTimeMillis = false;
            }
            this.size = MemoryCache.this.currentTimeMillis ? SizeCalculator.calcObjectSize((Serializable)object2) : 1;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            stringBuilder.append("key:").append(this.key.toString()).append(",");
            stringBuilder.append("obj:").append(this.obj.toString()).append(",");
            stringBuilder.append("size:").append(this.size).append(",");
            stringBuilder.append("time:").append(this.accessTime).append(",");
            stringBuilder.append("count:").append(this.accessCont);
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }
}

