/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling;

import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.Workspace;
import jet.server.api.profiling.CollectingAgency;
import jet.server.db.Connector;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.WorkspaceImpl;
import jet.server.db.core.WorkspaceManager;
import jet.server.db.transfer.ProfilingTransferHelp;
import jet.server.event.EventHandler;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.event.TopicEvent;
import jet.server.event.subscriber.SubscribeService;
import jet.server.log.ServiceLogger;
import jet.server.profiling.CounterCategory;
import jet.server.profiling.PerformanceCounter;
import jet.server.profiling.ProfilingReport;
import jet.server.profiling.ProfilingService;
import jet.server.profiling.jreport.DefProfilingReport;
import jet.server.profiling.net.RemoteFileSystemImpl;
import jet.server.rmi.RemoteObjectFactory;

public final class ProfilingServiceImpl
implements ProfilingService,
jet.server.api.profiling.ProfilingService {
    private static final long serialVersionUID = -6081093301513897814L;
    private static ProfilingServiceImpl SEDU = null;
    private RemoteFileSystemImpl activate = null;
    private SubscribeService addSelector = null;
    private Connector append = null;
    private Database clone = null;
    private Hashtable close = new Hashtable();
    private CollectingAgency createStatement = null;
    private CollectingAgency createSubscriber = null;
    private static final String databases = "SELECT  COUNT(ID) AS NC_TSK_TOTALS,SUM(NC_RPT_FORMATS*NC_RPT_PAGES) AS SUM_PGS_TOTALS,SUM(VI_TSK_STATUS) AS NC_TSK_SUCCESSFUL,MAX(NC_RPT_FORMATS*NC_RPT_PAGES) AS MAX_PGS_TOTALS,SUM(TC_TSK_TOTAL) AS SUM_TSKTIME_TOTAL,MAX(TC_TSK_TOTAL) AS MAX_TSKTIME_TOTAL,SUM(TC_TSK_WAITED) AS SUM_TSKTIME_WAITED,MAX(TC_TSK_WAITED) AS MAX_TSKTIME_WAITED,SUM(TC_ENG_TOTAL) AS SUM_ENGTIME_TOTAL,MAX(TC_ENG_TOTAL) AS MAX_ENGTIME,SUM(NC_ENG_CONCURRENT) AS SUM_ENG_CONCURRENT,MAX(NC_ENG_CONCURRENT) AS MAX_ENG_CONCURRENT,SUM(VI_TSK_TYPE) AS NC_TSK_SCHEDULE FROM TASKCONTEXT";

    public static ProfilingServiceImpl getInstance() {
        return SEDU;
    }

    public static synchronized ProfilingServiceImpl newInstance() {
        if (SEDU == null) {
            try {
                SEDU = new ProfilingServiceImpl();
                if (ServerEnv.shouldStartRMI()) {
                    UnicastRemoteObject.exportObject((Remote)SEDU, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
                }
            }
            catch (RemoteException remoteException) {
                ServiceLogger.logError(remoteException);
                SEDU = null;
            }
        }
        return SEDU;
    }

    public void destroy() {
        if (SEDU != null) {
            if (this.createStatement != null) {
                this.createStatement.destroy();
            }
            if (this.createSubscriber != null) {
                this.createSubscriber.destroy();
            }
            if (this.clone != null) {
                ((DatabaseImpl)this.clone).close();
            }
            if (this.append != null) {
                this.append.destroy();
            }
            if (this.addSelector != null) {
                this.addSelector.destroyAllSubscribers();
            }
            this.activate = null;
            SEDU = null;
        }
    }

    public void registerToManager() {
        RemoteObjectFactory.register("42bab3c2-c4b4-471f-9b45-027a50f2f151", this);
        RemoteObjectFactory.register("8fc391bf-6f98-4c47-b6c2-9dd1c04a8413", this.activate);
    }

    @Override
    public PerformanceCounter getPerformanceCounter(String string, String string2) throws RemoteException {
        return CounterCategory.getCounter(null, string, string2);
    }

    @Override
    public PerformanceCounter[] getPerformanceCounters(String string) throws RemoteException {
        CounterCategory counterCategory = CounterCategory.getCategory(null, string);
        return counterCategory.getCounters();
    }

    @Override
    public String[] getCategories() throws RemoteException {
        CounterCategory[] counterCategoryArray = CounterCategory.getCategories();
        String[] stringArray = new String[counterCategoryArray.length];
        for (int i = 0; i < counterCategoryArray.length; ++i) {
            stringArray[i] = counterCategoryArray[i].getCategoryName();
        }
        return stringArray;
    }

    public void registerProfilingReport(ProfilingReport profilingReport) {
        this.close.put(profilingReport.getProfileName(), profilingReport);
    }

    @Override
    public String[] getProfileNames() throws RemoteException {
        String[] stringArray = new String[this.close.size()];
        Enumeration enumeration = this.close.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    @Override
    public Properties getProfilingCounterValue() {
        if (this.append != null) {
            try {
                Connection connection = this.append.getConnection(10000L);
                Statement statement = connection.createStatement();
                statement.setEscapeProcessing(true);
                ResultSet resultSet = statement.executeQuery(databases);
                Properties properties = new Properties();
                if (resultSet.next()) {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n = resultSetMetaData.getColumnCount();
                    for (int i = 1; i < n + 1; ++i) {
                        String string = resultSetMetaData.getColumnName(i);
                        String string2 = resultSet.getString(i);
                        if (string2 != null) {
                            properties.put(string, string2);
                            continue;
                        }
                        properties.put(string, "0");
                    }
                    resultSet.close();
                    statement.close();
                    connection.close();
                    return properties;
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return new Properties();
    }

    @Override
    public String runReport(String string, Properties properties) throws RemoteException {
        ProfilingReport profilingReport = (ProfilingReport)this.close.get(string);
        if (profilingReport != null && this.append != null) {
            properties.setProperty("jreport.rpthome", ServerEnv.homePath);
            properties.setProperty("jrs.param$jdbc_driver", this.append.getProperty("driver", ""));
            properties.setProperty("jrs.param$jdbc_url", this.append.getProperty("url", ""));
            properties.setProperty("jrs.param$jdbc_user", this.append.getProperty("user", ""));
            properties.setProperty("jrs.param$jdbc_password", this.append.getProperty("password", ""));
            try {
                Connection connection = this.append.getConnection(10000L);
                properties.put("profilingdb.connection", connection);
            }
            catch (SQLException sQLException) {
                throw new RemoteException("", sQLException);
            }
            try {
                return profilingReport.runReport(properties);
            }
            catch (Exception exception) {
                throw new RemoteException("", exception);
            }
        }
        throw new RemoteException("Can not found " + string + " profiling report.");
    }

    private ProfilingServiceImpl() throws RemoteException {
        String string = ServerEnv.getActiveRealm();
        Workspace workspace = WorkspaceManager.getInstance().workspaces(string);
        if (workspace == null) {
            workspace = new WorkspaceImpl(string);
            this.clone = this.SEDU(workspace);
            WorkspaceManager.getInstance().append(workspace);
            WorkspaceManager.getInstance().saveConfig();
        } else {
            this.clone = workspace.databases("profile");
            if (this.clone == null) {
                this.clone = this.SEDU(workspace);
                WorkspaceManager.getInstance().saveConfig();
            }
        }
        if (this.clone instanceof DatabaseImpl) {
            ((DatabaseImpl)this.clone).setTransferHelp(new ProfilingTransferHelp());
        }
        try {
            ((DatabaseImpl)this.clone).open();
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getLocalizedMessage());
        }
        ServiceLogger.logDebug(4640002, new String[]{string, "profiling"}, 4);
        this.append = ((DatabaseImpl)this.clone).getConnector();
        this.activate = new RemoteFileSystemImpl();
        if (ServerEnv.shouldStartRMI()) {
            UnicastRemoteObject.exportObject((Remote)this.activate, CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        }
        this.addSelector = SubscribeService.newInstance();
        Subscriber subscriber = this.addSelector.createSubscriber(new ProfileDataReceiver());
        SelectorImpl selectorImpl = new SelectorImpl("*", 32);
        selectorImpl.enableAll();
        subscriber.addSelector(selectorImpl);
        try {
            subscriber.activate();
            ServiceLogger.logEvent(6660002, 6);
        }
        catch (Exception exception) {
            ServiceLogger.logEvent(6660003, 6);
        }
        try {
            this.createStatement = (CollectingAgency)Class.forName("jet.server.profiling.jreport.RptServerCollectingAgency").newInstance();
        }
        catch (InstantiationException instantiationException) {
            ServiceLogger.logError(instantiationException, 2);
        }
        catch (IllegalAccessException illegalAccessException) {
            ServiceLogger.logError(illegalAccessException, 2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ServiceLogger.logError(classNotFoundException, 2);
        }
        try {
            this.createSubscriber = (CollectingAgency)Class.forName("jet.server.profiling.jreport.ReportCollector").newInstance();
        }
        catch (InstantiationException instantiationException) {
            ServiceLogger.logError(instantiationException, 2);
        }
        catch (IllegalAccessException illegalAccessException) {
            ServiceLogger.logError(illegalAccessException, 2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ServiceLogger.logError(classNotFoundException, 2);
        }
        Properties properties = (Properties)this.clone.getProperties().clone();
        if (this.append != null) {
            properties.put("database", this.clone);
        }
        if (this.createStatement != null) {
            properties.put("restore.profiling", System.getProperty("restore.profiling", ""));
            this.createStatement.init(properties);
            this.createSubscriber.init(properties);
        }
        this.registerProfilingReport(new DefProfilingReport("Reports Running Profile", "RptProfile.cls", "TaskRunningStat"));
        this.registerProfilingReport(new DefProfilingReport("Frequently Accessed Reports", "FreqAccessStat.cls", "FreqAccessdStat"));
    }

    private Database SEDU(Workspace workspace) {
        Object object;
        int n = 8886;
        ExProperties exProperties = new ExProperties();
        try {
            object = ServerEnv.homePath + "derby" + File.separator + "derby.properties";
            exProperties.load((String)object);
            n = exProperties.getProperty("derby.drda.portNumber", 1527);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        object = new DatabaseImpl(workspace, "profile");
        object.setProperty("driver", "org.apache.derby.jdbc.ClientDriver");
        object.setProperty("user", "APP");
        object.setProperty("password", "APP");
        object.setProperty("auto-start-derbyservice", "true");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jdbc:derby://localhost:").append(n).append("/profilingtable.").append(workspace.getName()).append(";create=true");
        object.setProperty("url", stringBuffer.substring(0));
        ((WorkspaceImpl)workspace).append((Database)object);
        return object;
    }

    private final class ProfileDataReceiver
    implements EventHandler {
        @Override
        public void process(TopicEvent topicEvent) {
            if ("TaskContext".equals(topicEvent.getTopic()) && ProfilingServiceImpl.this.createStatement != null && ProfilingServiceImpl.this.createStatement.isAlive()) {
                ProfilingServiceImpl.this.createStatement.collects((Hashtable)topicEvent.getData());
            }
            if (topicEvent.getTopic().equals("TaskAuditor")) {
                if (ProfilingServiceImpl.this.createStatement != null && ProfilingServiceImpl.this.createStatement.isAlive()) {
                    ProfilingServiceImpl.this.createStatement.collects((Hashtable)topicEvent.getData());
                }
                if (ProfilingServiceImpl.this.createSubscriber != null && ProfilingServiceImpl.this.createSubscriber.isAlive()) {
                    ProfilingServiceImpl.this.createSubscriber.collects((Hashtable)topicEvent.getData());
                }
            }
        }
    }
}

