/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.jreport.performance.monitor;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import jet.server.api.http.HttpUtil;
import jet.server.event.EventHandler;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.event.TopicEvent;
import jet.server.event.subscriber.SubscribeService;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.profiling.jreport.performance.monitor.JRTaskInfo;
import jet.server.profiling.jreport.performance.monitor.JRTaskStatistic;

public class TaskEventHandler
implements EventHandler {
    private Map SEDU = new ConcurrentHashMap();
    private Map activate = new ConcurrentHashMap();
    private Map addSelector = new ConcurrentHashMap();
    private Map append = new ConcurrentHashMap();
    private Map clear = new Hashtable();
    private Map containsKey = new Hashtable();
    private Map createSubscriber = new ConcurrentHashMap();
    private boolean enableAll = true;
    private int equals = 0;
    private int get = 0;
    private int getAllTaskStatistics = 0;
    private long getData = 0L;

    public TaskEventHandler() {
        Subscriber subscriber = SubscribeService.newInstance().createSubscriber(this);
        SelectorImpl selectorImpl = new SelectorImpl("TaskManager", 8);
        selectorImpl.enableAll();
        subscriber.addSelector(selectorImpl);
        try {
            subscriber.activate();
            subscriber.update();
            ServiceLogger.logEvent("TaskEventHandler:: Subscriber for TaskManager topic is activated", 6);
        }
        catch (Exception exception) {
            ServiceLogger.logEvent("TaskEventHandler:: Subscriber for TaskManager topic is not activated", 6);
        }
        this.SEDU();
    }

    @Override
    public void process(TopicEvent topicEvent) {
        String string = topicEvent.getTopic();
        ServiceLogger.print("TaskEventHandler:: TaskEventHandler, process " + topicEvent);
        if (string != null) {
            int n = topicEvent.getType();
            if (string.equals("TaskManager")) {
                this.addSelector(n, (Properties)topicEvent.getData());
            } else {
                ServiceLogger.logEvent("TaskEventHandler:: received unknown event " + topicEvent + ", topic=" + string, 6);
            }
        } else {
            ServiceLogger.logEvent("TaskEventHandler:: received bad event " + topicEvent + ", topic=" + string, 6);
        }
    }

    private void SEDU() {
        this.SEDU.clear();
        this.activate.clear();
        this.addSelector.clear();
        this.append.clear();
        this.containsKey.clear();
        this.clear.clear();
        this.enableAll = true;
        this.equals = 0;
        this.get = 0;
        this.getAllTaskStatistics = 0;
        this.activate();
    }

    private void activate() {
        this.createSubscriber.clear();
        try {
            JRRptServer jRRptServer = (JRRptServer)((Object)HttpUtil.getHttpRptServer());
            Vector vector = jRRptServer.getTaskManager().getAllTaskStatistics();
            for (int i = 0; i < vector.size(); ++i) {
                Properties properties = (Properties)vector.get(i);
                JRTaskStatistic jRTaskStatistic = new JRTaskStatistic(properties.getProperty("rptName"), Long.parseLong(properties.getProperty("firstSubmitTime")), Integer.parseInt(properties.getProperty("runTimesNumber")));
                jRTaskStatistic.setLastCatalogName(properties.getProperty("rptSource"));
                jRTaskStatistic.setLastSubmittedTime(Long.parseLong(properties.getProperty("submitTime")));
                jRTaskStatistic.setLastTaskID(properties.getProperty("taskID"));
                jRTaskStatistic.setLastUser(properties.getProperty("userName"));
                jRTaskStatistic.setLastPageeNumber(Integer.parseInt(properties.getProperty("rptPages")));
                this.createSubscriber.put(jRTaskStatistic.getReportName(), jRTaskStatistic);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    private void addSelector(int n, Properties properties) {
        JRTaskInfo jRTaskInfo = null;
        switch (n) {
            case 0: {
                jRTaskInfo = (JRTaskInfo)this.SEDU.get(properties.getProperty("taskID"));
                int n2 = Integer.parseInt(properties.getProperty("taskStatus"));
                if (jRTaskInfo == null && n2 == 3) {
                    return;
                }
                if (jRTaskInfo == null || n2 == 1 || n2 == 2) {
                    jRTaskInfo = new JRTaskInfo(properties.getProperty("taskID"), properties.getProperty("rptName"), Integer.parseInt(properties.getProperty("taskType")), properties.getProperty("serverName"), Long.parseLong(properties.getProperty("submitTime")), properties.getProperty("rptSource"), properties.getProperty("userName"));
                    if (Integer.parseInt(properties.getProperty("taskType")) == 2) {
                        jRTaskInfo.setTaskID(this.enableAll(properties.getProperty("taskID")));
                    }
                    long l = Long.parseLong(properties.getProperty("submitTime")) + this.getData;
                    jRTaskInfo.setSubmittedTime(l);
                    this.append(jRTaskInfo);
                }
                jRTaskInfo.setTaskStatus(n2);
                break;
            }
            case 1: {
                String string = properties.getProperty("taskID");
                int n3 = Integer.parseInt(properties.getProperty("taskStatus"));
                if (n3 == 5 || n3 == 4) {
                    jRTaskInfo = (JRTaskInfo)this.SEDU.get(string);
                    if (jRTaskInfo == null) {
                        jRTaskInfo = this.equals(this.SEDU, string);
                    }
                    if (jRTaskInfo == null) break;
                    jRTaskInfo.setRunHost(properties.getProperty("runHost"));
                    try {
                        jRTaskInfo.setRunPort(Integer.parseInt(properties.getProperty("runPort")));
                    }
                    catch (NumberFormatException numberFormatException) {
                        jRTaskInfo.setRunPort(-1);
                    }
                    long l = Long.parseLong(properties.getProperty("startTime")) + this.getData;
                    jRTaskInfo.setStartedTime(l);
                    jRTaskInfo.setTaskStatus(n3);
                    this.clear(jRTaskInfo);
                    break;
                }
                jRTaskInfo = (JRTaskInfo)this.activate.get(string);
                if (jRTaskInfo == null) {
                    jRTaskInfo = this.equals(this.activate, string);
                }
                if (jRTaskInfo == null) break;
                jRTaskInfo.setTaskStatus(n3);
                break;
            }
            case 2: {
                String string = properties.getProperty("taskID");
                jRTaskInfo = (JRTaskInfo)this.activate.get(string);
                if (jRTaskInfo == null) {
                    jRTaskInfo = this.equals(this.activate, string);
                }
                if (jRTaskInfo == null) break;
                jRTaskInfo.setRunHost(properties.getProperty("runHost"));
                try {
                    jRTaskInfo.setRunPort(Integer.parseInt(properties.getProperty("runPort")));
                }
                catch (NumberFormatException numberFormatException) {
                    jRTaskInfo.setRunPort(-1);
                }
                long l = Long.parseLong(properties.getProperty("finishTime")) + this.getData;
                jRTaskInfo.setFinishedTime(l);
                int n4 = 0;
                try {
                    n4 = Integer.parseInt(properties.getProperty("rptPages"));
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = -1;
                }
                if (n4 < 0) {
                    ServiceLogger.logEvent("TaskEventHandler:: received a finished task with '" + n4 + "' pages", 6);
                    n4 = 0;
                }
                jRTaskInfo.setReportPages(n4);
                jRTaskInfo.setResultFileName(properties.getProperty("rstFileName"));
                jRTaskInfo.setReason(properties.getProperty("reason"));
                jRTaskInfo.setEngineInfo(properties.getProperty("engineInfo"));
                jRTaskInfo.setTaskStatus(Integer.parseInt(properties.getProperty("taskStatus")));
                this.containsKey(jRTaskInfo);
                break;
            }
            case 3: {
                String string = properties.getProperty("taskID");
                jRTaskInfo = (JRTaskInfo)this.addSelector.get(string);
                if (jRTaskInfo == null && (jRTaskInfo = (JRTaskInfo)this.activate.get(string)) == null && (jRTaskInfo = (JRTaskInfo)this.SEDU.get(string)) == null && (jRTaskInfo = this.equals(this.SEDU, string)) == null && (jRTaskInfo = this.equals(this.activate, string)) == null) {
                    jRTaskInfo = this.equals(this.addSelector, string);
                }
                if (jRTaskInfo == null) break;
                jRTaskInfo.setFailedInfo(properties.getProperty("failedInfo"));
                jRTaskInfo.setTaskStatus(Integer.parseInt(properties.getProperty("taskStatus")));
                jRTaskInfo.setFailedToRun();
                this.createSubscriber(jRTaskInfo);
                break;
            }
            default: {
                ServiceLogger.logEvent("TaskEventHandler:: received a unknown task event. It doesn''t support this task type: " + n, 6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(JRTaskInfo jRTaskInfo) {
        this.SEDU.put(jRTaskInfo.getTaskID(), jRTaskInfo);
        JRTaskStatistic jRTaskStatistic = null;
        Map map = this.createSubscriber;
        synchronized (map) {
            jRTaskStatistic = (JRTaskStatistic)this.createSubscriber.get(jRTaskInfo.getReportName());
            if (jRTaskStatistic == null) {
                jRTaskStatistic = new JRTaskStatistic(jRTaskInfo.getReportName(), jRTaskInfo.getSubmittedTime(), 0);
                this.createSubscriber.put(jRTaskStatistic.getReportName(), jRTaskStatistic);
            }
        }
        jRTaskStatistic.setLastUser(jRTaskInfo.getUserName());
        jRTaskStatistic.setLastSubmittedTime(jRTaskInfo.getSubmittedTime());
        jRTaskStatistic.setLastCatalogName(jRTaskInfo.getReportSource());
        jRTaskStatistic.setLastTaskID(jRTaskInfo.getTaskID());
        jRTaskStatistic.runOnce();
    }

    private void clear(JRTaskInfo jRTaskInfo) {
        this.SEDU.remove(jRTaskInfo.getTaskID());
        this.activate.put(jRTaskInfo.getTaskID(), jRTaskInfo);
    }

    private void containsKey(JRTaskInfo jRTaskInfo) {
        this.activate.remove(jRTaskInfo.getTaskID());
        this.addSelector.put(jRTaskInfo.getTaskID(), jRTaskInfo);
        if (this.enableAll) {
            this.equals = (int)((long)this.equals + (jRTaskInfo.getFinishedTime() - jRTaskInfo.getStartedTime()));
            this.get = (int)((long)this.get + (jRTaskInfo.getStartedTime() - jRTaskInfo.getSubmittedTime()));
            ++this.getAllTaskStatistics;
        }
        String string = jRTaskInfo.getUserName();
        int n = 0;
        if (this.containsKey.get(string) != null) {
            n = (Integer)this.containsKey.get(string);
        }
        this.containsKey.put(string, ++n);
        JRTaskStatistic jRTaskStatistic = (JRTaskStatistic)this.createSubscriber.get(jRTaskInfo.getReportName());
        jRTaskStatistic.setLastPageeNumber(jRTaskInfo.getReportPages());
    }

    private void createSubscriber(JRTaskInfo jRTaskInfo) {
        this.SEDU.remove(jRTaskInfo.getTaskID());
        this.activate.remove(jRTaskInfo.getTaskID());
        this.addSelector.remove(jRTaskInfo.getTaskID());
        this.append.put(jRTaskInfo.getTaskID(), jRTaskInfo);
        JRTaskStatistic jRTaskStatistic = (JRTaskStatistic)this.createSubscriber.get(jRTaskInfo.getReportName());
        jRTaskStatistic.setLastPageeNumber(jRTaskInfo.getReportPages());
    }

    private String enableAll(String string) {
        int n;
        String string2 = null;
        int n2 = this.get(this.SEDU, string);
        if (n2 < (n = this.get(this.activate, string))) {
            n2 = n;
        }
        if (n2 < (n = this.get(this.addSelector, string))) {
            n2 = n;
        }
        if (n2 == 0) {
            string2 = string;
            if (this.clear.get(string) != null) {
                this.clear.remove(string);
            }
        } else {
            if (this.clear.get(string) != null) {
                n2 = (Integer)this.clear.get(string);
            }
            string2 = string + "_uid_" + n2;
            this.clear.put(string, n2);
        }
        return string2;
    }

    private JRTaskInfo equals(Map map, String string) {
        if (this.clear.containsKey(string)) {
            int n = (Integer)this.clear.get(string);
            for (int i = 1; i <= n; ++i) {
                JRTaskInfo jRTaskInfo = (JRTaskInfo)map.get(string + "_uid_" + i);
                if (jRTaskInfo == null) continue;
                return jRTaskInfo;
            }
        }
        return null;
    }

    private int get(Map map, String string) {
        int n = 0;
        if (map.containsKey(string)) {
            for (String string2 : map.keySet()) {
                if (!string2.startsWith(string)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getWaitingRptNums() {
        return this.SEDU.size();
    }

    public int getRunningRptNums() {
        return this.activate.size();
    }

    public int getFinishedRptNums() {
        return this.addSelector.size();
    }

    public int getFinishedRptPages() {
        int n = 0;
        for (JRTaskInfo jRTaskInfo : this.addSelector.values()) {
            n += jRTaskInfo.getTotalPages();
        }
        return n;
    }

    public int getAvgProcessTimeByRpt() {
        if (this.getAllTaskStatistics != 0) {
            return this.equals / this.getAllTaskStatistics;
        }
        return 0;
    }

    public int getAvgWaitTimeByRpt() {
        if (this.getAllTaskStatistics != 0) {
            return this.get / this.getAllTaskStatistics;
        }
        return 0;
    }

    public int getAvgSubmitRptNumsByUser() {
        int n = 0;
        int n2 = 0;
        for (String string : this.containsKey.keySet()) {
            n += ((Integer)this.containsKey.get(string)).intValue();
            ++n2;
        }
        if (n2 != 0) {
            return n / n2;
        }
        return 0;
    }
}

