/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.util;

import java.util.Hashtable;
import java.util.Properties;
import jet.server.log.ServiceLogger;
import jet.server.profiling.util.ProfilingCounterNames;

public class ProfilingCounterUtil {
    public static Properties profilingAccumulateProps = new Properties();
    private static Properties SEDU = new Properties();
    private static String averageconcurrentengines = "NC_TSK_TOTALS";
    private static String containsKey = "SUM_ENGTIME_TOTAL";
    private static String doubleValue = "SUM_PGS_TOTALS";
    private static String equalsIgnoreCase = "NC_TSK_SUCCESSFUL";
    private static String exportpagesperminute = "NC_TSK_SCHEDULE";
    private static String get = "VI_tsk_type";
    private static String indexOf = "VI_tsk_status";
    private static String intValue = "TC_eng_total";
    private static String isEmpty = "NC_rpt_pages";
    private static String isLoggable = "SUM_TSKTIME_TOTAL";
    private static String length = "TC_tsk_total";
    private static String logError = "SUM_TSKTIME_WAITED";
    private static String longValue = "SUM_ENG_CONCURRENT";
    private static String maximumconcurrent = "TC_tsk_waited";
    private static String numberofreportsperminute = "NC_eng_concurrent";
    private static String ondemandtasks = "MAX_PGS_TOTALS";
    private static String parseInt = "MAX_TSKTIME_TOTAL";
    private static String put = "MAX_TSKTIME_WAITED";
    private static String substring = "MAX_ENGTIME";
    private static String successfultasks = "MAX_ENG_CONCURRENT";
    private static String taskaverageenginetime = "NC_rpt_formats";

    public ProfilingCounterUtil(Properties properties) {
        SEDU = properties;
    }

    private Double SEDU(Double d) {
        String string = Double.toString(d);
        int n = string.length();
        int n2 = 2;
        if (string.indexOf(".") > -1) {
            int n3 = string.indexOf(".");
            if ((n3 = n3 + 1 + n2) < n) {
                int n4;
                if (n >= n3 + 1 && (n4 = Integer.parseInt(string.substring(n3, n3 + 1))) >= 5) {
                    Double d2 = new Double(d + 0.005);
                    string = d2.toString();
                }
                string = string.substring(0, n3);
            }
        }
        return new Double(string);
    }

    public synchronized void accumulateProfilingCounterValues() {
        Properties properties;
        block5: {
            if (SEDU == null || SEDU.get(averageconcurrentengines) == null) {
                return;
            }
            Double d = (Double)SEDU.get(averageconcurrentengines);
            Double d2 = 0.0;
            Double d3 = (Double)SEDU.get(containsKey);
            properties = new Properties();
            if (SEDU.isEmpty() || SEDU.get(averageconcurrentengines) == "0") {
                return;
            }
            try {
                Double d4 = (Double)SEDU.get(doubleValue);
                properties.put(ProfilingCounterNames.totalcompletedtasks.toString(), SEDU.get(averageconcurrentengines));
                if (d3 != 0.0) {
                    d2 = d / (d3 / 60000.0);
                    properties.put(ProfilingCounterNames.numberofreportsperminute.toString(), this.SEDU(d2));
                    d2 = d4 / (d3 / 60000.0);
                    properties.put(ProfilingCounterNames.totalnumberofpageexported.toString(), SEDU.get(doubleValue));
                    properties.put(ProfilingCounterNames.exportpagesperminute.toString(), this.SEDU(d2));
                    properties.put(ProfilingCounterNames.successfultasks.toString(), SEDU.get(equalsIgnoreCase));
                    d2 = d - (Double)SEDU.get(exportpagesperminute);
                    properties.put(ProfilingCounterNames.ondemandtasks.toString(), d2);
                    d2 = d2 / d;
                    d2 = d4 / d;
                    properties.put(ProfilingCounterNames.taskaveragepages.toString(), this.SEDU(d2));
                    properties.put(ProfilingCounterNames.taskmaximumpages.toString(), SEDU.get(ondemandtasks));
                    Double d5 = (Double)SEDU.get(isLoggable);
                    d2 = d5 / 1000.0 / d;
                    properties.put(ProfilingCounterNames.taskaverageruntime.toString(), this.SEDU(d2));
                    d2 = (Double)SEDU.get(parseInt) / 1000.0;
                    properties.put(ProfilingCounterNames.taskmaximumruntime.toString(), this.SEDU(d2));
                    d5 = (Double)SEDU.get(logError);
                    d2 = d5 / 1000.0 / d;
                    properties.put(ProfilingCounterNames.taskaveragewaittime.toString(), this.SEDU(d2));
                    d2 = (Double)SEDU.get(put) / 1000.0;
                    properties.put(ProfilingCounterNames.taskmaxwaittime.toString(), this.SEDU(d2));
                    d2 = d3 / 1000.0 / d;
                    properties.put(ProfilingCounterNames.taskaverageenginetime.toString(), this.SEDU(d2));
                    d2 = (Double)SEDU.get(substring) / 1000.0;
                    properties.put((Object)ProfilingCounterNames.taskmaximumenginetime, this.SEDU(d2));
                    d2 = (Double)SEDU.get(longValue);
                    d2 = d2 / d;
                    properties.put(ProfilingCounterNames.averageconcurrentengines.toString(), this.SEDU(d2));
                    properties.put(ProfilingCounterNames.maximumconcurrent.toString(), SEDU.get(successfultasks));
                }
            }
            catch (Exception exception) {
                if (!ServiceLogger.isLoggable(2, 3)) break block5;
                ServiceLogger.logError(exception, 3);
            }
        }
        profilingAccumulateProps = properties;
    }

    public synchronized void updateProfilingProp(Hashtable hashtable) {
        if (hashtable != null) {
            Number number;
            Number number2;
            if (SEDU.get(averageconcurrentengines) != null) {
                number2 = (Double)SEDU.get(averageconcurrentengines) + 1.0;
                SEDU.put(averageconcurrentengines, number2);
            }
            if ((Integer)(number2 = (Integer)hashtable.get(get)) != 0) {
                number = (Double)SEDU.get(exportpagesperminute);
                number = (Double)number + 1.0;
                SEDU.put(exportpagesperminute, number);
            }
            number2 = (Integer)hashtable.get(indexOf);
            Double d = (Double)SEDU.get(equalsIgnoreCase);
            number2 = (Integer)number2 + d.intValue();
            d = new Double(((Integer)number2).intValue());
            SEDU.put(equalsIgnoreCase, d);
            if (SEDU.get(containsKey) != null) {
                Double d2 = (Double)SEDU.get(containsKey);
                number = (Long)hashtable.get(intValue);
                d2 = d2 + ((Long)number).doubleValue();
            }
            if (SEDU.get(doubleValue) != null) {
                Double d3 = (Double)SEDU.get(doubleValue);
                number = (Long)hashtable.get(isEmpty) * (Long)hashtable.get(taskaverageenginetime);
                d3 = d3 + ((Long)number).doubleValue();
                SEDU.put(doubleValue, d3);
            }
            number = (Long)hashtable.get(length);
            if (SEDU.get(isLoggable) != null) {
                d = ((Long)number).doubleValue() + (Double)SEDU.get(isLoggable);
                SEDU.put(isLoggable, d);
            }
            number = (Long)hashtable.get(maximumconcurrent);
            d = ((Long)number).doubleValue() + (Double)SEDU.get(logError);
            SEDU.put(logError, d);
            number = (Long)hashtable.get(intValue);
            d = ((Long)number).doubleValue() + (Double)SEDU.get(containsKey);
            SEDU.put(containsKey, d);
            number = (Long)hashtable.get(numberofreportsperminute);
            d = ((Long)number).doubleValue() + (Double)SEDU.get(longValue);
            SEDU.put(longValue, d);
            number = (Long)hashtable.get(isEmpty) * (Long)hashtable.get(taskaverageenginetime);
            d = ((Long)number).doubleValue();
            if (d > (Double)SEDU.get(ondemandtasks)) {
                SEDU.put(ondemandtasks, d);
            }
            if ((d = Double.valueOf(((Long)(number = (Long)hashtable.get(length))).doubleValue())) > (Double)SEDU.get(parseInt)) {
                SEDU.put(parseInt, d);
            }
            if ((d = Double.valueOf(((Long)(number = (Long)hashtable.get(maximumconcurrent))).doubleValue())) > (Double)SEDU.get(put)) {
                SEDU.put(put, d);
            }
            if ((d = Double.valueOf(((Long)(number = (Long)hashtable.get(intValue))).doubleValue())) > (Double)SEDU.get(substring)) {
                SEDU.put(substring, d);
            }
            if ((d = Double.valueOf(((Long)(number = (Long)hashtable.get(numberofreportsperminute))).doubleValue())) > (Double)SEDU.get(successfultasks)) {
                SEDU.put(successfultasks, d);
            }
        }
    }

    public static String getCounterType(String string) {
        if (string.equalsIgnoreCase(ProfilingCounterNames.totalcompletedtasks.toString()) || string.equalsIgnoreCase(ProfilingCounterNames.successfultasks.toString()) || string.equalsIgnoreCase(ProfilingCounterNames.ondemandtasks.toString())) {
            return "int";
        }
        if (string.equalsIgnoreCase(ProfilingCounterNames.totalnumberofpageexported.toString()) || string.equalsIgnoreCase(ProfilingCounterNames.taskmaximumpages.toString()) || string.equalsIgnoreCase(ProfilingCounterNames.maximumconcurrent.toString())) {
            return "long";
        }
        return "float";
    }

    public Double getCounter(String string) {
        String string2 = string.toLowerCase();
        if (!profilingAccumulateProps.isEmpty() && profilingAccumulateProps.containsKey(string2)) {
            return (Double)profilingAccumulateProps.get(string2);
        }
        return 0.0;
    }

    public Properties getCounterProperties() {
        return profilingAccumulateProps;
    }
}

