/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.ws.impl;

import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpSession;
import jet.server.ServerEnv;
import jet.server.event.EventHandler;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.event.TopicEvent;
import jet.server.event.subscriber.SubscribeService;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.server.profiling.ProfilingServiceImpl;
import jet.server.profiling.util.ProfilingCounterUtil;
import jet.server.profiling.ws.service.ErrorInfoBean;
import jet.server.profiling.ws.service.JReportServerProfilingWs;
import org.codehaus.xfire.transport.http.XFireServletController;

public class JReportServerProfilingWsImpl
implements JReportServerProfilingWs,
EventHandler {
    ProfilingServiceImpl profilingService;
    private Properties SEDU;
    ProfilingCounterUtil profilingCounterUtil;
    String errorMsg = null;
    ErrorInfoBean errorBean;

    public JReportServerProfilingWsImpl() {
        SubscribeService subscribeService = SubscribeService.newInstance();
        Subscriber subscriber = subscribeService.createSubscriber(this);
        SelectorImpl selectorImpl = new SelectorImpl("TaskContext", 8);
        selectorImpl.enableAll();
        subscriber.addSelector(selectorImpl);
        try {
            subscriber.activate();
            subscriber.update();
            ServiceLogger.logEvent(6660002, 6);
        }
        catch (Exception exception) {
            ServiceLogger.logEvent(6660003, 6);
        }
        this.profilingCounterUtil = new ProfilingCounterUtil(this.SEDU());
        this.profilingCounterUtil.accumulateProfilingCounterValues();
        this.errorBean = new ErrorInfoBean();
    }

    @Override
    public String getCounter(String string) {
        HttpSession httpSession = XFireServletController.getRequest().getSession();
        String string2 = (String)httpSession.getAttribute("JREntServerLogin");
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            return this.profilingCounterUtil.getCounter(string).toString();
        }
        this.errorMsg = "Not login, pls login in first";
        this.errorBean.setErrorMessage(this.errorMsg);
        return null;
    }

    @Override
    public String getCounterType(String string) {
        HttpSession httpSession = XFireServletController.getRequest().getSession();
        String string2 = (String)httpSession.getAttribute("JREntServerLogin");
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            return ProfilingCounterUtil.getCounterType(string);
        }
        this.errorMsg = "Not login, pls login in first";
        this.errorBean.setErrorMessage(this.errorMsg);
        return null;
    }

    @Override
    public void checkLogin(String string, String string2) {
        SecurityService securityService = UserDataToolkit.getSecurityService(ServerEnv.getActiveRealm());
        if (securityService.isValidUser(string, string2)) {
            HttpSession httpSession = XFireServletController.getRequest().getSession();
            httpSession.setAttribute("JREntServerLogin", (Object)"true");
        } else {
            this.errorMsg = string + "is not valid user";
            this.errorBean.setErrorMessage(this.errorMsg);
        }
    }

    @Override
    public ErrorInfoBean getLastError() {
        return this.errorBean;
    }

    private Properties SEDU() {
        this.profilingService = ProfilingServiceImpl.newInstance();
        this.SEDU = this.profilingService.getProfilingCounterValue();
        return this.SEDU;
    }

    @Override
    public void process(TopicEvent topicEvent) {
        if ("TaskContext".equals(topicEvent.getTopic())) {
            Hashtable hashtable = (Hashtable)topicEvent.getData();
            Properties properties = (Properties)this.profilingCounterUtil.getCounterProperties().clone();
            this.profilingCounterUtil.updateProfilingProp(hashtable);
            this.profilingCounterUtil.accumulateProfilingCounterValues();
        }
    }
}

