/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rc;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.rc.ActionProcessor;
import jet.server.rc.HomeProcessor;
import jet.server.rc.RealmProcessor;
import jet.server.userman.Realm;
import jet.server.userman.Resource;
import jet.server.userman.SharedPasswordRealm;
import jet.server.userman.UserDataToolkit;

public class ProtectProcessor
extends ActionProcessor {
    public static String IDS_LIST_PROTECT = "ListProtect";
    public static String IDS_NEW_PROTECT = "NewProtect";
    public static String IDS_EDIT_PROTECT = "EditProtect";
    public static String IDS_REQUEST_NEW_PROTECT = "RequestNewProtect";
    public static String IDS_REQUEST_EDIT_PROTECT = "RequestEditProtect";
    public static String IDS_REMOVE_PROTECT = "RemoveProtect";
    public static String IDS_REQUEST_REMOVE_PROTECT = "RequestRemoveProtect";

    public ProtectProcessor() {
        this.actions.addElement(IDS_LIST_PROTECT);
        this.actions.addElement(IDS_NEW_PROTECT);
        this.actions.addElement(IDS_EDIT_PROTECT);
        this.actions.addElement(IDS_REQUEST_NEW_PROTECT);
        this.actions.addElement(IDS_REQUEST_EDIT_PROTECT);
        this.actions.addElement(IDS_REMOVE_PROTECT);
        this.actions.addElement(IDS_REQUEST_REMOVE_PROTECT);
    }

    @Override
    public void processEvent(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        super.processEvent(string, properties, httpServletRequest, httpServletResponse);
        if (string.equalsIgnoreCase(IDS_LIST_PROTECT)) {
            this.IDS_LIST_PROTECT();
        } else if (string.equalsIgnoreCase(IDS_NEW_PROTECT)) {
            this.IDS_NEW_PROTECT();
        } else if (string.equalsIgnoreCase(IDS_EDIT_PROTECT)) {
            this.IDS_EDIT_PROTECT();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_NEW_PROTECT)) {
            this.IDS_REMOVE_PROTECT(true);
        } else if (string.equalsIgnoreCase(IDS_REQUEST_EDIT_PROTECT)) {
            this.IDS_REMOVE_PROTECT(false);
        } else if (string.equalsIgnoreCase(IDS_REMOVE_PROTECT)) {
            this.IDS_REQUEST_HOME();
        } else if (string.equalsIgnoreCase(IDS_REQUEST_REMOVE_PROTECT)) {
            this.IDS_REQUEST_NEW_PROTECT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void IDS_EDIT_PROTECT() throws IOException {
        String[] stringArray;
        String string = null;
        String string2 = IDS_LIST_PROTECT;
        String string3 = this.getPropertyIgnoreCase("realm");
        String string4 = null;
        try {
            stringArray = Realm.get(string3);
            Enumeration enumeration = this.request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                if (!string5.startsWith("select_")) continue;
                string4 = string5.substring("select_".length());
                String string6 = this.request.getParameter(string5);
                String[] stringArray2 = stringArray;
                // MONITORENTER : stringArray
                Resource resource = stringArray.getResource(string4);
                if (resource != null) {
                    resource.setAcl(string6);
                } else {
                    stringArray.makeResource(string4, 0);
                    stringArray.getResource(string4).setAcl(string6);
                }
                // MONITOREXIT : stringArray2
            }
            UserDataToolkit.saveResourceProperties((SharedPasswordRealm)stringArray);
            this.logManageSuccessEvent("protect " + string3 + ":" + string4);
            this.IDS_LIST_PROTECT();
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = "Realm " + string3 + " does not exist!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            string = "Realm " + string3 + " is invalid!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        catch (IOException iOException) {
            string = "Save protection properties failed!";
            ServiceLogger.logError(iOException);
        }
        if (string == null) return;
        stringArray = new String[]{"realm", string3};
        this.printMessage(stringArray, string, string2);
    }

    private void IDS_LIST_PROTECT() throws IOException {
        String[] stringArray;
        String string = null;
        String string2 = HomeProcessor.IDS_REQUEST_HOME;
        String string3 = this.getCurEditRealm();
        try {
            stringArray = Realm.get(string3);
            Enumeration enumeration = stringArray.getAclNames();
            Vector<String> vector = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
            String string4 = "";
            string4 = string4 + "<head>";
            string4 = string4 + "<title>Protection List</title>";
            string4 = string4 + "</head>";
            string4 = string4 + "<body>";
            string4 = string4 + "<table width=100% border=0>";
            string4 = string4 + "  <tbody>";
            string4 = string4 + "    <tr>";
            string4 = string4 + "      <td width=43%><strong><font face=Arial>Protection List</font></strong></td>";
            string4 = string4 + "      <td width=57%>";
            string4 = string4 + "        <p align=right><font face=Arial><small>Selected Realm: [" + string3 + "]</small></font></p>";
            string4 = string4 + "      </td>";
            string4 = string4 + "    </tr>";
            string4 = string4 + "  </tbody>";
            string4 = string4 + "</table>";
            string4 = string4 + "<hr>";
            string4 = string4 + "<p align=left><font face=Arial size=2>&nbsp;<a href=" + IDS_REQUEST_NEW_PROTECT + "?realm=" + string3 + "><img border=0 src=" + this.getImage("create") + " width=18 height=13>Create a new protection</a></font></p>";
            string4 = string4 + "<form>";
            string4 = string4 + " <input type=\"hidden\" name=\"realm\" value=\"" + string3 + "\">";
            string4 = string4 + " <table border=1 width=100% align=\"center\" bordercolordark=#C0C0C0 cellspacing=0 cellpadding=0 bordercolorlight=#C0C0C0 bordercolor=#C0C0C0>";
            string4 = string4 + "  <tr>";
            string4 = string4 + "    <td width=41% bgcolor=#5095ba><b style=\"font-size=12px\">&nbsp;<font face=Arial color=#FFFFFF>Resource Node</font></b></td>";
            string4 = string4 + "    <td width=38% bgcolor=#5095ba><font face=Arial color=#FFFFFF><b style=\"font-size=12px\">&nbsp;Protection ACL</b></font></td>";
            string4 = string4 + "    <td width=6% bgcolor=#5095ba align=center>&nbsp;</td>";
            string4 = string4 + "  </tr>";
            Enumeration enumeration2 = stringArray.getResources();
            while (enumeration2.hasMoreElements()) {
                String string5;
                Resource resource = (Resource)enumeration2.nextElement();
                String string6 = string5 = resource.getName();
                String string7 = resource.getAclName();
                if (string5.startsWith("<")) {
                    string5 = "&lt;" + string5.substring(1, string5.length() - 1) + "&gt;";
                }
                string4 = string4 + "  <tr>";
                string4 = string4 + "    <td width=41%><font size=2 face=Arial>&nbsp;" + string5 + "</font></td>";
                string4 = string4 + "    <td width=38%><font size=2 face=Arial>&nbsp;<select size=1 name=\"select_" + string5 + "\" STYLE=\"font-size:11px; font-family:arial; height:27; width:365\">";
                for (int i = 0; i < vector.size(); ++i) {
                    boolean bl = ((String)vector.get(i)).equalsIgnoreCase(string7);
                    string4 = string4 + "        <option " + (bl ? "selected" : "") + ">" + vector.get(i) + "</option>";
                }
                string4 = string4 + "      </select></font></td>";
                if (!string6.equalsIgnoreCase("/") && !string6.equalsIgnoreCase("<the server>")) {
                    string4 = string4 + "    <td width=6% align=center><a href=\"" + IDS_REMOVE_PROTECT + "?realm=" + string3 + "&resource=" + HttpUtil.encodeEsc(string5) + "\"><font face=Arial size=2>Delete</font></td>";
                }
                string4 = string4 + "  </tr>";
            }
            string4 = string4 + "  <tr>";
            string4 = string4 + "    <td width=100% colspan=3>";
            string4 = string4 + "      <p align=right><input type=submit value=OK name=button" + IDS_EDIT_PROTECT + ">&nbsp;&nbsp; </td>";
            string4 = string4 + "  </tr>";
            string4 = string4 + "</table>";
            string4 = string4 + "</form>";
            string4 = string4 + "</body>";
            this.writeResponse(string4);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = "Realm " + string3 + " does not exist!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            string = "Realm " + string3 + " is invalid!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        if (string != null) {
            stringArray = new String[]{"realm", string3};
            this.printMessage(stringArray, string, string2);
        }
    }

    private String IDS_LIST_REALM(String string, String string2) {
        int n = 36;
        int n2 = n - string.length();
        if (string.startsWith("&")) {
            n2 += 6;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("&nbsp;");
            }
        }
        stringBuffer.append("&nbsp;|");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void IDS_NEW_PROTECT() throws IOException {
        String[] stringArray;
        String string = null;
        String string2 = IDS_LIST_PROTECT;
        String string3 = this.getPropertyIgnoreCase("realm");
        String string4 = this.getPropertyIgnoreCase("path");
        String string5 = this.getPropertyIgnoreCase("acl1");
        try {
            String[] stringArray2 = stringArray = Realm.get(string3);
            synchronized (stringArray) {
                Resource resource = stringArray.getResource(string4);
                if (resource != null) {
                    resource.setAcl(string5);
                } else {
                    stringArray.makeResource(string4, 0);
                    stringArray.getResource(string4).setAcl(string5);
                }
                // ** MonitorExit[var7_10] (shouldn't be in output)
                UserDataToolkit.saveResourceProperties((SharedPasswordRealm)stringArray);
                this.logManageSuccessEvent("protect " + string3 + ":" + string4);
                this.IDS_LIST_PROTECT();
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = "Realm " + string3 + " does not exist!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            string = "Realm " + string3 + " is invalid!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        catch (IOException iOException) {
            string = "Save protection properties failed!";
            ServiceLogger.logError(iOException);
        }
        {
            if (string != null) {
                stringArray = new String[]{"realm", string3};
                this.printMessage(stringArray, string, string2);
            }
            return;
        }
    }

    private void IDS_REMOVE_PROTECT(boolean bl) throws IOException {
        String[] stringArray;
        String string = null;
        String string2 = IDS_LIST_PROTECT;
        String string3 = this.request.getParameter("realm");
        if (string3 == null) {
            string3 = this.getPropertyIgnoreCase("realm");
        }
        String string4 = this.getPropertyIgnoreCase("type");
        String string5 = bl ? null : this.getPropertyIgnoreCase("protection");
        String string6 = "/";
        if (string5 != null) {
            if (string5.equals("/") || string5.equals("<the server>")) {
                string = "This protection cannot be edited.  Please edit its ACL if needed.";
            } else {
                string6 = string5;
            }
        } else {
            string6 = "/";
        }
        if (string == null) {
            try {
                stringArray = Realm.get(string3);
                Resource resource = stringArray.getResource(string6);
                String string7 = "";
                string7 = string7 + "<input type=\"hidden\" name=\"realm\" value=\"" + string3 + "\">";
                if (!bl) {
                    string7 = string7 + "<input type=\"hidden\" name=\"type\" value=\"path\">";
                    string7 = string7 + "<input type=\"hidden\" name=\"path\" value=\"" + string6 + "\">";
                }
                string7 = string7 + " <table border=\"0\" width=\"100%\">";
                string7 = string7 + "  <tr>";
                string7 = string7 + "   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; " + (bl ? "New Protection" : "Edit Protection") + "</font></strong></td>";
                string7 = string7 + "   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\"> Selected Realm: [" + string3 + "]" + (bl ? "" : " Resource Node: [" + string6 + "]") + "</font></small></td>";
                string7 = string7 + "  </tr>";
                string7 = string7 + " </table>";
                string7 = string7 + " <hr>";
                string7 = string7 + " <table border=\"0\" width=\"100%\" height=\"68\">";
                string7 = string7 + "  <tr>";
                string7 = string7 + "   <td width=\"21%\" align=\"right\" valign=\"top\" height=\"1\"><u><small><font face=\"Arial\">Resource Node:</font></small></u></td>";
                string7 = string7 + "   <td width=\"79%\" valign=\"top\" align=\"left\" height=\"1\"><small><font face=\"Arial\">";
                string7 = !bl ? string7 + string6 : string7 + "    <input type=\"text\" name=\"path\" size=\"20\" value=\"" + string6 + "\">";
                string7 = string7 + "  </font></small></td>";
                string7 = string7 + "  </tr>";
                string7 = string7 + "  <tr>";
                string7 = string7 + "   <td width=\"21%\" height=\"37\" align=\"right\" valign=\"top\"></td>";
                string7 = string7 + "   <td width=\"79%\" valign=\"bottom\" align=\"left\" height=\"37\"><small>";
                string7 = string7 + "   </small></td>";
                string7 = string7 + "  </tr>";
                String string8 = resource == null ? null : resource.getAclName();
                string7 = string7 + "  <tr>";
                string7 = string7 + "   <td width=\"21%\" height=\"37\" align=\"right\" valign=\"top\"><u><small><font face=\"Arial\">Protect ACL:</font></small></u></td>";
                string7 = string7 + "    <td width=\"79%\" valign=\"top\" align=\"left\" height=\"37\"><small><font face=\"Arial\">";
                string7 = string7 + "    <select name=\"acl1\" size=\"1\">";
                string7 = string7 + this.IDS_REQUEST_EDIT_PROTECT((Realm)stringArray, string8);
                string7 = string7 + "   </select><br>";
                string7 = string7 + "   </font></small></td>";
                string7 = string7 + "  </tr>";
                string7 = string7 + "  <tr>";
                string7 = string7 + "   <td width=\"21%\" height=\"45\"></td>";
                string7 = string7 + "   <td width=\"79%\" valign=\"bottom\" align=\"left\" height=\"45\">";
                string7 = string7 + "    <input  type=\"submit\" value=\" OK \" name=\"button" + IDS_NEW_PROTECT + "\">";
                string7 = string7 + "    <input  type=\"submit\" value=\"Cancel\" name=\"button" + IDS_LIST_PROTECT + "\"></td>";
                string7 = string7 + "  </tr>";
                string7 = string7 + " </table>";
                this.writeResponse(string7);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                string = "Realm " + string3 + " does not exist!";
                string2 = RealmProcessor.IDS_LIST_REALM;
                ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
            }
            catch (BadRealmException badRealmException) {
                string = "Realm " + string3 + " is invalid!";
                string2 = RealmProcessor.IDS_LIST_REALM;
                ServiceLogger.logError((Throwable)((Object)badRealmException));
            }
        }
        if (string != null) {
            stringArray = new String[]{"realm", string3, "protection", string5};
            this.printMessage(stringArray, string, string2);
        }
    }

    private String IDS_REQUEST_EDIT_PROTECT(Realm realm, String string) throws BadRealmException {
        String string2 = "";
        Enumeration enumeration = realm.getAclNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = string3.equals(string) ? "selected" : "";
            string2 = string2 + "<option " + string4 + " value=\"" + string3 + "\">" + string3 + "</option>";
        }
        return string2;
    }

    private void IDS_REQUEST_HOME() throws IOException {
        String[] stringArray;
        String string = null;
        String string2 = IDS_LIST_PROTECT;
        String string3 = this.getPropertyIgnoreCase("realm");
        String string4 = this.getPropertyIgnoreCase("resource");
        try {
            stringArray = Realm.get(string3);
            stringArray.deleteResource(string4);
            UserDataToolkit.saveResourceProperties((SharedPasswordRealm)stringArray);
            this.logManageSuccessEvent("unprotect " + string3 + ":" + string4);
            this.IDS_LIST_PROTECT();
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = "Realm " + string3 + " does not exist!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)noSuchRealmException));
        }
        catch (BadRealmException badRealmException) {
            string = "Realm " + string3 + " is invalid!";
            string2 = RealmProcessor.IDS_LIST_REALM;
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        catch (IOException iOException) {
            string = "Save protection properties failed!";
            ServiceLogger.logError(iOException);
        }
        if (string != null) {
            stringArray = new String[]{"realm", string3};
            this.printMessage(stringArray, string, string2);
        }
    }

    private void IDS_REQUEST_NEW_PROTECT() throws IOException {
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("protection");
        if (string2.startsWith("<")) {
            string2 = "&lt;" + string2.substring(1, string2.length() - 1) + "&gt;";
        }
        if (string2.equals("/") || string2.startsWith("&lt;")) {
            String string3 = "Cannot delete protection: " + string2;
            String[] stringArray = new String[]{"realm", string};
            this.printMessage(stringArray, string3, IDS_LIST_PROTECT);
        } else {
            String string4 = "Do you confirm to release the protection of " + string2 + "?";
            String[] stringArray = new String[]{"realm", string, "protection", string2};
            String[] stringArray2 = new String[]{" Yes ", IDS_REMOVE_PROTECT, " No ", IDS_LIST_PROTECT};
            this.printMessage(stringArray, string4, stringArray2);
        }
    }

    private Vector IDS_REQUEST_REMOVE_PROTECT(Realm realm, String string) {
        Vector<String> vector = new Vector<String>(3);
        for (int i = 0; i < 3; ++i) {
            vector.addElement(null);
        }
        if (realm == null || string == null || string.length() == 0) {
            return vector;
        }
        if ((string.endsWith("/*") || string.endsWith("/-")) && (string = string.substring(0, string.length() - 2)).length() == 0) {
            string = "/";
        }
        try {
            Enumeration enumeration = realm.getResources();
            while (enumeration.hasMoreElements()) {
                Resource resource = (Resource)enumeration.nextElement();
                String string2 = resource.getName();
                if (string.equals(string2) || string.equals(string2 + "/")) {
                    vector.setElementAt(resource.getAclName(), 0);
                    continue;
                }
                if (string2.endsWith("/*")) {
                    if (!string2.substring(0, string2.length() - 1).equals(string.endsWith("/") ? string : string + "/")) continue;
                    vector.setElementAt(resource.getAclName(), 1);
                    continue;
                }
                if (!string2.endsWith("/-") || !string2.substring(0, string2.length() - 1).equals(string.endsWith("/") ? string : string + "/")) continue;
                vector.setElementAt(resource.getAclName(), 2);
            }
        }
        catch (BadRealmException badRealmException) {
            ServiceLogger.logError((Throwable)((Object)badRealmException));
        }
        return vector;
    }
}

