/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rc;

import guitools.GuiUtil;
import guitools.toolkit.JDebug;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.JSvrResource;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.ResourceInfoException;
import jet.server.api.exception.UnknownMIMEType;
import jet.server.api.exception.UnknownResource;
import jet.server.log.ServiceLogger;
import jet.server.rc.ActionProcessor;
import jet.server.rc.RcToolkit;
import jet.server.resource.JRptUtil;
import jet.server.resource.NodeInfo;
import jet.server.resource.RptResourceManager;
import jet.server.resource.RptResourceNode;
import jet.server.userman.UserDataToolkit;
import jet.server.util.MIMETypeTable;
import jet.server.util.WebSecurityUtil;
import jet.util.WildcardMatcher;

public class ResourceProcessor
extends ActionProcessor {
    public static String IDS_LIST_ROOT_RESOURCE = "ListRootResource";
    public static String IDS_LIST_RESOURCE = "ListResource";
    public static String IDS_LIST_REFRESH = "RefreshResourcList";
    public static String IDS_SHOW_EDITOR = "EditResourceNode";
    public static String IDS_CONFIRM_EDIT_RSCNODE = "ConfirmEditingResourceNode";
    public static String IDS_ADD_NEW_RSCNODE = "AddNewResourceNode";
    public static String IDS_REMOVE_RSCNODE = "RemoveResourceNode";
    public static String IDS_ADD_REACHABLES = "AddReachables";
    public static String IDS_CANCEL_EDIT = "CancelEdit";
    public static String IDS_CONFIRMOF_ADD_REACHABLE = "ConfirmOnAddReachablePage";
    public static String IDS_CANCEL_FROM_ADD_REACHABLE = "CancelFromAddReachable";
    public static String IDS_ADD_REACHABLE_FILTER = "AddReachableFilter";
    public static String IDS_CONFIRM_EDIT_KVRNODE = "ConfirmEditingKnownVrNode";
    public static String IDS_DECLARE = "Declare";
    private static String I = "catrpt";
    private static String INFO = "working";
    private static String SEDU = "all";
    private static String WARNING = "ALL";
    private static String addElement = "allNOT";

    public ResourceProcessor() {
        this.actions.addElement(IDS_LIST_ROOT_RESOURCE);
        this.actions.addElement(IDS_LIST_RESOURCE);
        this.actions.addElement(IDS_LIST_REFRESH);
        this.actions.addElement(IDS_SHOW_EDITOR);
        this.actions.addElement(IDS_CONFIRM_EDIT_RSCNODE);
        this.actions.addElement(IDS_ADD_NEW_RSCNODE);
        this.actions.addElement(IDS_REMOVE_RSCNODE);
        this.actions.addElement(IDS_ADD_REACHABLES);
        this.actions.addElement(IDS_CANCEL_EDIT);
        this.actions.addElement(IDS_CONFIRMOF_ADD_REACHABLE);
        this.actions.addElement(IDS_CANCEL_FROM_ADD_REACHABLE);
        this.actions.addElement(IDS_ADD_REACHABLE_FILTER);
        this.actions.addElement(IDS_CONFIRM_EDIT_KVRNODE);
        this.actions.addElement(IDS_DECLARE);
    }

    @Override
    public void processEvent(String string, Properties properties, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        super.processEvent(string, properties, httpServletRequest, httpServletResponse);
        if (string.equalsIgnoreCase(IDS_LIST_ROOT_RESOURCE)) {
            this.I();
        } else if (string.equalsIgnoreCase(IDS_LIST_RESOURCE)) {
            this.IDS_ADD_NEW_RSCNODE();
        } else if (string.equalsIgnoreCase(IDS_LIST_REFRESH)) {
            this.IDS_ADD_REACHABLES();
        } else if (string.equalsIgnoreCase(IDS_SHOW_EDITOR)) {
            this.IDS_CANCEL_EDIT();
        } else if (string.equalsIgnoreCase(IDS_CONFIRM_EDIT_RSCNODE)) {
            this.IDS_CONFIRM_EDIT_RSCNODE();
        } else if (string.equalsIgnoreCase(IDS_ADD_NEW_RSCNODE)) {
            this.IDS_DECLARE();
        } else if (string.equalsIgnoreCase(IDS_REMOVE_RSCNODE)) {
            this.IDS_LIST_REFRESH();
        } else if (string.equalsIgnoreCase(IDS_ADD_REACHABLES)) {
            this.IDS_LIST_RESOURCE();
        } else if (string.equalsIgnoreCase(IDS_CANCEL_EDIT)) {
            this.addElement();
        } else if (string.equalsIgnoreCase(IDS_ADD_REACHABLE_FILTER)) {
            this.IDS_REMOVE_RSCNODE();
        } else if (string.equalsIgnoreCase(IDS_CONFIRMOF_ADD_REACHABLE)) {
            this.IDS_SHOW_EDITOR();
        } else if (string.equalsIgnoreCase(IDS_CANCEL_FROM_ADD_REACHABLE)) {
            this.INFO();
        } else if (string.equalsIgnoreCase(IDS_CONFIRM_EDIT_KVRNODE)) {
            this.areEqual();
        } else if (string.equalsIgnoreCase(IDS_DECLARE)) {
            this.arrangeCatSubNodes();
        }
    }

    private void I() throws IOException {
        String string = null;
        String string2 = this.getPropertyIgnoreCase("realm");
        if (string2 == null) {
            string2 = RcToolkit.curRealmName;
        }
        String string3 = this.remoteUser;
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Processing listing root resource...");
        JDebug.INFO((String)(" realm name..." + string2));
        JDebug.INFO((String)(" user........." + string3));
        try {
            string = this.IDS_ADD_REACHABLE_FILTER(string2, string3, null, false, I);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (IOException iOException) {
            string = this.checkAlias(iOException);
        }
        catch (UnknownMIMEType unknownMIMEType) {
            string = this.checkAlias((Exception)((Object)unknownMIMEType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = this.checkAlias(illegalArgumentException);
        }
        this.writeResponse(string);
    }

    private void IDS_ADD_NEW_RSCNODE() throws IOException {
        String string = null;
        String string2 = this.getPropertyIgnoreCase("realm");
        String string3 = this.getPropertyIgnoreCase("subnodes");
        String string4 = this.getPropertyIgnoreCase("parentpath");
        String string5 = this.getPropertyIgnoreCase("gototype");
        String string6 = this.getPropertyIgnoreCase("listtype");
        String string7 = this.getPropertyIgnoreCase("user");
        String string8 = null;
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Processing List Resource...");
        JDebug.INFO((String)(" realm name..........." + string2));
        JDebug.INFO((String)(" formated node name...\"" + string3 + "\""));
        JDebug.INFO((String)(" parent node name....." + string4));
        JDebug.INFO((String)(" goto type............" + string5));
        JDebug.INFO((String)(" list type............" + string6));
        Object var9_9 = null;
        String string9 = null;
        boolean bl = false;
        if (string5.equals("gotoselnode")) {
            int n;
            if (string3.equals("..")) {
                if (string4.equals("(R)/")) {
                    string8 = null;
                    string9 = null;
                } else {
                    n = string4.lastIndexOf("/");
                    string8 = string4.substring(0, n);
                    if (string8.equals("(R)")) {
                        string8 = "(R)/";
                    }
                }
            } else {
                n = string3.indexOf(")");
                string8 = string4.equals("none") ? string3 : string4 + (string4.endsWith("/") ? string3 : "/" + string3);
            }
            bl = true;
        } else {
            string8 = this.getPropertyIgnoreCase("gotonode");
            if (string8.trim().length() == 0) {
                string = "Please input the full name of the node you want to got to.";
            }
        }
        JDebug.INFO((String)(" type..." + string9));
        JDebug.INFO((String)(" full name where goes to..." + string8));
        if (string == null) {
            try {
                string = this.IDS_ADD_REACHABLE_FILTER(string2, string7, string8, bl, string6);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                string = this.checkAlias((Exception)((Object)noSuchRealmException));
            }
            catch (UnknownResource unknownResource) {
                string = this.checkAlias((Exception)((Object)unknownResource));
            }
            catch (IOException iOException) {
                string = this.checkAlias(iOException);
            }
            catch (UnknownMIMEType unknownMIMEType) {
                string = this.checkAlias((Exception)((Object)unknownMIMEType));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = this.checkAlias(illegalArgumentException);
            }
        }
        JDebug.INFO((String)(" content returned..." + (string == null ? "null" : "" + string.length())));
        this.writeResponse(string);
    }

    private void IDS_ADD_REACHABLES() throws IOException {
        String string = null;
        String string2 = this.getPropertyIgnoreCase("realm");
        String string3 = this.getPropertyIgnoreCase("parentpath");
        String string4 = this.getPropertyIgnoreCase("listtype");
        String string5 = this.getPropertyIgnoreCase("user");
        if (string3.equals("none")) {
            string3 = null;
        }
        if (string == null) {
            try {
                string = this.IDS_ADD_REACHABLE_FILTER(string2, string5, string3, true, string4);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                string = this.checkAlias((Exception)((Object)noSuchRealmException));
            }
            catch (UnknownResource unknownResource) {
                string = this.checkAlias((Exception)((Object)unknownResource));
            }
            catch (IOException iOException) {
                string = this.checkAlias(iOException);
            }
            catch (UnknownMIMEType unknownMIMEType) {
                string = this.checkAlias((Exception)((Object)unknownMIMEType));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = this.checkAlias(illegalArgumentException);
            }
        }
        this.writeResponse(string);
    }

    private String IDS_ADD_REACHABLE_FILTER(String string, String string2, String string3, boolean bl, String string4) throws NoSuchRealmException, UnknownResource, IOException, UnknownMIMEType, IllegalArgumentException {
        CharSequence charSequence;
        int n;
        Object object;
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Generating Nodes List...");
        JDebug.INFO((String)(" realm name..." + string));
        JDebug.INFO((String)(" user........." + string2));
        JDebug.INFO((String)(" curNode......" + string3));
        JDebug.INFO((String)(" formatedName." + bl));
        JDebug.INFO((String)(" list type...." + string4));
        Vector vector = new Vector(1);
        if (string3 != null) {
            object = UserDataToolkit.getManager(string);
            if (object == null) {
                throw new NoSuchRealmException(620003, new Object[]{string}, null);
            }
            n = string4.equals(I) ? 0 : (string4.equals(INFO) ? 1 : 2);
            if (!bl) {
                charSequence = new StringBuffer();
                vector = ((RptResourceManager)object).getResourceTreeMan().getFormatedSubnodeNames(string3, n, (StringBuffer)charSequence);
                string3 = charSequence.toString();
            } else {
                vector = ((RptResourceManager)object).getResourceTreeMan().getFmtdSbndNmsOfSpcNd(string3, n);
            }
            JDebug.INFO((String)(" number of sub nodes..." + vector.size()));
            vector.insertElementAt("..", 0);
        } else {
            vector.addElement("(R)/");
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("<input type=\"hidden\" name=\"realm\" value=\"" + string + "\">");
        ((StringBuffer)object).append("<input type=\"hidden\" name=\"user\" value=\"" + string2 + "\">");
        ((StringBuffer)object).append("<input type=\"hidden\" name=\"parentpath\" value=\"" + (string3 == null ? "none" : string3) + "\">");
        ((StringBuffer)object).append(" <table border=\"0\" width=\"100%\">");
        ((StringBuffer)object).append("  <tr>");
        ((StringBuffer)object).append("   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; List of Sub-Resources</font></strong></td>");
        ((StringBuffer)object).append("   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "] </font></small></td>");
        ((StringBuffer)object).append("  </tr>");
        ((StringBuffer)object).append("  <tr>");
        ((StringBuffer)object).append("   <td width=\"32%\"></td>");
        ((StringBuffer)object).append("   <td width=\"68%\"><small><font face=\"Arial\"><p align=\"right\">Resource: [" + (string3 == null ? "none" : string3) + "]</font></small></td>");
        ((StringBuffer)object).append("  </tr>");
        ((StringBuffer)object).append(" </table>");
        ((StringBuffer)object).append(" <hr>");
        ((StringBuffer)object).append(" <table border=\"0\" width=\"100%\" height=\"17\">");
        ((StringBuffer)object).append("  <tr>");
        ((StringBuffer)object).append("   <td width=\"23%\" height=\"1\" align=\"right\" valign=\"top\"><u><small><font face=\"Arial\">Sub-resources:</font></small></u><p>&nbsp;</td>");
        ((StringBuffer)object).append("   <td width=\"77%\" valign=\"top\" align=\"left\" height=\"1\"><small><font face=\"Arial\">");
        ((StringBuffer)object).append("   <select name=\"subnodes\" size=\"6\">");
        n = vector == null ? 0 : vector.size();
        for (int i = 0; i < n; ++i) {
            charSequence = (String)vector.elementAt(i);
            ((StringBuffer)object).append("        <option " + (i == 0 ? "selected" : "") + " value=\"" + (String)charSequence + "\">" + (String)charSequence + "</option>");
        }
        ((StringBuffer)object).append("   </select></font></small></td>");
        ((StringBuffer)object).append("  </tr>");
        ((StringBuffer)object).append("  <tr>");
        ((StringBuffer)object).append("   <td width=\"23%\" height=\"45\" valign=\"top\" align=\"right\"><u><small><font face=\"Arial\">List");
        ((StringBuffer)object).append("   sub-resources of:</font></small></u></td>");
        ((StringBuffer)object).append("   <td width=\"77%\" valign=\"top\" align=\"left\" height=\"45\"><font face=\"Arial\"><small>");
        ((StringBuffer)object).append("    <input type=\"radio\" value=\"gotoselnode\" checked name=\"gototype\">selected resource<br>");
        ((StringBuffer)object).append("    <input type=\"radio\" value=\"gotospcnode\" name=\"gototype\">the resource </small></font>");
        ((StringBuffer)object).append("    <input type=\"text\" name=\"gotonode\" size=\"20\"></td>");
        ((StringBuffer)object).append("  </tr>");
        ((StringBuffer)object).append("  <tr>");
        ((StringBuffer)object).append("  <tr>");
        ((StringBuffer)object).append("   <td width=\"23%\" height=\"45\" valign=\"top\" align=\"right\"></td>");
        ((StringBuffer)object).append("   <td width=\"77%\" valign=\"top\" align=\"left\" height=\"45\">");
        ((StringBuffer)object).append("    <input type=\"submit\" value=\"List Sub-resources\" name=\"button" + IDS_LIST_RESOURCE + "\">");
        ((StringBuffer)object).append("   <input type=\"submit\" value=\"Edit Resource\" name=\"button" + IDS_SHOW_EDITOR + "\"></td>");
        ((StringBuffer)object).append("  </tr>");
        ((StringBuffer)object).append("  <tr>");
        ((StringBuffer)object).append("   <td width=\"23%\" height=\"45\" valign=\"top\" align=\"right\"><u><small><font face=\"Arial\">View");
        ((StringBuffer)object).append("   Option:</font></small></u></td>");
        ((StringBuffer)object).append("   <td width=\"77%\" valign=\"top\" align=\"left\" height=\"45\"><small><font face=\"Arial\">");
        ((StringBuffer)object).append("   <input type=\"radio\" value=\"" + I + "\" " + (string4.equals(I) ? "checked" : "") + " name=\"listtype\">All sub resource nodes, catalogs and their reports as well.<br>");
        ((StringBuffer)object).append("   <input type=\"radio\" value=\"" + INFO + "\" " + (string4.equals(INFO) ? "checked" : "") + " name=\"listtype\">All working resource<br>");
        ((StringBuffer)object).append("   <input type=\"radio\" value=\"" + SEDU + "\" " + (string4.equals(SEDU) ? "checked" : "") + " name=\"listtype\">All</font></small></td>");
        ((StringBuffer)object).append("  </tr>");
        ((StringBuffer)object).append("   <td width=\"23%\" height=\"45\" valign=\"top\" align=\"right\"></td>");
        ((StringBuffer)object).append("   <td width=\"77%\" valign=\"bottom\" align=\"left\" height=\"45\">");
        ((StringBuffer)object).append("   <input type=\"submit\" value=\"Refresh List\" name=\"button" + IDS_LIST_REFRESH + "\"> </td>");
        ((StringBuffer)object).append("  </tr>");
        ((StringBuffer)object).append(" </table>");
        ((StringBuffer)object).append(" <div align=\"center\"><center><table border=\"1\" width=\"91%\">");
        ((StringBuffer)object).append("  <tr>");
        ((StringBuffer)object).append("   <td width=\"100%\" colspan=\"2\"><strong><small><font face=\"Arial\">Prefix of Resource:</font></small></strong></td>");
        ((StringBuffer)object).append("  </tr>");
        ((StringBuffer)object).append("  <tr>");
        ((StringBuffer)object).append("   <td width=\"50%\" valign=\"top\" align=\"left\"><small><font face=\"Arial\">(R) - Resource Node<br>");
        ((StringBuffer)object).append("    (C) - Catalog File<br>");
        ((StringBuffer)object).append("    (D) - Directory<br>");
        ((StringBuffer)object).append("    (F) - Normal File<br>");
        ((StringBuffer)object).append("    (Rpt) -Report File</font></small></td>");
        ((StringBuffer)object).append("   <td width=\"50%\" valign=\"top\" align=\"left\"><small><font face=\"Arial\">(DH) - Unreachable directory<br>");
        ((StringBuffer)object).append("    (FH) - Unreachable normal file<br>");
        ((StringBuffer)object).append("    (CH) - Unreachable catalog file<br>");
        ((StringBuffer)object).append("    (RptH) - Unreachable report file</font></small></td>");
        ((StringBuffer)object).append("  </tr>");
        ((StringBuffer)object).append(" </table>");
        ((StringBuffer)object).append(" </center></div><p>&nbsp;</p>");
        JDebug.INFO((String)(" returned buffer is null?..." + (((StringBuffer)object).length() > 0 ? "false" : "true")));
        return ((StringBuffer)object).toString();
    }

    private void IDS_CANCEL_EDIT() throws IOException {
        String string = null;
        String string2 = this.getPropertyIgnoreCase("realm");
        String string3 = this.getPropertyIgnoreCase("subnodes");
        String string4 = this.getPropertyIgnoreCase("parentpath");
        String string5 = this.getPropertyIgnoreCase("gototype");
        String string6 = this.getPropertyIgnoreCase("listtype");
        String string7 = this.getPropertyIgnoreCase("user");
        String string8 = null;
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Processing Editing Resource...");
        JDebug.INFO((String)(" realm name..........." + string2));
        JDebug.INFO((String)(" formated node name...\"" + string3 + "\""));
        JDebug.INFO((String)(" parent node name....." + string4));
        JDebug.INFO((String)(" goto type............" + string5));
        JDebug.INFO((String)(" list type............" + string6));
        Object var9_9 = null;
        String string9 = null;
        if (string3 == null || string3.length() == 0) {
            string = "Please select a node from the list.";
        } else if (string3.equals("..")) {
            string = "Please select a node in the list rather than \"..\".";
        } else {
            int n = string3.indexOf(")");
            string9 = string3.substring(1, n);
            JDebug.INFO((String)(" node type is..." + string9));
            string8 = string4.equals("none") ? string3 : string4 + (string4.endsWith("/") ? string3 : "/" + string3);
        }
        JDebug.INFO((String)(" full name..." + string8));
        if (string == null) {
            try {
                RptResourceManager rptResourceManager = UserDataToolkit.getManager(string2);
                if (rptResourceManager == null) {
                    throw new NoSuchRealmException(620003, new Object[]{string2}, null);
                }
                NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string8);
                if (nodeInfo == null) {
                    throw new UnknownResource(string8);
                }
                string = nodeInfo.nodetype.equals("R") ? this.IDS_CANCEL_FROM_ADD_REACHABLE(string2, string7, string8, nodeInfo.rscNode, string6) : (nodeInfo.reachable == -1 ? this.IDS_CONFIRMOF_ADD_REACHABLE(string2, string7, string8, string6) : this.IDS_CONFIRM_EDIT_KVRNODE(string2, string7, string8, nodeInfo.reachable == 1, string6));
            }
            catch (NoSuchRealmException noSuchRealmException) {
                string = this.checkAlias((Exception)((Object)noSuchRealmException));
            }
            catch (UnknownResource unknownResource) {
                string = this.checkAlias((Exception)((Object)unknownResource));
            }
            catch (UnknownMIMEType unknownMIMEType) {
                string = this.checkAlias((Exception)((Object)unknownMIMEType));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = this.checkAlias(illegalArgumentException);
            }
        }
        this.writeResponse(string);
    }

    private String IDS_CANCEL_FROM_ADD_REACHABLE(String string, String string2, String string3, RptResourceNode rptResourceNode, String string4) {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Generate Resource Editor Page....");
        JDebug.INFO((String)(" realmName..." + string));
        JDebug.INFO((String)(" user........" + string2));
        JDebug.INFO((String)(" rscNode....." + rptResourceNode));
        JDebug.INFO((String)(" listtype...." + string4));
        StringBuffer stringBuffer = new StringBuffer();
        int n = rptResourceNode.getDefReachableOfSubnodes();
        String string5 = rptResourceNode.getRealPath();
        stringBuffer.append("  <input type=\"hidden\" name=\"realm\" value=\"" + string + "\"><input type=\"hidden\" name=\"node\" value=\"" + string3 + "\"");
        stringBuffer.append("  ><input type=\"hidden\" name=\"user\" value=\"" + string2 + "\"><input type=\"hidden\" name=\"listtype\" value=\"" + string4 + "\"><table border=\"0\" width=\"100%\">");
        stringBuffer.append(" <table border=\"0\" width=\"100%\">");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Edit Resource Node</font></strong></td>");
        stringBuffer.append("   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "] </font></small></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"32%\"></td>");
        stringBuffer.append("   <td width=\"68%\"><small><font face=\"Arial\"><p align=\"right\">Resource: [" + string3 + "]</font></small></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append(" </table>");
        stringBuffer.append(" <hr>");
        stringBuffer.append(" <small><font face=\"Arial\"><strong>NOTE:</strong> Once resource node is declared, no change to Sub-resources will take effect unless new real path is set. </small></font><br><br><br>");
        stringBuffer.append(" <table border=\"0\" width=\"100%\" height=\"88\">");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"8%\" height=\"1\" align=\"right\" valign=\"top\"><u><small><font face=\"Arial\">Resource");
        stringBuffer.append("   Name:</font></small></u></td>");
        stringBuffer.append("   <td width=\"92%\" valign=\"top\" align=\"left\" height=\"1\">");
        stringBuffer.append("    <input type=\"text\" name=\"rscname\" value=\"" + rptResourceNode.getText() + "\"size=\"20\"></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"8%\" height=\"31\" valign=\"top\" align=\"right\"><u><small><font face=\"Arial\">Real Path:</font></small></u></td>");
        stringBuffer.append("   <td width=\"92%\" valign=\"top\" align=\"left\" height=\"31\">");
        stringBuffer.append("    <input type=\"text\" name=\"realpath\" value=\"" + (string5 == null ? "" : string5) + "\"size=\"48\"></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"8%\" height=\"31\" valign=\"top\" align=\"right\"><u><small><font face=\"Arial\">Description:</font></small></u></td>");
        stringBuffer.append("   <td width=\"92%\" valign=\"top\" align=\"left\" height=\"1\">");
        stringBuffer.append("    <input type=\"text\" name=\"rscdescription\" value=\"" + rptResourceNode.getDescription() + "\"size=\"48\"></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"8%\" height=\"31\" valign=\"top\" align=\"right\"><u><small><font face=\"Arial\"> </font></small></u></td>");
        stringBuffer.append("   <td width=\"92%\" valign=\"top\" align=\"left\" height=\"1\">");
        String string6 = rptResourceNode.isMapSharedDisk() ? "checked" : "";
        stringBuffer.append("    <input type=\"checkbox\" name=\"mapsharedisk\"" + string6 + " onClick=\"alert('" + JSvrResource.getMessage("SLT_PG_228") + "')\">Map shared disk");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"8%\" height=\"30\" valign=\"top\" align=\"right\"><u><font face=\"Arial\"><small>All Sub-resources:</small><br></font></u>");
        stringBuffer.append("\t  </td>");
        stringBuffer.append("   <td width=\"92%\" valign=\"top\" align=\"left\" height=\"30\"><font face=\"Arial\"><small>");
        stringBuffer.append("    <input type=\"radio\" value=\"" + WARNING + "\" " + (n == 0 ? "checked" : "") + " name=\"reachable\">all reachable<br>");
        stringBuffer.append("    <input type=\"radio\" value=\"" + addElement + "\" " + (n == 2 ? "checked" : "") + " name=\"reachable\">all NOT reachable</small></font></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"31%\" height=\"46\" valign=\"top\" align=\"left\"></td>");
        stringBuffer.append("   <td width=\"69%\" height=\"46\" valign=\"bottom\" align=\"left\">");
        stringBuffer.append("    <input type=\"submit\" value=\" OK \" name=\"button" + IDS_CONFIRM_EDIT_RSCNODE + "\">");
        stringBuffer.append("    <input type=\"submit\" value=\"Delete\" name=\"button" + IDS_REMOVE_RSCNODE + "\">");
        stringBuffer.append("    <input type=\"submit\" value=\"Close\" name=\"button" + IDS_CANCEL_EDIT + "\"></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"31%\" height=\"38\" valign=\"top\" align=\"left\"></td>");
        stringBuffer.append("   <td width=\"69%\" height=\"38\" valign=\"bottom\" align=\"left\">");
        stringBuffer.append("    <input type=\"submit\" value=\"New Sub-node\" name=\"button" + IDS_ADD_NEW_RSCNODE + "\">");
        stringBuffer.append("    <input type=\"submit\" value=\"Add Reachable Sub-resources\" name=\"button" + IDS_ADD_REACHABLES + "\"></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append(" </table>");
        return stringBuffer.toString();
    }

    private String IDS_CONFIRMOF_ADD_REACHABLE(String string, String string2, String string3, String string4) {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Generate to edit virtual node whose reachable is unknown...");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" <input type=\"hidden\" name=\"realm\" value=\"" + string + "\"><input type=\"hidden\" name=\"user\"");
        stringBuffer.append("  value=\"" + string2 + "\"><input type=\"hidden\" name=\"node\" value=\"" + string3 + "\"><input type=\"hidden\"");
        stringBuffer.append("  name=\"listtype\" value=\"" + string4 + "\">");
        stringBuffer.append(" <table border=\"0\" width=\"100%\">");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Edit Resource</font></strong></td>");
        stringBuffer.append("   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "] </font></small></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"100%\" colspan=\"2\"><font face=\"Arial\"><small><p align=\"right\">Resource:");
        stringBuffer.append("   [" + string3 + "]</small></font></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append(" </table>");
        stringBuffer.append(" <hr>");
        stringBuffer.append(" <table border=\"0\" width=\"100%\" height=\"98\">");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"21%\" height=\"41\" valign=\"top\" align=\"right\"><small><u><font face=\"Arial\">Declaring");
        stringBuffer.append("   Option:</font></u></small></td>");
        stringBuffer.append("   <td width=\"79%\" valign=\"top\" align=\"left\" height=\"41\"><small><font face=\"Arial\">");
        stringBuffer.append("    <input type=\"radio\" value=\"reachable\" checked name=\"subreachable\">Set all of its sub-resources to be reachable.<br>");
        stringBuffer.append("    <input type=\"radio\" value=\"notreachable\" name=\"subreachable\">Set all of its sub-resources to be NOT reachable.</font></small></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"21%\" height=\"41\" valign=\"top\" align=\"right\"></td>");
        stringBuffer.append("   <td width=\"79%\" valign=\"bottom\" align=\"left\" height=\"41\"><font face=\"Arial\">");
        stringBuffer.append("    <input type=\"submit\" value=\"Declare\" name=\"button" + IDS_DECLARE + "\">");
        stringBuffer.append("    <input type=\"submit\" value=\"Close\" name=\"button" + IDS_CANCEL_EDIT + "\"></font></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append(" </table>");
        return stringBuffer.toString();
    }

    private String IDS_CONFIRM_EDIT_KVRNODE(String string, String string2, String string3, boolean bl, String string4) {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Generate to edit virutal node whose reachable is known...");
        JDebug.INFO((String)(" realmName..." + string));
        JDebug.INFO((String)(" user........" + string2));
        JDebug.INFO((String)(" fullName...." + string3));
        JDebug.INFO((String)(" reachable..." + bl));
        JDebug.INFO((String)(" listtype...." + string4));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" <input type=\"hidden\" name=\"realm\" value=\"" + string + "\"><input type=\"hidden\" name=\"user\"");
        stringBuffer.append("  value=\"" + string2 + "\"><input type=\"hidden\" name=\"node\" value=\"" + string3 + "\"><input type=\"hidden\"");
        stringBuffer.append("  name=\"listtype\" value=\"" + string4 + "\">");
        stringBuffer.append(" <table border=\"0\" width=\"100%\">");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Edit Resource</font></strong></td>");
        stringBuffer.append("   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "] </font></small></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"100%\" colspan=\"2\"><font face=\"Arial\"><small><p align=\"right\">Resource: [" + string3 + "]</small></font></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append(" </table>");
        stringBuffer.append(" <hr>");
        stringBuffer.append(" <table border=\"0\" width=\"100%\" height=\"98\">");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"21%\" height=\"1\" align=\"right\" valign=\"top\"><font face=\"Arial\"><u><small>Set");
        stringBuffer.append("   Reachable:</small></u></font></td>");
        stringBuffer.append("   <td width=\"79%\" valign=\"top\" align=\"left\" height=\"1\"><small><font face=\"Arial\">");
        stringBuffer.append("    <input type=\"radio\" value=\"reachable\" " + (bl ? "checked" : "") + " name=\"reachable\">Set to be reachable<br>");
        stringBuffer.append("    <input type=\"radio\" value=\"notreachable\" " + (bl ? "" : "checked") + " name=\"reachable\">Set to be not reachable</font></small></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"21%\" height=\"31\" valign=\"top\" align=\"right\"></td>");
        stringBuffer.append("   <td width=\"79%\" valign=\"bottom\" align=\"left\" height=\"31\">");
        stringBuffer.append("    <input type=\"submit\" value=\"Apply\" name=\"button" + IDS_CONFIRM_EDIT_KVRNODE + "\"></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"21%\" height=\"41\" valign=\"top\" align=\"right\"><small><u><font face=\"Arial\">Declaring");
        stringBuffer.append("   Option:</font></u></small></td>");
        stringBuffer.append("   <td width=\"79%\" valign=\"top\" align=\"left\" height=\"41\"><small><font face=\"Arial\">");
        stringBuffer.append("    <input type=\"radio\" value=\"reachable\" checked name=\"subreachable\">Set all of its sub-resources to be reachable.<br>");
        stringBuffer.append("    <input type=\"radio\" value=\"notreachable\" name=\"subreachable\">Set all of its sub-resources to be NOT reachable.</font></small></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append("  <tr>");
        stringBuffer.append("   <td width=\"21%\" height=\"41\" valign=\"top\" align=\"right\"></td>");
        stringBuffer.append("   <td width=\"79%\" valign=\"bottom\" align=\"left\" height=\"41\"><font face=\"Arial\">");
        stringBuffer.append("    <input type=\"submit\" value=\"Declare\" name=\"button" + IDS_DECLARE + "\">");
        stringBuffer.append("    <input type=\"submit\" value=\"Close\" name=\"button" + IDS_CANCEL_EDIT + "\"></font></td>");
        stringBuffer.append("  </tr>");
        stringBuffer.append(" </table>");
        return stringBuffer.toString();
    }

    private void IDS_CONFIRM_EDIT_RSCNODE() throws IOException {
        String string = null;
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Process Confriming of Resource Editor...");
        String string2 = this.getPropertyIgnoreCase("realm");
        String string3 = this.getPropertyIgnoreCase("node");
        String string4 = this.getPropertyIgnoreCase("listtype");
        String string5 = this.getPropertyIgnoreCase("rscname");
        String string6 = WebSecurityUtil.validateFilePathStr(this.getPropertyIgnoreCase("realpath"));
        String string7 = this.getPropertyIgnoreCase("rscdescription");
        String string8 = this.getPropertyIgnoreCase("reachable");
        String string9 = this.getPropertyIgnoreCase("user");
        String string10 = this.getPropertyIgnoreCase("mapsharedisk");
        JDebug.INFO((String)(" realmName......" + string2));
        JDebug.INFO((String)(" nodename......." + string3));
        JDebug.INFO((String)(" listtype......." + string4));
        JDebug.INFO((String)(" mapping name..." + string5));
        JDebug.INFO((String)(" real path......" + string6));
        JDebug.INFO((String)(" description...." + string7));
        JDebug.INFO((String)(" reachable......" + string8));
        try {
            Object object;
            RptResourceManager rptResourceManager = UserDataToolkit.getManager(string2);
            if (rptResourceManager == null) {
                throw new NoSuchRealmException(620003, new Object[]{string2}, null);
            }
            NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string3);
            if (nodeInfo == null || !nodeInfo.nodetype.equals("R")) {
                throw new UnknownResource(string3);
            }
            RptResourceNode rptResourceNode = nodeInfo.rscNode;
            if (string5 == null || string5.trim().length() == 0) {
                throw new Exception("Edit Failed! The name cannot be empty.");
            }
            string = JRptUtil.checkNewName(rptResourceNode, string5);
            if (string != null) {
                throw new Exception(string);
            }
            string = JRptUtil.checkNewRealPath(rptResourceManager, rptResourceNode, string6, rptResourceManager.getMIMETypeTable());
            if (string != null) {
                throw new Exception(string);
            }
            int n = rptResourceNode.getDefReachableOfSubnodes();
            boolean bl = false;
            int n2 = string8.equals(WARNING) ? 0 : 2;
            boolean bl2 = false;
            if (!GuiUtil.areEqual((String)rptResourceNode.getRealPath(), (String)string6)) {
                File file = new File(string6);
                if (string6 != null && string6.length() > 0) {
                    object = rptResourceManager.getMIMETypeTable();
                    if (((MIMETypeTable)object).mimeCheck("application/x-jrcatalog", string6)) {
                        if (file.exists()) {
                            Vector vector = JRptUtil.getValidRptNodesName(rptResourceNode, string6, (MIMETypeTable)object);
                            String[] stringArray = rptResourceManager.getAliasManager().checkAlias(rptResourceNode.getFullName(), vector, null, true);
                            if (stringArray != null) {
                                if (stringArray[0].equals("0")) {
                                    Object[] objectArray = new String[]{string6, stringArray[4], stringArray[1]};
                                    throw new Exception(JSvrResource.getMessage("RSCEDITOR_ERROR19", objectArray));
                                }
                                Object[] objectArray = new String[]{string6, stringArray[4], stringArray[1], stringArray[3], stringArray[2]};
                                throw new Exception(JSvrResource.getMessage("RSCEDITOR_ERROR18", objectArray));
                            }
                            if (n != n2) {
                                rptResourceNode.setDefReachableOfSubnodes(n2);
                            }
                            this.canCreateNew(rptResourceNode, string6);
                            JRptUtil.arrangeCatSubNodes(rptResourceNode, vector, null);
                            bl2 = true;
                        } else {
                            String[] stringArray = rptResourceManager.getAliasManager().checkAlias(rptResourceNode.getFullName(), null, null, true);
                            if (stringArray != null) {
                                if (stringArray[0].equals("0")) {
                                    Object[] objectArray = new String[]{string6, stringArray[4], stringArray[1]};
                                    throw new Exception(JSvrResource.getMessage("RSCEDITOR_ERROR19", objectArray));
                                }
                                Object[] objectArray = new String[]{string6, stringArray[4], stringArray[1], stringArray[3], stringArray[2]};
                                throw new Exception(JSvrResource.getMessage("RSCEDITOR_ERROR18", objectArray));
                            }
                            if (n != n2) {
                                rptResourceNode.setDefReachableOfSubnodes(n2);
                            }
                            this.canCreateNew(rptResourceNode, string6);
                            JRptUtil.arrangeCatSubNodes(rptResourceNode, null, null);
                            bl2 = true;
                        }
                    } else {
                        if (n != n2) {
                            rptResourceNode.setDefReachableOfSubnodes(n2);
                        }
                        this.canCreateNew(rptResourceNode, string6);
                        bl2 = true;
                    }
                } else {
                    if (n != n2) {
                        rptResourceNode.setDefReachableOfSubnodes(n2);
                    }
                    this.canCreateNew(rptResourceNode, string6);
                    bl2 = true;
                }
            }
            if (bl2) {
                bl = true;
            } else if (n != n2) {
                rptResourceNode.setDefReachableOfSubnodes(n2);
                bl = true;
            }
            if (!GuiUtil.areEqual((String)rptResourceNode.getName(), (String)string5)) {
                JDebug.INFO((String)" Setting new mapping name...");
                rptResourceNode.setText(string5);
                bl = true;
            }
            if (!GuiUtil.areEqual((String)rptResourceNode.getDescription(), (String)string7)) {
                JDebug.INFO((String)" Setting new description...");
                rptResourceNode.setDescription(string7);
                bl = true;
            }
            boolean bl3 = false;
            if (string10 != null) {
                bl3 = true;
            }
            if (rptResourceNode.isMapSharedDisk() != bl3) {
                JDebug.INFO((String)" Setting new map shared disk...");
                rptResourceNode.setMapSharedDisk(bl3);
                bl = true;
            }
            if (bl) {
                this.save(rptResourceManager, string9);
            }
            object = (RptResourceNode)rptResourceNode.getParent();
            JDebug.INFO((String)(" Parent node..." + (object == null ? "null" : ((RptResourceNode)object).getText())));
            string = this.IDS_ADD_REACHABLE_FILTER(string2, string9, object == null ? null : ((RptResourceNode)object).getFullName(), false, string4);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (UnknownMIMEType unknownMIMEType) {
            string = this.checkAlias((Exception)((Object)unknownMIMEType));
        }
        catch (IOException iOException) {
            string = this.checkAlias(iOException);
        }
        catch (ResourceInfoException resourceInfoException) {
            string = this.checkAlias((Exception)((Object)resourceInfoException));
        }
        catch (Exception exception) {
            string = this.checkAlias(exception);
        }
        this.writeResponse(string);
    }

    private void IDS_DECLARE() throws IOException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Process adding new Resource Node...");
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("node");
        String string3 = this.getPropertyIgnoreCase("listtype");
        String string4 = this.getPropertyIgnoreCase("user");
        String string5 = null;
        try {
            RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
            if (rptResourceManager == null) {
                throw new NoSuchRealmException(620003, new Object[]{string}, null);
            }
            NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string2);
            if (nodeInfo == null || !nodeInfo.nodetype.equals("R")) {
                throw new UnknownResource(string2);
            }
            RptResourceNode rptResourceNode = nodeInfo.rscNode;
            String string6 = JRptUtil.canCreateNew(rptResourceNode);
            if (string5 == null) {
                int n = 0;
                String string7 = "resource";
                while (rptResourceNode.getRscByName(string7 + n) != null) {
                    ++n;
                }
                string7 = string7 + n;
                RptResourceNode rptResourceNode2 = new RptResourceNode(string7, null, true);
                rptResourceNode.insert(rptResourceNode2, -1);
                this.logManageSuccessEvent(JSvrResource.getMessage("RscEd_Log_New_Succ", rptResourceNode2.getFullName()), 5);
                this.save(rptResourceManager, string4);
                string5 = this.IDS_CANCEL_FROM_ADD_REACHABLE(string, string4, string2 + (string2.endsWith("/") ? "" : "/") + "(R)" + string7, rptResourceNode2, string3);
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string5 = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string5 = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (ResourceInfoException resourceInfoException) {
            string5 = this.checkAlias((Exception)((Object)resourceInfoException));
        }
        catch (Exception exception) {
            string5 = this.checkAlias(exception);
        }
        this.writeResponse(string5);
    }

    private void IDS_LIST_REFRESH() throws IOException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Process removing Resource Node...");
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("node");
        String string3 = this.getPropertyIgnoreCase("listtype");
        String string4 = this.getPropertyIgnoreCase("user");
        String string5 = null;
        try {
            RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
            if (rptResourceManager == null) {
                throw new NoSuchRealmException(620003, new Object[]{string}, null);
            }
            NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string2);
            if (nodeInfo == null || !nodeInfo.nodetype.equals("R")) {
                throw new UnknownResource(string2);
            }
            RptResourceNode rptResourceNode = nodeInfo.rscNode;
            RptResourceNode rptResourceNode2 = (RptResourceNode)rptResourceNode.getParent();
            if (rptResourceNode2 == null) {
                string5 = "Cannot remove this Resource Node '" + string2 + "'";
            } else {
                rptResourceNode.deleted();
                this.logManageSuccessEvent(JSvrResource.getMessage("RscEd_Log_Remove_Succ", string2), 5);
                this.save(rptResourceManager, string4);
                string5 = this.append(string, string4, string3, string2);
            }
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string5 = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string5 = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (ResourceInfoException resourceInfoException) {
            string5 = this.checkAlias((Exception)((Object)resourceInfoException));
        }
        catch (Exception exception) {
            string5 = this.checkAlias(exception);
        }
        this.writeResponse(string5);
    }

    private void IDS_LIST_RESOURCE() throws IOException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Process adding reachable nodes to Resource Node...");
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("user");
        String string3 = this.getPropertyIgnoreCase("listtype");
        String string4 = this.getPropertyIgnoreCase("node");
        String string5 = null;
        try {
            RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
            if (rptResourceManager == null) {
                throw new NoSuchRealmException(620003, new Object[]{string}, null);
            }
            NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string4);
            if (nodeInfo == null || !nodeInfo.nodetype.equals("R")) {
                throw new UnknownResource(string4);
            }
            RptResourceNode rptResourceNode = nodeInfo.rscNode;
            File file = rptResourceNode.getFile();
            String[] stringArray = null;
            if (file != null && rptResourceNode.isCatNode()) {
                try {
                    String string6 = JRptUtil.getRptFilesDir(file);
                    file = new File(string6);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                stringArray = rptResourceManager.getMIMETypeTable().getExts("application/x-jrreport");
            }
            string5 = this.IDS_LIST_ROOT_RESOURCE(string, string2, string3, string4, file, stringArray, "");
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string5 = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string5 = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (IOException iOException) {
            string5 = this.checkAlias(iOException);
        }
        catch (UnknownMIMEType unknownMIMEType) {
            string5 = this.checkAlias((Exception)((Object)unknownMIMEType));
        }
        this.writeResponse(string5);
    }

    private String IDS_LIST_ROOT_RESOURCE(String string, String string2, String string3, String string4, File file, String[] stringArray, String string5) throws IOException {
        int n;
        int n2;
        Serializable serializable;
        Object object;
        String[] stringArray2;
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Generate to add reachable files...");
        JDebug.INFO((String)(" realmName..." + string));
        JDebug.INFO((String)(" user........" + string2));
        JDebug.INFO((String)(" listtype...." + string3));
        JDebug.INFO((String)(" nodename...." + string4));
        JDebug.INFO((String)(" file........" + file.toString()));
        JDebug.INFO((String)(" exts........" + Arrays.toString(stringArray)));
        if (stringArray != null) {
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                JDebug.INFO((String)("  " + stringArray[i]));
            }
        }
        JDebug.INFO((String)(" filter......" + string5));
        Object object2 = this.WARNING(file, stringArray);
        Serializable serializable2 = this.actions(file, stringArray);
        JDebug.INFO((String)(" dirNames...." + object2));
        JDebug.INFO((String)(" fileName...." + serializable2));
        if ((object2 != null || serializable2 != null) && string5.length() != 0) {
            stringArray2 = file.list((FilenameFilter)new WildcardMatcher(string5, true));
            object = null;
            serializable = null;
            if (stringArray2 != null && stringArray2.length > 0) {
                for (n2 = 0; n2 < stringArray2.length; ++n2) {
                    if (object2 != null && ((Vector)object2).contains(stringArray2[n2])) {
                        if (object == null) {
                            object = new Vector(1);
                        }
                        ((Vector)object).addElement(stringArray2[n2]);
                        continue;
                    }
                    if (serializable2 == null || !((Vector)serializable2).contains(stringArray2[n2])) continue;
                    if (serializable == null) {
                        serializable = new Vector(1);
                    }
                    ((Vector)serializable).addElement(stringArray2[n2]);
                }
            }
            object2 = object;
            serializable2 = serializable;
        }
        stringArray2 = file.getCanonicalPath();
        object = null;
        if (stringArray != null) {
            serializable = new StringBuffer();
            n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                ((StringBuffer)serializable).append(stringArray[i]);
                if (i >= n2 - 1) continue;
                ((StringBuffer)serializable).append(";");
            }
            object = ((StringBuffer)serializable).toString();
        } else {
            object = "*";
        }
        serializable = new StringBuffer();
        ((StringBuffer)serializable).append("  <input type=\"hidden\" name=\"realm\" value=\"" + string + "\"><input type=\"hidden\" name=\"user\"");
        ((StringBuffer)serializable).append("  value=\"" + string2 + "\"><input type=\"hidden\" name=\"node\" value=\"" + string4 + "\"><input type=\"hidden\"");
        ((StringBuffer)serializable).append("  name=\"listtype\" value=\"" + string3 + "\"><input type=\"hidden\" name=\"dir\" value=\"" + (String)stringArray2 + "\"><input");
        ((StringBuffer)serializable).append("  type=\"hidden\" name=\"exts\" value=\"" + (String)object + "\">");
        ((StringBuffer)serializable).append(" <table border=\"0\" width=\"100%\">");
        ((StringBuffer)serializable).append("  <tr>");
        ((StringBuffer)serializable).append("   <td width=\"32%\"><strong><font face=\"Arial\">&nbsp;&nbsp;&nbsp; Add Reachables</font></strong></td>");
        ((StringBuffer)serializable).append("   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Selected Realm: [" + string + "] </font></small></td>");
        ((StringBuffer)serializable).append("  </tr>");
        ((StringBuffer)serializable).append("  <tr>");
        ((StringBuffer)serializable).append("   <td width=\"32%\"></td>");
        ((StringBuffer)serializable).append("   <td width=\"68%\"><small><font face=\"Arial\"><p align=\"right\">Resource:");
        ((StringBuffer)serializable).append("   [" + string4 + "]</font></small></td>");
        ((StringBuffer)serializable).append("  </tr>");
        ((StringBuffer)serializable).append("  <tr>");
        ((StringBuffer)serializable).append("   <td width=\"32%\"></td>");
        ((StringBuffer)serializable).append("   <td width=\"68%\"><p align=\"right\"><small><font face=\"Arial\">Files of Type [" + (String)(object == null ? "*.*" : object) + "]</font></small></td>");
        ((StringBuffer)serializable).append("  </tr>");
        ((StringBuffer)serializable).append(" </table>");
        ((StringBuffer)serializable).append(" <hr>");
        ((StringBuffer)serializable).append(" <table border=\"0\" width=\"100%\" height=\"98\">");
        ((StringBuffer)serializable).append("  <tr>");
        ((StringBuffer)serializable).append("   <td width=\"21%\" height=\"1\" align=\"right\" valign=\"top\"><font face=\"Arial\"><u><small>Sub-resources:</small></u></font></td>");
        ((StringBuffer)serializable).append("   <td width=\"79%\" valign=\"top\" align=\"left\" height=\"1\">");
        ((StringBuffer)serializable).append("   <select name=\"reachables\" size=\"6\" multiple>");
        n2 = object2 == null ? 0 : ((Vector)object2).size();
        for (n = 0; n < n2; ++n) {
            String string6 = (String)((Vector)object2).elementAt(n);
            ((StringBuffer)serializable).append("<option value=\"" + string6 + "\">(D)" + string6 + "</option>");
        }
        n = serializable2 == null ? 0 : ((Vector)serializable2).size();
        for (int i = 0; i < n; ++i) {
            String string7 = (String)((Vector)serializable2).elementAt(i);
            ((StringBuffer)serializable).append("<option value=\"" + string7 + "\">(F)" + string7 + "</option>");
        }
        ((StringBuffer)serializable).append("   </select></td>");
        ((StringBuffer)serializable).append("  </tr>");
        ((StringBuffer)serializable).append("  <tr>");
        ((StringBuffer)serializable).append("   <td width=\"21%\" height=\"31\" valign=\"top\" align=\"right\"><u><small><font face=\"Arial\">Filter:</font></small></u></td>");
        ((StringBuffer)serializable).append("   <td width=\"79%\" valign=\"top\" align=\"left\" height=\"31\">");
        ((StringBuffer)serializable).append("    <input type=\"text\" name=\"filename\" value=\"" + string5 + "\" size=\"20\"></td>");
        ((StringBuffer)serializable).append("  </tr>");
        ((StringBuffer)serializable).append("  <tr>");
        ((StringBuffer)serializable).append("   <td width=\"21%\" height=\"41\" valign=\"top\" align=\"right\"></td>");
        ((StringBuffer)serializable).append("   <td width=\"79%\" valign=\"bottom\" align=\"left\" height=\"41\">");
        ((StringBuffer)serializable).append("    <input type=\"submit\" value=\"Filter List\" name=\"button" + IDS_ADD_REACHABLE_FILTER + "\">");
        ((StringBuffer)serializable).append("    <input type=\"submit\" value=\"Set Reachable\" name=\"button" + IDS_CONFIRMOF_ADD_REACHABLE + "\">");
        ((StringBuffer)serializable).append("    <input type=\"submit\" value=\"Close\" name=\"button" + IDS_CANCEL_FROM_ADD_REACHABLE + "\"></td>");
        ((StringBuffer)serializable).append("  </tr>");
        ((StringBuffer)serializable).append(" </table>");
        return ((StringBuffer)serializable).toString();
    }

    private void IDS_REMOVE_RSCNODE() throws IOException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Processing filtering from Add Reachables page...");
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("user");
        String string3 = this.getPropertyIgnoreCase("listtype");
        String string4 = this.getPropertyIgnoreCase("node");
        String string5 = WebSecurityUtil.validateFilePathStr(this.getPropertyIgnoreCase("dir"));
        String string6 = this.getPropertyIgnoreCase("exts");
        String string7 = this.getPropertyIgnoreCase("reachables");
        String string8 = this.getPropertyIgnoreCase("filename").trim();
        JDebug.INFO((String)(" realm name........" + string));
        JDebug.INFO((String)(" user.............." + string2));
        JDebug.INFO((String)(" list type........." + string3));
        JDebug.INFO((String)(" node name........." + string4));
        JDebug.INFO((String)(" dir..............." + string5));
        JDebug.INFO((String)(" exts.............." + string6));
        JDebug.INFO((String)(" reachable files..." + string7));
        JDebug.INFO((String)(" filter............" + string8));
        String string9 = null;
        if (string8.length() == 0) {
            string8 = "*";
        } else if (string8.indexOf("*") == -1 && string8.indexOf("?") == -1) {
            string8 = string8 + "*";
        }
        String[] stringArray = null;
        if (string6 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string6, ";");
            int n = stringTokenizer.countTokens();
            stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreElements()) {
                stringArray[n2++] = (String)stringTokenizer.nextElement();
            }
        }
        string9 = this.IDS_LIST_ROOT_RESOURCE(string, string2, string3, string4, new File(string5), stringArray, string8);
        this.writeResponse(string9);
    }

    private void IDS_SHOW_EDITOR() throws IOException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Processing confirming Add Reachables...");
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("user");
        String string3 = this.getPropertyIgnoreCase("listtype");
        String string4 = this.getPropertyIgnoreCase("node");
        String string5 = this.getPropertyIgnoreCase("dir");
        String string6 = this.getPropertyIgnoreCase("exts");
        String string7 = this.getPropertyIgnoreCase("reachables");
        String string8 = this.getPropertyIgnoreCase("filename").trim();
        JDebug.INFO((String)(" realm name........" + string));
        JDebug.INFO((String)(" user.............." + string2));
        JDebug.INFO((String)(" list type........." + string3));
        JDebug.INFO((String)(" node name........." + string4));
        JDebug.INFO((String)(" dir..............." + string5));
        JDebug.INFO((String)(" exts.............." + string6));
        JDebug.INFO((String)(" reachable files..." + string7));
        JDebug.INFO((String)(" filter............" + string8));
        String string9 = null;
        try {
            if (string7 != null) {
                RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
                if (rptResourceManager == null) {
                    throw new NoSuchRealmException(620003, new Object[]{string}, null);
                }
                NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string4);
                if (nodeInfo == null || !nodeInfo.nodetype.equals("R")) {
                    throw new UnknownResource(string4);
                }
                RptResourceNode rptResourceNode = nodeInfo.rscNode;
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                int n = 0;
                while (stringTokenizer.hasMoreElements()) {
                    String string10 = (String)stringTokenizer.nextElement();
                    if (rptResourceNode.setVrtFileReachable(string10, true)) {
                        stringBuffer.append("'" + string10 + "'");
                        ++n;
                        continue;
                    }
                    stringBuffer2.append(string10 + "\n");
                }
                if (stringBuffer2.length() > 0) {
                    String[] stringArray = new String[]{"realm", string, "user", string2, "listtype", string3, "node", string4};
                    this.printMessage(stringArray, "The following files are set reachable already:\n" + stringBuffer2, IDS_CANCEL_FROM_ADD_REACHABLE);
                    return;
                }
                if (n > 0) {
                    this.logManageSuccessEvent(JSvrResource.getMessage("RscEd_Log_AddReachable_Succ", stringBuffer.toString()), 5);
                }
            } else {
                String[] stringArray = new String[]{"realm", string, "user", string2, "listtype", string3, "node", string4};
                this.printMessage(stringArray, "No files are added to be reachable", IDS_CANCEL_FROM_ADD_REACHABLE);
                return;
            }
            string9 = this.SEDU(string, string2, string3, string4);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string9 = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string9 = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (UnknownMIMEType unknownMIMEType) {
            string9 = this.checkAlias((Exception)((Object)unknownMIMEType));
        }
        this.writeResponse(string9);
    }

    private void INFO() throws IOException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Processing cancel from Add Reachables...");
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("user");
        String string3 = this.getPropertyIgnoreCase("listtype");
        String string4 = this.getPropertyIgnoreCase("node");
        JDebug.INFO((String)(" realm name..." + string));
        JDebug.INFO((String)(" user........." + string2));
        JDebug.INFO((String)(" listtype....." + string3));
        JDebug.INFO((String)(" nodename....." + string4));
        String string5 = null;
        try {
            string5 = this.SEDU(string, string2, string3, string4);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string5 = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string5 = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (UnknownMIMEType unknownMIMEType) {
            string5 = this.checkAlias((Exception)((Object)unknownMIMEType));
        }
        this.writeResponse(string5);
    }

    private String SEDU(String string, String string2, String string3, String string4) throws NoSuchRealmException, UnknownResource, UnknownMIMEType {
        RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
        if (rptResourceManager == null) {
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
        NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string4);
        if (nodeInfo == null || !nodeInfo.nodetype.equals("R")) {
            throw new UnknownResource(string4);
        }
        return this.IDS_CANCEL_FROM_ADD_REACHABLE(string, string2, string4, nodeInfo.rscNode, string3);
    }

    private Vector WARNING(File file, String[] stringArray) {
        Vector<String> vector;
        block5: {
            block4: {
                int n;
                vector = null;
                if (stringArray != null) break block4;
                String string = "*";
                String[] stringArray2 = file.list((FilenameFilter)new WildcardMatcher(string, true, 4));
                int n2 = n = stringArray2 == null ? 0 : stringArray2.length;
                if (n <= 0) break block5;
                vector = new Vector<String>(n);
                for (int i = 0; i < n; ++i) {
                    vector.addElement(stringArray2[i]);
                }
                break block5;
            }
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                int n3;
                String[] stringArray3 = file.list((FilenameFilter)new WildcardMatcher("*" + stringArray[i], true, 4));
                int n4 = n3 = stringArray3 == null ? 0 : stringArray3.length;
                if (n3 <= 0) continue;
                if (vector == null) {
                    vector = new Vector(n3);
                }
                for (int j = 0; j < n3; ++j) {
                    vector.addElement(stringArray3[j]);
                }
            }
        }
        return vector;
    }

    private Vector actions(File file, String[] stringArray) {
        Vector<String> vector;
        block5: {
            block4: {
                int n;
                vector = null;
                if (stringArray != null) break block4;
                String string = "*";
                String[] stringArray2 = file.list((FilenameFilter)new WildcardMatcher(string, true, 2));
                int n2 = n = stringArray2 == null ? 0 : stringArray2.length;
                if (n <= 0) break block5;
                vector = new Vector<String>(n);
                for (int i = 0; i < n; ++i) {
                    vector.addElement(stringArray2[i]);
                }
                break block5;
            }
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                int n3;
                String[] stringArray3 = file.list((FilenameFilter)new WildcardMatcher("*" + stringArray[i], true, 2));
                int n4 = n3 = stringArray3 == null ? 0 : stringArray3.length;
                if (n3 <= 0) continue;
                if (vector == null) {
                    vector = new Vector(n3);
                }
                for (int j = 0; j < n3; ++j) {
                    vector.addElement(stringArray3[j]);
                }
            }
        }
        return vector;
    }

    private void addElement() throws IOException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Process escaping from editing Resource Node...");
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("user");
        String string3 = this.getPropertyIgnoreCase("listtype");
        String string4 = this.getPropertyIgnoreCase("node");
        String string5 = null;
        try {
            string5 = this.append(string, string2, string3, string4);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string5 = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string5 = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (IOException iOException) {
            string5 = this.checkAlias(iOException);
        }
        catch (UnknownMIMEType unknownMIMEType) {
            string5 = this.checkAlias((Exception)((Object)unknownMIMEType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string5 = this.checkAlias(illegalArgumentException);
        }
        this.writeResponse(string5);
    }

    private String append(String string, String string2, String string3, String string4) throws NoSuchRealmException, UnknownResource, IOException, UnknownMIMEType, IllegalArgumentException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"Generte the page which is canceled from Editor page.");
        JDebug.INFO((String)(" realmName...." + string));
        JDebug.INFO((String)(" user........." + string2));
        JDebug.INFO((String)(" listtype....." + string3));
        JDebug.INFO((String)(" nodename....." + string4));
        String string5 = null;
        int n = string4.lastIndexOf("/");
        string5 = string4.equals("(R)/") ? this.IDS_ADD_REACHABLE_FILTER(string, string2, null, false, string3) : (n == 3 ? this.IDS_ADD_REACHABLE_FILTER(string, string2, "(R)/", true, string3) : this.IDS_ADD_REACHABLE_FILTER(string, string2, string4.substring(0, n), true, string3));
        return string5;
    }

    private void areEqual() throws IOException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Processing confirming of editing vritual resource node...");
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("user");
        String string3 = this.getPropertyIgnoreCase("node");
        String string4 = this.getPropertyIgnoreCase("listtype");
        String string5 = this.getPropertyIgnoreCase("reachable");
        JDebug.INFO((String)(" realmName......" + string));
        JDebug.INFO((String)(" nodename......." + string3));
        JDebug.INFO((String)(" listtype......." + string4));
        JDebug.INFO((String)(" user..........." + string2));
        JDebug.INFO((String)(" reachable......" + string5));
        String string6 = null;
        try {
            RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
            if (rptResourceManager == null) {
                throw new NoSuchRealmException(620003, new Object[]{string}, null);
            }
            NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string3);
            if (nodeInfo == null || nodeInfo.nodetype.equals("R")) {
                throw new Exception("Cannot find the Virtual Resource Node '" + string3 + "'");
            }
            boolean bl = nodeInfo.reachable == 1;
            boolean bl2 = false;
            if (string5.equals("reachable")) {
                bl2 = true;
            }
            if (bl != bl2) {
                nodeInfo.rscNode.setVrtFileReachable(nodeInfo.name, bl2);
                this.save(rptResourceManager, string2);
            }
            string6 = this.IDS_ADD_REACHABLE_FILTER(string, string2, nodeInfo.rscNode.getFullName(), false, string4);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string6 = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string6 = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (UnknownMIMEType unknownMIMEType) {
            string6 = this.checkAlias((Exception)((Object)unknownMIMEType));
        }
        catch (IOException iOException) {
            string6 = this.checkAlias(iOException);
        }
        catch (ResourceInfoException resourceInfoException) {
            string6 = this.checkAlias((Exception)((Object)resourceInfoException));
        }
        catch (Exception exception) {
            string6 = this.checkAlias(exception);
        }
        this.writeResponse(string6);
    }

    private void arrangeCatSubNodes() throws IOException {
        JDebug.INFO((String)"");
        JDebug.INFO((String)"*** Processing declaring vritual resource node...");
        String string = this.getPropertyIgnoreCase("realm");
        String string2 = this.getPropertyIgnoreCase("user");
        String string3 = this.getPropertyIgnoreCase("node");
        String string4 = this.getPropertyIgnoreCase("listtype");
        String string5 = this.getPropertyIgnoreCase("reachable");
        String string6 = this.getPropertyIgnoreCase("subreachable");
        JDebug.INFO((String)(" realmName......" + string));
        JDebug.INFO((String)(" nodename......." + string3));
        JDebug.INFO((String)(" listtype......." + string4));
        JDebug.INFO((String)(" user..........." + string2));
        JDebug.INFO((String)(" reachable......" + string5));
        JDebug.INFO((String)(" subreachable..." + string6));
        String string7 = null;
        try {
            RptResourceManager rptResourceManager = UserDataToolkit.getManager(string);
            if (rptResourceManager == null) {
                throw new NoSuchRealmException(620003, new Object[]{string}, null);
            }
            NodeInfo nodeInfo = rptResourceManager.getResourceTreeMan().getNodeInfo(string3);
            if (nodeInfo == null || nodeInfo.nodetype.equals("R")) {
                throw new Exception("Cannot find the Virtual Resource Node '" + string3 + "'");
            }
            RptResourceNode rptResourceNode = rptResourceManager.getResourceTreeMan().declare(nodeInfo.rscNode, nodeInfo.relativePath, string6.equals("reachable"));
            this.save(rptResourceManager, string2);
            String string8 = rptResourceNode.getFullName();
            StringTokenizer stringTokenizer = new StringTokenizer(string8, "/");
            StringBuffer stringBuffer = new StringBuffer("(R)");
            while (stringTokenizer.hasMoreElements()) {
                String string9 = (String)stringTokenizer.nextElement();
                stringBuffer.append("/(R)" + string9);
            }
            string7 = this.IDS_CANCEL_FROM_ADD_REACHABLE(string, string2, stringBuffer.toString(), rptResourceNode, string4);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            string7 = this.checkAlias((Exception)((Object)noSuchRealmException));
        }
        catch (UnknownResource unknownResource) {
            string7 = this.checkAlias((Exception)((Object)unknownResource));
        }
        catch (UnknownMIMEType unknownMIMEType) {
            string7 = this.checkAlias((Exception)((Object)unknownMIMEType));
        }
        catch (IOException iOException) {
            string7 = this.checkAlias(iOException);
        }
        catch (ResourceInfoException resourceInfoException) {
            string7 = this.checkAlias((Exception)((Object)resourceInfoException));
        }
        catch (Exception exception) {
            string7 = this.checkAlias(exception);
        }
        this.writeResponse(string7);
    }

    private boolean canCreateNew(RptResourceNode rptResourceNode, String string) {
        if ((string = WebSecurityUtil.validateFilePathStr(string)) != null && string.length() > 0) {
            File file = new File(string);
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
        rptResourceNode.setRealPath(string);
        return true;
    }

    private void save(RptResourceManager rptResourceManager, String string) throws ResourceInfoException {
        try {
            rptResourceManager.save();
            this.logManageSuccessEvent(JSvrResource.getMessage("RscEd_Log_Save_Succ"), 4);
        }
        catch (ResourceInfoException resourceInfoException) {
            this.logManageFailEvent(JSvrResource.getMessage("RscEd_Log_Save_Fail"), 4);
            throw resourceInfoException;
        }
    }

    private String checkAlias(Exception exception) {
        String string = null;
        if (exception instanceof NoSuchRealmException) {
            string = "Realm '" + exception.getMessage() + "' does not exist!";
        } else if (exception instanceof UnknownResource) {
            string = "Cannot find resource " + exception.getMessage();
        } else if (exception instanceof IOException) {
            string = "An IO Exception occurs: " + exception.getMessage();
        } else if (exception instanceof UnknownMIMEType) {
            string = "Somthing wrong with " + JSvrResource.getMessage("SERVERNAME") + " - " + exception.getMessage();
        } else if (exception instanceof IllegalArgumentException) {
            string = "Somthing wrong with " + JSvrResource.getMessage("SERVERNAME") + " - " + exception.getMessage();
        } else if (exception instanceof ResourceInfoException) {
            string = "Saving resource failed: " + exception.getMessage();
        } else {
            JDebug.INFO((String)("*** Unknown Exception: " + exception));
            JDebug.WARNING((Throwable)exception);
            ServiceLogger.logError(exception);
            string = exception.getMessage();
        }
        return string;
    }
}

