/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resource;

import guitools.tree.TreePreorderTraversal;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.api.exception.ResourceInfoException;
import jet.server.resource.AliasNode;
import jet.server.resource.AliasRoot;
import jet.server.resource.InvalidAliases;
import jet.server.resource.ResourceInfo;
import jet.server.resource.ResourceTreeMan;
import jet.server.resource.ResourceUtil;

public abstract class GenericAliasInfo {
    protected AliasRoot root = null;
    protected String user = null;
    protected InvalidAliases invalidAliases = null;
    protected ResourceTreeMan rsctreeMan = null;
    protected String realm;
    protected ResourceInfo rscInfo;

    protected String getPropPrefix() {
        return this.realm + "." + this.user;
    }

    protected String getHiddenPropName(String string) {
        return this.realm + "." + this.user + string + ".hidden";
    }

    public String getResourceName(String string, StringBuffer stringBuffer) {
        int n;
        String string2 = null;
        if (!string.startsWith("/")) {
            return null;
        }
        Vector vector = ResourceUtil.getTokenSkippingDots(string);
        int n2 = vector.size();
        AliasNode aliasNode = this.root;
        AliasNode aliasNode2 = aliasNode;
        for (n = 0; n < n2 && (aliasNode2 = aliasNode.getSubNode((String)vector.elementAt(n))) != null && !aliasNode2.isHidden(); ++n) {
            aliasNode = aliasNode2;
        }
        if (aliasNode != null) {
            string2 = aliasNode.getResourceName();
            if (stringBuffer != null) {
                while (n < n2) {
                    stringBuffer.append("/" + vector.elementAt(n++));
                }
            }
        }
        return string2;
    }

    public AliasNode getAliasNode(String string) {
        AliasRoot aliasRoot;
        if (!string.startsWith("/")) {
            return null;
        }
        Vector vector = ResourceUtil.getTokenSkippingDots(string);
        int n = vector.size();
        AliasNode aliasNode = aliasRoot = this.root;
        for (int i = 0; i < n; ++i) {
            aliasNode = aliasRoot.getSubNode((String)vector.elementAt(i));
            if (aliasNode != null) {
                aliasRoot = aliasNode;
                continue;
            }
            aliasRoot = null;
            break;
        }
        return aliasRoot;
    }

    public String[] checkCatAlias(String string, Vector vector, Vector vector2, boolean bl) {
        String[] stringArray = null;
        TreePreorderTraversal treePreorderTraversal = new TreePreorderTraversal(this.root);
        AliasNode aliasNode = null;
        AliasNode aliasNode2 = null;
        boolean bl2 = false;
        while (treePreorderTraversal.hasMoreNodes()) {
            aliasNode = (AliasNode)treePreorderTraversal.nextTreeNode();
            String string2 = aliasNode.getResourceName();
            if (string2 == null || !string2.equals(string)) continue;
            Vector vector3 = aliasNode.getSubNodes();
            int n = vector3 == null ? 0 : vector3.size();
            for (int i = 0; i < n; ++i) {
                aliasNode2 = (AliasNode)vector3.elementAt(i);
                String string3 = aliasNode2.getResourceName();
                if (bl && aliasNode2.numberOfSubNodes() > 0) {
                    stringArray = new String[]{"0", aliasNode.getFullName(), aliasNode2.getFullName(), string3, this.user};
                    return stringArray;
                }
                if (string3 == null || string3.trim().length() <= 0) continue;
                string3 = string3.trim();
                String string4 = null;
                int n2 = -1;
                if (!string3.equals("/")) {
                    if (string3.endsWith("/")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    string4 = (n2 = string3.lastIndexOf("/")) == 0 ? "/" : string3.substring(0, n2);
                }
                if (string4 != null && string4.equals(string)) {
                    String string5 = string3.substring(n2 + 1);
                    if (vector != null && vector.contains(string5) || vector2 != null && vector2.contains(string5)) continue;
                    stringArray = new String[]{"1", aliasNode.getFullName(), aliasNode2.getFullName(), string3, this.user};
                    return stringArray;
                }
                stringArray = new String[]{"1", aliasNode.getFullName(), aliasNode2.getFullName(), string3, this.user};
                return stringArray;
            }
        }
        return stringArray;
    }

    public AliasRoot getAliasRoot() {
        return this.root;
    }

    public InvalidAliases getInvalidAliases() {
        return this.invalidAliases;
    }

    public boolean save() throws ResourceInfoException {
        if (this.rscInfo != null) {
            ExProperties exProperties = new ExProperties();
            ExProperties exProperties2 = new ExProperties();
            this.export(exProperties, exProperties2);
            this.rscInfo.saveAlias(exProperties, exProperties2, this.realm, this.user);
            return true;
        }
        return false;
    }

    public String getUserName() {
        return this.user;
    }

    public abstract void export(ExProperties var1, ExProperties var2);
}

