/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resstore.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.OrgConfiguration;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.version.SimpleVersionInfo;
import jet.server.log.ServiceLogger;
import jet.server.resstore.ServerResourceStoreFactory;
import jet.server.resstore.impl.JRServerResourceStore;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;

public class JRServerResourceStoreFactory
extends ServerResourceStoreFactory {
    private static final long HISTORY = 1800000L;
    private static JRServerResourceStoreFactory SEDU;
    private ConfigService TEMP;
    private final Thread append;
    private final File clear;
    private final File get;
    private final JRServerResourceStore getActiveRealm;
    private final Map getCRDMemoryUsage = new HashMap();

    public static synchronized JRServerResourceStoreFactory getInstance() {
        if (SEDU == null) {
            File file = new File(StorageEnv.localEnv().getDiskDir(Storage.StorageRoot.TEMP));
            File file2 = new File(StorageEnv.localEnv().getDiskDir(Storage.StorageRoot.HISTORY));
            SEDU = new JRServerResourceStoreFactory(file, file2);
        }
        return SEDU;
    }

    public static synchronized void destroy() {
        if (SEDU != null) {
            SEDU.shutdown();
            SEDU = null;
        }
    }

    public static void init(ConfigService configService) {
        JRServerResourceStoreFactory.getInstance().append(configService);
    }

    private JRServerResourceStoreFactory(File file, File file2) {
        this.get = file;
        this.clear = file2;
        this.getActiveRealm = this.HISTORY(null, null);
        this.append = new Thread("DiskStoreCleaner"){

            @Override
            public void run() {
                try {
                    while (true) {
                        JRServerResourceStoreFactory.this.cleanup();
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        };
        this.append.setDaemon(true);
        this.append.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() throws InterruptedException {
        ArrayList arrayList;
        Thread.sleep(1800000L);
        JRServerResourceStoreFactory jRServerResourceStoreFactory = this;
        synchronized (jRServerResourceStoreFactory) {
            arrayList = new ArrayList(this.getCRDMemoryUsage.values());
        }
        for (JRServerResourceStore jRServerResourceStore : arrayList) {
            jRServerResourceStore.getDiskStore().refreshFiles();
        }
    }

    private synchronized void shutdown() {
        this.append.interrupt();
        this.getCRDMemoryUsage.clear();
        this.TEMP = null;
    }

    public synchronized void removeResourceStore(String string) {
        this.getCRDMemoryUsage.remove(string);
    }

    @Override
    public JRServerResourceStore getResourceStore(String string) {
        return this.HISTORY(string, null);
    }

    @Override
    public JRServerResourceStore getResourceStoreByUser(String string) {
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        return this.HISTORY(string2, string3);
    }

    @Override
    public JRServerResourceStore getResourceStoreByResourcePath(String string) {
        String[] stringArray = CSUtil.parseVirtualResourcePath(string);
        return this.getResourceStore(stringArray[0]);
    }

    public JRServerResourceStore getResourceStoreByRealDiskPath(String string) {
        SimpleVersionInfo simpleVersionInfo = UserDataToolkit.getResourceManager(ServerEnv.getActiveRealm()).getResourceVersionByDiskPath(string);
        if (simpleVersionInfo == null) {
            ServiceLogger.logDebug("ResourceStore:: getResourceStoreByRealDiskPath() not found the resource path For the disk path: " + string, 4);
        }
        return this.getResourceStoreByResourcePath(simpleVersionInfo == null ? null : simpleVersionInfo.getResourcePath());
    }

    private synchronized JRServerResourceStore HISTORY(String string, String string2) {
        JRServerResourceStore jRServerResourceStore = (JRServerResourceStore)this.getCRDMemoryUsage.get(string = string == null || string.trim().isEmpty() ? null : string);
        if (jRServerResourceStore == null) {
            if (string == null) {
                jRServerResourceStore = this.TEMP(null, string);
            } else {
                jRServerResourceStore = this.TEMP(this.getActiveRealm, string);
                this.clear(jRServerResourceStore, this.SEDU(string));
            }
            this.getCRDMemoryUsage.put(string, jRServerResourceStore);
        }
        return jRServerResourceStore;
    }

    private OrgConfiguration SEDU(String string) {
        if (this.TEMP != null) {
            return this.TEMP.getOrgConfiguration(string);
        }
        return null;
    }

    private JRServerResourceStore TEMP(JRServerResourceStore jRServerResourceStore, String string) {
        JRServerResourceStore jRServerResourceStore2 = new JRServerResourceStore(jRServerResourceStore, string, this.get, this.clear);
        if (jRServerResourceStore == null) {
            jRServerResourceStore2.getDiskStore().getSpaceAllocator().setMaxSpace(Long.MAX_VALUE);
            jRServerResourceStore2.getMemoryStore().getSpaceAllocator().setMaxSpace(Long.MAX_VALUE);
            jRServerResourceStore2.getMemoryStore().getCatalogLoader().setMaxSize(10);
            jRServerResourceStore2.getMemoryStore().getCatalogLoader().setMaxSpace(Long.MAX_VALUE);
            jRServerResourceStore2.getMemoryStore().getReportLoader().setMaxSize(10);
            jRServerResourceStore2.getMemoryStore().getReportLoader().setMaxSpace(Long.MAX_VALUE);
            jRServerResourceStore2.getMemoryStore().getImageLoader().setMaxSize(Integer.MAX_VALUE);
            jRServerResourceStore2.getMemoryStore().getImageLoader().setMaxSpace(Long.MAX_VALUE);
        } else {
            jRServerResourceStore2.getDiskStore().getSpaceAllocator().setMaxSpace(0x1900000000L);
            jRServerResourceStore2.getMemoryStore().getSpaceAllocator().setMaxSpace(0x100000000L);
            jRServerResourceStore2.getMemoryStore().getCatalogLoader().setMaxSize(Integer.MAX_VALUE);
            jRServerResourceStore2.getMemoryStore().getCatalogLoader().setMaxSpace(0x3200000L);
            jRServerResourceStore2.getMemoryStore().getReportLoader().setMaxSize(Integer.MAX_VALUE);
            jRServerResourceStore2.getMemoryStore().getReportLoader().setMaxSpace(0x3200000L);
            jRServerResourceStore2.getMemoryStore().getImageLoader().setMaxSize(Integer.MAX_VALUE);
            jRServerResourceStore2.getMemoryStore().getImageLoader().setMaxSpace(0x3200000L);
        }
        jRServerResourceStore2.getDiskStore().getCrdAutoCacheDiskStore().getSpaceAllocator().setMaxSpace(0x20000000L);
        jRServerResourceStore2.getMemoryStore().getCubeSpaceAllocator().setMaxSpace(0L);
        jRServerResourceStore2.getMemoryStore().getCrdCache().setMaxMemorySize(0x400000L);
        return jRServerResourceStore2;
    }

    private void append(ConfigService configService) {
        ServiceLogger.logDebug("ResourceStore:: config system resource store", 4);
        this.TEMP = configService;
        JRServerResourceStore jRServerResourceStore = this.getActiveRealm;
        jRServerResourceStore.getDiskStore().getSpaceAllocator().setMaxSpace(Long.MAX_VALUE);
        jRServerResourceStore.getDiskStore().getCrdAutoCacheDiskStore().getSpaceAllocator().setMaxSpace((long)configService.getConfigurationCache().getMaxDiskUsage() * 0x100000L);
        jRServerResourceStore.getMemoryStore().getSpaceAllocator().setMaxSpace(Long.MAX_VALUE);
        jRServerResourceStore.getMemoryStore().getCatalogLoader().setMaxSpace(Long.MAX_VALUE);
        jRServerResourceStore.getMemoryStore().getCatalogLoader().setMaxSize(configService.getConfigurationCache().getMaxCacheCatalogSize());
        jRServerResourceStore.getMemoryStore().getCatalogLoader().setCacheEnabled(configService.getConfigurationCache().getEnableCacheCatelog());
        jRServerResourceStore.getMemoryStore().getReportLoader().setMaxSpace(Long.MAX_VALUE);
        jRServerResourceStore.getMemoryStore().getReportLoader().setMaxSize(configService.getConfigurationCache().getMaxCacheReportSize());
        jRServerResourceStore.getMemoryStore().getReportLoader().setCacheEnabled(configService.getConfigurationCache().getEnableCacheReport());
        jRServerResourceStore.getMemoryStore().getImageLoader().setMaxSpace(Long.MAX_VALUE);
        jRServerResourceStore.getMemoryStore().getImageLoader().setMaxSize(configService.getConfigurationCache().isCacheAllImages() ? Integer.MAX_VALUE : configService.getConfigurationCache().getMaxCacheImageSize());
        jRServerResourceStore.getMemoryStore().getImageLoader().setCacheEnabled(configService.getConfigurationCache().getEnableCacheImage());
        jRServerResourceStore.getMemoryStore().getCubeSpaceAllocator().setMaxSpace((long)(configService.getConfigurationCache().getMaxCubeMemory() * 1048576.0));
        jRServerResourceStore.getMemoryStore().getCrdCache().setMaxMemorySize((long)configService.getConfigurationCache().getCRDMemoryUsage() * 0x100000L);
        for (JRServerResourceStore jRServerResourceStore2 : this.getCRDMemoryUsage.values()) {
            this.clear(jRServerResourceStore2, this.SEDU(jRServerResourceStore2.getOrganizationName()));
        }
    }

    private void clear(JRServerResourceStore jRServerResourceStore, OrgConfiguration orgConfiguration) {
        if (orgConfiguration == null) {
            return;
        }
        ServiceLogger.logDebug("ResourceStore:: config org resource store: " + jRServerResourceStore.getOrganizationName(), 4);
        jRServerResourceStore.getDiskStore().getSpaceAllocator().setMaxSpace((long)orgConfiguration.getMaxDiskSpace() * 0x40000000L);
        jRServerResourceStore.getDiskStore().getCrdAutoCacheDiskStore().getSpaceAllocator().setMaxSpace(this.getActiveRealm.getDiskStore().getCrdAutoCacheDiskStore().getSpaceAllocator().getMaxSpace());
        jRServerResourceStore.getMemoryStore().getSpaceAllocator().setMaxSpace((long)orgConfiguration.getMaxMemorySpace() * 0x40000000L);
        jRServerResourceStore.getMemoryStore().getCatalogLoader().setMaxSpace((long)orgConfiguration.getMaxCacheCatalogsSize() * 0x100000L);
        jRServerResourceStore.getMemoryStore().getCatalogLoader().setMaxSize(Integer.MAX_VALUE);
        jRServerResourceStore.getMemoryStore().getCatalogLoader().setCacheEnabled(orgConfiguration.isEnabledCacheCatalogs());
        jRServerResourceStore.getMemoryStore().getReportLoader().setMaxSpace((long)orgConfiguration.getMaxCacheReportsSpace() * 0x100000L);
        jRServerResourceStore.getMemoryStore().getReportLoader().setMaxSize(Integer.MAX_VALUE);
        jRServerResourceStore.getMemoryStore().getReportLoader().setCacheEnabled(orgConfiguration.isEnabledCacheReports());
        jRServerResourceStore.getMemoryStore().getImageLoader().setMaxSpace((long)orgConfiguration.getMaxCacheImagesSpace() * 0x100000L);
        jRServerResourceStore.getMemoryStore().getImageLoader().setMaxSize(Integer.MAX_VALUE);
        jRServerResourceStore.getMemoryStore().getImageLoader().setCacheEnabled(orgConfiguration.isEnabledCacheImages());
        jRServerResourceStore.getMemoryStore().getCubeSpaceAllocator().setMaxSpace((long)orgConfiguration.getMaxCubeSpace() * 0x100000L);
        jRServerResourceStore.getMemoryStore().getCrdCache().setMaxMemorySize((long)orgConfiguration.getMaxReportDataSpace() * 0x100000L);
    }
}

