/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.schedule.Committer;

public class CommitRunner
implements Runnable {
    private Committer SEDU = null;
    long interval;
    boolean stopRun = false;
    private boolean commit = false;
    private long currentTimeMillis = 0L;
    private Object getCommitInterval = new Object();
    private long logError = 0L;

    public CommitRunner(Committer committer) {
        this.SEDU = committer;
        this.interval = (long)ServerEnv.getCommitInterval() * 1000L;
        if (this.interval > 600000L) {
            this.interval = 600000L;
        }
        ServiceLogger.logEvent(5610001, new Object[]{committer, new Long(this.interval)}, 5);
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServiceLogger.logEvent(5610002, 5);
        while (!this.stopRun) {
            try {
                Object object = this.getCommitInterval;
                synchronized (object) {
                    this.getCommitInterval.wait(this.interval);
                }
                this.SEDU();
                if (!this.stopRun) continue;
                break;
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    public void stop() {
        this.stopRun = true;
    }

    private void SEDU() throws Exception {
        if (this.commit()) {
            this.SEDU.commit();
            this.commit = false;
        }
    }

    private boolean commit() {
        if (!this.commit) {
            return false;
        }
        return System.currentTimeMillis() - this.currentTimeMillis >= this.interval;
    }

    public void notifyCommit() {
        this.currentTimeMillis = System.currentTimeMillis();
        this.commit = true;
    }
}

