/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.util.Vector;
import jet.server.api.ResultFiles;

public class JRResultFiles
implements ResultFiles {
    private static final int SEDU = 15;
    public static final int RST_FORMAT = 0;
    public static final int HTML_FORMAT = 1;
    public static final int PDF_FORMAT = 2;
    public static final int TEXT_FORMAT = 3;
    public static final int EXCEL_FORMAT = 4;
    public static final int POSTSCRIPT_FORMAT = 5;
    public static final int RTF_FORMAT = 6;
    public static final int XML_FORMAT = 7;
    public static final int AST_FORMAT = 8;
    public static final int CSV_FORMAT = 9;
    public static final int TIFF_FORMAT = 10;
    public static final int SVG_FORMAT = 11;
    public static final int RSD_FORMAT = 12;
    public static final int WST_FORMAT = 13;
    public static final int EXCEL_2010_FORMAT = 14;
    private String addElement = null;
    private String addFormat = null;
    public static final String[] suffixs = new String[]{".rst", ".html", ".pdf", ".txt", ".xls", ".ps", ".rtf", ".xml", ".ast", ".csv", ".tiff", ".svg", ".rsd", ".wst", ".xlsx"};
    private String append = null;
    private long endsWith = 0L;
    private long equalsIgnoreCase = 0L;
    private long getHtmlFileName = 0L;
    private long getIndexOfFormat = 0L;
    private int lastIndexOf = -1;
    private String[] substring = new String[15];

    public static int getFormat(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return n;
            }
            case 8: {
                return 12;
            }
            case 12: {
                return 13;
            }
        }
        return -1;
    }

    public JRResultFiles(String string, String string2) {
        this(string, string2, 0L, 0L, 0L);
    }

    public JRResultFiles(String string, String string2, long l, long l2, long l3) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        this.append = string;
        this.equalsIgnoreCase = l;
        this.getHtmlFileName = l2;
        this.getIndexOfFormat = l3;
        this.addFormat(this.getIndexOfFormat(string2));
    }

    public JRResultFiles(String string, long l, long l2, long l3, long l4, int n) {
        this.append = string;
        this.endsWith = l;
        this.equalsIgnoreCase = l2;
        this.getHtmlFileName = l3;
        this.getIndexOfFormat = l4;
        this.lastIndexOf = n;
        for (int i = 0; i < 15; ++i) {
            if (!this.addElement(l, i)) continue;
            this.substring[i] = string + suffixs[i];
        }
    }

    public String getSharedPrefix() {
        return this.append;
    }

    public long getResultFormats() {
        return this.endsWith;
    }

    public long getFormatViewedStatus() {
        return this.equalsIgnoreCase;
    }

    @Override
    public Vector getResultFileNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < 15; ++i) {
            if (this.substring[i] == null) continue;
            if (i == 1) {
                vector.addElement(this.getHtmlFileName());
                continue;
            }
            vector.addElement(this.substring[i]);
        }
        return vector;
    }

    public void addFormat(int n) {
        this.SEDU(n, null);
    }

    private void SEDU(int n, String string) {
        String string2;
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        if (string == null) {
            string = this.append;
        }
        if (!(string2 = string).endsWith(suffixs[n])) {
            if (string2.toLowerCase().endsWith(suffixs[n])) {
                int n2 = string2.lastIndexOf(".");
                string2 = string2.substring(0, n2) + suffixs[n];
            } else {
                string2 = string2 + suffixs[n];
            }
        }
        this.substring[n] = string2;
        this.endsWith = this.addFormat(this.endsWith, n, true);
    }

    public void removeFormat(int n) {
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.substring[n] = null;
        this.endsWith = this.addFormat(this.endsWith, n, false);
    }

    public void setFormat(int n, boolean bl) {
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.endsWith = this.addFormat(this.endsWith, n, bl);
    }

    public void setFormatViewed(int n) {
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.equalsIgnoreCase = this.addFormat(this.equalsIgnoreCase, n, true);
    }

    public void setPLSResult(int n) {
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.getHtmlFileName = this.addFormat(this.getHtmlFileName, n, true);
    }

    public void setSecConstraint(int n) {
        if (n < 0 || n >= 15) {
            throw new IllegalArgumentException("Error format: " + n);
        }
        this.getIndexOfFormat = this.addFormat(this.getIndexOfFormat, n, true);
    }

    public int getIndexOfFormat(String string) {
        int n;
        for (n = 0; n < 15 && !suffixs[n].equalsIgnoreCase(string); ++n) {
        }
        return n;
    }

    private boolean addElement(long l, int n) {
        return (l & (long)(1 << n)) != 0L;
    }

    private long addFormat(long l, int n, boolean bl) {
        if (bl) {
            return l | (long)(1 << n);
        }
        return l & (long)(~(1 << n));
    }

    @Override
    public boolean hasRstFile() {
        return this.addElement(this.endsWith, 0);
    }

    @Override
    public String getRstFileName() {
        return this.substring[0];
    }

    @Override
    public boolean hasWstFile() {
        return this.addElement(this.endsWith, 13);
    }

    @Override
    public String getWstFileName() {
        return this.substring[13];
    }

    @Override
    public boolean hasHtmlFile() {
        return this.addElement(this.endsWith, 1);
    }

    @Override
    public String getHtmlFileName() {
        String string = this.substring[1];
        return string;
    }

    @Override
    public boolean hasPdfFile() {
        return this.addElement(this.endsWith, 2);
    }

    @Override
    public String getPdfFileName() {
        return this.substring[2];
    }

    @Override
    public boolean hasExcelFile() {
        boolean bl = false;
        bl = this.addElement(this.endsWith, 4);
        if (!bl) {
            bl = this.addElement(this.endsWith, 14);
        }
        return bl;
    }

    @Override
    public String getExcelFileName() {
        return this.substring[4] == null ? this.substring[14] : this.substring[4];
    }

    @Override
    public boolean hasXmlFile() {
        return this.addElement(this.endsWith, 7);
    }

    @Override
    public String getXmlFileName() {
        return this.substring[7];
    }

    @Override
    public boolean hasPostScriptFile() {
        return this.addElement(this.endsWith, 5);
    }

    @Override
    public String getPostScriptFileName() {
        return this.substring[5];
    }

    @Override
    public boolean hasTextFile() {
        boolean bl = false;
        bl = this.addElement(this.endsWith, 3);
        if (!bl) {
            bl = this.addElement(this.endsWith, 9);
        }
        return bl;
    }

    @Override
    public String getTextFileName() {
        return this.substring[3] == null ? this.substring[9] : this.substring[3];
    }

    @Override
    public boolean hasRtfFile() {
        return this.addElement(this.endsWith, 6);
    }

    @Override
    public String getRtfFileName() {
        return this.substring[6];
    }

    @Override
    public boolean hasAstFile() {
        return this.addElement(this.endsWith, 8);
    }

    @Override
    public String getAstFileName() {
        return this.substring[8];
    }

    public String toString() {
        return "JRResultFiles[" + this.append + ":" + this.endsWith + ", " + this.lastIndexOf + "]";
    }

    @Override
    public boolean hasTiffFile() {
        return this.addElement(this.endsWith, 10);
    }

    @Override
    public String getTiffFileName() {
        return this.substring[10];
    }

    @Override
    public boolean hasSvgFile() {
        return this.addElement(this.endsWith, 11);
    }

    @Override
    public String getSvgFileName() {
        return this.substring[11];
    }

    @Override
    public boolean hasRsdFile() {
        return this.addElement(this.endsWith, 12);
    }

    @Override
    public String getRsdFileName() {
        return this.substring[12];
    }

    @Override
    public boolean isAnalysisResult() {
        return this.lastIndexOf != -1;
    }

    @Override
    public int getAnalysisReportAmount() {
        return this.lastIndexOf;
    }

    @Override
    public String getReportName() {
        return this.addElement;
    }

    @Override
    public String getReportDisplayName() {
        return this.addFormat;
    }

    public void setReportName(String string) {
        this.addElement = string;
    }

    public void setReportDisplayName(String string) {
        this.addFormat = string;
    }

    @Override
    public boolean isViewedExcelFile() {
        return this.addElement(this.equalsIgnoreCase, 4);
    }

    @Override
    public boolean isViewedHtmlFile() {
        return this.addElement(this.equalsIgnoreCase, 1);
    }

    @Override
    public boolean isViewedPdfFile() {
        return this.addElement(this.equalsIgnoreCase, 2);
    }

    @Override
    public boolean isViewedPostScriptFile() {
        return this.addElement(this.equalsIgnoreCase, 5);
    }

    @Override
    public boolean isViewedRsdFile() {
        return this.addElement(this.equalsIgnoreCase, 12);
    }

    @Override
    public boolean isViewedRstFile() {
        return this.addElement(this.equalsIgnoreCase, 0);
    }

    @Override
    public boolean isViewedRtfFile() {
        return this.addElement(this.equalsIgnoreCase, 6);
    }

    @Override
    public boolean isViewedTextFile() {
        boolean bl = this.addElement(this.equalsIgnoreCase, 3);
        if (!bl) {
            bl = this.addElement(this.equalsIgnoreCase, 9);
        }
        return bl;
    }

    @Override
    public boolean isViewedXmlFile() {
        return this.addElement(this.equalsIgnoreCase, 7);
    }

    @Override
    public boolean isViewedWstFile() {
        return this.addElement(this.equalsIgnoreCase, 13);
    }

    @Override
    public boolean isPLSHtmlFile() {
        return this.addElement(this.getHtmlFileName, 1);
    }

    @Override
    public boolean isPLSRsdFile() {
        return this.addElement(this.getHtmlFileName, 12);
    }

    @Override
    public boolean isSecurityConstraintHtmlFile() {
        return this.addElement(this.getIndexOfFormat, 1);
    }

    @Override
    public boolean isSecurityConstraintRsdFile() {
        return this.addElement(this.getIndexOfFormat, 12);
    }

    public long getPlsResultBits() {
        return this.getHtmlFileName;
    }

    public long getSecConstraintBits() {
        return this.getIndexOfFormat;
    }
}

