/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.ReportEnv;
import jet.cs.CSMail;
import jet.cs.CSUtil;
import jet.cs.PrefixFilenameFilter;
import jet.export.mail.mailconfig;
import jet.server.ServerEnv;
import jet.server.cluster.ClusterEnv;
import jet.server.jrc.quartz.JRBasicTrigger;
import jet.server.jrc.quartz.JRRepeatQuartzTrigger;
import jet.server.jrc.quartz.JRTimeQuartzTrigger;
import jet.server.jrc.quartz.JRTrigger;
import jet.server.log.ServiceLogger;
import jet.server.schedule.Int;
import jet.server.schedule.RepeatLaunchableObj;
import jet.server.schedule.TimeLaunchableObj;
import jet.server.schedule.TriggerLaunchableObj;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.JRTask;
import jet.server.schedule.jrtasks.PublishRptTask;
import jet.server.schedule.jrtasks.RunRptTaskRoot;
import jet.server.util.WebSecurityUtil;
import jet.util.AsciiProperties;
import jet.util.TempFile;
import jet.util.WildcardMatcher;

public class SchdTools {
    public static SecureRandom random = new SecureRandom();
    public static boolean dbg = true;
    public static long TIMEOUT = ServerEnv.getResultLife() * 1000L;
    public static String TEMP_FILE_PREF = "T_";
    public static String TEMP_FILE_SUFF = ".temp";
    public static String TEMP_PATH = "temp";
    public static String HTML_REF_PREFIX = "html_ref_prefix";
    public static Hashtable idTable = new Hashtable();
    static Date lastTime = new Date();
    private static final String[] C = new String[]{"jrs.launch_type", "jrs.timezone", "jrs.exe_year", "jrs.exe_month", "jrs.exe_day", "jrs.exe_hour", "jrs.exe_min", "jrs.exe_sec", "jrs.cease_year", "jrs.cease_month", "jrs.cease_day", "jrs.cease_hour", "jrs.cease_min", "jrs.cease_sec", "jrs.is_after", "jrs.is_before", "jrs.is_between", "jrs.hour", "jrs.min", "jrs.is_pm", "jrs.hour2", "jrs.min2", "jrs.is_pm2", "jrs.is_hourly", "jrs.hours", "jrs.at_min", "jrs.is_minutely", "jrs.minutes", "jrs.days_id", "jrs.is_weekday", "jrs.week", "jrs.weekdays", "jrs.is_day", "jrs.month", "jrs.day", "jrs.weekday"};
    private static Hashtable CompressMail = new Hashtable();

    public static int[] getExeTime(Hashtable hashtable) {
        return SchdTools.getTime(hashtable, true);
    }

    public static int[] getExpireTime(Hashtable hashtable) {
        return SchdTools.getTime(hashtable, false);
    }

    public static int[] getTime(Hashtable hashtable, boolean bl) {
        int[] nArray = new int[]{CSUtil.parseInt((String)hashtable.get(bl ? "jrs.exe_year" : "jrs.exp_year"), 0), CSUtil.parseInt((String)hashtable.get(bl ? "jrs.exe_month" : "jrs.exp_month"), 1) - 1, CSUtil.parseInt((String)hashtable.get(bl ? "jrs.exe_day" : "jrs.exp_day"), 0), CSUtil.parseInt((String)hashtable.get(bl ? "jrs.exe_hour" : "jrs.exp_hour"), 0), CSUtil.parseInt((String)hashtable.get(bl ? "jrs.exe_min" : "jrs.exp_min"), 0), CSUtil.parseInt((String)hashtable.get(bl ? "jrs.exe_sec" : "jrs.exp_sec"), 0)};
        return nArray;
    }

    public static String getTempFileName(String string, String string2, String string3) {
        File file = SchdTools.createTempFile(string, string2, string3);
        if (file != null) {
            return file.getName();
        }
        return null;
    }

    public static File createTempFile(String string, String string2, String string3) {
        File file = null;
        String string4 = WebSecurityUtil.validateFilePathStr(string);
        if (!string4.endsWith(CSUtil.fileSep)) {
            string4 = string4 + CSUtil.fileSep;
        }
        String string5 = string2 = string2 == null ? "" : string2;
        if (!string2.startsWith(SchdTools.getClusterMemberPrefix())) {
            string2 = SchdTools.getClusterMemberPrefix() + string2;
        }
        TempFile tempFile = new TempFile(string4, string2, "temp", true);
        try {
            File file2 = new File(string4);
            if (!file2.exists()) {
                file2.mkdir();
            }
            if ((file = tempFile.createTempFileWithExt(string3)).exists()) {
                file.delete();
            }
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        return file;
    }

    public static void deleteFilesByPrefix(String string, String string2) {
        String string3 = string;
        if (!string3.endsWith(CSUtil.fileSep)) {
            string3 = string3 + CSUtil.fileSep;
        }
        SchdTools.deleteFilesByPrefix(string3 + string2);
    }

    public static void deleteFilesByPrefix(String string) {
        try {
            File file = null;
            String[] stringArray = null;
            file = new File(new File(string).getParent());
            if (file.exists() && file.isDirectory()) {
                stringArray = file.list((FilenameFilter)new WildcardMatcher(CSUtil.getNameWithoutExt(new File(string).getName()) + "*", false));
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(file, stringArray[i]);
                    file2.delete();
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static void deleteFile(String string, String string2) {
        String string3 = string;
        if (!string3.endsWith(CSUtil.fileSep)) {
            string3 = string3 + CSUtil.fileSep;
        }
        SchdTools.deleteFile(string3 + string2);
    }

    public static void deleteFile(String string) {
        File file = new File(SchdTools.C(string));
        file.delete();
    }

    public static long calcDiskSize(File file) {
        File[] fileArray;
        if (!file.isDirectory()) {
            return file.length();
        }
        long l = 0L;
        for (File file2 : fileArray = file.listFiles()) {
            l += SchdTools.calcDiskSize(file2);
        }
        return l;
    }

    private static String C(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == File.separatorChar && i < string.length() - 2 && string.charAt(i + 1) == '.' && string.charAt(i + 2) == '.') {
                i += 2;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static void deleteDir(String string) {
        SchdTools.deleteTempFiles(string);
        new File(string).delete();
    }

    public static void deleteTempFiles(String string) {
        File file = new File(string);
        if (file.exists()) {
            String[] stringArray = file.list();
            int n = stringArray.length;
            String string2 = string;
            if (string2.endsWith(CSUtil.fileSep)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            String string3 = null;
            for (int i = 0; i < n; ++i) {
                string3 = stringArray[i].toLowerCase();
                SchdTools.deleteFile(string2 + CSUtil.fileSep + stringArray[i]);
            }
        }
    }

    public static void deleteTempFilesWithSubFolders(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else {
                String[] stringArray = file.list();
                int n = stringArray.length;
                String string2 = string;
                if (string2.endsWith(CSUtil.fileSep)) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                for (int i = 0; i < n; ++i) {
                    String string3 = string2 + CSUtil.fileSep + stringArray[i];
                    File file2 = new File(string3);
                    if (file2.exists() && file2.isDirectory()) {
                        SchdTools.deleteTempFilesWithSubFolders(string3);
                    }
                    SchdTools.deleteFile(string3);
                }
            }
        }
    }

    public static Vector deleteExpiredFiles(String string) {
        return SchdTools.deleteExpiredFiles(string, new String[]{".class"});
    }

    public static Vector deleteExpiredFiles(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        if (string == null) {
            return vector;
        }
        File file = WebSecurityUtil.validateFilePath(string);
        if (file != null && file.exists()) {
            class Filter1
            implements FileFilter {
                HashSet ignoreTypes = null;
                long _TIMEOUT = TIMEOUT;

                public Filter1(String[] stringArray) {
                    this.ignoreTypes = new HashSet();
                    if (stringArray != null) {
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            this.ignoreTypes.add(stringArray[i]);
                        }
                    }
                    this._TIMEOUT = ServerEnv.getResultLife() * 1000L;
                }

                @Override
                public boolean accept(File file) {
                    return file.isFile() && !this.ignoreTypes.contains(CSUtil.getExtName(file.getName())) && System.currentTimeMillis() - file.lastModified() > this._TIMEOUT;
                }
            }
            File[] fileArray = file.listFiles(new Filter1(stringArray));
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    fileArray[i].delete();
                    vector.add(fileArray[i].getName());
                }
                fileArray = null;
            }
            file = null;
        }
        return vector;
    }

    public static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        if (throwable != null) {
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    public static String getClusterMemberPrefix() {
        if (ClusterEnv.isClusterEnabled()) {
            return ClusterEnv.getMemberID() + "$";
        }
        return "";
    }

    public static String escapeFileName(String string) {
        return string == null ? null : string.replaceAll("[/?*|<>:\"\\\\`!&()']", "_");
    }

    public static String getTempFilePrefix() {
        int n = random.nextInt();
        if (n == Integer.MIN_VALUE) {
            ++n;
        }
        return SchdTools.getClusterMemberPrefix() + String.valueOf(Math.abs(n));
    }

    public static synchronized String getIdBase() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        if (timestamp.getTime() - lastTime.getTime() > 1000L) {
            idTable.clear();
        }
        lastTime = timestamp;
        Int intVal = (Int)idTable.get(timestamp);
        if (intVal == null) {
            idTable.put(timestamp, new Int(0));
        } else {
            ++intVal.val;
        }
        return SchdTools.getClusterMemberPrefix() + timestamp.toString() + (intVal == null ? "" : "-" + intVal.val);
    }

    public static int getIntValueOfKey(Hashtable hashtable, String string, int n) {
        int n2 = n;
        String string2 = (String)hashtable.get(string);
        if (string2 != null) {
            try {
                n2 = CSUtil.parseInt(string2);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsciiProperties saveMailConfig(Properties properties) throws Exception {
        Class<SchdTools> clazz = SchdTools.class;
        synchronized (SchdTools.class) {
            File file = new File(ReportEnv.binPath + "mailconfig.properties");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            AsciiProperties asciiProperties = AsciiProperties.create((Properties)properties);
            if (asciiProperties == null) {
                asciiProperties = new AsciiProperties();
                if (mailconfig.SMTPServerIP != null) {
                    asciiProperties.put((Object)"smtp.server", (Object)mailconfig.SMTPServerIP);
                }
                if (mailconfig.MyMailAddress != null) {
                    asciiProperties.put((Object)"mailbox", (Object)mailconfig.MyMailAddress);
                }
                asciiProperties.put((Object)"smtp.server.port", (Object)String.valueOf(mailconfig.SMTPServerPort));
                asciiProperties.put((Object)"default.format", (Object)String.valueOf(mailconfig.defaultIndex));
                asciiProperties.put((Object)"compress.mail", (Object)String.valueOf(mailconfig.CompressMail));
                asciiProperties.put((Object)"Tag_MaxMailSize", (Object)String.valueOf(mailconfig.maxMailSize));
                asciiProperties.put((Object)"Tag_MaxMailPage", (Object)String.valueOf(-1));
                asciiProperties.put((Object)"Tag_SplitBy", (Object)String.valueOf(0));
            }
            asciiProperties.store((OutputStream)fileOutputStream, null);
            fileOutputStream.close();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return asciiProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMailConfig(Properties properties) throws Exception {
        Class<SchdTools> clazz = SchdTools.class;
        synchronized (SchdTools.class) {
            if (properties != null) {
                int n;
                String string = properties.getProperty("smtp.server");
                if (string != null) {
                    mailconfig.SMTPServerIP = string;
                }
                if ((string = properties.getProperty("mailbox")) != null) {
                    mailconfig.MyMailAddress = string;
                }
                mailconfig.SMTPServerPort = n = CSUtil.parseInt(properties.getProperty("smtp.server.port"), mailconfig.SMTPServerPort);
                n = CSUtil.parseInt(properties.getProperty("default.format"), mailconfig.defaultIndex);
                mailconfig.DefaultFormat = mailconfig.getTrueFormat((int)n);
                mailconfig.CompressMail = CSUtil.getBoolean(properties.getProperty("compress.mail"), mailconfig.CompressMail);
                int n2 = CSUtil.parseInt(properties.getProperty("Tag_MaxMailSize"), mailconfig.maxMailSize);
                int n3 = CSUtil.parseInt(properties.getProperty("Tag_MaxMailPage"), -1);
                int n4 = CSUtil.parseInt(properties.getProperty("Tag_SplitBy"), 0);
                if (n4 == 0) {
                    mailconfig.maxMailSize = n2;
                    mailconfig.maxMailPage = -1;
                } else if (n4 == 1) {
                    mailconfig.maxMailPage = n3;
                    mailconfig.maxMailSize = -1;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Properties loadMailConfig() throws Exception {
        File file = new File(ReportEnv.binPath + "mailconfig.properties");
        AsciiProperties asciiProperties = null;
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            asciiProperties = new AsciiProperties();
            asciiProperties.load((InputStream)fileInputStream);
            fileInputStream.close();
        } else {
            asciiProperties = SchdTools.saveMailConfig(asciiProperties);
        }
        return asciiProperties;
    }

    public static String copyFile(File file, File file2) {
        String string;
        block9: {
            if (file.equals(file2)) {
                return null;
            }
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            string = null;
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[131072];
                while ((n = fileInputStream.read(byArray)) >= 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                fileInputStream.close();
                fileOutputStream.close();
            }
            catch (Throwable throwable) {
                string = throwable.getMessage();
                ServiceLogger.logError(throwable);
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        ServiceLogger.logError(throwable2);
                    }
                }
                if (fileOutputStream == null) break block9;
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable3) {
                    ServiceLogger.logError(throwable3);
                }
            }
        }
        return string;
    }

    public static void copyFilesByPrefix(String string, String string2, String string3, String string4) throws Exception {
        String string5 = string3 + string4;
        int n = string2.length();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        try {
            String string6;
            int n2;
            File file = new File(string);
            PrefixFilenameFilter prefixFilenameFilter = new PrefixFilenameFilter(string2 + ".");
            String[] stringArray = file.list(prefixFilenameFilter);
            int n3 = stringArray.length;
            if (n3 > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    string6 = string5 + stringArray[n2].substring(n);
                    SchdTools.copyFile(new File(string + stringArray[n2]), new File(string6));
                }
            }
            if ((n3 = (stringArray = file.list(prefixFilenameFilter = new PrefixFilenameFilter(string2 + "_"))).length) > 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    string6 = string5 + stringArray[n2].substring(n);
                    SchdTools.copyFile(new File(string + stringArray[n2]), new File(string6));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public static void copyFile2(File file, File file2, boolean bl) throws IOException {
        if (file == null || file2 == null || !file.exists() || file.equals(file2)) {
            return;
        }
        if (file.isDirectory()) {
            file2.mkdirs();
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    if (file3.isFile()) {
                        SchdTools.copyFile(file3, new File(file2, file3.getName()));
                        continue;
                    }
                    if (!bl || !file3.isDirectory()) continue;
                    SchdTools.copyFile2(file3, new File(file2, file3.getName()), bl);
                }
            }
        } else if (file.isFile()) {
            file2.getParentFile().mkdirs();
            SchdTools.copyFile(file, file2);
        }
    }

    public static void replaceStringInFile(String string, String string2, String string3) {
        block17: {
            FileInputStream fileInputStream = null;
            FileOutputStream fileOutputStream = null;
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            try {
                int n;
                File file2 = new File(string + ".new");
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[4096];
                StringBuffer stringBuffer = new StringBuffer("");
                String string4 = "";
                boolean bl = false;
                int n2 = string2.length();
                while ((n = fileInputStream.read(byArray)) > 0) {
                    int n3;
                    stringBuffer.setLength(0);
                    String string5 = new String(byArray, 0, n);
                    int n4 = 0;
                    if (bl) {
                        n3 = string4.length();
                        if (string4.equals(string5.substring(0, n3))) {
                            stringBuffer = stringBuffer.append(string3);
                            n4 = n3;
                        }
                        bl = false;
                    }
                    boolean bl2 = true;
                    while (bl2) {
                        int n5 = string5.indexOf(string2, n4);
                        if (n5 == -1) {
                            if (n - n2 > n4) {
                                string4 = string5.substring(n - n2);
                                stringBuffer = stringBuffer.append(string5.substring(n4, n - n2));
                            } else {
                                string4 = string5.substring(n4);
                            }
                            for (int i = n3 = string4.length(); i > 0; --i) {
                                if (!string2.substring(0, i).equals(string4.substring(n3 - i))) continue;
                                bl = true;
                                stringBuffer = stringBuffer.append(string4.substring(0, n3 - i));
                                string4 = string2.substring(i);
                                break;
                            }
                            if (!bl) {
                                stringBuffer = stringBuffer.append(string4);
                            }
                            bl2 = false;
                            continue;
                        }
                        stringBuffer = stringBuffer.append(string5.substring(n4, n5));
                        stringBuffer = stringBuffer.append(string3);
                        n4 = n5 + n2;
                        if (n4 != n) continue;
                        bl2 = false;
                    }
                    int n6 = stringBuffer.length();
                    byte[] byArray2 = new byte[n6];
                    byArray2 = stringBuffer.toString().getBytes();
                    fileOutputStream.write(byArray2, 0, n6);
                    Arrays.fill(byArray, (byte)0);
                }
                fileInputStream.close();
                fileOutputStream.close();
                file.delete();
                file2.renameTo(file);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        ServiceLogger.logError(throwable2);
                    }
                }
                if (fileOutputStream == null) break block17;
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable3) {
                    ServiceLogger.logError(throwable3);
                }
            }
        }
    }

    public static Properties toProperties(TimeLaunchableObj timeLaunchableObj) {
        Properties properties = (Properties)timeLaunchableObj.getTask().clone();
        if (properties == null) {
            return null;
        }
        properties.put("jrs.task_id", timeLaunchableObj.getTaskId());
        if (timeLaunchableObj instanceof RepeatLaunchableObj) {
            RepeatLaunchableObj repeatLaunchableObj = (RepeatLaunchableObj)timeLaunchableObj;
            properties = repeatLaunchableObj.toProperties(properties);
            String string = repeatLaunchableObj.getGC().getTimeZone().getID();
            properties.put("jrs.next_exe_time", String.valueOf(repeatLaunchableObj.getExeTime()));
            if (repeatLaunchableObj.getLastExeTime() > 0L) {
                properties.put("jrs.last_exe_time", String.valueOf(repeatLaunchableObj.getLastExeTime()));
            } else {
                properties.put("jrs.last_exe_time", "");
                properties.put("jrs.last_exe_stat", "");
            }
        } else if (timeLaunchableObj instanceof TriggerLaunchableObj) {
            TriggerLaunchableObj triggerLaunchableObj = (TriggerLaunchableObj)timeLaunchableObj;
            properties = triggerLaunchableObj.toProperties(properties);
            properties.put("jrs.next_exe_time", String.valueOf(triggerLaunchableObj.getExeTime()));
            long l = triggerLaunchableObj.getLastExeTime();
            if (l > 0L) {
                properties.put("jrs.last_exe_time", String.valueOf(l));
            } else {
                properties.put("jrs.last_exe_time", "");
                properties.put("jrs.last_exe_stat", "");
            }
        } else {
            properties = timeLaunchableObj.toProperties(properties);
            properties.put("jrs.next_exe_time", String.valueOf(timeLaunchableObj.getExeTime()));
            properties.put("jrs.last_exe_time", "");
            properties.put("jrs.last_exe_stat", "");
        }
        properties.put("jrs.report_names", JRTUtil.parseSheetDisplayNames(properties));
        return properties;
    }

    public static Properties toProperties(JRTrigger jRTrigger) {
        Properties properties = (Properties)jRTrigger.getTask().clone();
        if (properties == null) {
            return null;
        }
        properties.put("jrs.task_id", jRTrigger.getTaskID());
        properties.put("jrs.is_successful", String.valueOf(jRTrigger.getLastSuccessful()));
        if (jRTrigger instanceof JRRepeatQuartzTrigger) {
            JRRepeatQuartzTrigger jRRepeatQuartzTrigger = (JRRepeatQuartzTrigger)jRTrigger;
            properties = jRRepeatQuartzTrigger.toProperties(properties);
            Date date = jRRepeatQuartzTrigger.getNextFireTime();
            if (null != date) {
                properties.put("jrs.next_exe_time", String.valueOf(date.getTime()));
            } else {
                properties.put("jrs.next_exe_time", "");
            }
            properties.put("jrs.last_exe_time", String.valueOf(jRRepeatQuartzTrigger.getLastExeTime()));
        } else if (jRTrigger instanceof JRTimeQuartzTrigger) {
            Object object;
            JRTimeQuartzTrigger jRTimeQuartzTrigger = (JRTimeQuartzTrigger)jRTrigger;
            properties = jRTimeQuartzTrigger.toProperties(properties);
            if (!(jRTrigger instanceof JRBasicTrigger)) {
                object = jRTimeQuartzTrigger.getNextFireTime();
                Date date = new Date(399, 11, 31, 23, 59, 59);
                if (null != object && ((Date)object).before(date)) {
                    properties.put("jrs.next_exe_time", String.valueOf(((Date)object).getTime()));
                } else {
                    properties.put("jrs.next_exe_time", "");
                }
            }
            if (jRTrigger instanceof JRBasicTrigger) {
                object = (JRBasicTrigger)jRTrigger;
                properties.put("jrs.launch_type", String.valueOf(0));
                properties.put("jrs.last_exe_time", String.valueOf(((JRTimeQuartzTrigger)((Object)object)).getLastExeTime()));
            } else {
                object = jRTimeQuartzTrigger.getPreviousFireTime();
                if (null != object && ((Date)object).getTime() > 0L) {
                    properties.put("jrs.last_exe_time", String.valueOf(jRTimeQuartzTrigger.getLastExeTime()));
                } else {
                    properties.put("jrs.last_exe_time", "");
                    properties.put("jrs.last_exe_stat", "");
                }
            }
        }
        properties.put("jrs.report_names", JRTUtil.parseSheetDisplayNames(properties));
        return properties;
    }

    public static void removeUnusedTaskProps(Properties properties) {
        String string;
        if (properties == null) {
            return;
        }
        properties.remove("Submit_Btn");
        properties.remove("jrs.cmd");
        boolean bl = CSUtil.getBoolean((String)properties.get("jrs.has_nonbursting_result"), false);
        boolean bl2 = CSUtil.getBoolean(properties.getProperty("jrs.is_bursting_task"), false);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.startsWith("jrs.nonbursting$") || bl2 && bl) continue;
            properties.remove(string);
        }
        string = (String)properties.get("jrs.notification_emails");
        Vector vector = CSMail.parseMails(string);
        if (vector == null) {
            properties.remove("jrs.notification_emails");
        }
        SchdTools.CompressMail(properties, "");
        if (bl) {
            SchdTools.CompressMail(properties, "jrs.nonbursting$");
        }
    }

    private static void CompressMail(Properties properties, String string) {
        properties.remove(string + "jrs.ftpRst");
        properties.remove(string + "jrs.ftpHtml");
        properties.remove(string + "jrs.ftpPdf");
        properties.remove(string + "jrs.ftpExl");
        properties.remove(string + "jrs.ftpTxt");
        properties.remove(string + "jrs.ftpRtf");
        properties.remove(string + "jrs.ftpXml");
        properties.remove(string + "jrs.ftpPs");
        properties.remove(string + "jrs.ftpRstPcs");
        properties.remove(string + "jrs.ftpHtmPcs");
        properties.remove(string + "jrs.ftpPdfPcs");
        properties.remove(string + "jrs.ftpExlPcs");
        properties.remove(string + "jrs.ftpTxtPcs");
        properties.remove(string + "jrs.ftpRtfPcs");
        properties.remove(string + "jrs.ftpXmlPcs");
        properties.remove(string + "jrs.ftpPsPcs");
        properties.remove(string + "jrs.ftpHost");
        properties.remove(string + "jrs.ftpPort");
        properties.remove(string + "jrs.ftpUn");
        properties.remove(string + "jrs.ftpPsd");
        properties.remove(string + "jrs.ftpAcct");
        properties.remove(string + "jrs.ftpLbl");
        properties.remove(string + "jrs.ftpProt");
        properties.remove(string + "jrs.ftpHdlCls");
        properties.remove(string + "jrs.ftpLoc");
        properties.remove(string + "jrs.ftpRstFn");
        properties.remove(string + "jrs.ftpZipRst");
        properties.remove(string + "jrs.ftpHtmlFn");
        properties.remove(string + "jrs.ftpHtmNoM");
        properties.remove(string + "jrs.ftpHtmMF");
        properties.remove(string + "jrs.ftpHtmEC");
        properties.remove(string + "jrs.ftpHtmHL");
        properties.remove(string + "jrs.ftpHtmPN");
        properties.remove(string + "jrs.ftpHtmRFS");
        properties.remove(string + "jrs.ftpHtmDD");
        properties.remove(string + "jrs.ftpHtmUSO");
        properties.remove(string + "jrs.ftpHtmUHT");
        properties.remove(string + "jrs.ftpHtmUS");
        properties.remove(string + "jrs.ftpHtmICA");
        properties.remove(string + "jrs.ftpHtmFC");
        properties.remove(string + "jrs.ftpHtmRsl");
        properties.remove(string + "jrs.ftpHtmWB");
        properties.remove(string + "jrs.ftpHtmTO");
        properties.remove(string + "jrs.ftpIsDht");
        properties.remove(string + "jrs.ftpPdfFn");
        properties.remove(string + "jrs.ftpPdfNoM");
        properties.remove(string + "jrs.ftpPdfIsC");
        properties.remove(string + "jrs.ftpPdfCIm");
        properties.remove(string + "jrs.ftpPdfPM");
        properties.remove(string + "jrs.ftpPdfToc");
        properties.remove(string + "jrs.ftpPdfDD");
        properties.remove(string + "jrs.ftpPdfEcr");
        properties.remove(string + "jrs.ftpPdfCmp");
        properties.remove(string + "jrs.ftpPdfPwd");
        properties.remove(string + "jrs.ftpPdfPmP");
        properties.remove(string + "jrs.ftpPdfPrt");
        properties.remove(string + "jrs.ftpPdfChg");
        properties.remove(string + "jrs.ftpPdfECp");
        properties.remove(string + "jrs.ftpPdfEAc");
        properties.remove(string + "jrs.ftpPdfSgn");
        properties.remove(string + "jrs.ftpPdfSM");
        properties.remove(string + "jrs.ftpPdfDP");
        properties.remove(string + "jrs.ftpPdfPsw");
        properties.remove(string + "jrs.ftpPdfDR");
        properties.remove(string + "jrs.ftpPdfEdt");
        properties.remove(string + "jrs.ftpPdfLoc");
        properties.remove(string + "jrs.ftpPdfCnt");
        properties.remove(string + "jrs.ftpPdfGTp");
        properties.remove(string + "jrs.ftpExlFn");
        properties.remove(string + "jrs.ftpExlWW");
        properties.remove(string + "jrs.ftpExl2k");
        properties.remove(string + "jrs.ftpExlLyt");
        properties.remove(string + "jrs.ftpExlHS");
        properties.remove(string + "jrs.ftpExlAdv");
        properties.remove(string + "jrs.ftpExlPrH");
        properties.remove(string + "jrs.ftpExlPrF");
        properties.remove(string + "jrs.ftpExlPGL");
        properties.remove(string + "jrs.ftpTxtFn");
        properties.remove(string + "jrs.ftpTxtNrm");
        properties.remove(string + "jrs.ftpTxtQM");
        properties.remove(string + "jrs.ftpTxtIDl");
        properties.remove(string + "jrs.ftpTxtDlm");
        properties.remove(string + "jrs.ftpTxtTab");
        properties.remove(string + "jrs.ftpTxtCsv");
        properties.remove(string + "jrs.ftpTxtCmp");
        properties.remove(string + "jrs.ftpTxtChW");
        properties.remove(string + "jrs.ftpTxtChH");
        properties.remove(string + "jrs.ftpTxtHF");
        properties.remove(string + "jrs.ftpTxtWin");
        properties.remove(string + "jrs.ftpTxtRpt");
        properties.remove(string + "jrs.ftpTxtRes");
        properties.remove(string + "jrs.ftpRtfFn");
        properties.remove(string + "jrs.ftpRtfBE");
        properties.remove(string + "jrs.ftpRtfNoM");
        properties.remove(string + "jrs.ftpXmlFn");
        properties.remove(string + "jrs.ftpXmlIOD");
        properties.remove(string + "jrs.ftpXmlXsd");
        properties.remove(string + "jrs.ftpPsFn");
        properties.remove(string + "jrs.ftpPsNoM");
        properties.remove(string + "jrs.ftp_end");
        properties.remove(string + "jrs.ftpsConType");
        properties.remove(string + "jrs.ftpsTransMode");
        properties.remove(string + "jrs.ftpsSecProt");
        properties.remove(string + "jrs.ftpsEnNoSec");
        properties.remove(string + "jrs.ftpsKSType");
        properties.remove(string + "jrs.ftpsKSFile");
        properties.remove(string + "jrs.ftpsKSPsd");
        properties.remove(string + "jrs.ftpsKMAlg");
        properties.remove(string + "jrs.ftpsTSType");
        properties.remove(string + "jrs.ftpsTSFile");
        properties.remove(string + "jrs.ftpsTSPsd");
        properties.remove(string + "jrs.ftpsTMAlg");
    }

    public static void removeScheduleProps(Properties properties) {
        if (properties == null) {
            return;
        }
        properties.remove("jrs.launch_type");
        properties.remove("jrs.exe_year");
        properties.remove("jrs.exe_month");
        properties.remove("jrs.exe_day");
        properties.remove("jrs.exe_hour");
        properties.remove("jrs.exe_min");
        properties.remove("jrs.exe_sec");
        properties.remove("jrs.timezone");
        properties.remove("jrs.is_enabled");
        properties.remove("jrs.ileie");
        properties.remove("jrs.exe_date");
        properties.remove("jrs.at_min");
        properties.remove("jrs.cease_year");
        properties.remove("jrs.cease_month");
        properties.remove("jrs.cease_day");
        properties.remove("jrs.cease_hour");
        properties.remove("jrs.cease_min");
        properties.remove("jrs.day");
        properties.remove("jrs.days_id");
        properties.remove("jrs.hour");
        properties.remove("jrs.hours");
        properties.remove("jrs.hour2");
        properties.remove("jrs.is_after");
        properties.remove("jrs.is_before");
        properties.remove("jrs.is_between");
        properties.remove("jrs.is_day");
        properties.remove("jrs.is_hourly");
        properties.remove("jrs.is_minutely");
        properties.remove("jrs.is_pm");
        properties.remove("jrs.is_pm2");
        properties.remove("jrs.is_weekday");
        properties.remove("jrs.minutes");
        properties.remove("jrs.min");
        properties.remove("jrs.min2");
        properties.remove("jrs.month");
        properties.remove("jrs.week");
        properties.remove("jrs.weekday");
        properties.remove("jrs.weekdays");
        properties.remove("jrs.after_day");
        properties.remove("jrs.after_hour");
        properties.remove("jrs.after_minute");
        properties.remove("jrs.before_day");
        properties.remove("jrs.before_hour");
        properties.remove("jrs.before_minute");
        properties.remove("jrs.after_apm");
        properties.remove("jrs.before_apm");
        properties.remove("jrs.once_apm");
        properties.remove("jrs.upd_apm");
        properties.remove("jrs.btw_apm1");
        properties.remove("jrs.btw_apm2");
        properties.remove("jrs.sch_days");
        properties.remove("jrs.sch_weeks");
        properties.remove("jrs.sch_months1");
        properties.remove("jrs.sch_months2");
        properties.remove("jrs.which_week");
        properties.remove("jrs.which_weekday");
        properties.remove("jrs.btw_h1");
        properties.remove("jrs.btw_m1");
        properties.remove("jrs.wkd0");
        properties.remove("jrs.wkd1");
        properties.remove("jrs.wkd2");
        properties.remove("jrs.wkd3");
        properties.remove("jrs.wkd4");
        properties.remove("jrs.wkd5");
        properties.remove("jrs.wkd6");
    }

    public static String getCronAtExpression(Properties properties, int n) {
        if (properties == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = C.length;
        if (1 == n) {
            n2 = 8;
        }
        for (int i = 0; i < n2; ++i) {
            String string = C[i];
            String string2 = properties.getProperty(string);
            if (string2 == null || string2.trim().length() <= 0) continue;
            stringBuffer.append(string).append("=").append(string2).append("\r\n");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties saveFaxConfig(Properties properties) throws Exception {
        Class<SchdTools> clazz = SchdTools.class;
        synchronized (SchdTools.class) {
            String string;
            File file = new File(ReportEnv.binPath + "faxconfig.properties");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            if (properties == null) {
                properties = new Properties();
            }
            if ((string = (String)properties.get("dialing")) == null) {
                properties.put("dialing", "0");
            }
            if ((string = (String)properties.get("flow_command")) == null) {
                properties.put("flow_command", "0");
            }
            if ((string = (String)properties.get("flow_control")) == null) {
                properties.put("flow_control", "0");
            }
            if ((string = (String)properties.get("max_retries")) == null) {
                properties.put("max_retries", "3");
            }
            if ((string = (String)properties.get("modem_class")) == null) {
                properties.put("modem_class", "0");
            }
            if ((string = (String)properties.get("time_out")) == null) {
                properties.put("time_out", "59");
            }
            if ((string = (String)properties.get("init_string")) == null) {
                properties.put("init_string", "");
            }
            if ((string = (String)properties.get("port")) == null) {
                properties.put("port", "");
            }
            if ((string = (String)properties.get("via_fax_server")) == null) {
                properties.put("via_fax_server", "false");
            }
            if ((string = (String)properties.get("server_ip")) == null) {
                properties.put("server_ip", "");
            }
            if ((string = (String)properties.get("server_port")) == null) {
                properties.put("server_port", "");
            }
            if ((string = (String)properties.get("user_id")) == null) {
                properties.put("user_id", "");
            }
            if ((string = (String)properties.get("password")) == null) {
                properties.put("password", "");
            }
            if ((string = (String)properties.get("user_name")) == null) {
                properties.put("user_name", "");
            }
            if ((string = (String)properties.get("special_parameters")) == null) {
                properties.put("special_parameters", "");
            }
            properties.store(fileOutputStream, null);
            fileOutputStream.close();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return properties;
        }
    }

    public static Properties loadFaxConfig() throws Exception {
        File file = new File(ReportEnv.binPath + "faxconfig.properties");
        Properties properties = null;
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
        } else {
            properties = SchdTools.saveFaxConfig(properties);
        }
        return properties;
    }

    public static Properties loadPrecisionConfig(Properties properties) {
        try {
            File file = new File(ReportEnv.binPath + "precisionconfig.properties");
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return properties;
    }

    public static synchronized void savePrecisionConfig(Properties properties) throws Exception {
        File file = new File(ReportEnv.binPath + "precisionconfig.properties");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, "The precision mapping(format=precisionLevel)");
        fileOutputStream.close();
    }

    public static Properties loadBinProperties(String string) throws Exception {
        Properties properties = new Properties();
        File file = new File(ReportEnv.binPath + string);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mkdirs(String string) throws IOException {
        IntMonitor intMonitor;
        if (new File(string).exists()) {
            return true;
        }
        Hashtable hashtable = CompressMail;
        synchronized (hashtable) {
            intMonitor = !CompressMail.containsKey(string) ? new IntMonitor() : (IntMonitor)CompressMail.get(string);
            intMonitor.increase();
            CompressMail.put(string, intMonitor);
        }
        boolean bl = true;
        Object object = intMonitor;
        synchronized (object) {
            File file = new File(string);
            if (!file.exists()) {
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    bl = SchdTools.mkdirs(file2.getAbsolutePath());
                }
                bl = file.mkdir();
            }
        }
        object = CompressMail;
        synchronized (object) {
            intMonitor.decrease();
            if (intMonitor.isZero()) {
                CompressMail.remove(string);
            }
        }
        return bl;
    }

    public static synchronized void saveBinProperties(Properties properties, String string) throws Exception {
        File file = new File(ReportEnv.binPath + string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, null);
        fileOutputStream.close();
    }

    public static String getSortedScript(TimeLaunchableObj timeLaunchableObj) {
        Properties properties = SchdTools.toProperties(timeLaunchableObj);
        if (properties == null) {
            properties = new Properties();
        }
        properties.remove("jrs.wait_run_time");
        properties.remove("jrs.remote_addr");
        properties.remove("jrs.request_url");
        properties.remove("jrs.param_file");
        properties.remove("jrs.uid");
        properties.remove("jrs.submit_time");
        properties.remove("jrs.next_exe_time");
        properties.remove("jrs.last_exe_stat");
        properties.remove("jrs.last_exe_time");
        properties.remove("jrs.is_successful");
        properties.remove("jrs.path");
        properties.remove("jrs.version_number");
        properties.remove("jrs.ext_qrybl_id");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CSUtil.LINE).append("<task>").append(CSUtil.LINE).append(CSUtil.LINE);
        stringBuffer.append(JRTask.filterTaskScript(properties, true)).append(CSUtil.LINE);
        if (timeLaunchableObj instanceof RepeatLaunchableObj) {
            stringBuffer.append(RepeatLaunchableObj.filterRepeatLaunchableScriptItems(properties, true)).append(CSUtil.LINE);
        } else {
            stringBuffer.append(TimeLaunchableObj.filterTimeLaunchableScriptItems(properties, true)).append(CSUtil.LINE);
        }
        stringBuffer.append(RunRptTaskRoot.filterReportScript(properties, true)).append(CSUtil.LINE);
        stringBuffer.append(PublishRptTask.filterPublishScript(properties, true)).append(CSUtil.LINE);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = properties.get(object);
            if (object2 == null || !(object2 instanceof String)) continue;
            String string = (String)object2;
            stringBuffer.append((String)object).append("=").append(string).append(CSUtil.LINE);
        }
        stringBuffer.append("</task>");
        return stringBuffer.toString();
    }

    public static String getSortedScript(JRTrigger jRTrigger) {
        Properties properties = SchdTools.toProperties(jRTrigger);
        if (properties == null) {
            properties = new Properties();
        }
        properties.remove("jrs.wait_run_time");
        properties.remove("jrs.remote_addr");
        properties.remove("jrs.request_url");
        properties.remove("jrs.param_file");
        properties.remove("jrs.uid");
        properties.remove("jrs.submit_time");
        properties.remove("jrs.next_exe_time");
        properties.remove("jrs.last_exe_stat");
        properties.remove("jrs.last_exe_time");
        properties.remove("jrs.is_successful");
        properties.remove("jrs.path");
        properties.remove("jrs.version_number");
        properties.remove("jrs.ext_qrybl_id");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CSUtil.LINE).append("<task>").append(CSUtil.LINE).append(CSUtil.LINE);
        String string = JRTask.filterTaskScript(properties, true);
        string = string.replaceAll("<", "&jlt;");
        string = string.replaceAll(">", "&jgt;");
        stringBuffer.append(string).append(CSUtil.LINE);
        if (jRTrigger instanceof JRTimeQuartzTrigger) {
            stringBuffer.append(JRTimeQuartzTrigger.filterTimeQuartzTriggerScriptItems(properties, true)).append(CSUtil.LINE);
        } else {
            stringBuffer.append(JRRepeatQuartzTrigger.filterRepeatQuartzTriggerScriptItems(properties, true)).append(CSUtil.LINE);
        }
        stringBuffer.append(RunRptTaskRoot.filterReportScript(properties, true)).append(CSUtil.LINE);
        stringBuffer.append(PublishRptTask.filterPublishScript(properties, true)).append(CSUtil.LINE);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = properties.get(object);
            if (object2 == null || !(object2 instanceof String)) continue;
            String string2 = (String)object2;
            string2 = string2.replaceAll("<", "&jlt;");
            string2 = string2.replaceAll(">", "&jgt;");
            stringBuffer.append((String)object).append("=").append(string2).append(CSUtil.LINE);
        }
        stringBuffer.append("</task>");
        return stringBuffer.toString();
    }

    private static class IntMonitor {
        int value = 0;

        IntMonitor() {
        }

        void increase() {
            ++this.value;
        }

        void decrease() {
            --this.value;
        }

        boolean isZero() {
            return this.value == 0;
        }
    }
}

