/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import jet.server.api.trigger.Trigger;
import jet.server.api.trigger.TriggerManager;
import jet.server.jrc.quartz.JRBasicTrigger;
import jet.server.jrc.quartz.JRTrigger;
import jet.server.schedule.ScheduledTask;
import jet.server.trigger.ReferencableObj;
import jet.server.trigger.TriggerManagerImpl;
import jet.server.util.StringUtil;

public class ScheduledTaskImpl
implements ScheduledTask,
Serializable {
    public static final String TRIGGERS_ARRAY = "jrs.triggers";
    public static final String TRIGGERS_LOGIC = "jrs.triggers.logic";
    public static final String TRIGGERS_STATE = "jrs.triggers.state";
    private HashMap flags = new HashMap();
    private JRTrigger trigger = null;
    private String timeFlagName = null;
    public static final String OP_ONLY = "ONLY";
    public static final String OP_OR = "OR";
    public static final String OP_AND = "AND";
    public static final String OP_AND2 = "AND2";
    public static final String TIME_FLAG = "CRONAT_";

    public ScheduledTaskImpl(JRTrigger jRTrigger) {
        this.trigger = jRTrigger;
        this.timeFlagName = this.append();
        this.SEDU(this.getTaskDetail());
        if (jRTrigger instanceof JRBasicTrigger) {
            this.setFlag(this.getTimeFlagName(), null);
        }
    }

    @Override
    public final void setFlag(String string, Object object) {
        Flag flag = (Flag)this.flags.get(string);
        if (flag != null) {
            flag.set();
            if (object != null) {
                this.getTaskDetail().put("TRGDATA_" + string, object);
            }
        }
        this.clear();
    }

    @Override
    public final void resetAllFlags() {
        Iterator iterator = this.flags.values().iterator();
        Properties properties = this.getTaskDetail();
        while (iterator.hasNext()) {
            Flag flag = (Flag)iterator.next();
            flag.reset();
            properties.remove("TRGDATA_" + flag.flagName);
        }
        if (this.trigger instanceof JRBasicTrigger) {
            this.setFlag(this.getTimeFlagName(), null);
        }
        this.clear();
    }

    @Override
    public final boolean isReady() {
        String string = this.getTaskDetail().getProperty(TRIGGERS_LOGIC);
        if (string == null || string.trim().length() == 0) {
            string = OP_OR;
            this.getTaskDetail().setProperty(TRIGGERS_LOGIC, string);
        }
        if (OP_ONLY.equals(string)) {
            for (Flag flag : this.flags.values()) {
                if (!flag.isReady()) continue;
                return true;
            }
            return false;
        }
        if (OP_OR.equals(string)) {
            for (Flag flag : this.flags.values()) {
                if (!flag.isReady()) continue;
                return true;
            }
            return false;
        }
        if (OP_AND.equals(string)) {
            for (Flag flag : this.flags.values()) {
                if (flag.isReady()) continue;
                return false;
            }
            return true;
        }
        if (OP_AND2.equals(string)) {
            Flag flag2;
            boolean bl = true;
            for (Flag flag2 : this.flags.values()) {
                if (flag2.isReady()) continue;
                bl = false;
                break;
            }
            if (!bl && (flag2 = (Flag)this.flags.get(this.getTimeFlagName())).isReady()) {
                flag2.reset();
            }
            return bl;
        }
        return false;
    }

    @Override
    public final Set getAllFlagsName() {
        return this.flags.keySet();
    }

    @Override
    public final String getTaskId() {
        return null == this.trigger ? null : this.trigger.getTaskID();
    }

    @Override
    public final void setEnabled(boolean bl) {
        if (null != this.trigger) {
            this.trigger.setEnable(bl);
        }
    }

    @Override
    public final boolean isEnabled() {
        return null == this.trigger ? false : this.trigger.isEnable();
    }

    @Override
    public final Properties getTaskDetail() {
        return this.trigger.getTask();
    }

    protected String getTimeFlagName() {
        return this.timeFlagName;
    }

    @Override
    public JRTrigger getJRTrigger() {
        return this.trigger;
    }

    @Override
    public void setJRTrigger(JRTrigger jRTrigger) {
        this.trigger = jRTrigger;
    }

    @Override
    public HashMap getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(HashMap hashMap) {
        this.flags = hashMap;
    }

    protected void finalize() throws Throwable {
        this.flags.clear();
        this.flags = null;
        this.trigger = null;
        super.finalize();
    }

    private void SEDU(Properties properties) {
        String[] stringArray;
        TriggerManager triggerManager = TriggerManagerImpl.getInstance();
        String string = properties.getProperty(TRIGGERS_ARRAY);
        if (string != null && string.trim().length() > 0) {
            stringArray = StringUtil.split(string, ",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = Integer.parseInt(properties.getProperty("jrs.triggers.state$" + string2, "0"));
                Trigger trigger = null;
                trigger = triggerManager.getTrigger(string2);
                if (trigger == null) continue;
                ((ReferencableObj)((Object)trigger)).incRef();
                ((TriggerManagerImpl)triggerManager).getTriggersMap().put(string2, trigger);
                Flag flag = new Flag(string2);
                if (n == 0) {
                    flag.reset();
                } else {
                    flag.set();
                }
                this.flags.put(string2, flag);
            }
        }
        stringArray = new Flag(this.getTimeFlagName());
        this.flags.put(stringArray.flagName, stringArray);
    }

    private String append() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TIME_FLAG).append(Integer.toHexString(this.getTaskId().hashCode()));
        return stringBuffer.toString();
    }

    private void clear() {
        Iterator iterator = this.flags.values().iterator();
        Properties properties = this.getTaskDetail();
        while (iterator.hasNext()) {
            String string;
            Flag flag = (Flag)iterator.next();
            String string2 = flag.flagName;
            String string3 = string = flag.isReady() ? "1" : "0";
            if (string2.startsWith(TIME_FLAG)) continue;
            properties.setProperty("jrs.triggers.state$" + string2, string);
        }
    }

    private static final class Flag
    implements Serializable {
        String flagName;
        boolean isSet = false;

        public Flag(String string) {
            this.flagName = string;
        }

        public synchronized void set() {
            this.isSet = true;
        }

        public synchronized void reset() {
            this.isSet = false;
        }

        public synchronized boolean isReady() {
            return this.isSet;
        }

        public String toString() {
            return this.flagName + ":" + (this.isReady() ? "1" : "0");
        }
    }
}

