/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import com.jinfonet.api.objectmanager.CatalogKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import jet.bean.JREngine;
import jet.bean.ReportInfo;
import jet.cs.CSUtil;
import jet.exception.InvalidParameterException;
import jet.formula.ParamDesc;
import jet.parameter.UserInput;
import jet.reportLogic.objectInfo.bursting.BurstingSchema;
import jet.rptservice.api.ParameterEnv;
import jet.rptservice.api.ParameterEnvAdapter;
import jet.server.ServerEnv;
import jet.server.api.ResourceManager;
import jet.server.api.RptServerException;
import jet.server.api.TaskListener;
import jet.server.api.TaskListenerException;
import jet.server.api.exception.GenerateParameterException;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.param.InvalidParamsException;
import jet.server.jrc.param.ParamDescsUtil;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRParamInfo;
import jet.server.jrserver.JRReportSheetInfo;
import jet.server.log.ServiceLogger;
import jet.server.schedule.JRServerEnv;
import jet.server.schedule.JRServerInfo;
import jet.server.schedule.ParameterManager;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.util.ParamUtil;
import jet.server.util.ServerUtil;
import jet.universe.JetUUniverse;
import jet.util.EngineTools;

public class ReportInfoCache {
    private static Hashtable IsParameters = new Hashtable();
    private static Hashtable ParamValueChanged = new Hashtable();
    private String SEDU;
    private String add;
    private int addElement;
    private String append;
    private String asList;
    private int booleanValue;
    private String canSaveRSD;
    private Hashtable changeParamValue;
    private String checkRange;
    private int clear;
    private String clone;
    private Object[] contains;
    private Vector containsKey;
    private List convertParamValuesToProp;
    private boolean createEngine = false;
    private ParamInfoObj currentTimeMillis = new ParamInfoObj(new ArrayList(), null);
    private ParamInfoObj entrySet = new ParamInfoObj(new ArrayList(), null);
    private boolean equals = false;
    private CatalogKey evalParamValue;
    private JetUUniverse exit;
    private boolean forName;
    private JREngine free;
    private boolean generateParameterValue = false;
    private ParameterEnvAdapter get;
    private List getAllDataSource = new ArrayList();
    private List getAllParameters = new ArrayList();
    private List getAvailableLocales = new ArrayList();
    private List getAvlGroupFields = new ArrayList();
    private long getBoolean = System.currentTimeMillis();

    private ReportInfoCache(String string, String string2, int n, String string3, int n2, JRServerEnv jRServerEnv, Hashtable hashtable) throws Exception {
        try {
            this.SEDU = string;
            this.asList = string2;
            this.booleanValue = n;
            if (string2 != null && string2.length() > 0) {
                this.canSaveRSD = jRServerEnv.getRealPath(string, string2, n);
            }
            this.add = string3;
            this.addElement = n2;
            this.append = jRServerEnv.getRealPath(string, string3, n2);
            this.changeParamValue = hashtable;
            if (hashtable != null) {
                this.checkRange = (String)hashtable.get("jrs.engine_id");
            }
            this.clone = "[uid=" + string + ", cat=" + string2 + ", catVer=" + n + ", rpt=" + string3 + ", rptVer=" + n2 + "]";
            ServiceLogger.logDebug(0x64B644, new Object[]{this.checkRange, this.clone}, 6);
            this.addElement();
            if (!this.generateParameterValue) {
                this.append();
            }
            if (!this.createEngine) {
                this.asList();
            }
            if (!this.generateParameterValue && !this.createEngine) {
                this.booleanValue();
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError("ReportInfoCache::fail to initEngineEnv, trying clear engine...", 3);
            this.canSaveRSD();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
    }

    public static ReportInfoCache getReportInfoCache(String string) {
        ReportInfoCache reportInfoCache = null;
        if (string != null) {
            reportInfoCache = (ReportInfoCache)IsParameters.get(string);
            if (reportInfoCache != null) {
                reportInfoCache.SEDU();
            } else {
                ServiceLogger.logDebug(4600250, string, 4);
            }
        }
        return reportInfoCache;
    }

    public static ReportInfoCache getReportInfoCache(String string, String string2, int n, String string3, int n2, JRServerEnv jRServerEnv, Hashtable hashtable) throws Exception {
        ReportInfoCache reportInfoCache = null;
        String string4 = null;
        if (hashtable != null) {
            string4 = (String)hashtable.get("jrs.engine_id");
        }
        if (string4 != null) {
            reportInfoCache = ReportInfoCache.getReportInfoCache(string4);
        }
        ResourceManager resourceManager = HttpUtil.getHttpRptServer().getResourceManager();
        if (string2 != null && string2.length() > 0) {
            n = n != -1 ? n : resourceManager.getLatestVersionNumber(string2, string);
        }
        int n3 = n2 = n2 != -1 ? n2 : resourceManager.getLatestVersionNumber(string3, string);
        if (reportInfoCache == null || !reportInfoCache.ParamValueChanged(string, string2, n, string3, n2)) {
            if (reportInfoCache != null) {
                ServiceLogger.logDebug(4600251, new Object[]{reportInfoCache.checkRange, reportInfoCache.clone, string, string2, n, string3, n2}, 4);
                ReportInfoCache.removeReportInfoCache(reportInfoCache.getEngineID());
            }
            reportInfoCache = new ReportInfoCache(string, string2, n, string3, n2, jRServerEnv, hashtable);
            IsParameters.put(reportInfoCache.checkRange, reportInfoCache);
        }
        return reportInfoCache;
    }

    public static void removeReportInfoCache(String string) {
        if (string == null) {
            return;
        }
        ReportInfoCache reportInfoCache = (ReportInfoCache)IsParameters.remove(string);
        if (reportInfoCache != null) {
            reportInfoCache.canSaveRSD();
        }
        ServiceLogger.logDebug(6600252, new Object[]{string, IsParameters.size()}, 6);
    }

    public static Vector getCachedParams(String string) {
        if (string == null) {
            return null;
        }
        Vector vector = null;
        Object[] objectArray = (Object[])ParamValueChanged.get(string);
        if (objectArray != null) {
            vector = (Vector)objectArray[0];
            objectArray[1] = System.currentTimeMillis();
        }
        ServiceLogger.logDebug(6600259, new Object[]{string, vector}, 6);
        return vector;
    }

    public static Vector removeCachedParams(String string) {
        if (string == null) {
            return null;
        }
        Vector vector = null;
        Object[] objectArray = (Object[])ParamValueChanged.remove(string);
        if (objectArray != null) {
            vector = (Vector)objectArray[0];
        }
        ServiceLogger.logDebug(6600272, new Object[]{string, ParamValueChanged.size(), vector}, 6);
        return vector;
    }

    private static void IsParameters(String string, Vector vector) {
        if (string == null || vector == null) {
            return;
        }
        for (ParamDesc paramDesc : vector) {
            paramDesc.getParameterRuntime().setValueListFetcher(null, null);
        }
        ParamValueChanged.put(string, new Object[]{vector, System.currentTimeMillis()});
    }

    public static void removeExpiredCacheInfo() throws Exception {
        Object[] objectArray;
        String string;
        ServiceLogger.logDebug(6600253, new Object[]{IsParameters.size(), ParamValueChanged.size()}, 6);
        long l = ServerEnv.getResultLife() * 1000L;
        long l2 = System.currentTimeMillis();
        Enumeration enumeration = IsParameters.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            objectArray = (Object[])IsParameters.get(string);
            if (l2 - objectArray.add() <= l) continue;
            ReportInfoCache.removeReportInfoCache(string);
        }
        enumeration = ParamValueChanged.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            objectArray = (Object[])ParamValueChanged.get(string);
            if (l2 - (Long)objectArray[1] <= l) continue;
            ReportInfoCache.removeCachedParams(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateParameter(String string, int n, JRServerEnv jRServerEnv, Properties properties, TaskListener taskListener, JRServerInfo jRServerInfo) throws InvalidParameterException, Exception {
        String string2;
        block7: {
            properties.put("jrs.time_base_line", "" + System.currentTimeMillis());
            ServiceLogger.logDebug(6600254, new Object[]{string}, 6);
            string2 = null;
            try {
                String string3 = properties.getProperty("jrs.uid");
                String string4 = properties.getProperty("jrs.catalog");
                int n2 = CSUtil.parseInt(properties.getProperty("jrs.cat_version"), -1);
                String string5 = properties.getProperty("jrs.report");
                int n3 = CSUtil.parseInt(properties.getProperty("jrs.rpt_version"), -1);
                if (string != null) {
                    properties.put("jrs.engine_id", string);
                }
                ReportInfoCache reportInfoCache = ReportInfoCache.getReportInfoCache(string3, string4, n2, string5, n3, jRServerEnv, properties);
                string2 = reportInfoCache.getEngineID();
                Vector vector = reportInfoCache.entrySet(n, properties, taskListener, jRServerInfo);
                if (vector == null || vector.size() == 0) {
                    ReportInfoCache.removeCachedParams(reportInfoCache.getEngineID());
                } else {
                    ReportInfoCache.IsParameters(reportInfoCache.getEngineID(), vector);
                }
                int n4 = CSUtil.parseInt((String)properties.get("jrs.result_type"), 0);
                boolean bl = CSUtil.getBoolean(properties.getProperty("remain_paramengine"), false);
                if (n4 == 8 || bl) break block7;
                ReportInfoCache.removeReportInfoCache(reportInfoCache.getEngineID());
            }
            catch (Throwable throwable) {
                if (string == null || CSUtil.getBoolean(properties.getProperty("jrs.force_remove_cache_engine"))) {
                    ReportInfoCache.removeReportInfoCache(string2);
                    ReportInfoCache.removeCachedParams(string2);
                }
                properties.remove("jrs.time_base_line");
                throw throwable;
            }
        }
        if (string == null || CSUtil.getBoolean(properties.getProperty("jrs.force_remove_cache_engine"))) {
            ReportInfoCache.removeReportInfoCache(string2);
            ReportInfoCache.removeCachedParams(string2);
        }
        properties.remove("jrs.time_base_line");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void evaluateParameter(String string, JRServerEnv jRServerEnv, Properties properties, JRServerInfo jRServerInfo) throws InvalidParameterException, Exception {
        int n;
        String string2;
        String string3;
        int n2;
        String string4;
        ResourceManager resourceManager;
        String string5;
        ParameterEnvAdapter parameterEnvAdapter;
        boolean bl;
        JetUUniverse jetUUniverse;
        CatalogKey catalogKey;
        JREngine jREngine;
        block45: {
            jREngine = null;
            catalogKey = null;
            jetUUniverse = null;
            bl = false;
            parameterEnvAdapter = null;
            string5 = properties.getProperty("jrs.uid");
            resourceManager = HttpUtil.getHttpRptServer().getResourceManager();
            string4 = properties.getProperty("jrs.catalog");
            n2 = CSUtil.parseInt(properties.getProperty("jrs.cat_version"), -1);
            string3 = null;
            if (string4 != null && string4.length() > 0) {
                n2 = n2 != -1 ? n2 : resourceManager.getLatestVersionNumber(string4, string5);
                string3 = jRServerEnv.getRealPath(string5, string4, n2);
            }
            string2 = properties.getProperty("jrs.report");
            n = CSUtil.parseInt(properties.getProperty("jrs.rpt_version"), -1);
            if (string2 != null) break block45;
            if (jREngine == null) return;
            try {
                ServiceLogger.logDebug(0x64B646, new Object[]{"evaluateParameter_" + string, jREngine.getID()}, 6);
                jREngine.exit();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            try {
                ServiceLogger.logDebug(6600263, new Object[]{"evaluateParameter_" + string, jREngine.getID()}, 6);
                parameterEnvAdapter.clear();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
            try {
                ServiceLogger.logDebug(6600264, new Object[]{"evaluateParameter_" + string, jREngine.getID()}, 6);
                UserDataToolkit.getJDataServiceByUser(string5).unregistCatalog(catalogKey);
                if (bl) return;
                jetUUniverse.free();
                return;
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable, 3);
            }
            return;
        }
        n = n != -1 ? n : resourceManager.getLatestVersionNumber(string2, string5);
        String string6 = jRServerEnv.getRealPath(string5, string2, n);
        if (string != null) {
            properties.put("jrs.engine_id", string);
        }
        Object[] objectArray = JRTUtil.createEngine(string5, string4, n2, string3, string2, n, string6, properties);
        jREngine = (JREngine)objectArray[0];
        catalogKey = (CatalogKey)objectArray[1];
        jetUUniverse = (JetUUniverse)objectArray[2];
        bl = (Boolean)objectArray[3];
        parameterEnvAdapter = jREngine.getParameterEnvAdapter();
        ParamDescsUtil paramDescsUtil = new ParamDescsUtil(new ArrayList(parameterEnvAdapter.getAllParameters(false).values()));
        long l = ParamUtil.getTimeBaseLine(properties);
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        Locale locale = ReportInfoCache.evalParamValue(properties);
        Map map = ReportInfoCache.exit(properties, jRServerInfo);
        InvalidParamsException invalidParamsException = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (ParamDesc paramDesc : paramDescsUtil.getParams()) {
            CharSequence charSequence;
            try {
                Object object = ParamUtil.evalParamValue(paramDesc, map, properties);
                if (object instanceof String) {
                    hashMap.put(paramDesc.getPrompt(), object);
                } else if (object instanceof UserInput) {
                    hashMap.put(paramDesc.getPrompt(), ((UserInput)object).getUserInput());
                } else if (object instanceof String[]) {
                    charSequence = new StringBuffer();
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        ((StringBuffer)charSequence).append("," + ((String[])object)[i]);
                    }
                    if (0 < ((String[])object).length) {
                        hashMap.put(paramDesc.getPrompt(), ((StringBuffer)charSequence).substring(1));
                    } else {
                        hashMap.put(paramDesc.getPrompt(), "");
                    }
                } else if (object instanceof UserInput[]) {
                    charSequence = new StringBuffer();
                    for (int i = 0; i < ((UserInput[])object).length; ++i) {
                        ((StringBuffer)charSequence).append("," + ((UserInput[])object)[i].getUserInput());
                    }
                    if (0 < ((UserInput[])object).length) {
                        hashMap.put(paramDesc.getPrompt(), ((StringBuffer)charSequence).substring(1));
                    } else {
                        hashMap.put(paramDesc.getPrompt(), "");
                    }
                } else {
                    hashMap.put(paramDesc.getPrompt(), object == null ? "" : object.toString());
                    ServiceLogger.logDebug("ParamUtil.evalParamValue: value=" + object, 6);
                }
                ParamUtil.setParamValue(paramDesc, object, locale, l);
                ParamUtil.putRuntimeParamValue(properties, paramDesc, locale);
            }
            catch (InvalidParameterException invalidParameterException) {
                charSequence = paramDesc.getPrompt();
                charSequence = charSequence == null || ((String)charSequence).length() == 0 ? paramDesc.getName() : charSequence;
                String string7 = "Parameter \"" + (String)charSequence + "\", ";
                invalidParamsException = new InvalidParamsException(invalidParamsException, string7 + invalidParameterException.getMessage());
            }
        }
        properties.put("display_parameters_values", hashMap);
        if (invalidParamsException != null) {
            throw invalidParamsException;
        }
        ReportInfoCache.IsParameters(string, paramDescsUtil.getParams());
        if (jREngine == null) return;
        try {
            ServiceLogger.logDebug(0x64B646, new Object[]{"evaluateParameter_" + string, jREngine.getID()}, 6);
            jREngine.exit();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        try {
            ServiceLogger.logDebug(6600263, new Object[]{"evaluateParameter_" + string, jREngine.getID()}, 6);
            parameterEnvAdapter.clear();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
        }
        try {
            ServiceLogger.logDebug(6600264, new Object[]{"evaluateParameter_" + string, jREngine.getID()}, 6);
            UserDataToolkit.getJDataServiceByUser(string5).unregistCatalog(catalogKey);
            if (bl) return;
            jetUUniverse.free();
            return;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
            return;
        }
        catch (Exception exception) {
            try {
                throw exception;
                catch (Throwable throwable) {
                    throw new Exception(throwable);
                }
            }
            catch (Throwable throwable) {
                if (jREngine == null) throw throwable;
                try {
                    ServiceLogger.logDebug(0x64B646, new Object[]{"evaluateParameter_" + string, jREngine.getID()}, 6);
                    jREngine.exit();
                }
                catch (Throwable throwable2) {
                    ServiceLogger.logError(throwable2);
                }
                try {
                    ServiceLogger.logDebug(6600263, new Object[]{"evaluateParameter_" + string, jREngine.getID()}, 6);
                    parameterEnvAdapter.clear();
                }
                catch (Throwable throwable3) {
                    ServiceLogger.logError(throwable3, 3);
                }
                try {
                    ServiceLogger.logDebug(6600264, new Object[]{"evaluateParameter_" + string, jREngine.getID()}, 6);
                    UserDataToolkit.getJDataServiceByUser(string5).unregistCatalog(catalogKey);
                    if (bl) throw throwable;
                    jetUUniverse.free();
                    throw throwable;
                }
                catch (Throwable throwable4) {
                    ServiceLogger.logError(throwable4, 3);
                }
                throw throwable;
            }
        }
    }

    private boolean ParamValueChanged(String string, String string2, int n, String string3, int n2) throws Exception {
        boolean bl;
        boolean bl2 = bl = this.addElement == n2 && this.add.equals(string3);
        if (this.asList != null && this.asList.length() > 0) {
            bl = bl && this.booleanValue == n && this.asList.equals(string2);
        }
        return bl;
    }

    private void SEDU() {
        this.getBoolean = System.currentTimeMillis();
    }

    private long add() {
        return this.getBoolean;
    }

    private void addElement() throws Exception {
        Object[] objectArray = JRTUtil.createEngine(this.SEDU, this.asList, this.booleanValue, this.canSaveRSD, this.add, this.addElement, this.append, this.changeParamValue);
        this.free = (JREngine)objectArray[0];
        this.evalParamValue = (CatalogKey)objectArray[1];
        this.exit = (JetUUniverse)objectArray[2];
        this.forName = (Boolean)objectArray[3];
        this.clear = this.free.getID();
        if (this.checkRange == null) {
            this.checkRange = System.currentTimeMillis() + "-" + this.clear;
        }
        ServiceLogger.logDebug(6600261, new Object[]{this.checkRange, this.clear, this.canSaveRSD, this.append}, 6);
        this.getReportInfo();
        this.get = this.free.getParameterEnvAdapter();
        if (this.get == null) {
            ServiceLogger.logError("ReportInfoCache::initEngineEnv: paramEnv is null, please check engine log for reason.");
            throw new NullPointerException("initEngineEnv failed: paramEnv is null");
        }
        this.createEngine = this.get.haveParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append() {
        if (this.free == null) {
            return;
        }
        try {
            ServiceLogger.logDebug(0x64B646, new Object[]{this.checkRange, this.clear}, 6);
            this.free.exit();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        finally {
            this.free = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asList() {
        if (this.get == null) {
            return;
        }
        try {
            ServiceLogger.logDebug(6600263, new Object[]{this.checkRange, this.clear}, 6);
            this.get.clear();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
        }
        finally {
            this.get = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void booleanValue() {
        if (this.evalParamValue == null) {
            return;
        }
        try {
            ServiceLogger.logDebug(6600264, new Object[]{this.checkRange, this.clear}, 6);
            UserDataToolkit.getJDataServiceByUser(this.SEDU).unregistCatalog(this.evalParamValue);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
        }
        try {
            if (!this.forName && this.exit != null) {
                this.exit.free();
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
        }
        finally {
            this.exit = null;
            this.evalParamValue = null;
        }
    }

    private void canSaveRSD() {
        this.append();
        this.asList();
        this.booleanValue();
    }

    private List changeParamValue(int n) {
        if (n == 0) {
            return this.getAllDataSource;
        }
        if (n == 1) {
            if (this.getAvlGroupFields.size() > 0) {
                ArrayList arrayList = new ArrayList(this.getAllParameters);
                arrayList.removeAll(this.getAvlGroupFields);
                return arrayList;
            }
            return this.getAllParameters;
        }
        return this.getAvailableLocales;
    }

    private List checkRange(int n, Map map) {
        List list = JRTUtil.parseSheetNames(map);
        if (list.size() == 0) {
            return this.changeParamValue(n);
        }
        list = this.clear(list);
        if (n == 1) {
            list.removeAll(this.getAvlGroupFields);
        }
        return list;
    }

    private List clear(List list) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.getAvailableLocales);
        arrayList.retainAll(list);
        return arrayList;
    }

    private boolean clone(List list) {
        if (!this.createEngine) {
            return true;
        }
        return ((Object)this.currentTimeMillis.getReportNames()).equals(list);
    }

    public Object[] getReportInfo() throws Exception {
        if (this.contains != null) {
            return this.contains;
        }
        this.contains = new Object[13];
        this.contains[0] = this.checkRange;
        this.contains[1] = this.free.getAvlGroupFields();
        this.convertParamValuesToProp = this.free.getSortParameter();
        this.contains[2] = this.convertParamValuesToProp;
        this.contains[3] = this.free.getAvailableLocales("");
        this.contains[4] = new Boolean(this.free.hasPageSecurity());
        this.contains[5] = this.free.getStyleGroupNames();
        this.contains[6] = new Boolean(this.free.canSaveRSD());
        this.contains[7] = this.free.getCurrStlGrpName();
        this.containsKey = this.free.getReportsOfReportSet();
        ReportInfo reportInfo = this.free.getCurrentReport();
        Vector<JRReportSheetInfo> vector = new Vector<JRReportSheetInfo>();
        Vector<JRReportSheetInfo> vector2 = new Vector<JRReportSheetInfo>(this.containsKey.size());
        for (ReportInfo reportInfo2 : this.containsKey) {
            HashMap hashMap = this.contains(reportInfo2);
            JRReportSheetInfo jRReportSheetInfo = new JRReportSheetInfo(reportInfo2, hashMap);
            vector2.add(jRReportSheetInfo);
            this.getAvailableLocales.add(reportInfo2.getRptName());
            if (reportInfo2.getRptName().equals(reportInfo.getRptName())) {
                this.contains[8] = jRReportSheetInfo;
                this.getAllDataSource.add(reportInfo2.getRptName());
            }
            if (reportInfo2.getRptStatus() == 0 || reportInfo2.getRptStatus() == 1) {
                vector.add(jRReportSheetInfo);
                this.getAllParameters.add(reportInfo2.getRptName());
            }
            if (!jRReportSheetInfo.isBurstingReport()) continue;
            this.getAvlGroupFields.add(reportInfo2.getRptName());
        }
        this.contains[9] = vector2;
        this.contains[10] = vector;
        this.contains[11] = this.free.getAllDataSource(2);
        this.contains[12] = this.free.getReportParamNames(2);
        ServiceLogger.logDebug(6600265, new Object[]{this.checkRange, this.clear}, 6);
        return this.contains;
    }

    public String getEngineID() {
        return this.checkRange;
    }

    private HashMap contains(ReportInfo reportInfo) throws Exception {
        BurstingSchema[] burstingSchemaArray = reportInfo.getBurstingSchemas();
        if (burstingSchemaArray != null) {
            HashMap<String, ParamDesc[]> hashMap = new HashMap<String, ParamDesc[]>();
            for (int i = 0; i < burstingSchemaArray.length; ++i) {
                ParamDesc[] paramDescArray = this.containsKey(burstingSchemaArray[i]);
                hashMap.put(burstingSchemaArray[i].getName(), paramDescArray);
            }
            return hashMap;
        }
        return null;
    }

    private ParamDesc[] containsKey(BurstingSchema burstingSchema) throws Exception {
        ParamDesc[] paramDescArray = null;
        if (burstingSchema != null) {
            String string = burstingSchema.getBurstingRecipientSchema().getDatasourceName();
            String string2 = burstingSchema.getBurstingRecipientSchema().getQueryName();
            paramDescArray = this.free.getEngineTools().getQueryParams(string, string2);
            if (!this.generateParameterValue && paramDescArray != null) {
                for (int i = 0; i < paramDescArray.length; ++i) {
                    if (!paramDescArray[i].IsParameters() && !paramDescArray[i].isReferedBy()) continue;
                    this.generateParameterValue = true;
                    break;
                }
            }
        }
        return paramDescArray;
    }

    public Vector getParamInfoByValueForRecipient(String string, String string2, String string3) throws RptServerException {
        ParamDesc[] paramDescArray = null;
        try {
            for (int i = 0; i < this.containsKey.size(); ++i) {
                ReportInfo reportInfo = (ReportInfo)this.containsKey.get(i);
                if (!reportInfo.getRptName().equals(string)) continue;
                paramDescArray = this.getParamDescByValueForRecipient(reportInfo.getBurstingSchemas()[0], string2, string3);
                break;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            throw new RptServerException(exception);
        }
        Vector<JRParamInfo> vector = null;
        if (paramDescArray != null) {
            vector = new Vector<JRParamInfo>(paramDescArray.length);
            for (int i = 0; i < paramDescArray.length; ++i) {
                vector.addElement(new JRParamInfo(paramDescArray[i]));
            }
        }
        return vector;
    }

    public ParamDesc[] getParamDescByValueForRecipient(BurstingSchema burstingSchema, String string, String string2) throws Exception {
        ParamDesc[] paramDescArray = null;
        if (burstingSchema != null) {
            EngineTools engineTools = null;
            String string3 = burstingSchema.getBurstingRecipientSchema().getDatasourceName();
            String string4 = burstingSchema.getBurstingRecipientSchema().getQueryName();
            if (this.free != null) {
                engineTools = this.free.getEngineTools();
                paramDescArray = engineTools.getQueryParams(string3, string4);
                paramDescArray = engineTools.ParamValueChanged(string, string2, paramDescArray);
            } else {
                ServiceLogger.logError(3600228, new Object[]{burstingSchema.getName(), string, string2, this.checkRange}, 3);
            }
        }
        return paramDescArray;
    }

    public Vector getReportParams(int n, String string, String string2, String string3, boolean bl) throws Exception {
        ServiceLogger.logDebug(4600266, this.checkRange, 4);
        return this.paramValueChanged(n, string2, string3);
    }

    public Vector getReportParams(int n, Map map) throws Exception {
        ServiceLogger.logDebug(0x64B64B, new Object[]{this.checkRange, n}, 6);
        return this.convertParamValuesToProp(this.changeParamValue(n), map);
    }

    public Vector getReportParams(List list, Map map) throws Exception {
        return this.convertParamValuesToProp(this.clear(list), map);
    }

    public List getOriginalReportParams(List list) {
        ServiceLogger.logDebug("ReportInfoCache[" + this.checkRange + "]: getOriginalReportParams: , reports=" + list, 6);
        try {
            this.createEngine(list);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return this.entrySet.getClonedParams();
    }

    public boolean isHasReportParam() {
        return this.createEngine;
    }

    private Vector convertParamValuesToProp(List list, Map map) throws Exception {
        long l = ParamUtil.getTimeBaseLine(map);
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        boolean bl = this.clone(list);
        this.createEngine(list);
        if (this.currentTimeMillis.size() == 0) {
            return new Vector();
        }
        if (map != null && map.size() > 0) {
            String string = (String)map.get("jrs.param_name");
            string = string == null ? (String)map.get("change_value") : string;
            Object v = null;
            if (string != null && string.length() > 0) {
                v = map.get("jrs.param_value");
                if (v == null) {
                    v = map.get("jrs.param$" + string);
                } else {
                    map.put("jrs.param$" + string, v);
                }
            }
            boolean bl2 = string != null && string.length() > 0 && v != null;
            Locale locale = ReportInfoCache.evalParamValue(map);
            String string2 = (String)map.get("jrs.timezone");
            TimeZone timeZone = TimeZone.getTimeZone(null == string2 ? "" : string2);
            if (bl2 && bl) {
                this.currentTimeMillis(string, v, locale, l, timeZone);
            } else {
                Map map2 = ReportInfoCache.exit(map, null);
                if (!map2.isEmpty()) {
                    ServiceLogger.logDebug(4600269, new Object[]{this.checkRange, string}, 4);
                    this.forName(map2, map, locale, false, bl2 ? string : null);
                }
            }
        }
        return this.currentTimeMillis.getSortedParams(this.convertParamValuesToProp);
    }

    private void createEngine(List list) throws Exception {
        if (!this.clone(list)) {
            if (this.get == null) {
                throw new NullPointerException("ReportInfoCache::getReportParams falied: paramEnv is null.");
            }
            List list2 = null;
            if (list == null || list.size() == 0) {
                ServiceLogger.logError("ReportInfoCache::getParamDescs: reportNames is empty.", 3);
            } else {
                list2 = this.get.getReportParameters(list.toArray(new String[0]));
            }
            this.currentTimeMillis = new ParamInfoObj(list, list2);
            this.entrySet = (ParamInfoObj)this.currentTimeMillis.clone();
            ServiceLogger.logDebug(6600268, new Object[]{this.checkRange, this.clear, list, this.currentTimeMillis.getParams()}, 6);
        }
    }

    public Vector paramValueChanged(int n, String string, Object object) throws Exception {
        ServiceLogger.logDebug(4600270, this.checkRange, 4);
        Hashtable<String, Object> hashtable = null;
        if (string != null && string.length() > 0 && object != null) {
            hashtable = new Hashtable<String, Object>();
            hashtable.put("jrs.param_name", string);
            hashtable.put("jrs.param$" + string, object);
        }
        return this.convertParamValuesToProp(this.changeParamValue(n), hashtable);
    }

    private void currentTimeMillis(String string, Object object, Locale locale, long l, TimeZone timeZone) throws Exception {
        if (this.currentTimeMillis.size() == 0) {
            return;
        }
        if (this.get == null) {
            throw new NullPointerException("ReportInfoCache::paramValueChanged falied: paramEnv is null.");
        }
        ParamDesc paramDesc = null;
        for (ParamDesc paramDesc2 : this.currentTimeMillis.getParams()) {
            if (!paramDesc2.getName().equals(string)) continue;
            paramDesc = paramDesc2;
            break;
        }
        if (paramDesc == null) {
            ServiceLogger.logError("ReportInfoCache::paramValueChanged: \"" + string + "\", parameter not found.", 3);
        } else if (ParamUtil.isChangedParamValue(paramDesc, object, locale, l)) {
            ParamDesc[] paramDescArray = ParamUtil.changeParamValue((ParameterEnv)this.get, paramDesc, object, l, locale, timeZone);
            if (paramDescArray == null) {
                ServiceLogger.logError("ReportInfoCache::paramValueChanged: \"" + string + "\", paramEnv return null.", 3);
            } else {
                this.currentTimeMillis.setParams(Arrays.asList(paramDescArray));
            }
            ServiceLogger.logDebug(6600271, new Object[]{this.checkRange, this.clear, this.currentTimeMillis.getReportNames(), string, ParamUtil.toStringParamValue(object), this.currentTimeMillis.getParams()}, 6);
        }
    }

    private Vector entrySet(int n, Properties properties, TaskListener taskListener, JRServerInfo jRServerInfo) throws InvalidParameterException, Exception {
        Vector vector = JRTUtil.parseSheetNames(properties);
        vector.removeAll(this.getAvailableLocales);
        if (!vector.isEmpty()) {
            throw new RptServerException(600056, new Object[]{vector}, null);
        }
        this.equals = false;
        List list = this.checkRange(n, properties);
        Locale locale = ReportInfoCache.evalParamValue(properties);
        ServiceLogger.logDebug(6600255, new Object[]{this.checkRange, locale, n, list, taskListener, jRServerInfo}, 6);
        this.createEngine(list);
        if (this.currentTimeMillis.size() == 0) {
            return null;
        }
        if (jRServerInfo == null) {
            jRServerInfo = ReportInfoCache.equals(properties);
        }
        Map map = ReportInfoCache.exit(properties, jRServerInfo);
        this.forName(map, properties, locale, true, null);
        Vector vector2 = this.currentTimeMillis.getParams();
        this.free(vector2, map, properties, locale);
        Vector vector3 = this.get.validateParameterValues();
        if (vector3 != null && !vector3.isEmpty()) {
            InvalidParamsException invalidParamsException = null;
            for (String string : vector3) {
                if (string == null || string.isEmpty()) continue;
                invalidParamsException = new InvalidParamsException(invalidParamsException, string);
            }
            if (invalidParamsException != null) {
                ServiceLogger.logDebug("User error: " + vector3);
                throw invalidParamsException;
            }
        }
        this.generateParameterValue(vector2, properties, taskListener, jRServerInfo);
        return this.equals ? null : vector2;
    }

    private static JRServerInfo equals(Map map) {
        Properties properties;
        if (map == null) {
            return new JRServerInfo(new Properties());
        }
        Object v = map.get("jrs.schd_props");
        if (v instanceof String) {
            properties = CSUtil.parseQuery((String)v);
        } else if (v instanceof Properties) {
            properties = (Properties)((Properties)v).clone();
        } else {
            properties = new Properties();
            properties.putAll((Map<?, ?>)map);
        }
        JRServerInfo jRServerInfo = new JRServerInfo(properties);
        if (map.get("jrs.request_url") != null) {
            jRServerInfo.setRequestURL((String)map.get("jrs.request_url"));
        }
        if (map.get("jrs.remote_addr") != null) {
            jRServerInfo.setRemoteAddr((String)map.get("jrs.remote_addr"));
        }
        return jRServerInfo;
    }

    private static Locale evalParamValue(Map map) {
        return ServerUtil.getLocale((String)map.get("jrs.rpt_language"), (String)map.get("jrs.rpt_country"), (String)map.get("jrs.rpt_variant"));
    }

    private static Map exit(Map map, JRServerInfo jRServerInfo) throws GenerateParameterException {
        String string;
        Object object;
        String string22;
        Object object3;
        String string3;
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        if (map.containsKey("jrs.param_file")) {
            string3 = (String)map.get("jrs.param_file");
            object3 = JRTUtil.readParamFile(string3);
            for (String string22 : object3.keySet()) {
                object = (List)object3.get(string22);
                if (object.size() == 1) {
                    string = (String)object.get(0);
                    if (string.startsWith("jrs.param_gen$")) {
                        properties2.put(string22, string);
                        continue;
                    }
                    properties.put("jrs.param$" + string22, string);
                    continue;
                }
                properties.put("jrs.param$" + string22, object.toArray(new String[object.size()]));
            }
        }
        if ((string3 = (String)map.get("jrs.param_values")) != null) {
            object3 = ParameterManager.convertParamValuesToProp(string3);
            Iterator<Object> iterator = ((Properties)object3).keySet().iterator();
            while (iterator.hasNext()) {
                string22 = iterator.next().toString();
                object = ((Properties)object3).getProperty(string22);
                if (((String)object).startsWith("jrs.param_gen$")) {
                    properties2.put(string22, object);
                    continue;
                }
                properties.put("jrs.param$" + string22, object);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            string22 = (String)entry.getKey();
            object = entry.getValue();
            if (string22.startsWith("jrs.param$")) {
                if (object instanceof String && object.toString().startsWith("jrs.param_gen$")) {
                    properties2.put(string22.substring("jrs.param$".length()), object);
                    continue;
                }
                properties.put(string22, object);
                continue;
            }
            if (!string22.startsWith("jrs.param.exp$") && !string22.startsWith("jrs.param.pattern$")) continue;
            properties.put(string22, object);
        }
        if (properties2.size() > 0 && jRServerInfo != null) {
            properties2 = ParameterManager.generateParameterValue(properties2, jRServerInfo);
            for (Map.Entry entry : properties2.entrySet()) {
                properties.put("jrs.param$" + entry.getKey(), entry.getValue());
            }
        }
        object3 = new ArrayList<Object>(properties.keySet());
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            string22 = (String)iterator.next();
            if (string22.startsWith("jrs.param$")) {
                object = "jrs.param$";
            } else if (string22.startsWith("jrs.param.exp$")) {
                object = "jrs.param.exp$";
            } else {
                if (!string22.startsWith("jrs.param.pattern$")) continue;
                object = "jrs.param.pattern$";
            }
            Object object2 = properties.remove(string22);
            if (object2 == null) continue;
            string = (String)object + string22.substring(((String)object).length()).toLowerCase();
            properties.put(string, object2);
        }
        return properties;
    }

    private void forName(Map map, Map map2, Locale locale, boolean bl, String string) throws Exception {
        Vector vector = this.currentTimeMillis.getParams();
        if (vector.size() == 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        InvalidParamsException invalidParamsException = null;
        List list = null;
        long l = ParamUtil.getTimeBaseLine(map2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < vector.size(); ++i) {
            ParamDesc paramDesc = (ParamDesc)vector.get(i);
            if (list != null && list.contains(paramDesc)) continue;
            String string2 = paramDesc.getName();
            if (string2.equals(string)) {
                list = ParamDescsUtil.getReferedBy(paramDesc);
            }
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
            try {
                if (!paramDesc.IsParameters() && !paramDesc.isReferedBy()) continue;
                Object object = ParamUtil.evalParamValue(paramDesc, map, map2);
                if (object instanceof String) {
                    hashMap.put(paramDesc.getPrompt(), object);
                } else if (object instanceof UserInput) {
                    hashMap.put(paramDesc.getPrompt(), ((UserInput)object).getUserInput());
                } else if (object instanceof String[]) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < ((String[])object).length; ++j) {
                        stringBuffer.append("," + ((String[])object)[j]);
                    }
                    if (0 < ((String[])object).length) {
                        hashMap.put(paramDesc.getPrompt(), stringBuffer.substring(1));
                    } else {
                        hashMap.put(paramDesc.getPrompt(), "");
                    }
                } else if (object instanceof UserInput[]) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < ((UserInput[])object).length; ++j) {
                        stringBuffer.append("," + ((UserInput[])object)[j].getUserInput());
                    }
                    if (0 < ((UserInput[])object).length) {
                        hashMap.put(paramDesc.getPrompt(), stringBuffer.substring(1));
                    } else {
                        hashMap.put(paramDesc.getPrompt(), "");
                    }
                } else {
                    hashMap.put(paramDesc.getPrompt(), object == null ? "" : object.toString());
                    ServiceLogger.logDebug("ParamUtil.evalParamValue: value=" + object, 6);
                }
                if (!bl && ParamUtil.isEmptyParamValue(object)) continue;
                boolean bl2 = true;
                if (bl) {
                    bl2 = !ParamUtil.checkRange(paramDesc, object, locale, l);
                }
                boolean bl3 = bl2 = bl2 && ParamUtil.isChangedParamValue(paramDesc, object, locale, l);
                if (bl2) {
                    String string3 = (String)map2.get("jrs.timezone");
                    TimeZone timeZone = TimeZone.getTimeZone(null == string3 ? "" : string3);
                    this.currentTimeMillis(paramDesc.getName(), object, locale, l, timeZone);
                    vector = this.currentTimeMillis.getParams();
                    if (paramDesc.IsParameters()) {
                        i = 0;
                    }
                }
                ParamUtil.putRuntimeParamValue(map2, paramDesc, locale);
                continue;
            }
            catch (InvalidParameterException invalidParameterException) {
                if (!bl) continue;
                String string4 = paramDesc.getPrompt();
                string4 = string4 == null || string4.length() == 0 ? string2 : string4;
                String string5 = "Parameter \"" + string4 + "\", ";
                invalidParamsException = new InvalidParamsException(invalidParamsException, string5 + invalidParameterException.getMessage());
                continue;
            }
            catch (Exception exception) {
                if (!bl) continue;
                throw exception;
            }
        }
        if (bl && invalidParamsException != null) {
            throw invalidParamsException;
        }
    }

    private void free(List list, Map map, Map map2, Locale locale) throws Exception {
        InvalidParamsException invalidParamsException = null;
        long l = ParamUtil.getTimeBaseLine(map2);
        for (ParamDesc paramDesc : list) {
            if (paramDesc.IsParameters() || paramDesc.isReferedBy()) continue;
            try {
                Object object = ParamUtil.evalParamValue(paramDesc, map, map2);
                ParamUtil.checkRange(paramDesc, object, locale, l);
                ParamUtil.setParamValue(paramDesc, object, locale, l);
                ParamUtil.putRuntimeParamValue(map2, paramDesc, locale);
            }
            catch (InvalidParameterException invalidParameterException) {
                String string = paramDesc.getPrompt();
                string = string == null || string.length() == 0 ? paramDesc.getName() : string;
                String string2 = "";
                invalidParamsException = new InvalidParamsException(invalidParamsException, string2 + invalidParameterException.getMessage());
            }
        }
        if (invalidParamsException != null) {
            throw invalidParamsException;
        }
    }

    private void generateParameterValue(List list, Map map, TaskListener taskListener, JRServerInfo jRServerInfo) throws Exception {
        boolean bl = CSUtil.getBoolean((String)map.get("jrs.has_task_listener"), false);
        String string = (String)map.get("jrs.task_listener_class");
        if (taskListener == null && bl && JRTUtil.validateTaskListenerClass(string)) {
            taskListener = (TaskListener)Class.forName(string.trim()).newInstance();
            ServiceLogger.logDebug(6600258, new Object[]{this.checkRange, taskListener}, 6);
        }
        if (taskListener != null) {
            jRServerInfo.setParamDescs(new Vector(list));
            try {
                taskListener.validateParameter(jRServerInfo);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                ServiceLogger.logError(noSuchMethodError, 3);
            }
            catch (AbstractMethodError abstractMethodError) {
                ServiceLogger.logError(abstractMethodError, 3);
            }
            catch (TaskListenerException taskListenerException) {
                throw new InvalidParameterException(taskListenerException.getMessage());
            }
        }
    }

    private static class ParamInfoObj
    extends ParamDescsUtil {
        private final List SEDU;

        public ParamInfoObj(List list, List list2) {
            super(list2);
            this.SEDU = list;
        }

        public ParamInfoObj(ParamInfoObj paramInfoObj) {
            super(paramInfoObj);
            this.SEDU = paramInfoObj.SEDU;
        }

        public List getReportNames() {
            return this.SEDU;
        }

        public Object clone() {
            return new ParamInfoObj(this);
        }
    }
}

