/*
 * Decompiled with CFR 0.152.
 */
package jet.server.servlets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import jet.JCliResource;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.server.api.BurstingSchemaInfo;
import jet.server.api.ExportedFileList;
import jet.server.api.PathInfo;
import jet.server.api.Permissions;
import jet.server.api.ReportInfo;
import jet.server.api.ReportSheetInfo;
import jet.server.api.RptServerException;
import jet.server.api.TooManyReportsException;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.resource.PathInfoImpl;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.http.JRStringBufferPrintWriter;
import jet.server.log.ServiceLogger;
import jet.server.schedule.JRServerEnv;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.ReportInfoCache;
import jet.server.servlets.JRServlet;
import jet.server.servlets.OperationBase;
import jet.server.servlets.ServletUtil;
import jet.server.util.WebSecurityUtil;

public class ViewerOperation1
extends OperationBase {
    public ViewerOperation1(JRServlet jRServlet) {
        super(jRServlet);
    }

    public void returnNodeInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        File file;
        PathInfo pathInfo = null;
        pathInfo = this.jrservlet.getHttpRptServer().getResourceManager().getPathInfo(this.jrservlet.getUser(httpServletRequest), this.jrservlet.getPathInfo(httpServletRequest));
        httpServletResponse.setStatus(200);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 6680023, pathInfo.getPath(), 6);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        PathInfoImpl pathInfoImpl = (PathInfoImpl)pathInfo;
        String string = "jrs.node_name=" + pathInfoImpl.getName() + "&" + "jrs.node_share" + "=" + pathInfoImpl.isShared() + "&" + "jrs.node_type" + "=" + pathInfoImpl.getNodeType() + "&isSelf=" + pathInfoImpl.isSelfContainReport() + "&isDynamic=" + pathInfoImpl.isDynamic();
        boolean bl = false;
        if (pathInfoImpl.isDir() && this.jrservlet.getHttpRptServer().getResourceManager().getSubnodes(this.jrservlet.getUser(httpServletRequest), pathInfoImpl.getPath()) != null) {
            bl = true;
        }
        string = string + "&hasSubnodes=" + bl;
        String string2 = pathInfoImpl.getRealPath();
        long l = 0L;
        if (string2 != null && (file = new File(string2)).exists()) {
            l = file.lastModified();
        }
        string = string + "&lastModifiedTime=" + l;
        string = string + "&path=" + pathInfoImpl.getPath();
        jRStringBufferPrintWriter.print(string);
        jRStringBufferPrintWriter.println("jrs.node_desc=" + pathInfoImpl.getDescription());
        jRStringBufferPrintWriter.close();
    }

    public void returnNodeReferInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        Object object;
        PathInfo pathInfo = null;
        try {
            pathInfo = this.jrservlet.getHttpRptServer().getResourceManager().getPathInfo(this.jrservlet.getUser(httpServletRequest), this.jrservlet.getPathInfo(httpServletRequest));
            object = pathInfo.getRealPath();
            object = object == null || ((String)object).length() == 0 ? "0" : (pathInfo.isDir() ? "1" : (pathInfo.isFile() ? "2" : "0"));
            Vector<PathInfo> vector = this.jrservlet.getHttpRptServer().getResourceManager().getSubnodes(this.jrservlet.getUser(httpServletRequest), this.jrservlet.getPathInfo(httpServletRequest));
            string = (String)object + (vector == null || vector.size() == 0 ? "0" : "1");
        }
        catch (RptServerException rptServerException) {
            string = "/?e?/" + rptServerException.getMessage();
        }
        httpServletResponse.setStatus(200);
        object = this.jrservlet.getWriter(httpServletResponse);
        ((JRStringBufferPrintWriter)object).println(string);
        ((JRStringBufferPrintWriter)object).close();
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 6680024, string, 6);
    }

    public void returnSubFileDirs(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Vector vector = null;
        String string = null;
        String string2 = this.jrservlet.getPathInfo(httpServletRequest);
        String string3 = this.jrservlet.getUser(httpServletRequest);
        try {
            vector = this.jrservlet.getHttpRptServer().getResourceManager().getSubpaths(string3, string2);
        }
        catch (RptServerException rptServerException) {
            string = rptServerException.getMessage();
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        if (string != null) {
            jRStringBufferPrintWriter.print("/?e?/");
            jRStringBufferPrintWriter.print(string);
            jRStringBufferPrintWriter.println();
        } else {
            PathInfo pathInfo = null;
            int n = vector == null ? 0 : vector.size();
            jRStringBufferPrintWriter.println(n);
            for (int i = 0; i < n; ++i) {
                Vector vector2;
                pathInfo = (PathInfo)vector.elementAt(i);
                boolean bl = false;
                if (pathInfo.isDir() && (vector2 = this.jrservlet.getHttpRptServer().getResourceManager().getSubpaths(string3, pathInfo.getPath())) != null && vector2.size() > 0) {
                    bl = true;
                }
                jRStringBufferPrintWriter.print(pathInfo.getName() + (char)(pathInfo.isFile() ? 50 : (pathInfo.isDir() ? 49 : 48)) + (bl ? (char)'1' : '0'));
                jRStringBufferPrintWriter.println();
            }
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnRealPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = null;
        String string2 = null;
        PathInfo pathInfo = null;
        try {
            pathInfo = this.jrservlet.getHttpRptServer().getResourceManager().getPathInfo(this.jrservlet.getUser(httpServletRequest), this.jrservlet.getPathInfo(httpServletRequest));
            string2 = pathInfo.getRealPath();
        }
        catch (RptServerException rptServerException) {
            string = rptServerException.getMessage();
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        if (string != null) {
            jRStringBufferPrintWriter.print("/?e?/");
            jRStringBufferPrintWriter.print(string);
            jRStringBufferPrintWriter.println();
        } else {
            if (string2 != null && string2.length() > 0) {
                jRStringBufferPrintWriter.print(string2);
            }
            jRStringBufferPrintWriter.println();
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnRptParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        ServiceLogger.logDebug("ViewerOperation1.returnRptParams: ht=" + hashtable);
        String string = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, hashtable);
            return;
        }
        String string2 = (String)hashtable.get("jrs.report");
        String string3 = (String)hashtable.get("jrs.catalog");
        String string4 = (String)hashtable.get("jrs.cat_version");
        String string5 = (String)hashtable.get("jrs.rpt_version");
        int n = string4 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string3) : CSUtil.parseInt(string4);
        int n2 = string5 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string2) : CSUtil.parseInt(string5);
        String string6 = this.jrservlet.getUser(httpServletRequest);
        ReportInfo reportInfo = null;
        reportInfo = hashtable.get("jrs.jdbc_driver") != null ? this.jrservlet.getHttpRptServer().getReportInfo(string6, string3, n, string2, n2, (Properties)hashtable) : this.jrservlet.getHttpRptServer().getReportInfo(string6, string3, n, string2, n2);
        Vector vector = reportInfo.getParamInfos(2);
        String string7 = (String)hashtable.get("jrs.rpt_language");
        String string8 = (String)hashtable.get("jrs.rpt_country");
        Locale locale = string7 != null && string8 != null ? new Locale(string7, string8) : (string7 != null ? new Locale(string7) : Locale.getDefault());
        String string9 = JRTUtil.getParamsString(vector, reportInfo.getAvailableGroupFields(), reportInfo.getOrderOfParams(), true, locale);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string9.length() > 0) {
            jRStringBufferPrintWriter.print(string9);
        }
        jRStringBufferPrintWriter.println();
        jRStringBufferPrintWriter.close();
    }

    public void returnBooleanNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        String string2 = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string2 != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string2, hashtable);
            return;
        }
        String string3 = (String)hashtable.get("jrs.report");
        String string4 = (String)hashtable.get("jrs.catalog");
        String string5 = (String)hashtable.get("jrs.cat_version");
        String string6 = (String)hashtable.get("jrs.rpt_version");
        int n = string5 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string4) : CSUtil.parseInt(string5);
        int n2 = string6 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string3) : CSUtil.parseInt(string6);
        Vector vector = this.jrservlet.getHttpRptServer().getReportInfo(this.jrservlet.getUser(httpServletRequest), string4, n, string3, n2).getBooleanColumns();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (vector != null && (string = APIUtil.VectorToURLEncodedString(vector)) != null && string.length() > 0) {
            jRStringBufferPrintWriter.println(string);
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnAvailableLanguages(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        String string2;
        String string3 = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string3 != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string3, hashtable);
            return;
        }
        String string4 = (String)hashtable.get("jrs.report");
        if (string4 != null) {
            string4 = HttpUtil.decodeEsc(string4);
        }
        if ((string2 = (String)hashtable.get("jrs.catalog")) != null) {
            string2 = HttpUtil.decodeEsc(string2);
        }
        String string5 = this.jrservlet.getUser(httpServletRequest);
        String string6 = (String)hashtable.get("jrs.cat_version");
        String string7 = (String)hashtable.get("jrs.rpt_version");
        int n = string6 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string2) : CSUtil.parseInt(string6);
        int n2 = string7 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string4) : CSUtil.parseInt(string7);
        Vector vector = this.jrservlet.getHttpRptServer().getReportInfo(string5, string2, n, string4, n2).getAvailableLanguages();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (vector != null && vector.size() > 0 && (string = APIUtil.VectorToURLEncodedString(vector)) != null && string.length() > 0) {
            jRStringBufferPrintWriter.println(string);
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnRptStyleGroups(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        String string2;
        String string3 = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string3 != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string3, hashtable);
            return;
        }
        String string4 = (String)hashtable.get("jrs.report");
        if (string4 != null) {
            string4 = HttpUtil.decodeEsc(string4);
        }
        if ((string2 = (String)hashtable.get("jrs.catalog")) != null) {
            string2 = HttpUtil.decodeEsc(string2);
        }
        String string5 = (String)hashtable.get("jrs.cat_version");
        String string6 = (String)hashtable.get("jrs.rpt_version");
        int n = string5 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string2) : CSUtil.parseInt(string5);
        int n2 = string6 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string4) : CSUtil.parseInt(string6);
        String string7 = (String)hashtable.get("jrs.uid");
        Vector vector = this.jrservlet.getHttpRptServer().getReportInfo(string7, string2, n, string4, n2).getStyleGroupInfos();
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (vector != null && vector.size() > 0 && (string = APIUtil.VectorToURLEncodedString(vector)) != null && string.length() > 0) {
            jRStringBufferPrintWriter.println(string);
        }
        jRStringBufferPrintWriter.close();
    }

    public void returnRptSheets(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string;
        String string2 = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string2 != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string2, hashtable);
            return;
        }
        String string3 = (String)hashtable.get("jrs.report");
        if (string3 != null) {
            string3 = HttpUtil.decodeEsc(string3);
        }
        if ((string = (String)hashtable.get("jrs.catalog")) != null) {
            string = HttpUtil.decodeEsc(string);
        }
        String string4 = (String)hashtable.get("jrs.cat_version");
        String string5 = (String)hashtable.get("jrs.rpt_version");
        int n = string4 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string) : CSUtil.parseInt(string4);
        int n2 = string5 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string3) : CSUtil.parseInt(string5);
        String string6 = (String)hashtable.get("jrs.uid");
        Vector vector = this.jrservlet.getHttpRptServer().getReportInfo(string6, string, n, string3, n2).getReportSheetInfos();
        String string7 = JRTUtil.getReportSheetsString(vector);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string7.length() > 0) {
            jRStringBufferPrintWriter.print(string7);
        }
        jRStringBufferPrintWriter.println();
        jRStringBufferPrintWriter.close();
    }

    public void returnRptSheetsFromRst(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
        if (string != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, hashtable);
            return;
        }
        String string2 = (String)hashtable.get("jrs.file");
        string2 = this.jrservlet.getHttpRptServer().getResourceManager().getHistDir() + string2;
        Vector vector = this.jrservlet.getHttpRptServer().getRstResultInfo(string2).getReportSheetInfos();
        String string3 = JRTUtil.getReportSheetsString(vector);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string3.length() > 0) {
            jRStringBufferPrintWriter.print(string3);
        }
        jRStringBufferPrintWriter.println();
        jRStringBufferPrintWriter.close();
    }

    public void returnCatReportLstNew(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        PathInfoImpl pathInfoImpl;
        int n;
        String string = HttpUtil.getUser(httpServletRequest);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        String string2 = (String)hashtable.get("jrs.path");
        if (string2 == null) {
            string2 = this.jrservlet.getPathInfo(httpServletRequest).trim();
        }
        if (string2 != null) {
            string2 = HttpUtil.decodeEsc(string2);
        }
        Object var7_7 = null;
        Vector<PathInfo> vector = this.jrservlet.getHttpRptServer().getResourceManager().getSubnodes(string, string2);
        int n2 = vector.size();
        for (n = n2 - 1; n >= 0; --n) {
            pathInfoImpl = (PathInfoImpl)vector.get(n);
            if (!pathInfoImpl.isAdhocReport() && !pathInfoImpl.isJDashboard()) continue;
            vector.removeElementAt(n);
        }
        n2 = vector.size();
        jRStringBufferPrintWriter.println(new Integer(n2).toString());
        for (n = 0; n < n2; ++n) {
            File file;
            pathInfoImpl = (PathInfoImpl)vector.get(n);
            String string3 = "jrs.node_name=" + CSUtil.escapeURLPath(pathInfoImpl.getName()) + "&" + "jrs.node_share" + "=" + pathInfoImpl.isShared() + "&" + "jrs.node_type" + "=" + pathInfoImpl.getNodeType() + "&isSelf=" + pathInfoImpl.isSelfContainReport();
            boolean bl = false;
            if (pathInfoImpl.isDir() && this.jrservlet.getHttpRptServer().getResourceManager().getSubnodes(string, pathInfoImpl.getPath()) != null) {
                bl = true;
            }
            string3 = string3 + "&hasSubnodes=" + bl;
            String string4 = pathInfoImpl.getRealPath();
            long l = 0L;
            if (string4 != null && (file = new File(string4)).exists()) {
                l = file.lastModified();
            }
            string3 = string3 + "&lastModifiedTime=" + l;
            string3 = string3 + "&jrs.node_desc=" + pathInfoImpl.getDescription();
            string3 = string3 + "&jrs.node_status=" + pathInfoImpl.getStatus();
            string3 = string3 + "&path=" + pathInfoImpl.getPath();
            jRStringBufferPrintWriter.println(string3);
        }
        httpServletResponse.setStatus(200);
        jRStringBufferPrintWriter.close();
    }

    public void returnRemovedPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = this.jrservlet.getPathInfo(httpServletRequest);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println(0);
        jRStringBufferPrintWriter.println(string);
        jRStringBufferPrintWriter.close();
    }

    public void returnServletPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        httpServletResponse.setStatus(200);
        String string = HttpUtil.getServletPath(httpServletRequest);
        if (string.length() > 0) {
            httpServletResponse.setContentLength(string.length() + 2);
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.print(WebSecurityUtil.escapeHTML(string) + "\r\n");
            servletOutputStream.close();
        }
    }

    public void responseGetTempResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        this.jrservlet.getServletOperation().responseTempResult(httpServletRequest, httpServletResponse, hashtable, (String)hashtable.get("jrs.file"), false);
    }

    public void responseWaitTempResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        this.jrservlet.getServletOperation().responseTempResult(httpServletRequest, httpServletResponse, hashtable, (String)hashtable.get("jrs.file"), true);
    }

    public void testTempResultReady(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.file");
        if (this.jrservlet.getServletOperation().testTempResultReady(string)) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_42") + "!", hashtable);
        } else {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 202, JSvrResource.getMessage("SLT_ERR_44", string), hashtable);
        }
    }

    public void responseRemoveTempResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.file");
        String string2 = (String)hashtable.get("jrs.html_temp_dir");
        String string3 = (String)hashtable.get("jrs.pdf_temp_dir");
        String string4 = (String)hashtable.get("jrs.rtf_temp_dir");
        String string5 = (String)hashtable.get("jrs.xml_temp_dir");
        this.jrservlet.getHttpRptServer().getTempResultOwnerManager().removeOwner(this.jrservlet.getUser(httpServletRequest), ServletUtil.getTempResultKey(string));
        if (string != null) {
            try {
                File file;
                if (string2 != null) {
                    SchdTools.deleteFile(this.jrservlet.getTempDir() + string2 + File.separator, string);
                    file = new File(this.jrservlet.getTempDir() + string2);
                    file.delete();
                }
                if (string3 != null) {
                    SchdTools.deleteFile(this.jrservlet.getTempDir() + string3 + File.separator, string);
                    file = new File(this.jrservlet.getTempDir() + string3);
                    file.delete();
                }
                if (string4 != null) {
                    SchdTools.deleteFile(this.jrservlet.getTempDir() + string4 + File.separator, string);
                    file = new File(this.jrservlet.getTempDir() + string4);
                    file.delete();
                }
                if (string5 != null) {
                    SchdTools.deleteFile(this.jrservlet.getTempDir() + string5 + File.separator, string);
                    file = new File(this.jrservlet.getTempDir() + string5);
                    file.delete();
                } else {
                    SchdTools.deleteFile(this.jrservlet.getTempDir(), string);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_42") + "!", hashtable);
    }

    public void responseVerResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.file");
        if (string == null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_43"), hashtable);
            return;
        }
        String string2 = this.jrservlet.getHistFile(string);
        boolean bl = JRRptServer.hasPageSecurity(string2);
        if (bl) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 500, JCliResource.getMessage("CS_MSG_140"), hashtable);
            return;
        }
        File file = new File(string2);
        if (!file.exists()) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_29", string), hashtable);
            return;
        }
        HttpUtil.processPartialRequest(httpServletRequest, httpServletResponse, file, hashtable);
    }

    public void runAndView(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws TooManyReportsException, Exception {
        ServiceLogger.logDebug("ViewerOperation1.runAndView: ht=" + properties);
        String string = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, properties);
        if (string != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string, (Hashtable)properties);
            return;
        }
        String string2 = (String)properties.get("jrs.catalog");
        String string3 = (String)properties.get("jrs.report");
        String string4 = this.jrservlet.getUser(httpServletRequest);
        properties.put("jrs.catalog", string2);
        properties.put("jrs.report", string3);
        String string5 = JRServlet.getRemoteHost(httpServletRequest);
        if (string5 != null) {
            properties.put("jrs.remote_host", string5);
        }
        properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
        properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
        Hashtable[] hashtableArray = new Hashtable[3];
        if (APIUtil.getBoolean((String)properties.get("jrs.define_permission"), false)) {
            hashtableArray[0] = CSUtil.parseQuery((String)properties.get("jrs.user_permission"));
            hashtableArray[1] = CSUtil.parseQuery((String)properties.get("jrs.role_permission"));
            hashtableArray[2] = CSUtil.parseQuery((String)properties.get("jrs.group_permission"));
        }
        properties.put("jrs.permission_values", hashtableArray);
        String string6 = this.jrservlet.getHttpRptServer().runReportNotWaitResult(string4, string2, string3, properties);
        if (string6 == null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, httpServletRequest.getRequestURI() + "?" + httpServletRequest.getQueryString(), (Hashtable)properties);
            return;
        }
        File file = new File(string6);
        this.jrservlet.getHttpRptServer().getTempResultOwnerManager().registerOwner(string4, ServletUtil.getTempResultKey(file.getName()));
        this.returnResultName(httpServletRequest, httpServletResponse, string6);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 5680025, new Object[]{string2, string3, string6}, 5);
    }

    public void returnResultName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        String string2 = new File(string).getName();
        if (string2 != null && string != null) {
            ServletUtil.realPathTempHashtable.put(string2, string);
        }
        String string3 = "Content-Location" + string2 + "\r\n";
        httpServletResponse.setStatus(200);
        httpServletResponse.setHeader("Content-Location", string2);
        httpServletResponse.setContentLength(string3.length());
        httpServletResponse.getOutputStream().print(string3);
    }

    public void responseExportResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws Throwable {
        String string;
        File file = null;
        String string2 = this.jrservlet.getUser(httpServletRequest);
        String string3 = (String)properties.get("jrs.file");
        if (string3 != null) {
            file = new File(string3);
        } else {
            string3 = (String)properties.get("jrs.temp_file");
            if (string3 != null) {
                string = string3;
                if (!APIUtil.getBoolean((String)properties.get("jrs.check_fullname"), false)) {
                    string = ServletUtil.getTempResultKey(string3);
                }
                if (!this.jrservlet.getHttpRptServer().getTempResultOwnerManager().isOwner(string2, string)) {
                    this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 403, JSvrResource.getMessage("SLT_ERR_56", string3), (Hashtable)properties);
                    return;
                }
                file = new File(this.jrservlet.getTempDir() + string3);
            } else {
                string3 = (String)properties.get("jrs.hist_file");
                if (string3 != null) {
                    file = new File(this.jrservlet.getHistFile(string3));
                }
            }
        }
        if (file == null || !file.exists()) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 404, this.jrservlet.getBase(httpServletRequest, true), (Hashtable)properties);
            return;
        }
        string3 = this.jrservlet.getUser(httpServletRequest);
        if (string3 != null) {
            properties.put("jrs.uid", string3);
        }
        if ((string = JRServlet.getRemoteHost(httpServletRequest)) != null) {
            properties.put("jrs.remote_host", string);
        }
        properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
        properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
        properties.put("exportResultInAType", String.valueOf("true"));
        ExportedFileList exportedFileList = this.jrservlet.getHttpRptServer().exportResult(string2, file.getCanonicalPath(), properties);
        if (exportedFileList != null) {
            int n;
            int n2;
            Vector vector;
            string3 = exportedFileList.getRSTFilename();
            if (string3 != null) {
                this.jrservlet.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, ServletUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((vector = exportedFileList.getHTMLFilenameList()) != null) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 == null) continue;
                    this.jrservlet.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                }
            }
            if ((vector = exportedFileList.getPDFFilename()) != null) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 == null) continue;
                    this.jrservlet.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                }
            }
            if ((string3 = exportedFileList.getTEXTFilename()) != null) {
                this.jrservlet.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, ServletUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((string3 = exportedFileList.getExcelFilename()) != null) {
                this.jrservlet.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, ServletUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((string3 = exportedFileList.getPSFilename()) != null) {
                this.jrservlet.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, ServletUtil.getTempResultKey(new File(string3).getName()));
            }
            if ((vector = exportedFileList.getRTFFilenameList()) != null) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 == null) continue;
                    this.jrservlet.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                }
            }
            if ((vector = exportedFileList.getXMLFilenameList()) != null) {
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    string3 = (String)vector.elementAt(n);
                    if (string3 == null) continue;
                    this.jrservlet.getHttpRptServer().getTempResultOwnerManager().registerOwner(string2, new File(string3).getName());
                }
            }
            httpServletResponse.setStatus(200);
            JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
            String string4 = exportedFileList.toHttpQueryString();
            jRStringBufferPrintWriter.println(string4);
            jRStringBufferPrintWriter.close();
            ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 6680026, string4, 6);
            return;
        }
        this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, httpServletRequest.getRequestURI(), (Hashtable)properties);
    }

    public void returnFolderFiles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Appendable appendable;
        String string = this.jrservlet.getUser(httpServletRequest);
        String string2 = this.jrservlet.getPathInfo(httpServletRequest);
        Vector<Object> vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector = this.jrservlet.getHttpRptServer().getResourceManager().getSubnodes(string, string2);
        Vector vector3 = this.jrservlet.getHttpRptServer().getResourceManager().getEnabledCustomFieldNames();
        int n = vector.size();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            vector2.clear();
            appendable = new StringBuffer(vector.elementAt(i).toString());
            PathInfo pathInfo = (PathInfo)vector.elementAt(i);
            if (!(pathInfo.isAdhocReport() || pathInfo.isStudioReport() || pathInfo.isJDashboard())) {
                File file;
                int n3;
                int n4 = 0;
                int n5 = 0;
                for (int j = 0; j < 9; ++j) {
                    n4 = ((StringBuffer)appendable).toString().indexOf(",");
                    if (n4 != -1) {
                        vector2.add(((StringBuffer)appendable).substring(n5, n4).toString().trim());
                        ((StringBuffer)appendable).delete(n5, n4 + 1);
                        n4 = 0;
                        continue;
                    }
                    vector2.add(((StringBuffer)appendable).toString().trim());
                }
                appendable = null;
                String string3 = vector2.elementAt(1).toString().trim();
                String string4 = vector2.elementAt(0).toString().trim();
                int n6 = string4.indexOf("=");
                String string5 = string4.substring(n6 + 1, string4.length());
                int n7 = string3.indexOf("=");
                String string6 = string3.substring(n7 + 1, string3.length());
                String string7 = vector2.elementAt(2).toString().trim();
                int n8 = string7.indexOf("=");
                String string8 = string7.substring(n8 + 1, string7.length());
                String string9 = vector2.elementAt(3).toString().trim();
                int n9 = string9.indexOf("=");
                String string10 = string9.substring(n9 + 1, string9.length());
                String string11 = vector2.elementAt(4).toString().trim();
                int n10 = string11.indexOf("=");
                String string12 = string11.substring(n10 + 1, string11.length());
                String string13 = vector2.elementAt(5).toString().trim();
                String string14 = string13.substring((n3 = string13.indexOf("=")) + 1, string13.length());
                if (string14 == null) {
                    string14 = " ";
                }
                boolean bl = pathInfo.isReport();
                boolean bl2 = pathInfo.isResult();
                boolean bl3 = pathInfo.isCatalog();
                boolean bl4 = pathInfo.isDir();
                int n11 = 0;
                if (bl) {
                    n11 = 0;
                } else if (bl2) {
                    n11 = 1;
                } else if (bl3) {
                    n11 = 2;
                } else if (bl4) {
                    n11 = 3;
                }
                String string15 = String.valueOf(n11);
                byte by = pathInfo.getStatus();
                String string16 = String.valueOf(by);
                String string17 = vector2.elementAt(5).toString().trim();
                int n12 = string17.indexOf("=");
                String string18 = string17.substring(n12 + 1, string17.length());
                String string19 = vector2.elementAt(5).toString().trim();
                int n13 = string19.indexOf("=");
                String string20 = string19.substring(n13 + 1, string19.length());
                String string21 = vector2.elementAt(5).toString().trim();
                int n14 = string21.indexOf("=");
                String string22 = string21.substring(n14 + 1, string21.length());
                String string23 = null;
                string23 = string12 != null ? ((file = new File(string12)).exists() ? APIUtil.toWinDateString(new Date(file.lastModified())) : "") : "";
                stringBuffer.append(string6 + "," + string8 + "," + string15 + "," + string14 + "," + string16 + ",");
                if (vector3 != null) {
                    for (int j = 0; j < vector3.size(); ++j) {
                        String string24 = (String)vector3.elementAt(j);
                        Object object = pathInfo.getCustomFieldValue(string24);
                        String string25 = object == null ? "" : object.toString();
                        stringBuffer.append(string25 + ",");
                    }
                }
                stringBuffer.append(string23 + ",");
                continue;
            }
            ++n2;
        }
        if (n - n2 >= 0) {
            stringBuffer.append(n - n2);
        } else {
            stringBuffer.append(0);
        }
        String string26 = this.jrservlet.getHttpRptServer().getResourceManager().getTempDir();
        if (!string26.endsWith(File.separator)) {
            string26 = string26 + File.separator;
        }
        appendable = new FileWriter(string26 + string + "folderfiles.txt");
        BufferedWriter bufferedWriter = new BufferedWriter((Writer)appendable);
        bufferedWriter.write(stringBuffer.toString().trim());
        bufferedWriter.flush();
        ((OutputStreamWriter)appendable).close();
        File file = new File(string26 + string + "folderfiles.txt");
        httpServletResponse.setContentType("text/plain");
        this.jrservlet.getServletOperation().sendFile(httpServletRequest, httpServletResponse, file);
        file.delete();
    }

    public void returnEnabledCustomFieldNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        Vector vector = this.jrservlet.getHttpRptServer().getResourceManager().getEnabledCustomFieldNames();
        if (vector == null) {
            vector = new Vector();
        }
        objectOutputStream.writeObject(vector);
        objectOutputStream.close();
    }

    public void returnFolderCatRpts(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, boolean bl) throws Exception {
        String string = this.jrservlet.getUser(httpServletRequest);
        String string2 = (String)hashtable.get("jrs.path");
        Vector<Object> vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        vector = this.jrservlet.getHttpRptServer().getResourceManager().getSubnodes(string, string2);
        int n = vector.size();
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            int n2;
            vector2.clear();
            PathInfo pathInfo = (PathInfo)vector.elementAt(i);
            if (pathInfo.isJDashboard() || pathInfo.isResult()) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(vector.elementAt(i).toString(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector2.add(stringTokenizer.nextToken().trim());
            }
            String string3 = vector2.elementAt(1).toString().trim();
            int n3 = string3.indexOf("=");
            String string4 = string3.substring(n3 + 1, string3.length());
            String string5 = vector2.elementAt(2).toString().trim();
            int n4 = string5.indexOf("=");
            String string6 = string5.substring(n4 + 1, string5.length());
            String string7 = vector2.elementAt(4).toString().trim();
            int n5 = string7.indexOf("=");
            String string8 = string7.substring(n5 + 1, string7.length());
            String string9 = vector2.elementAt(5).toString().trim();
            String string10 = string9.substring((n2 = string9.indexOf("=")) + 1, string9.length());
            if (string10 == null || string10 != null && string10.equals("null")) {
                string10 = " ";
            }
            byte by = pathInfo.getStatus();
            String string11 = String.valueOf(by);
            boolean bl2 = pathInfo.isReport();
            boolean bl3 = pathInfo.isCatalog();
            boolean bl4 = pathInfo.isLC();
            int n6 = 0;
            Date date = null;
            boolean bl5 = this.jrservlet.getHttpRptServer().getResourceManager().checkPermission(string, string6, Permissions.P_READ);
            int n7 = this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string6, string);
            if (!bl5 || n7 <= 0) continue;
            if (bl2) {
                serializable = this.jrservlet.getHttpRptServer().getResourceManager().getReportVersion(string, string6, n7);
                date = serializable.getCreatedTime();
                string8 = serializable.getRealPath();
                bl5 = this.jrservlet.getHttpRptServer().getResourceManager().checkPermission(string, string6, n7, Permissions.P_READ);
                n6 = 0;
            } else if (bl3) {
                serializable = this.jrservlet.getHttpRptServer().getResourceManager().getCatalogVersion(string, string6, n7);
                date = serializable.getCreatedTime();
                string8 = serializable.getRealPath();
                bl5 = this.jrservlet.getHttpRptServer().getResourceManager().checkPermission(string, string6, n7, Permissions.P_READ);
                n6 = 2;
            } else if (bl4) {
                serializable = this.jrservlet.getHttpRptServer().getResourceManager().getLCVersion(string, string6, n7);
                date = serializable.getCreatedTime();
                string8 = serializable.getRealPath();
                bl5 = this.jrservlet.getHttpRptServer().getResourceManager().checkPermission(string, string6, n7, Permissions.P_READ);
                n6 = 4;
            } else if (pathInfo.isDir()) {
                n6 = 3;
            }
            stringBuffer.append("jrs.node_name");
            stringBuffer.append(CSUtil.escapeURLPath(string4));
            stringBuffer.append("\n");
            serializable = new File(string8);
            String string12 = String.valueOf((int)Math.ceil((float)((File)serializable).length() / 1024.0f)) + " KB";
            stringBuffer.append("jrs.download_file_size");
            stringBuffer.append(string12);
            stringBuffer.append("\n");
            stringBuffer.append("jrs.node_type");
            stringBuffer.append(String.valueOf(n6));
            stringBuffer.append("\n");
            stringBuffer.append("jrs.version_date");
            stringBuffer.append(date != null ? simpleDateFormat.format(date) : "");
            stringBuffer.append("\n");
            stringBuffer.append("jrs.node_desc");
            stringBuffer.append(string10);
            stringBuffer.append("\n");
            stringBuffer.append("jrs.node_status");
            stringBuffer.append(string11);
            stringBuffer.append("\n");
            stringBuffer.append("jrs.has_read_permission");
            stringBuffer.append(bl5);
            stringBuffer.append("\n");
            stringBuffer.append("jrs.node_real_path");
            stringBuffer.append(CSUtil.escapeURLPath(string8));
            stringBuffer.append("\n");
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (stringBuffer.length() > 0) {
            jRStringBufferPrintWriter.print(stringBuffer.toString());
        }
        jRStringBufferPrintWriter.println();
        jRStringBufferPrintWriter.close();
    }

    public void responseRunTask(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws Exception {
        String string = this.jrservlet.getUser(httpServletRequest);
        properties.put("jrs.uid", string);
        String string2 = JRServlet.getRemoteHost(httpServletRequest);
        if (string2 != null) {
            properties.put("jrs.remote_host", string2);
        }
        properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
        properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
        String string3 = this.jrservlet.getHttpRptServer().runTask(string, properties);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 6680027, new Object[]{properties, string3}, 6);
        if (string3 == null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, JSvrResource.getMessage("SLT_ERR_61"), (Hashtable)properties);
        } else if (HttpUtil.isClientAPI(httpServletRequest, properties)) {
            httpServletResponse.setStatus(200);
            JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
            jRStringBufferPrintWriter.println(string3);
            jRStringBufferPrintWriter.close();
        } else {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_26", string3), (Hashtable)properties);
        }
    }

    public void responseStopTask(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.task_id");
        String string2 = HttpUtil.getUser(httpServletRequest);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), this.jrservlet.getUser(httpServletRequest), this.jrservlet.getSessionId(httpServletRequest), 6680028, string, 6);
        if (string == null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, JSvrResource.getMessage("SLT_ERR_52"), hashtable);
            return;
        }
        if (!this.jrservlet.getHttpRptServer().stopActiveTaskByUser(string, string2)) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 200, JSvrResource.getMessage("SLT_ERR_57", string), hashtable);
            return;
        }
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentLength(0);
    }

    public void returnAllRptParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Object object;
        String string;
        Object object2;
        Object object3;
        String string2;
        ServiceLogger.logDebug("ViewerOperation1.returnAllRptParams: ht=" + hashtable);
        String string3 = (String)hashtable.get("jrs.param_engineid");
        String string4 = this.jrservlet.getUser(httpServletRequest);
        Vector vector = new Vector();
        Vector vector2 = JRTUtil.parseSheetNames(hashtable);
        if (string3 != null) {
            string2 = (String)hashtable.get("jrs.param_name");
            object3 = hashtable.get("jrs.param_value");
            object2 = ReportInfoCache.getReportInfoCache(string3);
            vector = object2 == null ? null : (vector2.size() > 0 ? ((ReportInfoCache)object2).getReportParams(vector2, (Map)hashtable) : ((ReportInfoCache)object2).getReportParams(0, (Map)hashtable));
        } else {
            string2 = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
            if (string2 != null) {
                this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string2, hashtable);
                return;
            }
            object3 = (String)hashtable.get("jrs.report");
            object2 = (String)hashtable.get("jrs.catalog");
            string = (String)hashtable.get("jrs.cat_version");
            object = (String)hashtable.get("jrs.rpt_version");
            String string5 = (String)hashtable.get("jrs.param_file");
            int n = string == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber((String)object2) : CSUtil.parseInt(string);
            int n2 = object == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber((String)object3) : CSUtil.parseInt((String)object);
            JRServerEnv jRServerEnv = (JRServerEnv)((Object)this.jrservlet.getHttpRptServer().getResourceManager());
            try {
                ReportInfoCache reportInfoCache = ReportInfoCache.getReportInfoCache(string4, (String)object2, n, object3, n2, jRServerEnv, hashtable);
                vector = vector2.size() > 0 ? reportInfoCache.getReportParams(vector2, (Map)hashtable) : reportInfoCache.getReportParams(0, (Map)hashtable);
                string3 = reportInfoCache.getEngineID();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        if (string3 != null) {
            httpServletResponse.setHeader("jrs.param_engineid", string3);
        }
        string2 = (String)hashtable.get("jrs.rpt_language");
        object3 = (String)hashtable.get("jrs.rpt_country");
        object2 = string2 != null && object3 != null ? new Locale(string2, (String)object3) : (string2 != null ? new Locale(string2) : Locale.getDefault());
        string = JRTUtil.getParamsString(vector, null, null, false, (Locale)object2);
        httpServletResponse.setStatus(200);
        object = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string.length() > 0) {
            ((JRStringBufferPrintWriter)object).print(string);
        }
        ((JRStringBufferPrintWriter)object).println();
        ((JRStringBufferPrintWriter)object).close();
    }

    public void returnBurstRptParams(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Object object;
        String string;
        Object object2;
        Object object3;
        String string2;
        String string3 = (String)hashtable.get("jrs.param_engineid");
        String string4 = this.jrservlet.getUser(httpServletRequest);
        Vector vector = new Vector();
        String string5 = null;
        String string6 = null;
        if (string3 != null) {
            string5 = (String)hashtable.get("jrs.param_name");
            string6 = (String)hashtable.get("jrs.param_value");
            string2 = (String)hashtable.get("jrs.report_sheet");
            object3 = ReportInfoCache.getReportInfoCache(string3);
            if (object3 != null) {
                vector = ((ReportInfoCache)object3).getParamInfoByValueForRecipient(string2, string5, string6);
            }
        } else {
            string2 = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, hashtable);
            if (string2 != null) {
                this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string2, hashtable);
                return;
            }
            object3 = (String)hashtable.get("jrs.report");
            object2 = (String)hashtable.get("jrs.catalog");
            string = (String)hashtable.get("jrs.cat_version");
            object = (String)hashtable.get("jrs.rpt_version");
            String string7 = (String)hashtable.get("jrs.report_sheet");
            Vector<String> vector2 = new Vector<String>();
            String string8 = "jrs.bursting_schema$";
            for (String string9 : hashtable.keySet()) {
                if (!string9.startsWith(string8)) continue;
                vector2.add(string9.substring(string8.length()));
            }
            int n = string == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber((String)object2) : CSUtil.parseInt(string);
            int n2 = object == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber((String)object3) : CSUtil.parseInt((String)object);
            ReportInfo reportInfo = this.jrservlet.getHttpRptServer().getReportInfo(string4, (String)object2, n, (String)object3, n2);
            string3 = reportInfo.getParamEngineId();
            Vector vector3 = reportInfo.getReportSheetInfos();
            for (int i = 0; i < vector3.size(); ++i) {
                ReportSheetInfo reportSheetInfo = (ReportSheetInfo)vector3.get(i);
                if (!reportSheetInfo.isBurstingReport() || string7 == null || !string7.equals(reportSheetInfo.getName())) continue;
                BurstingSchemaInfo[] burstingSchemaInfoArray = reportSheetInfo.getBurstingSchemaInfos();
                for (int j = 0; j < burstingSchemaInfoArray.length; ++j) {
                    String string10 = burstingSchemaInfoArray[j].getName();
                    if (!vector2.contains(string10) || burstingSchemaInfoArray[j].getParamInfosForRecipient() == null) continue;
                    vector.addAll(burstingSchemaInfoArray[j].getParamInfosForRecipient());
                }
            }
        }
        if (string3 != null) {
            httpServletResponse.setHeader("jrs.param_engineid", WebSecurityUtil.validateResponseHeader(string3));
        }
        string2 = (String)hashtable.get("jrs.rpt_language");
        object3 = (String)hashtable.get("jrs.rpt_country");
        object2 = string2 != null && object3 != null ? new Locale(string2, (String)object3) : (string2 != null ? new Locale(string2) : Locale.getDefault());
        string = JRTUtil.getParamsString(vector, null, null, true, (Locale)object2);
        httpServletResponse.setStatus(200);
        object = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string.length() > 0) {
            ((JRStringBufferPrintWriter)object).print(string);
        }
        ((JRStringBufferPrintWriter)object).println();
        ((JRStringBufferPrintWriter)object).close();
    }

    public void responseDeleteParamEngine(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = this.jrservlet.getUser(httpServletRequest);
        String string2 = httpServletRequest.getHeader("jrs.param_engineid");
        JRTUtil.removeParamEngineById(string2);
        httpServletResponse.setStatus(200);
    }

    public void returnJDKVerion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = System.getProperty("java.version");
        httpServletResponse.setHeader("jrs.jdkverion", string);
        httpServletResponse.setStatus(200);
    }

    public void validateParameter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws Exception {
        String string;
        ServiceLogger.logDebug("ViewerOperation1.validateParameter: ht=" + properties);
        String string2 = this.jrservlet.checkCatRpt(httpServletRequest, httpServletResponse, properties);
        if (string2 != null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 406, string2, (Hashtable)properties);
            return;
        }
        String string3 = (String)properties.get("jrs.report");
        String string4 = (String)properties.get("jrs.catalog");
        String string5 = (String)properties.get("jrs.cat_version");
        String string6 = (String)properties.get("jrs.rpt_version");
        int n = string5 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string4) : CSUtil.parseInt(string5);
        int n2 = string6 == null ? this.jrservlet.getHttpRptServer().getResourceManager().getLatestVersionNumber(string3) : CSUtil.parseInt(string6);
        String string7 = this.jrservlet.getUser(httpServletRequest);
        if (string7 != null) {
            properties.put("jrs.uid", string7);
        }
        if ((string = httpServletRequest.getHeader("jrs.param_engineid")) != null) {
            properties.put("jrs.engine_id", string);
        }
        ReportInfo reportInfo = null;
        reportInfo = this.jrservlet.getHttpRptServer().getReportInfo(string7, string4, n, string3, n2, properties);
        String string8 = reportInfo.validateParameter(2, properties);
        if ((string = properties.getProperty("jrs.engine_id", string)) != null) {
            httpServletResponse.setHeader("jrs.param_engineid", WebSecurityUtil.validateResponseHeader(string));
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        httpServletResponse.setContentType("text/plain");
        if (string8 != null && string8.length() > 0) {
            jRStringBufferPrintWriter.print(string8);
        }
        jRStringBufferPrintWriter.println();
        jRStringBufferPrintWriter.close();
    }
}

