/*
 * Decompiled with CFR 0.152.
 */
package jet.server.servlets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.util.APIConst;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.ActiveTaskRecord;
import jet.server.api.CatalogVersionRecord;
import jet.server.api.CompletedTaskRecord;
import jet.server.api.CompletedTaskTable;
import jet.server.api.PathInfo;
import jet.server.api.ReportVersionRecord;
import jet.server.api.ResourceManager;
import jet.server.api.ResultFiles;
import jet.server.api.ResultVersionRecord;
import jet.server.api.UserPreferenceManager;
import jet.server.api.admin.cfg.ConfigurationCluster;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.jrserver.http.JRStringBufferPrintWriter;
import jet.server.log.ServiceLogger;
import jet.server.schedule.JRResultFiles;
import jet.server.servlets.JRServlet;
import jet.server.servlets.OperationBase;
import jet.server.servlets.ServletOperation;
import jet.server.servlets.ServletUtil;
import jet.server.util.WebSecurityUtil;

public class ViewerOperation2
extends OperationBase {
    public ViewerOperation2(JRServlet jRServlet) {
        super(jRServlet);
    }

    public void responseGetCatalogOfReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        boolean bl = APIUtil.getBoolean((String)hashtable.get("isConvertedServletPath"), false);
        String string = this.jrservlet.getPathInfo(httpServletRequest);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = ServletUtil._getCatAndRptNames(string, stringBuffer, stringBuffer2);
        String string3 = HttpUtil.getServletPath(httpServletRequest);
        if (string3 == null) {
            string3 = "";
        }
        string3 = bl ? string3 : HttpUtil.encodeEsc(string3, false);
        string = bl ? string : HttpUtil.encodeEsc(string, false);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        jRStringBufferPrintWriter.println("jrs.jrservlet_path=" + string3);
        jRStringBufferPrintWriter.println("jrs.path=" + string);
        jRStringBufferPrintWriter.println("jrs.catalog=" + stringBuffer.toString().trim());
        jRStringBufferPrintWriter.println("jrs.report=" + stringBuffer2.toString().trim());
        jRStringBufferPrintWriter.close();
    }

    public void responseRefreshFolders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws Exception {
        String string = this.jrservlet.getUser(httpServletRequest);
        this.jrservlet.getHttpRptServer().getResourceManager().refreshFolders(string);
        boolean bl = ServerEnv.needSecurity();
        File file = bl ? new File(ViewerOperation2.getRealmPath() + CSUtil.replWithEsc(string) + ".xml") : new File(ViewerOperation2.getRealmPath() + "folders.xml");
        this.jrservlet.getServletOperation().responseFile(httpServletRequest, httpServletResponse, file, properties);
    }

    public static String getRealmPath() {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        ConfigurationCluster configurationCluster = httpRptServer.getAdminService().getConfigService().getConfigurationCluster();
        String string = configurationCluster.getShareRealmDirectory();
        String string2 = string == null || string.length() == 0 ? httpRptServer.getServerEnv().getHomePath() + "realm" : string;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string2;
    }

    public void responseDocVersionList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        boolean bl;
        String string = this.jrservlet.getUser(httpServletRequest);
        String string2 = (String)hashtable.get("jrs.path");
        String string3 = (String)hashtable.get("jrs.result");
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getRealm(), string, this.jrservlet.getSessionId(httpServletRequest), 6680014, string3, 6);
        String string4 = (String)hashtable.get("jrs.report");
        String string5 = (String)hashtable.get("jrs.catalog");
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        Vector<ResultVersionRecord> vector = this.jrservlet.getHttpRptServer().getResourceManager().getResultDocVersions(string, string3);
        Object var11_11 = null;
        int n = vector == null ? 0 : vector.size();
        String string6 = "VCol";
        String string7 = (String)hashtable.get(string6);
        if (string7 == null) {
            string7 = "0";
        }
        jRStringBufferPrintWriter.println(n);
        boolean bl2 = bl = string7.equals("1");
        if (bl) {
            for (int i = n - 1; i >= 0; --i) {
                this.TASK_TO_RPT_DISPLAY_NAME(vector.elementAt(i), jRStringBufferPrintWriter);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.TASK_TO_RPT_DISPLAY_NAME(vector.elementAt(i), jRStringBufferPrintWriter);
            }
        }
        jRStringBufferPrintWriter.close();
    }

    public void responseCatVersionList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        boolean bl;
        String string = (String)hashtable.get("jrs.catalog");
        String string2 = this.jrservlet.getUser(httpServletRequest);
        if (string != null) {
            string = HttpUtil.decodeEsc(string);
        }
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getRealm(), string2, this.jrservlet.getSessionId(httpServletRequest), 6680015, string, 6);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        Vector<CatalogVersionRecord> vector = this.jrservlet.getHttpRptServer().getResourceManager().getCatalogVersions(string2, string);
        Object var8_8 = null;
        int n = vector == null ? 0 : vector.size();
        String string3 = "VCol";
        String string4 = (String)hashtable.get(string3);
        if (string4 == null) {
            string4 = "0";
        }
        jRStringBufferPrintWriter.println(n);
        boolean bl2 = bl = string4.equals("1");
        if (bl) {
            for (int i = n - 1; i >= 0; --i) {
                this.SEDU(vector.elementAt(i), jRStringBufferPrintWriter);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.SEDU(vector.elementAt(i), jRStringBufferPrintWriter);
            }
        }
        jRStringBufferPrintWriter.close();
    }

    private void SEDU(CatalogVersionRecord catalogVersionRecord, JRStringBufferPrintWriter jRStringBufferPrintWriter) {
        String string;
        String string2;
        String string3 = catalogVersionRecord.getVersionName();
        int n = catalogVersionRecord.getVersionNumber();
        Object var5_5 = null;
        String string4 = string3;
        if (string4 != null) {
            string2 = new File(string4).getParent();
            string = new File(string4).getName();
            string4 = string2 + File.separator + string;
        }
        if ((string2 = null) != null) {
            string2 = new File(string2).getName();
        }
        string = null;
        String string5 = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M'/'d'/'yyyy H:mm:ss a");
        jRStringBufferPrintWriter.println("/?vEriD?/" + catalogVersionRecord.getVersionID() + "/?vERrT?/" + string4 + "/?vERdT?/" + catalogVersionRecord.getCreatedTime().getTime() + "/?vERdTsTr?/" + simpleDateFormat.format(catalogVersionRecord.getCreatedTime()) + "/?vERpM?/" + (string2 == null ? "" : string2) + "jrs.version_number" + n + "jrs.expired_time" + string + "jrs.auto_delete_method" + string5);
    }

    public void responseVersionList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        boolean bl;
        String string;
        String string2 = (String)hashtable.get("jrs.report");
        String string3 = (String)hashtable.get("jrs.catalog");
        String string4 = this.jrservlet.getUser(httpServletRequest);
        if (string2 == null) {
            string2 = string = this.jrservlet.getPathInfo(httpServletRequest);
        }
        string2 = HttpUtil.decodeEsc(string2);
        string = httpServletRequest.getParameter("jrs.path");
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getRealm(), string4, this.jrservlet.getSessionId(httpServletRequest), 6680016, string2, 6);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        Vector<ResultVersionRecord> vector = this.jrservlet.getHttpRptServer().getResourceManager().getResultVersions(string4, string2);
        Object var10_10 = null;
        int n = vector == null ? 0 : vector.size();
        String string5 = "VCol";
        String string6 = (String)hashtable.get(string5);
        if (string6 == null) {
            string6 = "0";
        }
        jRStringBufferPrintWriter.println(n);
        boolean bl2 = bl = string6.equals("1");
        if (bl) {
            for (int i = n - 1; i >= 0; --i) {
                this.TASK_TO_RPT_DISPLAY_NAME(vector.elementAt(i), jRStringBufferPrintWriter);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.TASK_TO_RPT_DISPLAY_NAME(vector.elementAt(i), jRStringBufferPrintWriter);
            }
        }
        jRStringBufferPrintWriter.close();
    }

    private void TASK_TO_RPT_DISPLAY_NAME(ResultVersionRecord resultVersionRecord, JRStringBufferPrintWriter jRStringBufferPrintWriter) {
        String string;
        String string2 = resultVersionRecord.getVersionName();
        String string3 = resultVersionRecord.getVersionID();
        int n = resultVersionRecord.getVersionNumber();
        String string4 = resultVersionRecord.getSubmitter();
        String string5 = null;
        String string6 = "0";
        if (resultVersionRecord.getExpirationTime() != null) {
            string5 = String.valueOf(resultVersionRecord.getExpirationTime().getTime());
            string6 = String.valueOf(resultVersionRecord.getExpirationMethod());
        }
        if ((string = resultVersionRecord.getParamFile()) != null) {
            string = new File(string).getName();
        }
        ResultFiles resultFiles = null;
        Hashtable hashtable = resultVersionRecord.getAllReportResultFiles();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M'/'d'/'yyyy H:mm:ss a");
        if (hashtable.containsKey("jrs.report_result")) {
            resultFiles = (ResultFiles)hashtable.get("jrs.report_result");
            if (resultFiles == null) {
                resultFiles = new JRResultFiles("", "");
            }
            Vector vector = resultFiles.getResultFileNames();
            String string7 = this.add(resultFiles);
            String string8 = null;
            if (vector != null) {
                string8 = (String)vector.elementAt(0);
            }
            if (string8 != null) {
                String string9 = new File(string8).getParent();
                String string10 = new File(string8).getName();
                string8 = string9 + File.separator + string10;
            }
            jRStringBufferPrintWriter.println("/?vEriD?/" + resultVersionRecord.getVersionID() + "/?vERrT?/" + string8 + "/?vERdT?/" + resultVersionRecord.getCreatedTime().getTime() + "/?vERdTsTr?/" + simpleDateFormat.format(resultVersionRecord.getCreatedTime()) + "/?vERpM?/" + (string == null ? "" : string) + "jrs.version_number" + n + "jrs.expired_time" + string5 + "jrs.auto_delete_method" + string6 + "jrs.report_result_types" + string7);
        } else {
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            String string11 = null;
            String string12 = null;
            Vector vector = null;
            String string13 = null;
            String string14 = null;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string11 = (String)enumeration.nextElement();
                if (hashtable.get(string11) instanceof ResultFiles) {
                    resultFiles = (ResultFiles)hashtable.get(string11);
                    string12 = resultFiles.getReportDisplayName();
                }
                if (resultFiles == null) {
                    resultFiles = new JRResultFiles("", "");
                }
                vector = resultFiles.getResultFileNames();
                string13 = this.add(resultFiles);
                if (string11.equals("jrs.rst_result")) {
                    if (vector != null) {
                        string14 = (String)vector.elementAt(0);
                    }
                    if (string14 != null) {
                        String string15 = new File(string14).getParent();
                        String string16 = new File(string14).getName();
                        string14 = string15 + File.separator + string16;
                    }
                    hashtable2.put("jrs.rst_result", string13);
                    continue;
                }
                hashtable2.put(string11, string13);
                if (string12 == null) continue;
                hashtable3.put(string11, string12);
            }
            jRStringBufferPrintWriter.println("/?vEriD?/" + resultVersionRecord.getVersionID() + "/?vERrT?/" + string14 + "/?vERdT?/" + resultVersionRecord.getCreatedTime().getTime() + "/?vERdTsTr?/" + simpleDateFormat.format(resultVersionRecord.getCreatedTime()) + "/?vERpM?/" + (string == null ? "" : string) + "jrs.version_number" + n + "jrs.expired_time" + string5 + "jrs.auto_delete_method" + string6 + "jrs.version_files" + HttpUtil.makeQuery(hashtable2) + "SheetDisplayName:" + HttpUtil.makeQuery(hashtable3));
        }
    }

    public void responseSubmitMaxVersion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        boolean bl = true;
        String string = (String)hashtable.get("jrs.path");
        String string2 = this.jrservlet.getUser(httpServletRequest);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getRealm(), string2, this.jrservlet.getSessionId(httpServletRequest), 6680017, string, 6);
        ResourceManager resourceManager = this.jrservlet.getHttpRptServer().getResourceManager();
        boolean bl2 = APIUtil.getBoolean((String)hashtable.get("jrs.need_maxversion"), false);
        int n = APIUtil.parseInt((String)hashtable.get("jrs.maxversion"), 0);
        if (bl2) {
            if (n > 0) {
                resourceManager.setResultMaxVersionAmount(string2, string, n);
            }
        } else if (resourceManager.getResultMaxVersionAmount(string2, string) != 0) {
            resourceManager.setResultMaxVersionAmount(string2, string, 0);
        }
    }

    public void responseRptVersionList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        boolean bl;
        String string = (String)hashtable.get("jrs.report");
        if (string != null) {
            string = HttpUtil.decodeEsc(string);
        }
        String string2 = this.jrservlet.getUser(httpServletRequest);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getRealm(), string2, this.jrservlet.getSessionId(httpServletRequest), 6680016, string, 6);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        Vector<ReportVersionRecord> vector = this.jrservlet.getHttpRptServer().getResourceManager().getReportVersions(string2, string);
        Object var8_8 = null;
        int n = vector == null ? 0 : vector.size();
        String string3 = "VCol";
        String string4 = (String)hashtable.get(string3);
        if (string4 == null) {
            string4 = "0";
        }
        jRStringBufferPrintWriter.println(n);
        boolean bl2 = bl = string4.equals("1");
        if (bl) {
            for (int i = n - 1; i >= 0; --i) {
                this._getCatAndRptNames(vector.elementAt(i), jRStringBufferPrintWriter);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this._getCatAndRptNames(vector.elementAt(i), jRStringBufferPrintWriter);
            }
        }
        jRStringBufferPrintWriter.close();
    }

    private void _getCatAndRptNames(ReportVersionRecord reportVersionRecord, JRStringBufferPrintWriter jRStringBufferPrintWriter) {
        String string;
        String string2;
        String string3 = reportVersionRecord.getVersionName();
        int n = reportVersionRecord.getVersionNumber();
        Object var5_5 = null;
        String string4 = string3;
        if (string4 != null) {
            string2 = new File(string4).getParent();
            string = new File(string4).getName();
            string4 = string2 + File.separator + string;
        }
        if ((string2 = null) != null) {
            string2 = new File(string2).getName();
        }
        string = null;
        String string5 = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M'/'d'/'yyyy H:mm:ss a");
        jRStringBufferPrintWriter.println("/?vEriD?/" + reportVersionRecord.getVersionID() + "/?vERrT?/" + string4 + "/?vERdT?/" + reportVersionRecord.getCreatedTime().getTime() + "/?vERdTsTr?/" + simpleDateFormat.format(reportVersionRecord.getCreatedTime()) + "/?vERpM?/" + (string2 == null ? "" : string2) + "jrs.version_number" + n + "jrs.expired_time" + string + "jrs.auto_delete_method" + string5);
    }

    public void responseGetSchds(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        String string = this.jrservlet.getUser(httpServletRequest);
        httpServletResponse.setHeader("jrs.timezone", APIUtil.getDefaultTimeZone());
        Vector vector = HttpUtil.isSecure() ? this.jrservlet.getHttpRptServer().getScheduledTasksByUser(string) : this.jrservlet.getHttpRptServer().getScheduledTasks();
        ServiceLogger.logDebug(6680011, vector, 6);
        boolean bl = false;
        for (int i = vector.size() - 1; i >= 0; --i) {
            Properties properties = (Properties)vector.elementAt(i);
            properties.remove("jrs.request_url");
            properties.remove("jrs.schd_props");
            properties.remove("web_handler_query");
            String string2 = (String)properties.get("jrs.report");
            string2 = string2 == null ? "" : string2;
            properties.put("jrs.report", string2);
            String string3 = HttpUtil.makeQuery(properties);
            bl = properties.getProperty("jrs.task_class").equalsIgnoreCase("jet.server.schedule.jrtasks.PublishAnalysisRptTask");
            if (string3 == null || string3.trim().length() <= 0 || bl) continue;
            jRStringBufferPrintWriter.println(string3);
        }
        jRStringBufferPrintWriter.close();
    }

    public void responseGetActive(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws Exception {
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        String string = this.jrservlet.getUser(httpServletRequest);
        UserPreferenceManager userPreferenceManager = this.jrservlet.getHttpRptServer().getUserPreferenceManager();
        Properties properties2 = userPreferenceManager.getUserPreference(string);
        Vector vector = HttpUtil.isSecure() ? this.jrservlet.getHttpRptServer().getActiveTasksByUser(string) : this.jrservlet.getHttpRptServer().getActiveTasks();
        if (vector != null) {
            int n = vector.size();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            ActiveTaskRecord activeTaskRecord = null;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M'/'d'/'yyyy H:mm:ss a");
            for (int i = 0; i < n; ++i) {
                hashtable.clear();
                activeTaskRecord = (ActiveTaskRecord)vector.elementAt(i);
                String string2 = activeTaskRecord.getTaskID();
                if (string2 != null) {
                    hashtable.put("jrs.task_id", string2);
                }
                if ((string2 = activeTaskRecord.getTaskName()) != null) {
                    hashtable.put("jrs.schedule_name", string2);
                }
                string2 = simpleDateFormat.format(activeTaskRecord.getStartedTime());
                hashtable.put("jrs.exe_date", string2);
                String string3 = activeTaskRecord.getTaskClass();
                if (string3 != null && (string3.equalsIgnoreCase("jet.server.schedule.jrtasks.UpdateRptTask") || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.PublishToDiskTask") || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.SendJRMailTask") || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.PrintRptTask") || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.ValueTriggerTask") || string3.equalsIgnoreCase(APIConst.TASK_TO_RPT_DISPLAY_NAME) || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.PublishRptTask"))) {
                    string2 = activeTaskRecord.getCatalog();
                    if (string2 != null) {
                        hashtable.put("jrs.catalog", string2);
                    }
                    if ((string2 = activeTaskRecord.getReport()) != null) {
                        hashtable.put("jrs.report", string2);
                    }
                    if ((string2 = activeTaskRecord.getReportNames()) != null) {
                        hashtable.put("jrs.report_names", string2);
                    }
                }
                if ((string2 = activeTaskRecord.getPublishType()) != null) {
                    hashtable.put("jrs.task_class", string2);
                }
                if (string3 != null && (string3.equalsIgnoreCase("jet.server.schedule.jrtasks.UpdateRptTask") || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.PublishToDiskTask") || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.SendJRMailTask") || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.PrintRptTask") || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.ValueTriggerTask") || string3.equalsIgnoreCase(APIConst.TASK_TO_RPT_DISPLAY_NAME) || string3.equalsIgnoreCase("jet.server.schedule.jrtasks.PublishRptTask")) && (string2 = activeTaskRecord.getEngineStatus()) != null) {
                    hashtable.put("jrs.engine_message", string2);
                }
                if ((string2 = APIUtil.getLaunchTypeString(activeTaskRecord.getLaunchType())) != null) {
                    hashtable.put("jrs.launch_type", string2);
                }
                if ((string2 = activeTaskRecord.getSubmitter()) != null) {
                    hashtable.put("jrs.uid", string2);
                }
                if ((string2 = activeTaskRecord.getParamFile()) != null) {
                    hashtable.put("jrs.param_file", string2);
                }
                boolean bl = false;
                bl = string3.equalsIgnoreCase("jet.server.schedule.jrtasks.PublishAnalysisRptTask");
                String string4 = HttpUtil.makeQuery(hashtable);
                if (string4 == null || string4.trim().length() <= 0 || bl) continue;
                jRStringBufferPrintWriter.println(string4);
            }
        }
        jRStringBufferPrintWriter.close();
    }

    public void responseGetCompleted(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Object object;
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        String string = this.jrservlet.getUser(httpServletRequest);
        UserPreferenceManager userPreferenceManager = this.jrservlet.getHttpRptServer().getUserPreferenceManager();
        Properties properties = userPreferenceManager.getUserPreference(string);
        CompletedTaskTable completedTaskTable = this.jrservlet.getHttpRptServer().getCompletedTaskTable();
        Vector vector = new Vector();
        if (HttpUtil.isSecure()) {
            vector = completedTaskTable.getCompletedTaskRecordsByUser(string);
        } else {
            object = completedTaskTable.getAllCompletedTaskRecords();
            while (object.hasMoreElements()) {
                vector.add(object.nextElement());
            }
        }
        if (vector != null) {
            object = new java.util.Date(System.currentTimeMillis());
            int n = ((java.util.Date)object).getDate();
            int n2 = ((java.util.Date)object).getMonth();
            int n3 = ((java.util.Date)object).getYear();
            int n4 = APIUtil.parseInt(properties.getProperty("days_definition_for_completed"));
            java.util.Date date = new java.util.Date(n3, n2, n - n4, 0, 0, 0);
            for (int i = 0; i < vector.size(); ++i) {
                Object object2;
                CompletedTaskRecord completedTaskRecord = (CompletedTaskRecord)vector.elementAt(i);
                boolean bl = false;
                if (completedTaskRecord.getCompletedTime().before(date) && n4 != 0) continue;
                Properties properties2 = completedTaskRecord.toProperties(null);
                String string2 = completedTaskRecord.getParamFile();
                String string3 = null;
                if (string2 != null && string2.trim().length() > 0 && ((File)(object2 = new File(string2 = this.jrservlet.getHttpRptServer().getResourceManager().getHistFile(string2)))).exists()) {
                    String string4;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object2));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string4 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string4).append("\r\n");
                    }
                    string3 = stringBuffer.toString();
                }
                string3 = string3 == null ? "" : string3;
                properties2.put("jrs.param_values", string3);
                bl = completedTaskRecord.getTaskClass().equalsIgnoreCase("jet.server.schedule.jrtasks.PublishAnalysisRptTask");
                object2 = HttpUtil.makeQuery(properties2);
                if (object2 == null || ((String)object2).trim().length() <= 0 || bl) continue;
                jRStringBufferPrintWriter.println((String)object2);
            }
        }
        jRStringBufferPrintWriter.close();
    }

    public void responseEnableSchd(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.task_id");
        String string2 = this.jrservlet.getUser(httpServletRequest);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), string2, this.jrservlet.getSessionId(httpServletRequest), 6680018, string, 6);
        if (string == null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_52"), hashtable);
        } else {
            this.jrservlet.getHttpRptServer().enableScheduledTask(string);
            this.responseGetSchds(httpServletRequest, httpServletResponse, hashtable);
        }
    }

    public void responseDisableSchd(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.task_id");
        String string2 = this.jrservlet.getUser(httpServletRequest);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), string2, this.jrservlet.getSessionId(httpServletRequest), 6680019, string, 6);
        if (string == null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_52"), hashtable);
        } else {
            this.jrservlet.getHttpRptServer().disableScheduledTask(string);
            this.responseGetSchds(httpServletRequest, httpServletResponse, hashtable);
        }
    }

    public void responseDelSchd(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        String string = (String)hashtable.get("jrs.task_id");
        String string2 = this.jrservlet.getUser(httpServletRequest);
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), string2, this.jrservlet.getSessionId(httpServletRequest), 6680020, string, 6);
        if (string == null) {
            this.jrservlet.getServletOperation().sendError(httpServletRequest, httpServletResponse, 404, JSvrResource.getMessage("SLT_ERR_52"), hashtable);
        } else {
            this.jrservlet.getHttpRptServer().removeScheduledTask(string);
            this.responseGetSchds(httpServletRequest, httpServletResponse, hashtable);
        }
    }

    public void responseGetNodeProp(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable, boolean bl) throws Exception {
        Hashtable[] hashtableArray;
        int n;
        Object object;
        String string = HttpUtil.decodeEsc((String)hashtable.get("jrs.path"));
        String string2 = (String)hashtable.get("jrs.catalog");
        String string3 = (String)hashtable.get("jrs.report");
        String string4 = this.jrservlet.getUser(httpServletRequest);
        if (string3 == null) {
            string3 = string;
        }
        if (string == null) {
            this.jrservlet.getServletOperation().sendPathError(httpServletRequest, httpServletResponse, 406, "The resource is null!", null);
            return;
        }
        String string5 = "";
        String string6 = null;
        PathInfo pathInfo = this.jrservlet.getHttpRptServer().getResourceManager().getPathInfo(string4, string3);
        Vector vector = this.jrservlet.getHttpRptServer().getResourceManager().getEnabledCustomFieldNames();
        if (pathInfo.isReport()) {
            string6 = "Report";
        } else if (pathInfo.isCatalog()) {
            string6 = "Catalog";
        } else if (pathInfo.isDir()) {
            string6 = "Folder";
        } else if (pathInfo.isResult()) {
            string6 = "Result";
        }
        byte by = pathInfo.getStatus();
        String string7 = "";
        if (by == 1) {
            string7 = "Active";
        } else if (by == 2) {
            string7 = "Inactive";
        } else if (by == 3) {
            string7 = "Incomplete";
        }
        String string8 = (String)hashtable.get("jrs.cmd");
        String string9 = (String)hashtable.get("loadtype");
        if (string8 != null && string8.equals("jrs.get_node_prop")) {
            string9 = "local";
        }
        if (string9 == null) {
            string9 = "";
        }
        String string10 = pathInfo.getRealPath();
        String string11 = null;
        string11 = string10 != null ? (((File)(object = new File(string10))).exists() ? APIUtil.toWinDateString(new java.util.Date(((File)object).lastModified())) : "") : "";
        object = pathInfo.getDescription();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        if (vector != null) {
            for (n = 0; n < vector.size(); n += 1) {
                String string12 = (String)vector.elementAt(n);
                Object object2 = pathInfo.getCustomFieldValue(string12);
                String string13 = object2 == null ? "" : object2.toString();
                hashtable2.put("CUSTOM_FIELD_" + string12, string13);
            }
        }
        n = pathInfo.isEnableArchivePolicy();
        boolean bl2 = pathInfo.isArchiveNewVersion();
        boolean bl3 = pathInfo.isShared();
        int n2 = pathInfo.getMaxVersionAmount();
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string14 = httpSession == null ? null : httpSession.getId();
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), string4, string14, 6680021, new Object[]{string2, string3}, 6);
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        boolean bl4 = true;
        if (!bl && (hashtableArray = this.jrservlet.getHttpRptServer().getResourceManager().getPermissions(string4, string3, 0)) == null) {
            bl4 = false;
        }
        hashtableArray = new StringBuffer();
        hashtableArray.append("jrs.report").append("=").append(string3);
        hashtableArray.append("&").append("jrs.node_type").append("=").append(string6);
        hashtableArray.append("&").append("jrs.node_desc").append("=").append((String)object);
        hashtableArray.append("&").append("jrs.node_status").append("=").append(string7);
        hashtableArray.append("&").append("Field_Name_Values").append("=").append(CSUtil.escapeURLPath(CSUtil.makeNoHeadQuery(hashtable2)));
        hashtableArray.append("&").append("jrs.node_real_path").append("=").append(string10);
        hashtableArray.append("&").append("jrs.enable_archive_policy").append("=").append(n != 0);
        hashtableArray.append("&").append("jrs.archive_new_version").append("=").append(bl2);
        hashtableArray.append("&").append("jrs.maxversion").append("=").append(n2);
        hashtableArray.append("&").append("jrs.define_permission").append("=").append(!bl & bl4);
        hashtableArray.append("&").append("jrs.node_share").append("=").append(bl3);
        hashtableArray.append("&").append("jrs.enable_dynamic_resource").append("=").append(pathInfo.isEnableDynamicResource());
        if (!pathInfo.isCatalog() && !pathInfo.isSelfContainReport()) {
            boolean bl5 = pathInfo.isEnableLinkedCatalog();
            String string15 = this.jrservlet.getHttpRptServer().getResourceManager().getInheritedLinkedCatalog(string4, string);
            String string16 = pathInfo.getLinkedCatalog();
            if (bl5) {
                boolean bl6 = pathInfo.isUseInherited();
                hashtableArray.append("&").append("jrs.is.use.inherited").append("=").append(bl6);
                hashtableArray.append("&").append("jrs.linked.catalog").append("=").append(string16);
            }
            hashtableArray.append("&").append("jrs.enable.linked.catalog").append("=").append(bl5);
            if (string15 != null) {
                hashtableArray.append("&").append("jrs.inherited.linked.catalog").append("=").append(string15);
            }
        }
        jRStringBufferPrintWriter.println(hashtableArray.toString());
        jRStringBufferPrintWriter.close();
    }

    public void responseVerionProp(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        Hashtable hashtable2;
        Object object;
        Cloneable cloneable;
        String string = (String)hashtable.get("jrs.catalog");
        String string2 = (String)hashtable.get("jrs.report");
        String string3 = (String)hashtable.get("jrs.result");
        String string4 = (String)hashtable.get("jrs.version_number");
        String string5 = (String)hashtable.get("jrs.path");
        String string6 = (String)hashtable.get("jrs.cmd");
        boolean bl = false;
        String string7 = HttpUtil.getUser(httpServletRequest);
        String string8 = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string9 = httpSession == null ? null : httpSession.getId();
        ServiceLogger.logAccessSuccessEvent(this.jrservlet.getHttpRptServer().getResourceManager().getRealm(), string7, string9, 6680022, new Object[]{string, string2, string3}, 6);
        String string10 = "Report";
        String string11 = null;
        String string12 = null;
        if (string6 != null) {
            if (string6.equals("jrs.get_rpt_ver_prop")) {
                string10 = "Report";
                string11 = "jrs.save_rpt_ver_prop";
                string8 = this.jrservlet.getHttpRptServer().getResourceManager().getReportVersion(string7, string2, APIUtil.parseInt(string4, -1)).getReport();
                string12 = string2;
            } else if (string6.equals("jrs.get_rst_ver_prop")) {
                string10 = "Result";
                string11 = "jrs.save_rst_ver_prop";
                string8 = this.jrservlet.getHttpRptServer().getResourceManager().getResultVersion(string7, string2, APIUtil.parseInt(string4, -1)).getResultFile();
                string12 = string2;
                bl = true;
            } else if (string6.equals("jrs.get_rstdoc_ver_prop")) {
                string10 = "Result";
                string11 = "jrs.save_rstdoc_ver_prop";
                string8 = this.jrservlet.getHttpRptServer().getResourceManager().getResultDocVersion(string7, string3, APIUtil.parseInt(string4, -1)).getResultFile();
                string12 = string3;
            } else if (string6.equals("jrs.get_cat_ver_prop")) {
                string10 = "Catalog";
                string11 = "jrs.save_cat_ver_prop";
                string8 = this.jrservlet.getHttpRptServer().getResourceManager().getCatalogVersion(string7, string, APIUtil.parseInt(string4, -1)).getCatalog();
                string12 = string;
            }
        }
        httpServletResponse.setStatus(200);
        JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        String string13 = (String)hashtable.get("jrs.expired_time");
        long l = System.currentTimeMillis();
        int n = 0;
        boolean bl2 = false;
        int[] nArray = APIUtil.getYearMonthDate(new java.util.Date(l));
        String string14 = "";
        String string15 = "";
        String string16 = "";
        int n2 = 30;
        if (string13 != null && string13.length() != 0) {
            n = CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_method"), 1);
            long l2 = APIUtil.parseLong(string13);
            cloneable = new Date(l2);
            object = APIUtil.getYearMonthDate(cloneable);
            if (object[0] - nArray[0] < 100) {
                bl2 = true;
                string14 = String.valueOf(object[0]);
                string15 = String.valueOf(object[1]);
                string16 = String.valueOf(object[2]);
                n2 = (int)((l2 - new java.util.Date(nArray[0] - 1900, nArray[1] - 1, nArray[2]).getTime()) / 86400000L);
            }
        }
        hashtable3.put("jrs.need_expire", String.valueOf(bl2));
        hashtable3.put("jrs.auto_delete_method", String.valueOf(n));
        hashtable3.put("jrs.auto_delete_year", string14);
        hashtable3.put("jrs.auto_delete_month", string15);
        hashtable3.put("jrs.auto_delete_date", string16);
        hashtable3.put("jrs.expire_days", String.valueOf(n2));
        Hashtable[] hashtableArray = string6.equals("jrs.get_rst_ver_prop") ? this.jrservlet.getHttpRptServer().getResourceManager().getPermissions(string7, string12, 0) : this.jrservlet.getHttpRptServer().getResourceManager().getPermissions(string7, string12, APIUtil.parseInt(string4, 0));
        boolean bl3 = true;
        if (hashtableArray == null) {
            hashtableArray = new Hashtable[3];
            bl3 = false;
        }
        if ((hashtable2 = hashtableArray[0]) == null) {
            hashtable2 = new Hashtable();
        }
        if ((cloneable = hashtableArray[1]) == null) {
            cloneable = new Hashtable();
        }
        if ((object = (Object)hashtableArray[2]) == null) {
            object = new Hashtable();
        }
        jRStringBufferPrintWriter.println("USER_PERMISSION=" + hashtable2 + "&ROLE_PERMISSION=" + cloneable + "&GROUP_PERMISSION=" + object);
        jRStringBufferPrintWriter.close();
    }

    public void responseGetRptResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws Exception {
        String string = properties.get("jrs.result").toString();
        String string2 = (String)properties.get("jrs.report");
        String string3 = (String)properties.get("jrs.version_number");
        String string4 = this.jrservlet.getUser(httpServletRequest);
        boolean bl = false;
        PathInfo pathInfo = this.jrservlet.getHttpRptServer().getResourceManager().getPathInfo(string4, string2);
        bl = pathInfo.isResult();
        int n = -1;
        n = Integer.parseInt(string3);
        ResultVersionRecord resultVersionRecord = null;
        resultVersionRecord = bl ? HttpUtil.getHttpRptServer().getResourceManager().getResultDocVersion(string4, string2, n) : HttpUtil.getHttpRptServer().getResourceManager().getResultVersion(string4, string2, n);
        String string5 = resultVersionRecord.getRealPath();
        String string6 = string5.substring(0, string5.lastIndexOf(File.separator) + 1);
        String string7 = HttpUtil.getHttpRptServer().getResourceManager().getHistDir() + string6 + string;
        File file = null;
        file = WebSecurityUtil.validateFilePath(string7);
        ServletOperation servletOperation = new ServletOperation(this.jrservlet);
        servletOperation.responseFile(httpServletRequest, httpServletResponse, file, properties);
    }

    private String add(ResultFiles resultFiles) {
        String string = null;
        String string2 = "0";
        String string3 = "0";
        String string4 = "0";
        String string5 = "0";
        String string6 = "0";
        String string7 = "0";
        String string8 = "0";
        String string9 = "0";
        if (resultFiles.hasRstFile()) {
            string2 = "1";
        }
        if (resultFiles.hasHtmlFile()) {
            string3 = "1";
        }
        if (resultFiles.hasPdfFile()) {
            string4 = "1";
        }
        if (resultFiles.hasTextFile()) {
            string5 = "1";
        }
        if (resultFiles.hasExcelFile()) {
            string6 = "1";
        }
        if (resultFiles.hasPostScriptFile()) {
            string7 = "1";
        }
        if (resultFiles.hasRtfFile()) {
            string8 = "1";
        }
        if (resultFiles.hasXmlFile()) {
            string9 = "1";
        }
        string = string2 + string3 + string4 + string5 + string6 + string7 + string8 + string9;
        return string;
    }

    public void responseGetAllofFileNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws Exception {
        int n = 0;
        String string = null;
        String string2 = HttpUtil.getHttpRptServer().getResourceManager().getHistDir();
        String string3 = (String)hashtable.get("jrs.report");
        String string4 = (String)hashtable.get("jrs.version_number");
        String string5 = (String)hashtable.get("jrs.report_sheet");
        String string6 = this.jrservlet.getUser(httpServletRequest);
        boolean bl = false;
        PathInfo pathInfo = this.jrservlet.getHttpRptServer().getResourceManager().getPathInfo(string6, string3);
        bl = pathInfo.isResult();
        int n2 = -1;
        n2 = Integer.parseInt(string4);
        ResultVersionRecord resultVersionRecord = null;
        resultVersionRecord = bl ? HttpUtil.getHttpRptServer().getResourceManager().getResultDocVersion(string6, string3, n2) : HttpUtil.getHttpRptServer().getResourceManager().getResultVersion(string6, string3, n2);
        String string7 = resultVersionRecord.getRealPath();
        String string8 = string7.substring(0, string7.lastIndexOf(File.separator));
        String string9 = string2 + string8;
        String string10 = (String)hashtable.get("jrs.result_type");
        int n3 = string10.length();
        File file = new File(string9);
        if (string5 == null) {
            int n4;
            int n5;
            int n6 = file.listFiles().length;
            File[] fileArray = new File[n6];
            fileArray = file.listFiles();
            for (int i = 0; i < n6; ++i) {
                string = fileArray[i].getName();
                if (!string.substring((n5 = string.length()) - n3, n5).equalsIgnoreCase(string10)) continue;
                ++n;
            }
            String[] stringArray = new String[n];
            n5 = 0;
            for (int i = 0; i < n6; ++i) {
                string = fileArray[i].getName();
                if (!string.substring((n4 = string.length()) - n3, n4).equalsIgnoreCase(string10)) continue;
                stringArray[n5] = string;
                ++n5;
            }
            httpServletResponse.setStatus(200);
            JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
            jRStringBufferPrintWriter.println(n);
            for (n4 = 0; n4 < n; ++n4) {
                jRStringBufferPrintWriter.println(stringArray[n4]);
            }
            jRStringBufferPrintWriter.close();
        } else {
            int n7;
            int n8;
            File[] fileArray;
            int n9;
            String string11 = string10;
            if (string10.equals("css") || string10.equals("jpg") || string10.equals("gif") || string10.equals("jar") || string10.equals("png")) {
                string11 = "html";
            }
            if (string10.equals("xsd")) {
                string11 = "xml";
            }
            String string12 = null;
            Hashtable hashtable2 = resultVersionRecord.getAllReportResultFiles();
            ResultFiles resultFiles = (ResultFiles)hashtable2.get(string5);
            Vector vector = resultFiles.getResultFileNames();
            if (vector != null && !vector.isEmpty()) {
                for (n9 = 0; n9 < vector.size(); ++n9) {
                    fileArray = (File[])vector.elementAt(n9);
                    if (fileArray == null || !fileArray.endsWith(string11)) continue;
                    string12 = fileArray;
                    break;
                }
            }
            string12 = (string12 = string12.substring(string12.lastIndexOf(File.separator) + 1)).indexOf("_") > 0 ? string12.substring(0, string12.indexOf("_")) : string12.substring(0, string12.indexOf("."));
            n9 = file.listFiles().length;
            fileArray = new File[n9];
            fileArray = file.listFiles();
            for (int i = 0; i < n9; ++i) {
                string = fileArray[i].getName();
                if (!string.substring((n8 = string.length()) - n3, n8).equalsIgnoreCase(string10) || !string10.equals("jar") && string.indexOf(string12) == -1) continue;
                ++n;
            }
            String[] stringArray = new String[n];
            n8 = 0;
            for (int i = 0; i < n9; ++i) {
                string = fileArray[i].getName();
                if (!string.substring((n7 = string.length()) - n3, n7).equalsIgnoreCase(string10) || !string10.equals("jar") && string.indexOf(string12) == -1) continue;
                stringArray[n8] = string;
                ++n8;
            }
            httpServletResponse.setStatus(200);
            JRStringBufferPrintWriter jRStringBufferPrintWriter = this.jrservlet.getWriter(httpServletResponse);
            jRStringBufferPrintWriter.println(n);
            for (n7 = 0; n7 < n; ++n7) {
                jRStringBufferPrintWriter.println(stringArray[n7]);
            }
            jRStringBufferPrintWriter.close();
        }
    }
}

