/*
 * Decompiled with CFR 0.152.
 */
package jet.server.servlets;

import guitools.toolkit.JDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;
import jet.server.api.ExportedFileList;
import jet.server.api.RptServerException;
import jet.server.api.TooManyUsersException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoRemoteServerException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.api.http.TooManyTimesException;
import jet.server.log.ServiceLogger;
import jet.server.util.WebSecurityUtil;

public class WebViewServlet
extends HttpServlet {
    private String C = "/jinfonet/rsthtml.jsp";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String string = this.getInitParameter("rstPage");
        if (string != null) {
            this.C = string;
        }
        ServiceLogger.logDebug(6680064, this.C, 6);
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            if (!HttpUtil.checkLogin(httpServletRequest, httpServletResponse)) {
                return;
            }
            if (!HttpUtil.checkPermission(httpServletRequest)) {
                return;
            }
        }
        catch (TooManyUsersException tooManyUsersException) {
            httpServletResponse.sendError(406, "Too many users!");
        }
        catch (TooManyTimesException tooManyTimesException) {
            httpServletResponse.sendError(406, "Too many times!");
        }
        catch (NoRemoteServerException noRemoteServerException) {
            httpServletResponse.sendError(406, noRemoteServerException.getMessage());
        }
        catch (NoPrivilegeException noPrivilegeException) {
            httpServletResponse.sendError(406, noPrivilegeException.getMessage());
        }
        super.service(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        this.action(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getPathInfo();
        ServiceLogger.logDebug(6680065, string, 6);
        this.action(httpServletRequest, httpServletResponse);
    }

    private void action(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        try {
            Object object;
            Properties properties = new Properties();
            Object object2 = httpServletRequest.getParameterNames();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                String string = httpServletRequest.getParameter((String)object);
                JDebug.INFO((String)((String)object + "=" + string));
                properties.put(object, string);
            }
            object2 = (String)properties.get("jrs.cmd");
            if (object2 != null) {
                object2 = ((String)object2).trim().toLowerCase();
            }
            if (object2 == null) {
                object = this.encodeEsc(httpServletRequest, httpServletRequest.getPathInfo());
                if (object == null) {
                    httpServletResponse.sendError(404, "Cannot find file:" + httpServletRequest.getPathInfo());
                } else {
                    this.checkPermission(httpServletRequest, httpServletResponse, (File)object);
                }
            } else if (((String)object2).equalsIgnoreCase("jrs.get_temp_result")) {
                this.SEDU(httpServletRequest, httpServletResponse, properties);
            } else if (((String)object2).equalsIgnoreCase("jrs.get_ver_rst")) {
                this.append(httpServletRequest, httpServletResponse, properties);
            } else if (((String)object2).equalsIgnoreCase("jrs.remove_temp_result")) {
                this.INFO(httpServletRequest, httpServletResponse, properties);
            } else if (((String)object2).equalsIgnoreCase("jrs.exp_rst")) {
                this.responseExportResult(httpServletRequest, httpServletResponse, properties);
            } else {
                this.C(httpServletRequest, httpServletResponse, properties);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            httpServletResponse.sendError(500, throwable.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void C(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws IOException {
        try {
            String string;
            Object object;
            boolean bl = properties.get("jrs.hist_file") == null;
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            String string2 = HttpUtil.getUser(httpServletRequest);
            String string3 = null;
            int n = HttpUtil.getResultType(httpServletRequest.getParameter("jrs.result_type"), 0);
            if (bl) {
                object = httpServletRequest.getParameter("jrs.catalog");
                string = httpServletRequest.getParameter("jrs.report");
                ServiceLogger.logDebug(6680066, new Object[]{object, string}, 6);
                properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
                properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
                string3 = httpRptServer.runReport(string2, (String)object, string, properties);
                ServiceLogger.logDebug(6680067, string3, 6);
            } else {
                string3 = WebSecurityUtil.validateSubPath(httpServletRequest.getParameter("jrs.hist_file"));
                if (string3 == null) {
                    httpServletResponse.sendError(404, "The result version file was not specified!");
                    return;
                }
                object = new File(this.delete() + string3);
                ServiceLogger.logDebug(6680068, object, 6);
                if (!((File)object).exists() || ((File)object).isDirectory()) {
                    httpServletResponse.sendError(404, "Not found the file " + string3);
                    return;
                }
                if (n == 0) {
                    String string4 = this.checkLogin(httpServletRequest, (File)object, bl);
                    this.redirect(httpServletRequest, httpServletResponse, string4, this.C);
                    return;
                }
                properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
                properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
                string3 = httpRptServer.exportResultToOneFormat(string2, this.delete() + string3, properties);
            }
            if (string3 == null) {
                httpServletResponse.sendError(406, "result file is null!");
                return;
            } else {
                object = new File(string3);
                httpRptServer.getTempResultOwnerManager().registerOwner(string2, HttpUtil.getTempResultKey(((File)object).getName()));
                switch (n) {
                    case 0: {
                        string = this.checkLogin(httpServletRequest, (File)object, bl);
                        this.redirect(httpServletRequest, httpServletResponse, string, this.C);
                        return;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.redirect(httpServletRequest, httpServletResponse, HttpUtil.getBaseNoPath(httpServletRequest, false) + "/result/" + ((File)object).getName(), ((File)object).getName());
                        return;
                    }
                    default: {
                        File file = this.encodeEsc(httpServletRequest, "/result/" + ((File)object).getName());
                        if (file == null) return;
                        this.checkPermission(httpServletRequest, httpServletResponse, file);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            httpServletResponse.sendError(500, throwable.getMessage());
        }
    }

    private void INFO(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws IOException {
        String string = WebSecurityUtil.validateSubPath((String)properties.get("jrs.file"));
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        httpRptServer.getTempResultOwnerManager().removeOwner(HttpUtil.getUser(httpServletRequest), HttpUtil.getTempResultKey(string));
        if (string != null) {
            try {
                new File(this.close() + string).delete();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
        HttpUtil.sendMessage(httpServletRequest, httpServletResponse, 200, "OK!");
    }

    public void responseExportResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Properties properties) throws IOException {
        try {
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            String string = HttpUtil.getUser(httpServletRequest);
            File file = null;
            String string2 = WebSecurityUtil.validateFilePathStr((String)properties.get("jrs.file"));
            if (string2 != null) {
                file = new File(string2);
            } else {
                string2 = (String)properties.get("jrs.temp_file");
                if (string2 != null) {
                    file = new File(this.close() + string2);
                } else {
                    string2 = (String)properties.get("jrs.hist_file");
                    if (string2 != null) {
                        file = new File(this.delete() + string2);
                    }
                }
            }
            if (file == null || !file.exists()) {
                httpServletResponse.sendError(404, file + " not found!");
                return;
            }
            if (string != null) {
                properties.put("jrs.uid", string);
            }
            properties.put("jrs.remote_addr", httpServletRequest.getRemoteAddr());
            properties.put("jrs.request_url", HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString());
            ExportedFileList exportedFileList = httpRptServer.exportResult(string, file.getCanonicalPath(), properties);
            if (exportedFileList != null) {
                httpServletResponse.setStatus(200);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                String string3 = exportedFileList.toHttpQueryString();
                servletOutputStream.println(string3);
                servletOutputStream.close();
            } else {
                httpServletResponse.sendError(406, httpServletRequest.getRequestURI());
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            httpServletResponse.sendError(500, throwable.getMessage());
        }
    }

    private void SEDU(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws IOException {
        String string = WebSecurityUtil.validateSubPath((String)hashtable.get("jrs.file"));
        if (string == null) {
            httpServletResponse.sendError(406, "The result file was not specified!");
            return;
        }
        File file = new File(this.close() + string);
        if (!file.exists()) {
            httpServletResponse.sendError(404, string + " not found!");
            return;
        }
        this.checkPermission(httpServletRequest, httpServletResponse, file);
    }

    private void append(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws IOException {
        String string = (String)hashtable.get("jrs.file");
        if (string == null) {
            httpServletResponse.sendError(406, "The result file was not specified!");
            return;
        }
        File file = new File(this.delete() + string);
        if (!file.exists()) {
            httpServletResponse.sendError(404, string + " not found!");
            return;
        }
        this.checkPermission(httpServletRequest, httpServletResponse, file);
    }

    private String checkLogin(HttpServletRequest httpServletRequest, File file, boolean bl) {
        String string = "jrs.filename=" + HttpUtil.encodeEsc(file.getName()) + "&tempResult=" + bl + "&" + "jrs.applet_type" + "=" + httpServletRequest.getParameter("jrs.applet_type") + "&" + "jrs.catalog" + "=" + HttpUtil.encodeEsc(httpServletRequest.getParameter("jrs.catalog")) + "&" + "jrs.report" + "=" + HttpUtil.encodeEsc(httpServletRequest.getParameter("jrs.report"));
        String string2 = httpServletRequest.getParameter("jrs.frameapplet");
        if (string2 != null) {
            string = string + "&jrs.frameapplet=" + string2;
        }
        String string3 = httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + this.C + "?" + string;
        ServiceLogger.logDebug(6680069, string3, 6);
        return string3;
    }

    private void checkPermission(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file) throws IOException {
        ServiceLogger.logDebug(6680070, file, 6);
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        String string = file.getName();
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n);
        }
        String string3 = httpRptServer.getResourceManager().getMIMEType(string2);
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType(string3);
        httpServletResponse.setContentLength((int)file.length());
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[8192];
        try {
            int n2 = fileInputStream.read(byArray);
            while (n2 > 0) {
                servletOutputStream.write(byArray, 0, n2);
                n2 = fileInputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        fileInputStream.close();
        servletOutputStream.close();
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string4 = httpSession == null ? null : httpSession.getId();
        ServiceLogger.logAccessSuccessEvent(httpRptServer.getResourceManager().getRealm(), HttpUtil.getUser(httpServletRequest), string4, 5680043, file.getCanonicalPath(), 5);
    }

    private String close() {
        String string = HttpUtil.getHttpRptServer().getResourceManager().getTempDir();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    private String delete() {
        String string = HttpUtil.getHttpRptServer().getResourceManager().getHistDir();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    private File encodeEsc(HttpServletRequest httpServletRequest, String string) {
        Object object;
        ServiceLogger.logDebug(6680071, string, 6);
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        if (string.startsWith("/result/")) {
            string = string.replace('/', File.separatorChar);
            string = this.close() + string.substring(8);
        } else if (string.startsWith("/history/")) {
            string = string.replace('/', File.separatorChar);
            string = this.delete() + string.substring(9);
        } else if (string.startsWith("/report/") || string.startsWith("/catalog/")) {
            try {
                object = string.substring(string.startsWith("/report/") ? 7 : 8);
                string = httpRptServer.getResourceManager().getPathInfo(HttpUtil.getUser(httpServletRequest), (String)object).getRealPath();
                ServiceLogger.logDebug(6680072, new Object[]{object, string}, 6);
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError((Throwable)((Object)rptServerException));
                return null;
            }
        } else {
            return null;
        }
        object = new File(string);
        ServiceLogger.logDebug(6680073, object, 6);
        if (!((File)object).exists() || ((File)object).isDirectory()) {
            return null;
        }
        return object;
    }

    public void redirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws IOException {
        ServiceLogger.logDebug(6680074, new Object[]{string, string2}, 6);
        httpServletResponse.setStatus(302);
        httpServletResponse.setHeader("Location", WebSecurityUtil.validateResponseHeader(string));
        httpServletResponse.setHeader("Content-Location", WebSecurityUtil.validateResponseHeader(string));
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        servletOutputStream.println("<html>");
        servletOutputStream.println("<head>");
        servletOutputStream.println("<title>Redirection Page</title>");
        servletOutputStream.println("</head>");
        servletOutputStream.println("<body>");
        servletOutputStream.println("<H1>Redirection Page</H1>");
        servletOutputStream.println("If this page appears, it means your browser does not support redirection. Please click the following address to redirect:");
        servletOutputStream.print("<A href=\"" + WebSecurityUtil.escapeHTMLAttribute(string) + "\">");
        servletOutputStream.write(string2.getBytes());
        servletOutputStream.println("</b></A>");
        servletOutputStream.println("</body>");
        servletOutputStream.println("</html>");
        servletOutputStream.close();
    }
}

