/*
 * Decompiled with CFR 0.152.
 */
package jet.server.storage.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.regex.Pattern;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;

public class PATH {
    private static Pattern SEDU = Pattern.compile("/");
    private String append;
    private Storage.StorageRoot arraycopy;
    private File compile;
    private String[] endsWith;
    private int getDiskDir;

    public static PATH parse(String string) throws FileNotFoundException {
        String string2 = PATH.normalizePath(string);
        String[] stringArray = SEDU.split(string2, -1);
        if (stringArray.length > 1) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            for (int i = 0; i < stringArray2.length; ++i) {
                PATH.validateName(stringArray2[i], string);
            }
            Storage.StorageRoot storageRoot = null;
            try {
                storageRoot = Storage.StorageRoot.valueOf(stringArray2[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FileNotFoundException("Invalid storage path: \"" + string + "\"");
            }
            return new PATH(string2, stringArray2, storageRoot, StorageEnv.localEnv().getDiskDir(storageRoot));
        }
        throw new FileNotFoundException("Invalid storage path: \"" + string + "\"");
    }

    static PATH parseEntry(String string) throws FileNotFoundException {
        PATH pATH = PATH.parse(string);
        if (pATH.getLevel() == 1) {
            throw new FileNotFoundException("Unknown path: " + string);
        }
        return pATH;
    }

    static void validateName(String string, String string2) throws FileNotFoundException {
        if (string.length() == 0 || string.trim().length() != string.length()) {
            throw new FileNotFoundException("Invalid storage path: \"" + string2 + "\"");
        }
    }

    public static String normalizePath(String string) {
        if (!(string = string.replace("\\", "/")).startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/") && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String trimPath(String string, int n) {
        String string2 = PATH.normalizePath(string);
        if (n <= 0) {
            return string2;
        }
        String[] stringArray = SEDU.split(string2, -1);
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        if (stringArray2.length > n) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("/").append(stringArray2[i]);
            }
            return stringBuilder.toString();
        }
        return string2;
    }

    public static String replaceRootDiskPath(PATH pATH, String string, String string2) {
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - 1);
        }
        return string + pATH.SEDU(1, string2);
    }

    private PATH(String string, String[] stringArray, Storage.StorageRoot storageRoot, String string2) {
        this.append = string;
        this.arraycopy = storageRoot;
        this.endsWith = stringArray;
        this.getDiskDir = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]).append(File.separator);
        }
        this.compile = new File(string2, stringBuilder.toString());
    }

    public String getPath() {
        return this.append;
    }

    public String getParentPath(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.endsWith.length - n; ++i) {
            stringBuilder.append("/").append(this.endsWith[i]);
        }
        return stringBuilder.toString();
    }

    private String SEDU(int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < this.getDiskDir; ++i) {
            stringBuilder.append(string).append(this.endsWith[i]);
        }
        return stringBuilder.toString();
    }

    public Storage.StorageRoot getRoot() {
        return this.arraycopy;
    }

    public int getLevel() {
        return this.getDiskDir;
    }

    public File getFile() {
        return this.compile;
    }

    public String toString() {
        return this.append;
    }
}

