/*
 * Decompiled with CFR 0.152.
 */
package jet.server.storage.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.api.db.Database;
import jet.server.db.core.GlobalDataService;
import jet.server.log.ServiceLogger;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;
import jet.server.storage.StoragePathInfo;
import jet.server.storage.UnavailableStorageException;
import jet.server.storage.impl.PATH;
import jet.server.storage.impl.StorageTransceiver;
import jet.server.storage.util.StorageUtil;

public class StorageImpl
implements Storage {
    private boolean FONT;
    private StorageTransceiver GISINFO;

    public StorageImpl(Database database) throws Exception {
        ServiceLogger.logDebug(4670130, this, 4);
        this.FONT = ServerEnv.isClusterEnabled();
        if (this.FONT) {
            this.GISINFO = new StorageTransceiver(database);
            this.GISINFO();
        }
    }

    @Override
    public StorageEnv getStorageEnv() throws StorageException {
        return StorageEnv.localEnv();
    }

    public void close() {
        ServiceLogger.logDebug(4670131, this, 4);
    }

    @Override
    public File get(Storage.StorageRoot storageRoot, String string) throws IOException, StorageException, UnavailableStorageException {
        String string2 = storageRoot.getRootPath() + PATH.normalizePath(string);
        return this.get(string2);
    }

    @Override
    public File get(String string) throws IOException, StorageException, UnavailableStorageException {
        ServiceLogger.logDebug(6670132, string, 7);
        PATH pATH = PATH.parseEntry(string);
        if (!this.FONT || StorageEnv.isSharedDisk(pATH.getRoot())) {
            if (pATH.getFile().exists()) {
                return pATH.getFile();
            }
            throw new FileNotFoundException(string);
        }
        try {
            if (!this.GISINFO.get(pATH)) {
                if (pATH.getRoot() == Storage.StorageRoot.TEMP) {
                    if (!pATH.getFile().exists()) {
                        throw new FileNotFoundException(string);
                    }
                    return pATH.getFile();
                }
                if (pATH.getRoot() == Storage.StorageRoot.HISTORY && pATH.getLevel() > 3) {
                    PATH pATH2 = PATH.parseEntry(pATH.getParentPath(pATH.getLevel() - 3));
                    if (pATH2 == pATH) {
                        throw new FileNotFoundException(string);
                    }
                    ServiceLogger.logDebug(4670133, pATH2.getPath(), 4);
                    if (!this.GISINFO.get(pATH2)) {
                        throw new FileNotFoundException(string);
                    }
                }
            }
        }
        catch (ClusterException clusterException) {
            throw new StorageException((Throwable)((Object)clusterException));
        }
        if (!pATH.getFile().exists()) {
            throw new FileNotFoundException(string);
        }
        return pATH.getFile();
    }

    @Override
    public void add(Storage.StorageRoot storageRoot, String string, File file) throws IOException, StorageException {
        String string2 = storageRoot.getRootPath() + PATH.normalizePath(string);
        this.add(string2, file);
    }

    @Override
    public void add(String string, File file) throws IOException, StorageException {
        this.FONT(string, file, -1, false);
    }

    @Override
    public void add(Storage.StorageRoot storageRoot, String string, int n, boolean bl) throws IOException, StorageException {
        String string2 = storageRoot.getRootPath() + PATH.normalizePath(string);
        this.FONT(string2, null, n, bl);
    }

    private void FONT(String string, File file, int n, boolean bl) throws IOException, StorageException {
        ServiceLogger.logDebug(6670134, new Object[]{string, file}, 6);
        PATH pATH = PATH.parseEntry(string);
        if (file != null) {
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            if (!pATH.getFile().equals(file)) {
                StorageUtil.copy(file, pATH.getFile());
            }
        }
        if (!this.FONT || StorageEnv.isSharedDisk(pATH.getRoot())) {
            return;
        }
        if (!(n != -1 && n != this.GISINFO.getLocalMember().getID() || pATH.getFile().exists())) {
            throw new FileNotFoundException(pATH.getFile().getPath());
        }
        try {
            this.GISINFO.add(pATH, n, bl);
        }
        catch (ClusterException clusterException) {
            throw new StorageException((Throwable)((Object)clusterException));
        }
    }

    @Override
    public void delete(Storage.StorageRoot storageRoot, String string) throws IOException, StorageException {
        String string2 = storageRoot.getRootPath() + PATH.normalizePath(string);
        this.delete(string2);
    }

    @Override
    public void delete(String string) throws IOException, StorageException {
        ServiceLogger.logDebug(6670135, string, 6);
        PATH pATH = PATH.parseEntry(string);
        StorageUtil.delete(pATH.getFile());
        if (!this.FONT || StorageEnv.isSharedDisk(pATH.getRoot())) {
            return;
        }
        try {
            this.GISINFO.delete(pATH);
        }
        catch (ClusterException clusterException) {
            throw new StorageException((Throwable)((Object)clusterException));
        }
    }

    @Override
    public File map(Storage.StorageRoot storageRoot, String string) throws IOException, StorageException {
        String string2 = storageRoot.getRootPath() + PATH.normalizePath(string);
        return this.map(string2);
    }

    @Override
    public File map(String string) throws IOException, StorageException {
        return PATH.parse(string).getFile();
    }

    @Override
    public boolean exists(Storage.StorageRoot storageRoot, String string) throws IOException, StorageException {
        String string2 = storageRoot.getRootPath() + PATH.normalizePath(string);
        return this.exists(string2);
    }

    @Override
    public boolean exists(String string) throws IOException, StorageException {
        PATH pATH = PATH.parseEntry(string);
        if (!this.FONT || StorageEnv.isSharedDisk(pATH.getRoot())) {
            return pATH.getFile().exists();
        }
        return this.GISINFO.exists(pATH);
    }

    @Override
    public void cleanup(Storage.StorageRoot storageRoot) throws IOException, StorageException {
        ServiceLogger.logDebug(6670136, (Object)storageRoot, 6);
        if (!this.FONT || StorageEnv.isSharedDisk(storageRoot)) {
            return;
        }
        try {
            this.GISINFO.cleanup(storageRoot);
        }
        catch (ClusterException clusterException) {
            throw new StorageException((Throwable)((Object)clusterException));
        }
    }

    private ArrayList list(String string, boolean bl) throws StorageException {
        if (this.FONT) {
            return this.GISINFO.list(string, bl);
        }
        ArrayList arrayList = new ArrayList();
        try {
            this.list(arrayList, string, this.map(string), bl);
        }
        catch (IOException iOException) {
            throw new StorageException(iOException);
        }
        return arrayList;
    }

    private void list(ArrayList arrayList, String string, File file, boolean bl) {
        if (file == null || !file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            StoragePathInfo storagePathInfo = new StoragePathInfo();
            storagePathInfo.setPath(string + "/" + file2.getName());
            storagePathInfo.setIsDir(file2.isDirectory());
            storagePathInfo.setLastModified(file2.lastModified());
            arrayList.add(storagePathInfo);
            if (!file2.isDirectory() || !bl) continue;
            this.list(arrayList, string + "/" + file2.getName(), file2, bl);
        }
    }

    @Override
    public ArrayList list(Storage.StorageRoot storageRoot, String string) throws StorageException {
        String string2 = storageRoot.getRootPath() + PATH.normalizePath(string);
        return this.list(string2, false);
    }

    @Override
    public ArrayList listAll(Storage.StorageRoot storageRoot, String string) throws StorageException {
        String string2 = storageRoot.getRootPath() + PATH.normalizePath(string);
        return this.list(string2, true);
    }

    private void GISINFO() throws Exception {
        GlobalDataService globalDataService = GlobalDataService.getInstance();
        if (!globalDataService.isPendingUpgradeStatus()) {
            return;
        }
        ServiceLogger.logDebug(4670145, 4);
        new File(StorageEnv.localEnv().getDiskDir(Storage.StorageRoot.HISTORY)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    try {
                        StorageImpl.this.add(Storage.StorageRoot.HISTORY, file.getName(), null);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                } else if (file.isDirectory()) {
                    final String string = file.getName() + "/";
                    file.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                try {
                                    StorageImpl.this.add(Storage.StorageRoot.HISTORY, string + file.getName(), null);
                                }
                                catch (Exception exception) {
                                    ServiceLogger.logError(exception);
                                }
                            }
                            return false;
                        }
                    });
                }
                return false;
            }
        });
        new File(StorageEnv.localEnv().getDiskDir(Storage.StorageRoot.REALM)).listFiles(new FileFilter(){

            @Override
            public boolean accept(final File file) {
                if (file.isDirectory()) {
                    file.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file4) {
                            File file2;
                            if (file4.isDirectory() && (file2 = new File(file4, "upload")).isDirectory()) {
                                for (File file3 : StorageUtil.listFile(null, file2, true, false)) {
                                    try {
                                        StorageImpl.this.add(Storage.StorageRoot.REALM, file3.getCanonicalPath().substring(file.getParentFile().getCanonicalPath().length()), null);
                                    }
                                    catch (Exception exception) {
                                        ServiceLogger.logError(exception);
                                    }
                                }
                            }
                            return false;
                        }
                    });
                }
                return false;
            }
        });
        new File(StorageEnv.localEnv().getDiskDir(Storage.StorageRoot.FONT)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    try {
                        StorageImpl.this.add(Storage.StorageRoot.FONT, file.getName(), null);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
                return false;
            }
        });
        new File(StorageEnv.localEnv().getDiskDir(Storage.StorageRoot.STYLE)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    try {
                        StorageImpl.this.add(Storage.StorageRoot.STYLE, file.getName(), null);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
                return false;
            }
        });
        new File(StorageEnv.localEnv().getDiskDir(Storage.StorageRoot.GISINFO)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isFile()) {
                    try {
                        StorageImpl.this.add(Storage.StorageRoot.GISINFO, file.getName(), null);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
                return false;
            }
        });
        globalDataService.setFinishedUpgradeStatus();
        ServiceLogger.logDebug(4670146, 4);
    }
}

