/*
 * Decompiled with CFR 0.152.
 */
package jet.server.storage.impl;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import jet.server.rmi.rpc.RpcDispatcher;
import jet.server.rmi.rpc.RpcParam;
import jet.server.storage.Storage;
import jet.server.storage.StorageEnv;
import jet.server.storage.StorageException;

public class StorageWrapper
implements Storage {
    private RpcDispatcher SEDU;
    public static final String handlerName = Storage.class.getName();

    public StorageWrapper(RpcDispatcher rpcDispatcher) {
        this.SEDU = rpcDispatcher;
    }

    @Override
    public StorageEnv getStorageEnv() throws StorageException {
        try {
            return (StorageEnv)this.SEDU.call(new RpcParam(handlerName, "getStorageEnv", new Object[0]));
        }
        catch (RemoteException remoteException) {
            throw new StorageException(remoteException);
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public void add(String string, File file) throws IOException, StorageException {
        try {
            this.SEDU.call(new RpcParam(handlerName, "add", string, file));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public void add(Storage.StorageRoot storageRoot, String string, File file) throws IOException, StorageException {
        try {
            this.SEDU.call(new RpcParam(handlerName, "add", new Object[]{storageRoot, string, file}));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public void add(Storage.StorageRoot storageRoot, String string, int n, boolean bl) throws IOException, StorageException {
        try {
            this.SEDU.call(new RpcParam(handlerName, "add", new Object[]{storageRoot, string, n, bl}));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public File get(String string) throws IOException, StorageException {
        try {
            return (File)this.SEDU.call(new RpcParam(handlerName, "get", string));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public File get(Storage.StorageRoot storageRoot, String string) throws IOException, StorageException {
        try {
            return (File)this.SEDU.call(new RpcParam(handlerName, "get", new Object[]{storageRoot, string}));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public void delete(String string) throws IOException, StorageException {
        try {
            this.SEDU.call(new RpcParam(handlerName, "delete", string));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public void delete(Storage.StorageRoot storageRoot, String string) throws IOException, StorageException {
        try {
            this.SEDU.call(new RpcParam(handlerName, "delete", new Object[]{storageRoot, string}));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public ArrayList list(Storage.StorageRoot storageRoot, String string) throws StorageException {
        try {
            RpcParam rpcParam = new RpcParam(handlerName, "list", new Object[]{storageRoot, string});
            rpcParam.setTypes(Storage.StorageRoot.class, String.class);
            return (ArrayList)this.SEDU.call(rpcParam);
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public ArrayList listAll(Storage.StorageRoot storageRoot, String string) throws StorageException {
        try {
            return (ArrayList)this.SEDU.call(new RpcParam(handlerName, "listAll", new Object[]{storageRoot, string}));
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public File map(String string) throws IOException, StorageException {
        try {
            return (File)this.SEDU.call(new RpcParam(handlerName, "map", string));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public File map(Storage.StorageRoot storageRoot, String string) throws IOException, StorageException {
        try {
            return (File)this.SEDU.call(new RpcParam(handlerName, "map", new Object[]{storageRoot, string}));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public boolean exists(String string) throws IOException, StorageException {
        try {
            return (Boolean)this.SEDU.call(new RpcParam(handlerName, "exists", string));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public boolean exists(Storage.StorageRoot storageRoot, String string) throws IOException, StorageException {
        try {
            return (Boolean)this.SEDU.call(new RpcParam(handlerName, "exists", new Object[]{storageRoot, string}));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }

    @Override
    public void cleanup(Storage.StorageRoot storageRoot) throws IOException, StorageException {
        try {
            this.SEDU.call(new RpcParam(handlerName, "cleanup", new Object[]{storageRoot}));
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (StorageException storageException) {
            throw storageException;
        }
        catch (Exception exception) {
            throw new StorageException(exception);
        }
    }
}

