/*
 * Decompiled with CFR 0.152.
 */
package jet.server.storage.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CompressBitSet {
    private static final int SEDU = 6;
    private static final int add = 64;
    private static final int append = 63;
    private static final long arraycopy = -1L;
    private int[] bitInUnit;
    private long[] clear;

    public CompressBitSet() {
        this.clear();
    }

    public void clear() {
        this.bitInUnit = new int[0];
        this.clear = new long[0];
    }

    private int SEDU(int n) {
        for (int i = 0; i < this.bitInUnit.length; ++i) {
            if (n != this.bitInUnit[i]) continue;
            return i;
        }
        return -1;
    }

    private int add(int n) {
        int n2 = this.SEDU(n);
        if (n2 != -1) {
            return n2;
        }
        int[] nArray = new int[this.bitInUnit.length + 1];
        System.arraycopy(this.bitInUnit, 0, nArray, 0, this.bitInUnit.length);
        this.bitInUnit = nArray;
        this.bitInUnit[this.bitInUnit.length - 1] = n;
        long[] lArray = new long[this.clear.length + 1];
        System.arraycopy(this.clear, 0, lArray, 0, this.clear.length);
        this.clear = lArray;
        return this.bitInUnit.length - 1;
    }

    public void setUnit(int n, long l) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index < 0: " + n);
        }
        int n2 = this.add(n);
        this.clear[n2] = l;
    }

    public long getUnit(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index < 0: " + n);
        }
        int n2 = this.SEDU(n);
        if (n2 == -1) {
            return 0L;
        }
        return this.clear[n2];
    }

    public int[] noneZeroUnits() {
        int[] nArray = new int[this.bitInUnit.length];
        int n = 0;
        for (int i = 0; i < this.bitInUnit.length; ++i) {
            if (this.clear[i] == 0L) continue;
            nArray[n] = this.bitInUnit[i];
            ++n;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public List noneZeroBits() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.bitInUnit.length; ++i) {
            long l = this.clear[i];
            if (l == 0L) continue;
            int n = this.bitInUnit[i] << 6;
            for (int j = 0; j < 64; ++j) {
                if ((l & 1L << j) == 0L) continue;
                arrayList.add(n | j);
            }
        }
        return arrayList;
    }

    public void retain(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index < 0: " + n);
        }
        this.clear();
        int n2 = this.add(CompressBitSet.unitIndex(n));
        this.clear[n2] = CompressBitSet.bitInUnit(n);
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index < 0: " + n);
        }
        int n2 = this.SEDU(CompressBitSet.unitIndex(n));
        if (n2 == -1) {
            return false;
        }
        return (this.clear[n2] & CompressBitSet.bitInUnit(n)) != 0L;
    }

    public void set(int n, boolean bl) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("index < 0: " + n);
        }
        int n2 = this.add(CompressBitSet.unitIndex(n));
        long l = CompressBitSet.bitInUnit(n);
        if (bl) {
            int n3 = n2;
            this.clear[n3] = this.clear[n3] | l;
        } else {
            int n4 = n2;
            this.clear[n4] = this.clear[n4] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.clear);
    }

    public static int unitIndex(int n) {
        return n >> 6;
    }

    public static long bitInUnit(int n) {
        return 1L << (n & 0x3F);
    }
}

