/*
 * Decompiled with CFR 0.152.
 */
package jet.server.storage.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jet.server.schedule.SchdTools;

public class StorageUtil {
    public static void copy(File file, File file2) throws IOException {
        SchdTools.copyFile2(file, file2, true);
    }

    public static void delete(File file) throws IOException {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                    StorageUtil.delete(fileArray[i]);
                }
            }
            file.delete();
        }
    }

    public static void zipFile(ZipOutputStream zipOutputStream, File file) throws IOException {
        if (file.exists()) {
            StorageUtil.zip("", zipOutputStream, file);
        }
        zipOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(String string, ZipOutputStream zipOutputStream, File file) throws IOException {
        if (file.isDirectory()) {
            String string2 = string + file.getName() + "/";
            ZipEntry zipEntry = new ZipEntry(string2);
            zipOutputStream.putNextEntry(zipEntry);
            for (File file2 : file.listFiles()) {
                StorageUtil.zip(string2, zipOutputStream, file2);
            }
        } else {
            ZipEntry zipEntry = new ZipEntry(string + file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                int n = 0;
                while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
            }
            finally {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unZipFile(ZipInputStream zipInputStream, File file) throws IOException {
        ZipEntry zipEntry;
        if (file.exists() && !file.isDirectory()) {
            file.delete();
        }
        file.mkdirs();
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            File file2;
            if (zipEntry.isDirectory()) {
                file2 = new File(file, zipEntry.getName());
                if (file2.exists() && !file2.isDirectory()) {
                    file2.delete();
                }
                file2.mkdirs();
                continue;
            }
            file2 = new File(file, zipEntry.getName());
            if (file2.exists() && file2.isDirectory()) {
                StorageUtil.delete(file2);
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            try {
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = zipInputStream.read(byArray)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        zipInputStream.close();
    }

    public static List listFile(List list, final File file, final boolean bl, final boolean bl2) {
        final List list2 = list == null ? new ArrayList() : list;
        file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file2) {
                if (bl2 || file2.isFile()) {
                    list2.add(file2);
                }
                if (file2.isDirectory() && bl) {
                    StorageUtil.listFile(list2, file, bl, bl2);
                }
                return false;
            }
        });
        return list2;
    }

    public static List randomList(Collection collection) {
        if (collection == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(collection);
        Collections.rotate(arrayList, new SecureRandom().nextInt());
        return arrayList;
    }
}

