/*
 * Decompiled with CFR 0.152.
 */
package jet.server.tools.migration;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import jet.server.ServerEnv;
import jet.server.api.exception.NodeExistsException;
import jet.server.db.core.WorkspaceManager;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.jrc.JRDataService;
import jet.server.jrc.JRVersionService;
import jet.server.jrc.resource.ResourceToolkit;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.SecurityServiceImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.config.SecurityProvidersManagerImpl;
import jet.server.jrc.security.config.intf.SecurityProvidersManager;
import jet.server.jrc.security.config.xml.SecurityConfigurationImpl;
import jet.server.jrc.security.custom.db.SecurityDBEnv;

public class DataToolkitV6 {
    private String SEDU = null;
    private String addDataService = null;
    public Hashtable htResourceManager = new Hashtable();
    public Hashtable htSecurityService = new Hashtable();
    public Hashtable htVersionService = new Hashtable();
    public Hashtable htDataService = new Hashtable();
    private static SecurityProvidersManager addOriginalDBGetter;

    public DataToolkitV6(String string, String string2, String string3) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.SEDU = string3;
        this.addDataService = string;
        ServerEnv.propertiesPath = string2;
        ServerEnv.initEmptyServerProps();
        String string4 = ServerEnv.getReportHome();
        String string5 = string4 + File.separator + "bin";
        SecurityConfigurationImpl securityConfigurationImpl = new SecurityConfigurationImpl(string5, true);
        addOriginalDBGetter = new SecurityProvidersManagerImpl(securityConfigurationImpl, null, null);
    }

    public void addAllManager(String string, Properties properties) throws Exception {
        Properties properties2 = new Properties();
        properties2.put("active.workspace", string);
        String string2 = "file:///" + ServerEnv.getReportHome() + File.separator + "bin" + File.separator + "dbconfig.xml";
        properties2.put("datasource.realmtables", string2);
        try {
            WorkspaceManager.createInstance(properties2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        SecurityDBEnv.addOriginalDBGetter(string);
        JRDataService jRDataService = new JRDataService(string);
        UserDataToolkit.setDataService(string, jRDataService);
        JRVersionService jRVersionService = new JRVersionService(jRDataService, this.SEDU);
        ExCachedSecurityDataImpl exCachedSecurityDataImpl = new ExCachedSecurityDataImpl(string, addOriginalDBGetter);
        SecurityServiceImpl securityServiceImpl = new SecurityServiceImpl(string, exCachedSecurityDataImpl);
        ResourceTreeManagerImpl resourceTreeManagerImpl = new ResourceTreeManagerImpl(jRDataService, jRVersionService, securityServiceImpl, string);
        this.addResourceManager(string, resourceTreeManagerImpl, properties);
        this.addSecurityService(string, securityServiceImpl);
        this.addVersionService(string, jRVersionService);
        this.addDataService(string, jRDataService);
    }

    public void addResourceManager(String string, ResourceTreeManagerImpl resourceTreeManagerImpl, Properties properties) {
        try {
            resourceTreeManagerImpl.initTree();
            if (resourceTreeManagerImpl.getRoot() == null) {
                resourceTreeManagerImpl.loadDefaultTree();
            }
            System.out.println("start migrate resources in realm: " + string);
            System.out.print("in migrating");
            if (properties != null) {
                File file = new File(properties.getProperty("/"));
                ResourceToolkit.importResources(file, resourceTreeManagerImpl.getRoot(), true, false, resourceTreeManagerImpl, "JReport_System_User");
                System.out.print(">");
                String string2 = null;
                Folder folder = null;
                Node node = null;
                Hashtable<String, String> hashtable = null;
                String string3 = null;
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    string2 = properties.getProperty(string4);
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "/");
                    folder = resourceTreeManagerImpl.getRoot();
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        hashtable = new Hashtable<String, String>();
                        hashtable.put("jrs.node_name", string3);
                        try {
                            folder = resourceTreeManagerImpl.addSubFolder(folder, hashtable, "JReport_System_User");
                        }
                        catch (NodeExistsException nodeExistsException) {
                            node = folder.getChild(string3);
                            if (node.getNodeType() == 1) {
                                folder = (Folder)node;
                                continue;
                            }
                            folder = null;
                            break;
                        }
                    }
                    if (folder != null && folder != resourceTreeManagerImpl.getRoot()) {
                        ResourceToolkit.importResources(new File(string2), folder, true, false, resourceTreeManagerImpl, "JReport_System_User");
                    }
                    System.out.print(">");
                }
            }
            System.out.print("\r");
            System.out.println("complete resources migration in realm: " + string + " successfully!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.htResourceManager.put(string, resourceTreeManagerImpl);
    }

    public void removeResourceManager(String string) {
        this.htResourceManager.remove(string);
    }

    public void removeAllResourceManager() {
        this.htResourceManager.clear();
        this.htResourceManager = new Hashtable();
    }

    public ResourceTreeManagerImpl getResourceManager(String string) {
        return (ResourceTreeManagerImpl)this.htResourceManager.get(string);
    }

    public void addSecurityService(String string, SecurityServiceImpl securityServiceImpl) {
        this.htSecurityService.put(string, securityServiceImpl);
    }

    public void removeSecurityService(String string) {
        this.htSecurityService.remove(string);
    }

    public void removeAllSecurityService() {
        this.htSecurityService.clear();
        this.htSecurityService = new Hashtable();
    }

    public SecurityServiceImpl getSecurityService(String string) {
        return (SecurityServiceImpl)this.htSecurityService.get(string);
    }

    public void addVersionService(String string, JRVersionService jRVersionService) {
        this.htVersionService.put(string, jRVersionService);
    }

    public void removeVersionService(String string) {
        this.htVersionService.remove(string);
    }

    public void removeAllVersionService() {
        this.htVersionService.clear();
        this.htVersionService = new Hashtable();
    }

    public JRVersionService getVersionService(String string) {
        return (JRVersionService)this.htVersionService.get(string);
    }

    public void addDataService(String string, JRDataService jRDataService) {
        this.htDataService.put(string, jRDataService);
    }

    public void removeDataService(String string) {
        this.htDataService.remove(string);
    }

    public void removeAllDataService() {
        Enumeration enumeration = this.htDataService.elements();
        while (enumeration.hasMoreElements()) {
            ((JRDataService)enumeration.nextElement()).quit();
        }
        this.htDataService.clear();
        this.htDataService = new Hashtable();
    }

    public JRDataService getDataService(String string) {
        return (JRDataService)this.htDataService.get(string);
    }

    public void deleteFile(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray;
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            if ((stringArray = file.list()) != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(string + stringArray[i]);
                    if (file2.isDirectory()) {
                        this.deleteFile(file2.getPath());
                        continue;
                    }
                    file2.delete();
                }
            }
        }
        file.delete();
    }

    public void removeAllManager() {
        this.removeAllResourceManager();
        this.removeAllSecurityService();
        this.removeAllVersionService();
        this.removeAllDataService();
    }

    public void removeManager(String string) {
        this.removeResourceManager(string);
        this.removeSecurityService(string);
        this.removeVersionService(string);
    }
}

