/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jet.server.monitor.api.task.TaskInfo;
import jet.server.monitor.jrmon.task.JRTaskInfo;

public class CSVCreater {
    private FileOutputStream CSVEncode = null;
    private StringBuffer SEDU = null;
    private boolean append = false;
    public static final String DEL_CHAR = "\t";
    public static final String AV_CHAR = "\"";

    public CSVCreater() throws IOException {
        this.SEDU = new StringBuffer();
    }

    public CSVCreater(String string) throws IOException {
        this.CSVEncode = new FileOutputStream(string, false);
        this.SEDU = new StringBuffer();
    }

    public static String CSVEncode(String string) {
        String string2 = "";
        if (string == null) {
            return string2;
        }
        string2 = string.replaceAll("&", "&amp;");
        string2 = string2.replaceAll(AV_CHAR, "&quot;");
        return string2;
    }

    public static String CSVDecode(String string) {
        String string2 = "";
        if (string == null) {
            return string2;
        }
        string2 = string.replaceAll("&quot;", AV_CHAR);
        string2 = string2.replaceAll("&amp;", "&");
        return string2;
    }

    public void setData(String string) {
        if (this.append) {
            string = CSVCreater.CSVEncode(string);
        }
        this.SEDU.append(AV_CHAR);
        this.SEDU.append(string);
        this.SEDU.append(AV_CHAR);
        this.SEDU.append(DEL_CHAR);
    }

    public void setConvertFlag(boolean bl) {
        this.append = bl;
    }

    public void writeLine() {
        if (this.SEDU.charAt(this.SEDU.length() - 1) == '\t') {
            this.SEDU.delete(this.SEDU.length() - 1, this.SEDU.length());
        }
        this.SEDU.append("\r\n");
    }

    public void writeDataByLine(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.setData(stringArray[i]);
        }
        this.writeLine();
    }

    public void close() throws IOException {
        if (null != this.CSVEncode) {
            try {
                this.CSVEncode.write(this.SEDU.toString().getBytes());
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                this.CSVEncode.close();
            }
        }
    }

    public void writeTaskInfo(TaskInfo taskInfo) {
        this.setData(taskInfo.getTaskID());
        String string = taskInfo.getReportName();
        string = null == string ? "(New)" : string;
        this.setData(string);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = taskInfo.getReportSource();
        if (null != string2) {
            stringBuffer.append(string2);
        }
        List list = ((JRTaskInfo)taskInfo).getReportSources();
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append((String)list.get(i));
        }
        this.setData(stringBuffer.toString());
        this.setData(taskInfo.getTaskType());
        this.setData(taskInfo.getTaskStatus());
        this.setData(String.valueOf(taskInfo.getReportPages()));
        this.setData(taskInfo.getReason());
        this.setData(new Timestamp(taskInfo.getSubmittedTime()).toString());
        this.setData(new Timestamp(taskInfo.getStartedTime()).toString());
        this.setData(new Timestamp(taskInfo.getFinishedTime()).toString());
        Map map = ((JRTaskInfo)taskInfo).getParameters();
        Iterator iterator = map.keySet().iterator();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = map.get(string3).toString();
            stringBuffer2.append(",").append(string3).append(":").append(string4);
        }
        if (0 < map.size()) {
            this.setData(stringBuffer2.substring(1));
        } else {
            this.setData("");
        }
        this.writeLine();
    }

    public String getContent() {
        return this.SEDU.toString();
    }
}

