/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final char SEDU = '.';
    private static final char TYPE = '$';
    private static final String add = "$$";
    private static final Map append = new HashMap(8);
    private static final Map classPackageAsResourcePath = new HashMap(8);

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtils.class.getClassLoader();
        }
        return classLoader;
    }

    public static boolean isPresent(String string) {
        try {
            ClassUtils.forName(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return ClassUtils.forName(string, ClassUtils.getDefaultClassLoader());
    }

    public static Class forName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = ClassUtils.resolvePrimitiveClassName(string);
        if (clazz != null) {
            return clazz;
        }
        if (string.endsWith(ARRAY_SUFFIX)) {
            String string2 = string.substring(0, string.length() - ARRAY_SUFFIX.length());
            Class clazz2 = ClassUtils.forName(string2, classLoader);
            return Array.newInstance(clazz2, 0).getClass();
        }
        return Class.forName(string, true, classLoader);
    }

    public static Class resolvePrimitiveClassName(String string) {
        Class clazz = null;
        if (string != null && string.length() <= 8) {
            clazz = (Class)classPackageAsResourcePath.get(string);
        }
        return clazz;
    }

    public static String getShortName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Class name must not be empty");
        }
        int n = string.lastIndexOf(46);
        int n2 = string.indexOf(add);
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(n + 1, n2);
        string2 = string2.replace('$', '.');
        return string2;
    }

    public static String getShortName(Class clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class clazz) {
        return Introspector.decapitalize(ClassUtils.getShortName(clazz));
    }

    public static String getQualifiedName(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (clazz.isArray()) {
            return ClassUtils.SEDU(clazz);
        }
        return clazz.getName();
    }

    public static String getQualifiedMethodName(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        return method.getDeclaringClass().getName() + "." + method.getName();
    }

    public static boolean hasMethod(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        try {
            clazz.getMethod(string, classArray);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static int getMethodCountForName(Class clazz, String string) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        int n = 0;
        do {
            for (int i = 0; i < clazz.getDeclaredMethods().length; ++i) {
                Method method = clazz.getDeclaredMethods()[i];
                if (!string.equals(method.getName())) continue;
                ++n;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return n;
    }

    public static boolean hasAtLeastOneMethodWithName(Class clazz, String string) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        do {
            for (int i = 0; i < clazz.getDeclaredMethods().length; ++i) {
                Method method = clazz.getDeclaredMethods()[i];
                if (!method.getName().equals(string)) continue;
                return true;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return false;
    }

    public static Method getStaticMethod(Class clazz, String string, Class[] classArray) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Method name must not be null");
        }
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            if ((method.getModifiers() & 8) != 0) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        return null;
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        return append.containsKey(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveArray(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        return clazz.isArray() && ClassUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static boolean isAssignable(Class clazz, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("Target type must not be null");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("Value type must not be null");
        }
        return clazz.isAssignableFrom(clazz2) || clazz.equals(append.get(clazz2));
    }

    public static boolean isAssignableValue(Class clazz, Object object) {
        if (clazz == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        return object != null ? ClassUtils.isAssignable(clazz, object.getClass()) : !clazz.isPrimitive();
    }

    public static String addResourcePathToPackagePath(Class clazz, String string) {
        if (string == null) {
            throw new IllegalArgumentException("Resource name must not be null");
        }
        if (!string.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + "/" + string;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + string;
    }

    public static String classPackageAsResourcePath(Class clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static Class[] getAllInterfaces(Object object) {
        Set set = ClassUtils.getAllInterfacesAsSet(object);
        return set.toArray(new Class[set.size()]);
    }

    public static Class[] getAllInterfacesForClass(Class clazz) {
        Set set = ClassUtils.getAllInterfacesForClassAsSet(clazz);
        return set.toArray(new Class[set.size()]);
    }

    public static Set getAllInterfacesAsSet(Object object) {
        return ClassUtils.getAllInterfacesForClassAsSet(object.getClass());
    }

    public static Set getAllInterfacesForClassAsSet(Class clazz) {
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        HashSet hashSet = new HashSet();
        while (clazz != null) {
            for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                Class<?> clazz2 = clazz.getInterfaces()[i];
                hashSet.add(clazz2);
            }
            clazz = clazz.getSuperclass();
        }
        return hashSet;
    }

    private static String SEDU(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            stringBuffer.append(ARRAY_SUFFIX);
        }
        stringBuffer.insert(0, clazz.getName());
        return stringBuffer.toString();
    }

    static {
        append.put(Boolean.class, Boolean.TYPE);
        append.put(Byte.class, Byte.TYPE);
        append.put(Character.class, Character.TYPE);
        append.put(Double.class, Double.TYPE);
        append.put(Float.class, Float.TYPE);
        append.put(Integer.class, Integer.TYPE);
        append.put(Long.class, Long.TYPE);
        append.put(Short.class, Short.TYPE);
        for (Class clazz : append.values()) {
            classPackageAsResourcePath.put(clazz.getName(), clazz);
        }
    }
}

