/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jet.server.util.WebSecurityUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter {
    private static boolean SEDU = false;
    private static boolean append = true;
    private static String charAt = "UTF-8";

    public static void write(Document document, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        XMLWriter.print(document, stringBuffer, 0);
        XMLWriter.write(string, stringBuffer.toString());
    }

    public static byte[] write(Document document) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        XMLWriter.print(document, stringBuffer, 0);
        return stringBuffer.toString().getBytes(charAt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String string, String string2) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(WebSecurityUtil.validateFilePath(string)), charAt));
            bufferedWriter.write(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void print(Node node, StringBuffer stringBuffer, int n) {
        if (node == null) {
            return;
        }
        boolean bl = true;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                if (!SEDU) {
                    stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append(charAt).append("\"?>");
                }
                XMLWriter.print(((Document)node).getDocumentElement(), stringBuffer, n);
                break;
            }
            case 1: {
                stringBuffer.append("\r\n");
                for (int i = 0; i < 4 * n; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append("<");
                if (append) {
                    stringBuffer.append(node.getNodeName());
                } else {
                    stringBuffer.append(node.getLocalName());
                }
                Attr[] attrArray = XMLWriter.SEDU(node.getAttributes());
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    stringBuffer.append(' ');
                    if (append) {
                        stringBuffer.append(attr.getNodeName());
                    } else {
                        stringBuffer.append(attr.getLocalName());
                    }
                    stringBuffer.append("=\"");
                    stringBuffer.append(XMLWriter.append(attr.getNodeValue()));
                    stringBuffer.append('\"');
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null || nodeList.getLength() == 0) {
                    bl = false;
                    stringBuffer.append(' ').append("/>");
                    break;
                }
                stringBuffer.append('>');
                int n2 = nodeList.getLength();
                if (n2 == 1 && nodeList.item(0).getNodeType() == 3) {
                    XMLWriter.print(nodeList.item(0), stringBuffer, 0);
                    stringBuffer.append("</");
                    if (append) {
                        stringBuffer.append(node.getNodeName());
                    } else {
                        stringBuffer.append(node.getLocalName());
                    }
                    stringBuffer.append('>');
                    bl = false;
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    XMLWriter.print(nodeList.item(i), stringBuffer, n + 1);
                }
                break;
            }
            case 5: {
                if (SEDU) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    int n3 = nodeList.getLength();
                    for (int i = 0; i < n3; ++i) {
                        XMLWriter.print(nodeList.item(i), stringBuffer, n + 1);
                    }
                    break;
                }
                stringBuffer.append('&');
                if (append) {
                    stringBuffer.append(node.getNodeName());
                } else {
                    stringBuffer.append(node.getLocalName());
                }
                stringBuffer.append(';');
                break;
            }
            case 4: {
                if (SEDU) {
                    stringBuffer.append(XMLWriter.append(node.getNodeValue()));
                    break;
                }
                stringBuffer.append("\r\n<![CDATA[");
                stringBuffer.append(node.getNodeValue());
                stringBuffer.append("]]>");
                break;
            }
            case 3: {
                stringBuffer.append(XMLWriter.append(node.getNodeValue()));
                break;
            }
            case 7: {
                stringBuffer.append("\r\n");
                for (int i = 0; i < 4 * n; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append("<?");
                if (append) {
                    stringBuffer.append(node.getNodeName());
                } else {
                    stringBuffer.append(node.getLocalName());
                }
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string);
                }
                stringBuffer.append("?>");
                break;
            }
            case 8: {
                stringBuffer.append("\r\n");
                for (int i = 0; i < 4 * n; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append("<!-- ").append(node.getNodeValue()).append(" -->");
            }
        }
        if (bl && s == 1) {
            stringBuffer.append("\r\n");
            for (int i = 0; i < 4 * n; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("</");
            if (append) {
                stringBuffer.append(node.getNodeName());
            } else {
                stringBuffer.append(node.getLocalName());
            }
            stringBuffer.append('>');
        }
    }

    private static Attr[] SEDU(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = null;
            string = append ? attrArray[n].getNodeName() : attrArray[n].getLocalName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = null;
                string2 = append ? attrArray[i].getNodeName() : attrArray[i].getLocalName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    private static String append(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (SEDU) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        continue block7;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

