/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util;

import com.ice.tar.TarEntry;
import com.ice.tar.TarInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jet.server.util.WebSecurityUtil;

public class ZipTools {
    private static final int SEDU = 65536;
    private static final int append = -1;
    private static final int close = 0;
    private static final int contains = 1;
    private static final int endsWith = 2;
    private static final int equals = 3;
    private static final int exists = 4;
    private static final int getName = 5;
    private static final int getNextEntry = 6;

    private ZipTools() {
    }

    public static void unzip(String string, String string2, boolean bl) throws IOException, FileNotFoundException {
        int n = ZipTools.contains(string);
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                ZipTools.append(n, string, string2, bl);
                break;
            }
            case 1: {
                ZipTools.close(string, string2, bl);
                break;
            }
            default: {
                ZipTools.SEDU(string, string2, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipZIP(ZipInputStream zipInputStream, String string, boolean bl) throws IOException, FileNotFoundException {
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    ZipTools.getName(zipInputStream, ZipTools.equals(zipEntry.getName(), string, bl));
                    continue;
                }
                if (!bl) continue;
                ZipTools.exists(zipEntry.getName(), string);
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    private static void SEDU(String string, String string2, boolean bl) throws IOException, FileNotFoundException {
        ZipTools.unzipZIP(new ZipInputStream(new BufferedInputStream(new FileInputStream(string))), string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void append(int n, String string, String string2, boolean bl) throws IOException, FileNotFoundException {
        TarInputStream tarInputStream = null;
        try {
            tarInputStream = ZipTools.endsWith(n, string);
            TarEntry tarEntry = null;
            while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                if (!tarEntry.isDirectory()) {
                    ZipTools.getName((InputStream)tarInputStream, ZipTools.equals(tarEntry.getName(), string2, bl));
                    continue;
                }
                if (!bl) continue;
                ZipTools.exists(tarEntry.getName(), string2);
            }
        }
        finally {
            if (tarInputStream != null) {
                tarInputStream.close();
                tarInputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(String string, String string2, boolean bl) throws IOException, FileNotFoundException {
        InputStream inputStream = null;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(string));
            String string3 = new File(string).getName().toLowerCase();
            int n = string3.lastIndexOf(46);
            ZipTools.getName(inputStream, ZipTools.equals(string3.substring(0, n), string2, bl));
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
        }
    }

    private static int contains(String string) {
        int n = -1;
        String string2 = string.trim().toLowerCase();
        if (string2.endsWith(".tar.gz") || string2.endsWith(".tgz")) {
            n = 3;
        } else if (string2.endsWith(".tar.zip")) {
            n = 6;
        } else if (string2.endsWith(".tar")) {
            n = 4;
        } else if (string2.endsWith(".gz") || string2.endsWith(".gzip")) {
            n = 1;
        } else if (string2.endsWith(".zip")) {
            n = 0;
        } else if (string2.endsWith(".jar")) {
            n = 5;
        }
        return n;
    }

    private static TarInputStream endsWith(int n, String string) throws IOException {
        InputStream inputStream = null;
        switch (n) {
            case 3: {
                inputStream = new GZIPInputStream(new FileInputStream(string));
                break;
            }
            case 6: {
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                inputStream = zipInputStream;
                break;
            }
            default: {
                inputStream = new FileInputStream(string);
            }
        }
        return new TarInputStream(inputStream);
    }

    private static String equals(String string, String string2, boolean bl) {
        String string3 = null;
        if (bl) {
            File file;
            string3 = string;
            if (string3.startsWith("/") || string3.startsWith("\\")) {
                string3 = string3.substring(1);
            }
            string3 = string2 + string3;
            if (File.separator.equals("/") && string3.contains("\\")) {
                string3 = string3.replace("\\", "/");
            } else if (File.separator.equals("\\") && string3.contains("/")) {
                string3 = string3.replace("/", "\\");
            }
            String string4 = new File(string3).getParent();
            if (string4 != null && string4.length() > 0 && !(file = new File(string4)).exists()) {
                boolean bl2 = file.mkdirs();
            }
        } else {
            string3 = WebSecurityUtil.validateFilePathStr(string2 + new File(string).getName());
        }
        return string3;
    }

    private static void exists(String string, String string2) {
        File file;
        String string3 = string;
        if (string3.startsWith("/") || string3.startsWith("\\")) {
            string3 = string3.substring(1);
        }
        if (!(file = WebSecurityUtil.validateFilePath(string3 = string2 + string3)).exists()) {
            boolean bl = file.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getName(InputStream inputStream, String string) throws IOException, FileNotFoundException {
        OutputStream outputStream = null;
        try {
            int n;
            outputStream = new BufferedOutputStream(new FileOutputStream(WebSecurityUtil.validateFilePath(string)));
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

