/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.ui;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.api.http.HttpUtil;
import jet.server.intf.security.Comparator;
import jet.server.jrc.security.Sorter;
import jet.server.log.ServiceLogger;
import jet.server.util.XMLWriter;
import jet.server.util.ui.UINode;
import jet.server.util.ui.UINodeComparator;
import jet.server.util.ui.UITree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UITreeXMLWriter {
    String outputDir = "";
    UITree tree = null;
    private Document SEDU;

    public UITreeXMLWriter() {
    }

    public UITreeXMLWriter(UITree uITree, String string) {
        this.tree = uITree;
        this.outputDir = string;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.SEDU = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ServiceLogger.logError(parserConfigurationException);
        }
    }

    public boolean writeXml(OutputStream outputStream) {
        this.SEDU();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            XMLWriter.print(this.SEDU, stringBuffer, 0);
            outputStream.write(stringBuffer.toString().getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
            return false;
        }
        return true;
    }

    public boolean writeXml() {
        this.SEDU();
        try {
            XMLWriter.write(this.SEDU, this.outputDir);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
            return false;
        }
        return true;
    }

    private void SEDU() {
        UINode uINode = this.tree.getRoot();
        String string = uINode.getNodeName();
        String string2 = HttpUtil.encodeEsc(uINode.getNodeId());
        String string3 = uINode.getNodeType();
        String string4 = uINode.getPermissions();
        String string5 = String.valueOf(uINode.getLevel());
        Element element = this.SEDU.createElement("root");
        element.setAttribute("id", string2);
        element.setAttribute("nodename", string);
        element.setAttribute("nodetype", string3);
        element.setAttribute("permissions", string4);
        element.setAttribute("level", string5);
        this.SEDU.appendChild(element);
        Vector vector = uINode.getChildren();
        if (vector != null) {
            for (UINode uINode2 : vector) {
                this.writeXmlNode(element, uINode2);
            }
        }
    }

    public void writeXmlNode(Element element, UINode uINode) {
        Vector<String> vector = new Vector<String>();
        String string = uINode.getNodeName();
        String string2 = HttpUtil.encodeEsc(uINode.getNodeId());
        String string3 = uINode.getNodeType();
        String string4 = uINode.getPermissions();
        String string5 = String.valueOf(uINode.getLevel());
        vector.add(string2);
        vector.add(string);
        vector.add(string3);
        vector.add(string4);
        vector.add(string5);
        Element element2 = this.SEDU.createElement("node");
        element2.setAttribute("id", string2);
        element2.setAttribute("nodename", string);
        element2.setAttribute("nodetype", string3);
        element2.setAttribute("permissions", string4);
        element2.setAttribute("level", string5);
        element.appendChild(element2);
        Vector vector2 = uINode.getChildren();
        if (vector2 != null) {
            UINodeComparator uINodeComparator = new UINodeComparator();
            Sorter.sort(vector2, (Comparator)uINodeComparator);
            for (UINode uINode2 : vector2) {
                this.writeXmlNode(element2, uINode2);
            }
        }
    }
}

