/*
 * Decompiled with CFR 0.152.
 */
package jet.server.util.webxml;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import jet.server.util.ServletContextResource;
import jet.server.util.webxml.ServletHandler;
import jet.server.util.webxml.ServletMapping;
import jet.server.util.webxml.XmlParser;
import org.xml.sax.InputSource;

public class WebXml {
    protected XmlParser _xmlParser = WebXml.webXmlParser();
    protected Map servletMappings = new HashMap();
    protected Map servletNameMap = new HashMap();
    protected Map servletClassMap = new HashMap();
    private static WebXml SEDU = null;
    protected ServletContext servletContext;
    private Properties add = null;

    private WebXml(ServletContext servletContext) {
        this.servletContext = servletContext;
        try {
            this.configure();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static WebXml getInstance() {
        if (SEDU == null) {
            SEDU = new WebXml(null);
        }
        return SEDU;
    }

    public static WebXml getInstance(ServletContext servletContext) {
        if (SEDU == null || SEDU.getServletContext() == null) {
            SEDU = new WebXml(servletContext);
        }
        return SEDU;
    }

    public static XmlParser webXmlParser() {
        XmlParser xmlParser = new XmlParser();
        URL uRL = WebXml.class.getResource("/jet/server/util/webxml/resources/web-app_2_2.dtd");
        URL uRL2 = WebXml.class.getResource("/jet/server/util/webxml/resources/web-app_2_3.dtd");
        URL uRL3 = WebXml.class.getResource("/jet/server/util/webxml/resources/jsp_2_0.xsd");
        URL uRL4 = WebXml.class.getResource("/jet/server/util/webxml/resources/jsp_2_1.xsd");
        URL uRL5 = WebXml.class.getResource("/jet/server/util/webxml/resources/j2ee_1_4.xsd");
        URL uRL6 = WebXml.class.getResource("/jet/server/util/webxml/resources/web-app_2_4.xsd");
        URL uRL7 = WebXml.class.getResource("/jet/server/util/webxml/resources/web-app_2_5.xsd");
        URL uRL8 = WebXml.class.getResource("/jet/server/util/webxml/resources/XMLSchema.dtd");
        URL uRL9 = WebXml.class.getResource("/jet/server/util/webxml/resources/xml.xsd");
        URL uRL10 = WebXml.class.getResource("/jet/server/util/webxml/resources/j2ee_web_services_client_1_1.xsd");
        URL uRL11 = WebXml.class.getResource("/jet/server/util/webxml/resources/javaee_web_services_client_1_2.xsd");
        URL uRL12 = WebXml.class.getResource("/jet/server/util/webxml/resources/datatypes.dtd");
        xmlParser.redirectEntity("web-app_2_2.dtd", uRL);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", uRL);
        xmlParser.redirectEntity("web.dtd", uRL2);
        xmlParser.redirectEntity("web-app_2_3.dtd", uRL2);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", uRL2);
        xmlParser.redirectEntity("XMLSchema.dtd", uRL8);
        xmlParser.redirectEntity("http://www.w3.org/2001/XMLSchema.dtd", uRL8);
        xmlParser.redirectEntity("-//W3C//DTD XMLSCHEMA 200102//EN", uRL8);
        xmlParser.redirectEntity("jsp_2_0.xsd", uRL3);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", uRL3);
        xmlParser.redirectEntity("jsp_2_1.xsd", uRL4);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", uRL4);
        xmlParser.redirectEntity("j2ee_1_4.xsd", uRL5);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", uRL5);
        xmlParser.redirectEntity("web-app_2_4.xsd", uRL6);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", uRL6);
        xmlParser.redirectEntity("web-app_2_5.xsd", uRL7);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", uRL7);
        xmlParser.redirectEntity("xml.xsd", uRL9);
        xmlParser.redirectEntity("http://www.w3.org/2001/xml.xsd", uRL9);
        xmlParser.redirectEntity("datatypes.dtd", uRL12);
        xmlParser.redirectEntity("http://www.w3.org/2001/datatypes.dtd", uRL12);
        xmlParser.redirectEntity("j2ee_web_services_client_1_1.xsd", uRL10);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", uRL10);
        xmlParser.redirectEntity("javaee_web_services_client_1_2.xsd", uRL11);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", uRL11);
        return xmlParser;
    }

    public void configure() throws Exception {
        ServletContextResource servletContextResource = new ServletContextResource(this.servletContext, "WEB-INF/web.xml");
        XmlParser.Node node = null;
        node = this._xmlParser.parse(servletContextResource.getInputStream());
        this.initialize(node);
    }

    public void configure(InputSource inputSource) throws Exception {
        XmlParser.Node node = null;
        node = this._xmlParser.parse(inputSource);
        this.initialize(node);
    }

    public void configure(String string) throws Exception {
        XmlParser.Node node = null;
        node = this._xmlParser.parse(string);
        this.initialize(node);
    }

    protected void initialize(XmlParser.Node node) throws ClassNotFoundException, UnavailableException {
        Iterator iterator = node.iterator();
        XmlParser.Node node2 = null;
        while (iterator.hasNext()) {
            try {
                Object e = iterator.next();
                if (!(e instanceof XmlParser.Node)) continue;
                node2 = (XmlParser.Node)e;
                String string = node2.getTag();
                this.initWebXmlElement(string, node2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Exception exception) {
                throw new UnavailableException("Configuration problem");
            }
        }
    }

    protected void initWebXmlElement(String string, XmlParser.Node node) throws Exception {
        if ("servlet".equals(string)) {
            this.initServlet(node);
        } else if ("servlet-mapping".equals(string)) {
            this.initServletMapping(node);
        }
    }

    protected void initServlet(XmlParser.Node node) {
        String string = node.getString("servlet-name", false, true);
        String string2 = node.getString("servlet-class", false, true);
        ServletHandler servletHandler = new ServletHandler();
        servletHandler.setServletName(string);
        servletHandler.setServletClass(string2);
        this.servletNameMap.put(string, servletHandler);
        this.servletClassMap.put(string2, servletHandler);
    }

    protected void initServletMapping(XmlParser.Node node) {
        String string = node.getString("servlet-name", false, true);
        ServletMapping servletMapping = new ServletMapping();
        servletMapping.setServletName(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = node.iterator("url-pattern");
        while (iterator.hasNext()) {
            String string2 = ((XmlParser.Node)iterator.next()).toString(false, true);
            arrayList.add(string2);
        }
        servletMapping.setPathSpecs(arrayList.toArray(new String[arrayList.size()]));
        this.servletMappings.put(string, servletMapping);
    }

    public Map getServletMappings() {
        return this.servletMappings;
    }

    public void setServletMappings(Map map) {
        this.servletMappings = map;
    }

    public Map getServlets() {
        return this.servletNameMap;
    }

    public void setServlets(Map map) {
        this.servletNameMap = map;
    }

    public Map getServletClassMap() {
        return this.servletClassMap;
    }

    public void setServletClassMap(Map map) {
        this.servletClassMap = map;
    }

    public Map getServletNameMap() {
        return this.servletNameMap;
    }

    public void setServletNameMap(Map map) {
        this.servletNameMap = map;
    }

    public String getPathByServletClass(String string) {
        try {
            String string2 = ((ServletHandler)this.servletClassMap.get(string)).getServletName();
            String string3 = ((ServletMapping)this.servletMappings.get(string2)).getPathSpecs()[0].trim();
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            if (string3.endsWith("*")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if (string3.endsWith("/")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            return string3;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getContextPath() {
        if (this.servletContext == null) {
            return "";
        }
        String string = this.servletContext.getServletContextName();
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getContextPath(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return this.getContextPath();
        }
        return httpServletRequest.getContextPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPathByProperty(String string) {
        try {
            if (this.add != null) {
                if (this.add.size() != 0) return this.add.getProperty(string);
            }
            ServletContextResource servletContextResource = new ServletContextResource(this.servletContext, "WEB-INF/jrserver.properties");
            InputStream inputStream = null;
            try {
                this.add = new Properties();
                inputStream = servletContextResource.getInputStream();
                this.add.load(inputStream);
                return this.add.getProperty(string);
            }
            catch (Exception exception) {
                String string2 = null;
                return string2;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception3) {}
                }
            }
        }
        catch (Throwable throwable2) {
            return null;
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

