/*
 * Decompiled with CFR 0.152.
 */
package jet.web.dhtml;

import com.jinfonet.util.JDLog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import jet.JDException;
import jet.rptservice.exception.JRSInvalidParameterException;
import jet.server.api.admin.cfg.ConfigurationCache;
import jet.server.api.http.HttpUtil;
import jet.web.dhtml.DHTMLRunTimeReportInfo;
import jet.web.dhtml.DHTMLService;
import jet.web.dhtml.DHTMLServiceBase;
import jet.web.dhtml.RunTimeReportInfo;

public class DHTMLOpenTaskManager {
    private Hashtable SEDU = new Hashtable();
    private Hashtable add = new Hashtable();
    public int engine_doSort_bufferSize;

    DHTMLOpenTaskManager() {
        ConfigurationCache configurationCache = HttpUtil.getHttpRptServer().getAdminService().getConfigService().getConfigurationCache();
        this.engine_doSort_bufferSize = configurationCache.getEngineSortBufferSize();
    }

    public void updateRunTimeReportInfo(String string, RunTimeReportInfo runTimeReportInfo) {
        if (this.SEDU.containsValue(runTimeReportInfo) && this.SEDU.remove(string) == runTimeReportInfo) {
            this.registerRunTimeReportInfo(runTimeReportInfo);
        }
    }

    public void registerRunTimeReportInfo(RunTimeReportInfo runTimeReportInfo) {
        this.SEDU.put(runTimeReportInfo.getOpenTaskId(), runTimeReportInfo);
    }

    public void unregisterRunTimeReportInfo(RunTimeReportInfo runTimeReportInfo) {
        this.SEDU.remove(runTimeReportInfo.getOpenTaskId());
        runTimeReportInfo.notifyDelete();
    }

    public void rescindRunTimeReportInfo(String string) {
        if (string != null) {
            RunTimeReportInfo runTimeReportInfo = this.getRunTimeReportInfo(string);
            if (runTimeReportInfo != null) {
                this.unregisterRunTimeReportInfo(runTimeReportInfo);
            } else {
                this.SEDU.remove(string);
            }
        }
    }

    public RunTimeReportInfo getRunTimeReportInfo(String string) {
        return (RunTimeReportInfo)this.SEDU.get(string);
    }

    public void closeBackgroundReport(String string, String string2, boolean bl) {
        RunTimeReportInfo runTimeReportInfo = this.getRunTimeReportInfo(string2);
        if (runTimeReportInfo == null || !runTimeReportInfo.isBackground()) {
            return;
        }
        try {
            String string3 = runTimeReportInfo.getRptSetId();
            DHTMLService.getInstance().closeReportSet(string2, string3);
            if (bl) {
                this.registerRunTimeReportInfo(runTimeReportInfo);
            } else {
                this.rescindRunTimeReportInfo(string2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean stopProcessingBackgroundReport(String string, String string2) {
        RunTimeReportInfo runTimeReportInfo = this.getRunTimeReportInfo(string2);
        if (runTimeReportInfo.runFinish()) {
            return false;
        }
        runTimeReportInfo.setBeStopped();
        this.closeBackgroundReport(string, string2, true);
        this.getRunTimeReportInfo(string2).init();
        this.getRunTimeReportInfo(string2).updateServerBackgroundTaskList("stopped");
        return true;
    }

    public Vector getRunningReportsInfo(String string) {
        Vector<DHTMLRunTimeReportInfo> vector = new Vector<DHTMLRunTimeReportInfo>();
        Enumeration enumeration = this.SEDU.elements();
        while (enumeration.hasMoreElements()) {
            RunTimeReportInfo runTimeReportInfo = (RunTimeReportInfo)enumeration.nextElement();
            if (string != null && !runTimeReportInfo.userName.equals(string)) continue;
            vector.add(runTimeReportInfo.getDHTMLRunTimeReportInfo());
        }
        return vector;
    }

    public void saveRunEngineParameter(Hashtable hashtable) {
        String string = (String)hashtable.get("rpt_set_id");
        String string2 = (String)hashtable.get("sessionid");
        RunTimeReportInfo runTimeReportInfo = this.getRunTimeReportInfo(string2);
        if (runTimeReportInfo != null) {
            runTimeReportInfo.setDsRunParameter(hashtable);
        }
    }

    public boolean getPpromptMsgAgain(String string) {
        String string2 = (String)this.add.get(string);
        if (string2 != null) {
            return Boolean.valueOf(string2);
        }
        return true;
    }

    public void setPpromptMsgAgain(String string, String string2) {
        if (this.add.containsKey(string)) {
            this.add.remove(string);
        }
        this.add.put(string, string2);
    }

    private Map SEDU(String string, int n) throws Exception {
        RunTimeReportInfo runTimeReportInfo = this.getRunTimeReportInfo(string);
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 30000L) {
            Object object;
            if (runTimeReportInfo.runFinish()) {
                if (runTimeReportInfo.e != null) {
                    object = DHTMLService.getInstance();
                    ((DHTMLServiceBase)object).closeReportSet(runTimeReportInfo.getSessionId(), runTimeReportInfo.getRptSetId());
                    throw runTimeReportInfo.e;
                }
                return runTimeReportInfo.map;
            }
            object = runTimeReportInfo.getOpenReportStatusListener().getNotifyMessage(n);
            if (object == null) {
                Thread.currentThread();
                Thread.sleep(300L);
                continue;
            }
            return object;
        }
        return null;
    }

    public Map OpenAndGetReportInfo(Hashtable hashtable) throws JDException {
        try {
            boolean bl;
            boolean bl2 = (String)hashtable.get("use_thread_run") != null;
            boolean bl3 = bl = (String)hashtable.get("only_get_info") != null;
            if (bl) {
                String string = (String)hashtable.get("j$vm_pid");
                String string2 = (String)hashtable.get("lastStep");
                return this.SEDU(string, Integer.parseInt(string2));
            }
            if (bl2) {
                hashtable.remove("use_thread_run");
                RunTimeReportInfo runTimeReportInfo = new RunTimeReportInfo(hashtable);
                this.registerRunTimeReportInfo(runTimeReportInfo);
                runTimeReportInfo.start();
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                hashtable2.put("j$vm_pid", runTimeReportInfo.getOpenTaskId());
                return hashtable2;
            }
            RunTimeReportInfo runTimeReportInfo = new RunTimeReportInfo(hashtable);
            this.registerRunTimeReportInfo(runTimeReportInfo);
            return runTimeReportInfo.openReport();
        }
        catch (Exception exception) {
            if (JDLog.isError((int)2)) {
                JDLog.error((int)2, (int)2910235, (Throwable)exception);
            }
            throw new JDException((Throwable)exception);
        }
    }

    public void notify_change_engine_dosort_buffer_size(int n) {
        this.engine_doSort_bufferSize = n;
        DHTMLService dHTMLService = DHTMLService.getInstance();
        Enumeration enumeration = this.SEDU.elements();
        while (enumeration.hasMoreElements()) {
            RunTimeReportInfo runTimeReportInfo = (RunTimeReportInfo)enumeration.nextElement();
            String string = runTimeReportInfo.getRptSetId();
            try {
                dHTMLService.ds.setSortMemorySize(string, this.engine_doSort_bufferSize);
            }
            catch (JRSInvalidParameterException jRSInvalidParameterException) {
                if (!JDLog.isError((int)2)) continue;
                JDLog.error((int)2, (Throwable)jRSInvalidParameterException);
            }
        }
    }
}

