/*
 * Decompiled with CFR 0.152.
 */
package jet.web.dhtml.scene.filter;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import jet.JRException;
import jet.JResource;
import jet.connect.DbValue;
import jet.rptservice.design.ResourceNameInfo;
import jet.universe.businesslogic.BLContainer;
import jet.universe.businesslogic.BLNode;
import jet.universe.businesslogic.JUnifiedBusinessView;
import jet.util.DbValueFormat;
import jet.util.nls.INLSMap;
import jet.web.dhtml.DHTMLService;
import jet.web.dhtml.DataTools;
import jet.web.dhtml.pro.E;
import jet.web.dhtml.scene.bcfilter.BCFilterScene;
import jet.web.dhtml.scene.filter.Editor;
import jet.web.dhtml.scene.filter.FilterValue;
import jet.web.dhtml.scene.filter.Resource;

public class Tools {
    public static Resource buildTreeFromSameCub(Vector vector, String string, String string2) {
        Resource resource;
        if (vector == null || vector.size() == 0) {
            resource = new Resource();
        } else {
            BLContainer bLContainer = Tools.SEDU((ResourceNameInfo)vector.get(0));
            DHTMLService dHTMLService = DHTMLService.getInstance();
            INLSMap iNLSMap = dHTMLService.getINLSMap(string, string2);
            dHTMLService.setINLSMap(iNLSMap);
            Map map = dHTMLService.getDynamicBVElementDisplayName(string, string2);
            dHTMLService.setDyBVDisNames(map);
            resource = Tools.L(bLContainer, vector, string, string2, bLContainer.getDatabase().name.get());
            dHTMLService.clearThreadLocal();
            if (resource == null) {
                return new Resource("");
            }
        }
        return resource;
    }

    private static Resource L(BLContainer bLContainer, Vector vector, String string, String string2, String string3) {
        DHTMLService dHTMLService = DHTMLService.getInstance();
        String string4 = dHTMLService.getMetaNLSString((BLNode)bLContainer, string3);
        Resource resource = new Resource(string4);
        BLNode[] bLNodeArray = bLContainer.getBLChildren();
        if (bLNodeArray != null && bLNodeArray.length > 0) {
            for (BLNode bLNode : bLNodeArray) {
                Resource resource2 = null;
                int n = bLNode.getElementType();
                switch (n) {
                    case 3: {
                        resource2 = Tools.L((BLContainer)bLNode, vector, string, string2, string3);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        resource2 = Tools.add(bLNode, vector, dHTMLService, string, string2, string3);
                        break;
                    }
                }
                if (resource2 == null) continue;
                resource.addChild(resource2);
            }
        }
        if (resource.hasChildren()) {
            return resource;
        }
        return null;
    }

    private static BLContainer SEDU(ResourceNameInfo resourceNameInfo) {
        BLNode bLNode = resourceNameInfo.getNode();
        JUnifiedBusinessView jUnifiedBusinessView = bLNode.getUbv();
        return jUnifiedBusinessView;
    }

    public static boolean isFilterableSQLType(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    private static Resource add(BLNode bLNode, Vector vector, DHTMLService dHTMLService, String string, String string2, String string3) {
        ResourceNameInfo resourceNameInfo = Tools.addAll(vector, bLNode);
        if (resourceNameInfo == null) {
            return null;
        }
        if (Tools.isFilterableSQLType(resourceNameInfo.getSqlType())) {
            return null;
        }
        Resource resource = new Resource();
        resource.setId(resourceNameInfo.getBlColumnName());
        String string4 = dHTMLService.getMetaNLSString(bLNode, string3);
        resource.setDisplayName(string4);
        resource.setSqlType(resourceNameInfo.getSqlType());
        String string5 = BCFilterScene.getDefaultInputFormat(resourceNameInfo.getSqlType(), string);
        resource.setInputFormat(string5);
        resource.setHandle(resourceNameInfo.getBlColumnName());
        resource.setFormula(resourceNameInfo.isBasedOnFormula());
        int n = bLNode.getElementType();
        switch (n) {
            case 4: {
                resource.setResourceType(1);
                break;
            }
            case 5: {
                resource.setResourceType(2);
                break;
            }
            case 7: {
                resource.setResourceType(3);
                break;
            }
        }
        return resource;
    }

    private static ResourceNameInfo addAll(Vector vector, BLNode bLNode) {
        for (int i = vector.size() - 1; i >= 0; --i) {
            ResourceNameInfo resourceNameInfo = (ResourceNameInfo)vector.get(i);
            if (bLNode != resourceNameInfo.getNode()) continue;
            return resourceNameInfo;
        }
        return null;
    }

    public static Resource buildTreeFromSameCub2(List list, String string, String string2) {
        Resource resource;
        if (list == null || list.size() == 0) {
            resource = new Resource();
        } else {
            BLContainer bLContainer = Tools.children((Resource)list.get(0));
            DHTMLService dHTMLService = DHTMLService.getInstance();
            INLSMap iNLSMap = dHTMLService.getINLSMap(string, string2);
            dHTMLService.setINLSMap(iNLSMap);
            Map map = dHTMLService.getDynamicBVElementDisplayName(string, string2);
            dHTMLService.setDyBVDisNames(map);
            resource = Tools.addChild(bLContainer, list, string, string2);
            dHTMLService.clearThreadLocal();
        }
        return resource;
    }

    private static Resource addChild(BLContainer bLContainer, List list, String string, String string2) {
        String string3 = bLContainer.getDisplayName();
        if (string3 == null || string3.trim().length() == 0) {
            string3 = bLContainer.getName();
        }
        string3 = DHTMLService.getInstance().getMetaNLSString(string3);
        Resource resource = new Resource(string3);
        BLNode[] bLNodeArray = bLContainer.getBLChildren();
        if (bLNodeArray != null && bLNodeArray.length > 0) {
            for (BLNode bLNode : bLNodeArray) {
                Resource resource2 = null;
                int n = bLNode.getElementType();
                switch (n) {
                    case 3: {
                        resource2 = Tools.addChild((BLContainer)bLNode, list, string, string2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        resource2 = Tools.append(bLNode, list);
                        break;
                    }
                }
                if (resource2 == null) continue;
                resource.addChild(resource2);
            }
        }
        if (resource.hasChildren()) {
            return resource;
        }
        return null;
    }

    private static Resource append(BLNode bLNode, List list) {
        Resource resource = Tools.buildTreeFromSameCub2(list, bLNode);
        if (resource == null) {
            return null;
        }
        int n = bLNode.getElementType();
        switch (n) {
            case 4: {
                resource.setResourceType(1);
                break;
            }
            case 5: {
                resource.setResourceType(2);
                break;
            }
            case 7: {
                resource.setResourceType(3);
                break;
            }
        }
        return resource;
    }

    private static Resource buildTreeFromSameCub2(List list, BLNode bLNode) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Resource resource = (Resource)list.get(i);
            if (bLNode != resource.getBLNode()) continue;
            return resource;
        }
        return null;
    }

    private static BLContainer children(Resource resource) {
        BLNode bLNode = resource.getBLNode();
        JUnifiedBusinessView jUnifiedBusinessView = bLNode.getUbv();
        return jUnifiedBusinessView;
    }

    public static Resource reBuildTreeFromConditionFormat(Resource resource, String string, String string2) {
        List list = resource.getChildren();
        LinkedList<Resource> linkedList = new LinkedList<Resource>();
        LinkedList<Resource> linkedList2 = new LinkedList<Resource>();
        for (int i = 0; i < list.size(); ++i) {
            Resource resource2 = (Resource)list.get(i);
            BLNode bLNode = resource2.getBLNode();
            if (bLNode == null) {
                linkedList.add(resource2);
                continue;
            }
            int n = resource2.get_DisplayName().getNameType();
            if (n == 6) {
                resource2.setResourceType(5);
                linkedList.add(resource2);
                continue;
            }
            if (n == 7) {
                resource2.setResourceType(6);
                linkedList.add(resource2);
                continue;
            }
            linkedList2.add(resource2);
        }
        Resource resource3 = null;
        resource3 = Tools.buildTreeFromSameCub2(linkedList2, string, string2);
        resource3.children.addAll(linkedList);
        return resource3;
    }

    public static void DBValuesToFilterValues(List list, List list2, String string, Locale locale, String string2) {
        DbValue dbValue = null;
        DbValueFormat dbValueFormat = null;
        for (int i = 0; i < list2.size(); ++i) {
            dbValue = (DbValue)list2.get(i);
            if (dbValue.isNull()) continue;
            if (i == 0 && string != null) {
                if (string.equals("")) {
                    dbValueFormat = null;
                } else {
                    int n = dbValue.getSqlType();
                    dbValueFormat = DataTools.makeDbValueFormat(n, string, locale);
                }
            }
            String[] stringArray = new String[]{dbValueFormat != null ? DataTools.format(dbValueFormat, dbValue, string2) : DataTools.parseValueToString(dbValue, string2), DataTools.parseValueToString(dbValue, null)};
            FilterValue filterValue = new FilterValue(stringArray[1], stringArray[0], "constant");
            if (stringArray[0] == null || stringArray[0].equals("")) {
                filterValue.setDisplay(filterValue.get());
            }
            list.add(filterValue);
        }
    }

    public static void AlertPromptMessage(Exception exception, Hashtable hashtable, Editor editor) {
        String string;
        if (exception instanceof JRException) {
            JRException jRException = (JRException)((Object)exception);
            int n = jRException.getErrorKey();
            Object[] objectArray = jRException.getParams();
            Locale locale = editor.getUILocale(null);
            string = JResource.getExceptionMessage((int)n, (Object[])objectArray, (Locale)locale);
            E.L("Query Filter Alert Prompt Message: errorKey:" + n + " ui locale toString:" + locale.toString() + "\n message:" + string + " locale.getLanguage():" + locale.getLanguage() + " locale.getCountry():" + locale.getCountry());
        } else {
            string = editor.getMessage(null, "31013002001");
        }
        hashtable.put("messsage", string);
        hashtable.put("targeturi", "scene/widget/alert.jsp");
    }
}

