/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.beans;

import com.jinfonet.web.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jet.webreport.beans.Atom;
import jet.webreport.util.Elem;
import jet.webreport.util.Lisp;

public final class Expression
implements Lisp,
Serializable {
    public static final transient String AND = "AND";
    public static final transient String OR = "OR";
    public static final transient String NOT = "NOT";
    public static final transient String EQUALS = "EQUALS";
    public static final transient String NOTEQUALS = "NOT EQUALS";
    public static final transient String MORETHAN = "MORE THAN";
    public static final transient String MORETHANEQUALS = "MORE THAN EQUALS";
    public static final transient String LESSTHAN = "LESS THAN";
    public static final transient String LESSTHANEQUALS = "LESS THAN EQUALS";
    public static final transient String IN = "IN";
    public static final transient String NOTIN = "NOT IN";
    public static final transient String LIKE = "LIKE";
    public static final transient String NOTLIKE = "NOT LIKE";
    public static final transient String BETWEEN = "BETWEEN";
    public static final transient String NOTBETWEEN = "NOT BETWEEN";
    public static final transient String ISNULL = "ISNULL";
    public static final transient String NOTISNULL = "NOT ISNULL";
    public static final transient String SORTBY = "SORTBY";
    public static final transient String ASCENDING = "ASCENDING";
    public static final transient String DESCENDING = "DESCENDING";
    public static final transient String ORIGINAL = "ORIGINAL";
    private static final transient HashMap SEDU = new HashMap();
    public static final transient char DELIMITER = ',';
    private static final long serialVersionUID = -2177639345198798031L;
    private String name;
    private List list;
    private static final transient String[] add;

    public Expression(String string) {
        this.name = string;
        this.list = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean atom() {
        return false;
    }

    @Override
    public boolean nil() {
        return this.list.isEmpty();
    }

    @Override
    public String value() {
        return null;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Elem get(int n) {
        return (Elem)this.list.get(n);
    }

    @Override
    public Lisp cons(Elem elem) {
        if (elem != null) {
            this.list.add(0, elem);
        }
        return this;
    }

    @Override
    public Lisp append(Elem elem) {
        if (elem != null) {
            this.list.add(elem);
        }
        return this;
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = Expression.toString(this, null);
        return stringBuffer.toString();
    }

    private static StringBuffer toString(Elem elem, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer = stringBuffer == null ? new StringBuffer() : stringBuffer;
        if (elem.atom()) {
            stringBuffer.append(elem.toString());
        } else {
            stringBuffer.append("[");
            Lisp lisp = (Lisp)elem;
            int n = lisp.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                Elem elem2 = lisp.get(i);
                Expression.toString(elem2, stringBuffer);
            }
            stringBuffer.append("]");
        }
        return stringBuffer;
    }

    public static Expression parseExpression(String string) {
        int n = string.indexOf(91);
        if (n != -1) {
            string = string.substring(n);
        }
        return Expression.SEDU(string, null);
    }

    private static Expression SEDU(String string, Expression expression) {
        if (!Expression.add(string = string.trim()) && !Expression.append(string)) {
            throw new IllegalArgumentException(string);
        }
        if (Expression.append(string)) {
            int n;
            String string2 = string.substring(1, string.length() - 1);
            int n2 = 0;
            if (string2.startsWith("T") && (n = string2.indexOf(":")) != -1 && string2.charAt(n + 1) == '\'') {
                n2 = Integer.parseInt(string2.substring(1, n));
                string2 = string2.substring(n + 1);
            }
            Atom atom = new Atom(string2);
            atom.setType(n2);
            expression.append(atom);
        } else {
            Expression expression2 = new Expression("");
            string = string.substring(1, string.length() - 1);
            List list = StringUtil.split((String)string, (char)',', (String[])add);
            for (String string3 : list) {
                Expression.SEDU(string3, expression2);
            }
            if (expression != null) {
                expression.append(expression2);
            } else {
                expression = expression2;
            }
        }
        return expression;
    }

    private static boolean add(String string) {
        return string.startsWith("[") && string.endsWith("]");
    }

    private static boolean append(String string) {
        return string.startsWith("\"") && string.endsWith("\"");
    }

    public static String getOperatorForHTML(String string) {
        return (String)SEDU.get(string);
    }

    static {
        SEDU.put(AND, AND);
        SEDU.put(OR, OR);
        SEDU.put(NOT, NOT);
        SEDU.put(EQUALS, "=");
        SEDU.put(NOTEQUALS, "!=");
        SEDU.put(MORETHAN, "&gt;");
        SEDU.put(MORETHANEQUALS, "&gt;=");
        SEDU.put(LESSTHAN, "&lt;");
        SEDU.put(LESSTHANEQUALS, "&lt;=");
        SEDU.put(IN, IN);
        SEDU.put(NOTIN, NOTIN);
        SEDU.put(LIKE, LIKE);
        SEDU.put(NOTLIKE, NOTLIKE);
        SEDU.put(BETWEEN, BETWEEN);
        SEDU.put(NOTBETWEEN, NOTBETWEEN);
        SEDU.put(ISNULL, ISNULL);
        SEDU.put(NOTISNULL, NOTISNULL);
        SEDU.put(SORTBY, SORTBY);
        SEDU.put(ASCENDING, ASCENDING);
        SEDU.put(DESCENDING, DESCENDING);
        add = new String[]{"\"", "\"", "[", "]"};
    }
}

