/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XMLUtil {
    public static final String XML_ENCODING = "xml.encoding";
    public static final String XML_INDENT = "xml.indent";
    public static final String ENCODING = System.getProperty("xml.encoding", "UTF-8");
    public static final boolean INDENT = Boolean.valueOf(System.getProperty("xml.indent", "false"));
    private static final boolean SEDU = false;
    private static final boolean append = true;

    public static Document newDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return document;
    }

    public static StringBuffer write(Document document, Properties properties) {
        properties = XMLUtil.initProperties(properties);
        StringBuffer stringBuffer = new StringBuffer("");
        XMLUtil.print(document, stringBuffer, 0, properties);
        return stringBuffer;
    }

    public static void write(Document document, String string, Properties properties) throws IOException {
        properties = XMLUtil.initProperties(properties);
        StringBuffer stringBuffer = XMLUtil.write(document, properties);
        String string2 = properties.getProperty(XML_ENCODING, ENCODING);
        XMLUtil.write(string, stringBuffer.toString(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String string, String string2, String string3) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(string)), string3));
            bufferedWriter.write(string2);
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void print(Node node, StringBuffer stringBuffer, int n, Properties properties) {
        if (node == null) {
            return;
        }
        String string = properties.getProperty(XML_ENCODING, ENCODING);
        boolean bl = Boolean.valueOf(properties.getProperty(XML_INDENT, Boolean.toString(INDENT)));
        boolean bl2 = true;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append(string).append("\"?>");
                XMLUtil.print(((Document)node).getDocumentElement(), stringBuffer, n, properties);
                break;
            }
            case 1: {
                stringBuffer.append("\r\n");
                if (bl) {
                    for (int i = 0; i < 4 * n; ++i) {
                        stringBuffer.append(' ');
                    }
                }
                stringBuffer.append("<");
                stringBuffer.append(node.getNodeName());
                Attr[] attrArray = XMLUtil.ENCODING(node.getAttributes());
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    stringBuffer.append(' ');
                    stringBuffer.append(attr.getNodeName());
                    stringBuffer.append("=\"");
                    stringBuffer.append(XMLUtil.normalize(attr.getNodeValue()));
                    stringBuffer.append('\"');
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null || nodeList.getLength() == 0) {
                    bl2 = false;
                    stringBuffer.append(' ').append("/>");
                    break;
                }
                stringBuffer.append('>');
                int n2 = nodeList.getLength();
                if (n2 == 1 && nodeList.item(0).getNodeType() == 3) {
                    XMLUtil.print(nodeList.item(0), stringBuffer, 0, properties);
                    stringBuffer.append("</");
                    stringBuffer.append(node.getNodeName());
                    stringBuffer.append('>');
                    bl2 = false;
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    XMLUtil.print(nodeList.item(i), stringBuffer, n + 1, properties);
                }
                break;
            }
            case 5: {
                stringBuffer.append('&');
                stringBuffer.append(node.getNodeName());
                stringBuffer.append(';');
                break;
            }
            case 4: {
                stringBuffer.append("\r\n<![CDATA[");
                stringBuffer.append(node.getNodeValue());
                stringBuffer.append("]]>");
                break;
            }
            case 3: {
                stringBuffer.append(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                stringBuffer.append("\r\n");
                if (bl) {
                    for (int i = 0; i < 4 * n; ++i) {
                        stringBuffer.append(' ');
                    }
                }
                stringBuffer.append("<?");
                stringBuffer.append(node.getNodeName());
                String string2 = node.getNodeValue();
                if (string2 != null && string2.length() > 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                }
                stringBuffer.append("?>");
                break;
            }
            case 8: {
                stringBuffer.append("\r\n");
                if (bl) {
                    for (int i = 0; i < 4 * n; ++i) {
                        stringBuffer.append(' ');
                    }
                }
                stringBuffer.append("<!-- ").append(node.getNodeValue()).append(" -->");
            }
        }
        if (bl2 && s == 1) {
            stringBuffer.append("\r\n");
            if (bl) {
                for (int i = 0; i < 4 * n; ++i) {
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append("</");
            stringBuffer.append(node.getNodeName());
            stringBuffer.append('>');
        }
    }

    private static Attr[] ENCODING(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = null;
            string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = null;
                string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Properties initProperties(Properties properties) {
        if (properties == null) {
            properties = new Properties();
            properties.setProperty(XML_ENCODING, ENCODING);
            properties.setProperty(XML_INDENT, Boolean.toString(INDENT));
        }
        return properties;
    }
}

