/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Servlet;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.servlets.RcServlet;
import jet.server.util.ServerUtil;
import server.servlet.ServletLoader;
import server.servlet.http.HttpAdminServerHandler;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServer;
import server.servlet.http.HttpServerBase;
import server.servlet.http.HttpServerHandlerBase;
import server.servlet.http.JRequestDispatcherImpl;
import server.servlet.http.ServiceHandler;

public class HttpAdminServer
extends HttpServerBase {
    private RcServlet I;
    private HttpServer ID_ADMINSERVER;
    private boolean ID_SERVER = false;

    public HttpAdminServer(ExProperties exProperties, HttpServer httpServer) {
        super(exProperties);
        this.serverProps = exProperties;
        this.ID_ADMINSERVER = httpServer;
        this.loadProperties();
        this.maxHandlers = 50;
        this.maxConnections = 80;
        this.mimeTypeTable = ServerEnv.getMimeTypeTable();
        this.shutdownTimeout = ServerEnv.getShutdownTimeout();
        this.htmlPath = ServerEnv.htmlPath;
        JRequestDispatcherImpl.useOldForwardMethod = ServerEnv.isUseOldForwardMethod();
        HttpResponse.outputEncoding = ServerEnv.getOutputEncoding();
    }

    public HttpAdminServer(ExProperties exProperties, HttpServer httpServer, boolean bl) {
        super(exProperties);
        this.serverProps = exProperties;
        this.ID_ADMINSERVER = httpServer;
        this.ID_SERVER = bl;
        this.loadProperties();
        this.maxHandlers = 50;
        this.maxConnections = 80;
        this.mimeTypeTable = ServerEnv.getMimeTypeTable();
        this.shutdownTimeout = ServerEnv.getShutdownTimeout();
        this.htmlPath = ServerEnv.htmlPath;
        JRequestDispatcherImpl.useOldForwardMethod = ServerEnv.isUseOldForwardMethod();
        HttpResponse.outputEncoding = ServerEnv.getOutputEncoding();
    }

    public void setServer(HttpServer httpServer) {
        this.ID_ADMINSERVER = httpServer;
    }

    public HttpServer getServer() {
        return this.ID_ADMINSERVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalOnly(boolean bl) {
        block23: {
            if (this.ID_SERVER == bl) {
                return;
            }
            this.ID_SERVER = bl;
            try {
                InetAddress inetAddress = InetAddress.getByName("127.0.0.1");
                if (bl) {
                    Object object;
                    int n;
                    for (int i = 0; i < this.serviceHandlers.size(); ++i) {
                        ServiceHandler serviceHandler = (ServiceHandler)this.serviceHandlers.elementAt(i);
                        if (serviceHandler.getHostAddr().equals(inetAddress)) continue;
                        try {
                            serviceHandler.serverSocket.close();
                            continue;
                        }
                        catch (IOException iOException) {
                            this.fireError(iOException);
                        }
                    }
                    Vector vector = this.sockets;
                    synchronized (vector) {
                        for (n = this.sockets.size() - 1; n >= 0; --n) {
                            object = (Socket)this.sockets.elementAt(n);
                            if (((Socket)object).getInetAddress().equals(inetAddress)) continue;
                            this.sockets.removeElementAt(n);
                            try {
                                ((Socket)object).close();
                                continue;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    vector = this.handlerThreads;
                    synchronized (vector) {
                        for (n = this.handlerThreads.size() - 1; n >= 0; --n) {
                            object = (HttpServerHandlerBase)this.handlerThreads.elementAt(n);
                            if (((HttpServerHandlerBase)object).socket == null || ((HttpServerHandlerBase)object).socket.getInetAddress().equals(inetAddress)) continue;
                            try {
                                ((HttpServerHandlerBase)object).socket.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.handlerThreads.removeElement(object);
                        }
                        break block23;
                    }
                }
                String string = "";
                int n = ServerEnv.getSocketTimeout() * 1000;
                for (int i = 0; i < this.hostAddrs.length; ++i) {
                    if (inetAddress.equals(this.hostAddrs[i])) continue;
                    ServiceHandler serviceHandler = null;
                    try {
                        serviceHandler = new ServiceHandler(this, this.getServicePort(), this.backlog, this.hostAddrs[i], n);
                        this.serviceHandlers.addElement(serviceHandler);
                        new Thread(this.serviceHandlerGroup, serviceHandler).start();
                    }
                    catch (IOException iOException) {
                        string = string + "FAILURE on starting service at address:" + this.hostAddrs[i] + " port:" + this.getServicePort() + ", Error:" + iOException.getMessage() + "\n";
                    }
                    if (serviceHandler == null) continue;
                    this.fireServiceStarted(serviceHandler, null);
                }
                if (!"".equals(string)) {
                    this.errMsg = new Exception(string);
                    this.fireError(this.errMsg);
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.fireError(unknownHostException);
            }
        }
    }

    public RcServlet getRcServlet() {
        return this.I;
    }

    public void loadProperties() {
        if (this.ID_SERVER) {
            this.hostAddrs = new InetAddress[1];
            try {
                this.hostAddrs[0] = InetAddress.getByName("127.0.0.1");
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("Unknown host address " + unknownHostException.getMessage());
            }
        } else {
            this.useAllHosts = this.serverProps.getProperty("httpserver.host.all", true);
            this.hostName = this.serverProps.getProperty("httpserver.host.name");
            if (this.hostName == null || this.hostName.trim().length() == 0) {
                this.hostName = "*";
            }
            if (this.useAllHosts || this.hostName.equals("*")) {
                try {
                    this.hostAddrs = ServerUtil.getAllLocalAddresses().toArray(new InetAddress[0]);
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host address " + unknownHostException.getMessage());
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.hostName, " \t;");
                Vector<InetAddress> vector = new Vector<InetAddress>();
                while (stringTokenizer.hasMoreElements()) {
                    String string = stringTokenizer.nextToken();
                    try {
                        InetAddress inetAddress = InetAddress.getByName(string);
                        if (!vector.contains(inetAddress)) {
                            vector.addElement(inetAddress);
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                        System.err.println("Unknown host address " + string);
                    }
                    this.hostAddrs = new InetAddress[vector.size()];
                    vector.copyInto(this.hostAddrs);
                }
            }
        }
        this.port = this.serverProps.getProperty("httpserver.port", this.port);
        this.adminport = this.serverProps.getProperty("httpserver.admin.port", 8889);
        this.secureAdminPort = this.serverProps.getProperty("httpserver.ssl.admin.port", 6889);
        this.backlog = this.serverProps.getProperty("httpserver.backlog", this.backlog);
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", this.maxHandlers);
        this.maxConnections = this.serverProps.getProperty("httpserver.max.connections", this.maxConnections);
        if (this.maxHandlers > this.maxConnections) {
            this.maxHandlers = this.maxConnections;
        }
        this.timeout = this.serverProps.getProperty("httpserver.timeout", this.timeout);
        this.name = this.serverProps.getProperty("httpserver.name", this.name);
        this.servletPropFile = this.serverProps.getProperty("httpserver.servlet.admin.propfile", System.getProperty("reporthome", ".") + File.separator + "bin" + File.separator + "admin.properties");
        this.loadServletProps();
    }

    @Override
    public void initLoader() {
        this.setAttribute(ServerEnv.ID_SERVER, this.ID_ADMINSERVER);
        this.setAttribute(ServerEnv.ID_ADMINSERVER, this);
        this.loader = new ServletLoader(".");
        if (this.autoStartedServlets != null) {
            for (int i = 0; i < this.autoStartedServlets.length; ++i) {
                Servlet servlet = this.getServletEx(this.autoStartedServlets[i]);
                if (!(servlet instanceof RcServlet)) continue;
                this.I = (RcServlet)servlet;
            }
        }
    }

    @Override
    protected int getServicePort() {
        return this.adminport;
    }

    @Override
    protected int getSecureServicePort() {
        return this.secureAdminPort;
    }

    @Override
    protected String getThreadGroupName() {
        return "Admin Service";
    }

    @Override
    public void startHandler() {
        HttpAdminServerHandler httpAdminServerHandler = new HttpAdminServerHandler(this);
        this.handlerThreads.addElement(httpAdminServerHandler);
        new Thread(this.handlers, httpAdminServerHandler).start();
    }
}

