/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.util.ServerUtil;
import server.servlet.http.HttpDashboardServerHandler;
import server.servlet.http.HttpServer;
import server.servlet.http.HttpServerBase;

public class HttpDashboardServer
extends HttpServerBase {
    private HttpServer I;

    public HttpDashboardServer(ExProperties exProperties, HttpServer httpServer) {
        super(exProperties);
        this.serverProps = exProperties;
        this.I();
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", 100);
        this.maxConnections = this.serverProps.getProperty("httpserver.max.connections", 150);
        if (this.maxHandlers > this.maxConnections) {
            this.maxHandlers = this.maxConnections;
        }
        this.mimeTypeTable = ServerEnv.getMimeTypeTable();
        this.shutdownTimeout = ServerEnv.getShutdownTimeout();
        this.htmlPath = ServerEnv.htmlPath;
        this.I = httpServer;
    }

    public void setServer(HttpServer httpServer) {
        this.I = httpServer;
    }

    public HttpServer getServer() {
        return this.I;
    }

    private void I() {
        this.useAllHosts = this.serverProps.getProperty("httpserver.host.all", true);
        this.hostName = this.serverProps.getProperty("httpserver.host.name");
        if (this.hostName == null || this.hostName.trim().length() == 0) {
            this.hostName = "*";
        }
        if (this.useAllHosts || this.hostName.equals("*")) {
            try {
                this.hostAddrs = ServerUtil.getAllLocalAddresses().toArray(new InetAddress[0]);
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("Unknown host address " + unknownHostException.getMessage());
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.hostName, " \t;");
            Vector<InetAddress> vector = new Vector<InetAddress>();
            while (stringTokenizer.hasMoreElements()) {
                String string = stringTokenizer.nextToken();
                try {
                    InetAddress inetAddress = InetAddress.getByName(string);
                    if (!vector.contains(inetAddress)) {
                        vector.addElement(inetAddress);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host address " + string);
                }
                this.hostAddrs = new InetAddress[vector.size()];
                vector.copyInto(this.hostAddrs);
            }
        }
        this.port = this.serverProps.getProperty("httpserver.dashboard.port", 8887);
        this.securePort = this.serverProps.getProperty("httpserver.ssl.dashboard.port", 6887);
        this.backlog = this.serverProps.getProperty("httpserver.backlog", this.backlog);
        this.maxHandlers = this.serverProps.getProperty("httpserver.max.handlers", this.maxHandlers);
        this.maxConnections = this.serverProps.getProperty("httpserver.max.connections", this.maxConnections);
        if (this.maxHandlers > this.maxConnections) {
            this.maxHandlers = this.maxConnections;
        }
        this.timeout = this.serverProps.getProperty("httpserver.timeout", this.timeout);
        this.name = this.serverProps.getProperty("httpserver.name", this.name);
    }

    @Override
    public void initLoader() {
    }

    @Override
    protected int getServicePort() {
        return this.port;
    }

    @Override
    protected int getSecureServicePort() {
        return this.securePort;
    }

    @Override
    protected String getThreadGroupName() {
        return "Dashboard Service";
    }

    @Override
    public void startHandler() {
        HttpDashboardServerHandler httpDashboardServerHandler = new HttpDashboardServerHandler(this, this.I);
        this.handlerThreads.addElement(httpDashboardServerHandler);
        Thread thread = new Thread(this.handlers, httpDashboardServerHandler);
        thread.start();
    }
}

