/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Observer;
import javax.servlet.ServletOutputStream;
import server.servlet.http.HttpDate;

public class HttpOutputStream
extends ServletOutputStream {
    private OutputStream DATELEN;
    protected byte[] buf;
    protected int count;
    protected int total;
    protected int limit;
    protected int length = 1;
    protected Observer obs;
    protected IOException except;
    protected boolean committed;
    protected int countedLength;
    private int SEDU;
    private boolean arraycopy = false;
    private boolean check = true;
    private boolean close = false;
    private ByteArrayOutputStream finish = new ByteArrayOutputStream();

    public void setLogging(boolean bl) {
        this.close = bl;
        this.finish.reset();
    }

    public byte[] getLog() {
        if (!this.close) {
            return null;
        }
        return this.finish.toByteArray();
    }

    public HttpOutputStream(int n) {
        this.buf = new byte[n];
        this.SEDU = n;
    }

    public HttpOutputStream() {
        this(4096);
    }

    public void init(OutputStream outputStream) throws IOException {
        this.initNewBuffer(outputStream, false);
    }

    public void initNewBuffer(OutputStream outputStream, boolean bl) throws IOException {
        this.DATELEN = outputStream;
        if (bl) {
            this.buf = new byte[this.SEDU];
        }
    }

    public void init(OutputStream outputStream, boolean bl) throws IOException {
        this.initNewBuffer(outputStream, false);
        this.arraycopy = true;
    }

    public void next() {
        this.count = 0;
        this.total = 0;
        this.limit = -1;
        this.length = -1;
        this.obs = null;
        this.committed = false;
        this.countedLength = 0;
        this.arraycopy = false;
        this.except = null;
    }

    public void finish() throws IOException {
        if (this.length == -1 && this.countedLength != 0) {
            this.length = this.countedLength;
        }
        this.flush();
    }

    public void resets() {
        this.DATELEN = null;
        this.obs = null;
        this.check = true;
        this.arraycopy = false;
    }

    public int getTotal() {
        return this.total;
    }

    public void setContentLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid content length");
        }
        this.length = n;
    }

    public void unsetContentLength() {
        this.check = false;
    }

    public int getContentLength() {
        return this.length;
    }

    public void setObserver(Observer observer) {
        this.obs = observer;
        this.limit = -1;
    }

    public void setIOException(IOException iOException) {
        this.except = iOException;
        this.limit = -1;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    protected void check(int n) throws IOException {
        if (this.except != null) {
            throw this.except;
        }
        if (n == 0) {
            return;
        }
        if (this.limit < 0) {
            if (this.total > 0) {
                throw new InternalError();
            }
            this.limit = Integer.MAX_VALUE;
            if (this.length != -1 && this.length < Integer.MAX_VALUE - this.total) {
                this.limit = this.total + this.length;
            }
        }
        if (this.check && this.total + n > this.limit) {
            this.limit = -1;
            this.except = new IOException("tried to write more than content length");
            throw this.except;
        }
    }

    public void write(int n) throws IOException {
        if (this.total >= this.limit) {
            this.check(1);
        }
        if (this.count == this.buf.length) {
            this.flushBytes();
        }
        this.buf[this.count++] = (byte)n;
        ++this.total;
        ++this.countedLength;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException();
        }
        if (this.total + n2 > this.limit) {
            this.check(n2);
        }
        if (n2 >= this.buf.length) {
            this.flushBytes();
            this.total += n2;
            this.writeOut(byArray, n, n2);
            return;
        }
        if (n2 > this.buf.length - this.count) {
            this.flushBytes();
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
        this.total += n2;
        this.countedLength += n2;
    }

    public void flush() throws IOException {
        if (this.limit >= 0) {
            this.check(0);
        }
        this.flushBytes();
    }

    protected void flushBytes() throws IOException {
        if (!this.committed && this.obs != null) {
            this.obs.update(null, (Object)this);
        }
        this.committed = true;
        if (this.count > 0) {
            this.writeOut(this.buf, 0, this.count);
            this.DATELEN.flush();
            this.count = 0;
        }
    }

    public void print(String string) throws IOException {
        int n = string.length();
        if (this.total + n > this.limit) {
            this.check(n);
        }
        int n2 = 0;
        while (n > 0) {
            byte[] byArray;
            int n3 = this.buf.length - this.count;
            if (n3 == 0) {
                this.flushBytes();
                n3 = this.buf.length - this.count;
            }
            if (n3 > n) {
                n3 = n;
            }
            try {
                byArray = string.getBytes("ISO-8859-1");
            }
            catch (Exception exception) {
                byArray = string.getBytes();
            }
            System.arraycopy(byArray, n2, this.buf, this.count, n3);
            this.count += n3;
            this.total += n3;
            n2 += n3;
            n -= n3;
            this.countedLength += n3;
        }
    }

    public void print(HttpDate httpDate) throws IOException {
        int n;
        int n2 = HttpDate.DATELEN;
        if (this.total + n2 > this.limit) {
            this.check(n2);
        }
        if ((n = this.buf.length - this.count) < n2) {
            this.flushBytes();
            n = this.buf.length - this.count;
        }
        n2 = httpDate.getBytes(this.buf, this.count, n);
        this.count += n2;
        this.total += n2;
    }

    public void close() throws IOException {
        this.finish();
        if (this.arraycopy) {
            try {
                this.DATELEN.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.arraycopy = false;
        }
    }

    public void setHeader(byte[] byArray) throws IOException {
        this.writeOut(byArray, 0, byArray.length);
    }

    public void setHeader(byte[] byArray, int n, int n2) throws IOException {
        this.writeOut(byArray, n, n2);
    }

    public void writeRaw(byte[] byArray, int n, int n2) throws IOException {
        if (!this.committed && this.obs != null) {
            this.obs.update(null, (Object)this);
        }
        this.committed = true;
        this.writeOut(byArray, n, n2);
        this.total += n2;
        this.countedLength += n2;
        if (this.limit < 0 && (this.limit = this.length) < 0) {
            this.limit = Integer.MAX_VALUE;
        }
    }

    protected void writeOut(byte[] byArray, int n, int n2) throws IOException {
        block3: {
            try {
                this.DATELEN.write(byArray, n, n2);
            }
            catch (SocketException socketException) {
                String string = socketException.getMessage();
                if (string == null || string.indexOf("reset by peer") >= 0 || string.indexOf("code=10053") >= 0 || string.indexOf("aborted by peer") >= 0 || string.indexOf("Broken pipe") >= 0 || string.indexOf("Software caused connection abort") >= 0) break block3;
                throw socketException;
            }
        }
        if (this.close) {
            this.finish.write(byArray, n, n2);
        }
    }
}

