/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import server.servlet.http.SessionContextImpl;

public class HttpSessionImpl
implements HttpSession {
    private String SEDU;
    private long currentTimeMillis;
    private long get;
    private Hashtable getValue = new Hashtable();
    private SessionContextImpl hasMoreElements;
    private boolean keys;
    private boolean nextElement;
    private boolean put;
    private Cookie putValue;
    private boolean remove;
    private boolean removeSession;
    private int removeValue;
    private ServletContext setSession;

    public HttpSessionImpl(SessionContextImpl sessionContextImpl, ServletContext servletContext, Cookie cookie) {
        this.get = this.currentTimeMillis = System.currentTimeMillis();
        this.hasMoreElements = sessionContextImpl;
        this.setSession = servletContext;
        this.keys = false;
        this.putValue = cookie;
        this.SEDU = sessionContextImpl.setSession(this);
        cookie.setValue(this.SEDU);
        this.remove = true;
        this.removeSession = true;
    }

    public void setNew(boolean bl) {
        this.remove = bl;
    }

    public void setCookieSupported(boolean bl) {
        this.keys = true;
        this.nextElement = bl;
    }

    public void setLastAccessedTime() {
        this.get = System.currentTimeMillis();
    }

    public Cookie getCookie() {
        return this.putValue;
    }

    public boolean isCookieSupportDetermined() {
        if (this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.keys;
    }

    public boolean isUsingCookies() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return true;
    }

    public boolean isNew() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.remove;
    }

    public boolean isUsingUrlRewriting() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return false;
    }

    public String getId() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.SEDU;
    }

    public HttpSessionContext getSessionContext() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.hasMoreElements;
    }

    public long getCreationTime() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.currentTimeMillis;
    }

    public long getLastAccessedTime() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.get;
    }

    public void invalidate() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        this.hasMoreElements.removeSession(this.SEDU);
        this.removeSession = false;
    }

    public void putValue(String string, Object object) {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        this.removeValue(string);
        this.getValue.put(string, object);
        if (object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public Object getValue(String string) {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.getValue.get(string);
    }

    public void removeValue(String string) {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        Object v = this.getValue.get(string);
        if (v != null) {
            this.getValue.remove(string);
        }
        if (v instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)v).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
        }
    }

    public String[] getValueNames() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        String[] stringArray = new String[this.getValue.size()];
        int n = 0;
        Enumeration enumeration = this.getValue.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public boolean isValid() {
        return this.removeSession;
    }

    public int getMaxInactiveInterval() {
        return this.removeValue;
    }

    public void setMaxInactiveInterval(int n) {
        this.removeValue = n;
    }

    public Object getAttribute(String string) {
        return this.getValue(string);
    }

    public Enumeration getAttributeNames() {
        if (!this.removeSession) {
            throw new IllegalStateException("Attempt to access an invalidated session");
        }
        return this.getValue.keys();
    }

    public void setAttribute(String string, Object object) {
        this.putValue(string, object);
    }

    public void removeAttribute(String string) {
        this.removeValue(string);
    }

    public ServletContext getServletContext() {
        return this.setSession;
    }
}

