/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import server.servlet.http.JRKeyManager;

public class JRServerSocketFactory {
    private boolean DEFAULT_SSL_KEYSTORE = false;
    protected SSLServerSocketFactory sslProxy = null;
    private static boolean SEDU = false;
    private static boolean accept = false;
    private static boolean addElement = false;
    protected KeyStore keyStore = null;
    private String append = null;
    private String close = null;
    private String copyInto = null;
    private String createServerSocket = null;
    private String equals = null;
    private String getDefaultCipherSuites = null;
    private String getInstance = null;
    private String getKeyManagers = null;
    private String getMessage = null;
    private ExProperties getProperty = new ExProperties();
    private static JRServerSocketFactory getSSLServerProps = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JRServerSocketFactory getInstance() throws IOException {
        Class<JRServerSocketFactory> clazz = JRServerSocketFactory.class;
        synchronized (JRServerSocketFactory.class) {
            if (getSSLServerProps == null) {
                getSSLServerProps = new JRServerSocketFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return getSSLServerProps;
        }
    }

    private JRServerSocketFactory() {
    }

    private void DEFAULT_SSL_KEYSTORE() throws IOException {
        if (!this.DEFAULT_SSL_KEYSTORE) {
            this.getProperty = ServerEnv.getSSLServerProps();
            this.append = this.getProperty.getProperty("httpserver.ssl.keystore", ServerEnv.DEFAULT_SSL_KEYSTORE);
            this.close = this.getProperty.getProperty("httpserver.ssl.keystore.password", "jinfonet");
            this.copyInto = this.getProperty.getProperty("httpserver.ssl.keystore.type", "JKS");
            this.createServerSocket = this.getProperty.getProperty("httpserver.ssl.truststore");
            this.equals = this.getProperty.getProperty("httpserver.ssl.truststore.password");
            this.getDefaultCipherSuites = this.getProperty.getProperty("httpserver.ssl.truststore.type", "JKS");
            this.getInstance = this.getProperty.getProperty("httpserver.ssl.algorithm", "sunx509");
            this.getKeyManagers = this.getProperty.getProperty("httpserver.ssl.protocol", "SSL");
            this.DEFAULT_SSL_KEYSTORE = true;
        }
        this.addElement();
    }

    private void SEDU(ServerSocket serverSocket) {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)serverSocket;
        String[] stringArray = sSLServerSocket.getSupportedCipherSuites();
        sSLServerSocket.setEnabledCipherSuites(stringArray);
    }

    public ServerSocket createSocket(int n, int n2, InetAddress inetAddress) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (this.sslProxy == null) {
            this.DEFAULT_SSL_KEYSTORE();
        }
        ServerSocket serverSocket = this.sslProxy.createServerSocket(n, n2, inetAddress);
        this.SEDU(serverSocket);
        return serverSocket;
    }

    private KeyStore accept(String string, String string2, String string3) throws IOException {
        KeyStore keyStore = null;
        InputStream inputStream = null;
        try {
            keyStore = KeyStore.getInstance(string);
            File file = new File(string2);
            inputStream = new FileInputStream(file);
            keyStore.load(inputStream, string3.toCharArray());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Exception trying to load keystore " + string2 + ": " + exception.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return keyStore;
    }

    private void addElement() throws IOException {
        try {
            KeyStore keyStore;
            SSLContext sSLContext = SSLContext.getInstance(this.getKeyManagers);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.getInstance);
            KeyStore keyStore2 = this.accept(this.copyInto, this.append, this.close);
            keyManagerFactory.init(keyStore2, this.close.toCharArray());
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            if (this.getMessage != null) {
                this.getMessage = this.getMessage.toLowerCase();
                for (int i = 0; i < keyManagerArray.length; ++i) {
                    keyManagerArray[i] = new JRKeyManager((X509KeyManager)keyManagerArray[i], this.getMessage);
                }
            }
            TrustManager[] trustManagerArray = null;
            if (this.createServerSocket != null && (keyStore = this.accept(this.getDefaultCipherSuites, this.createServerSocket, this.equals)) != null) {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.getInstance);
                trustManagerFactory.init(keyStore);
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            this.sslProxy = sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
    }

    public Socket acceptSocket(ServerSocket serverSocket) throws IOException {
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)serverSocket.accept();
        }
        catch (SSLException sSLException) {
            throw new SocketException("SSL handshake error" + sSLException.toString());
        }
        return sSLSocket;
    }

    public void handshake(Socket socket) throws IOException {
        ((SSLSocket)socket).startHandshake();
    }

    protected String[] getEnabledCiphers(String string, String[] stringArray) {
        Object[] objectArray = null;
        if (string != null) {
            int n;
            Vector<String> vector = null;
            String string2 = string;
            int n2 = string.indexOf(44);
            if (n2 != -1) {
                n = 0;
                while (n2 != -1) {
                    string2 = string.substring(n, n2).trim();
                    if (string2.length() > 0) {
                        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                            if (!stringArray[i].equals(string2)) continue;
                            if (vector == null) {
                                vector = new Vector();
                            }
                            vector.addElement(string2);
                            break;
                        }
                    }
                    n = n2 + 1;
                    n2 = string.indexOf(44, n);
                }
                string2 = string.substring(n);
            }
            if (string2 != null && (string2 = string2.trim()).length() > 0) {
                for (n = 0; stringArray != null && n < stringArray.length; ++n) {
                    if (!stringArray[n].equals(string2)) continue;
                    if (vector == null) {
                        vector = new Vector<String>();
                    }
                    vector.addElement(string2);
                    break;
                }
            }
            if (vector != null) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
        } else {
            objectArray = this.sslProxy.getDefaultCipherSuites();
        }
        return objectArray;
    }
}

