/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import jet.server.log.ServiceLogger;
import server.servlet.http.HttpSessionImpl;

public class SessionContextImpl
implements HttpSessionContext {
    private int SEDU;
    private InetAddress append;
    private byte[] arraycopy;
    private static final char[] convertSessionIdBytesToSessionId = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5'};
    private static final int[] currentTimeMillis = new int[]{0, 1, 3, 7, 31};
    private Hashtable digest = new Hashtable();
    private static final int generateSessionId = 28;

    public SessionContextImpl() {
        this.initializeSessionIdTemplate();
    }

    public HttpSession getSession(String string) {
        return (HttpSession)this.digest.get(string);
    }

    public Enumeration getIds() {
        return this.digest.keys();
    }

    public synchronized String setSession(HttpSessionImpl httpSessionImpl) {
        String string = this.generateSessionId();
        this.digest.put(string, httpSessionImpl);
        return string;
    }

    public void removeSession(String string) {
        if (this.getSession(string) != null) {
            this.digest.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getLocalHost() {
        if (this.append == null) {
            SessionContextImpl sessionContextImpl = this;
            synchronized (sessionContextImpl) {
                try {
                    this.append = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    try {
                        this.append = InetAddress.getByName("127.0.0.1");
                    }
                    catch (UnknownHostException unknownHostException2) {
                        // empty catch block
                    }
                }
            }
        }
        return this.append;
    }

    protected void initializeSessionIdTemplate() {
        this.arraycopy = new byte[14];
        byte[] byArray = String.valueOf(System.currentTimeMillis()).getBytes();
        int n = byArray.length - 1;
        for (int i = this.arraycopy.length - 1; n >= 0 && i >= 0; --n, --i) {
            this.arraycopy[i] = byArray[n];
        }
        n = 8;
        byte[] byArray2 = this.getLocalHost().getAddress();
        this.arraycopy[2] = byArray2[0];
        this.arraycopy[4] = byArray2[1];
        this.arraycopy[7] = byArray2[2];
        this.arraycopy[12] = byArray2[3];
        System.arraycopy(byArray2, 0, this.arraycopy, n, 4);
    }

    synchronized int generateSessionIdCount() {
        return this.SEDU++;
    }

    String generateSessionId() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[28];
        secureRandom.nextBytes(byArray);
        try {
            byArray = this.append().digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ServiceLogger.logError(noSuchAlgorithmException);
            return this.oldGenerateSessionId();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = (byte)((byArray[i] & 0xF0) >> 4);
            byte by2 = (byte)(byArray[i] & 0xF);
            stringBuffer.append(this.SEDU(by));
            stringBuffer.append(this.SEDU(by2));
        }
        return stringBuffer.toString();
    }

    private char SEDU(byte by) {
        if (by < 10) {
            return (char)(48 + by);
        }
        return (char)(65 + (by - 10));
    }

    private MessageDigest append() throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        return messageDigest;
    }

    String oldGenerateSessionId() {
        byte[] byArray = new byte[this.arraycopy.length];
        System.arraycopy(this.arraycopy, 0, byArray, 0, this.arraycopy.length);
        int n = this.generateSessionIdCount();
        long l = System.currentTimeMillis();
        long l2 = l * 39L * (long)n;
        int n2 = n * 379;
        int n3 = (int)(l2 >> 32);
        int n4 = (int)(l2 & Integer.MAX_VALUE);
        byArray[0] = (byte)(n2 >> 0 & 0xFF);
        byArray[1] = (byte)(n3 >> 24 & 0xFF);
        byArray[3] = (byte)(n4 >> 0 & 0xFF);
        byArray[5] = (byte)(n3 >> 16 & 0xFF);
        byArray[6] = (byte)(n4 >> 8 & 0xFF);
        byArray[8] = (byte)(n3 >> 8 & 0xFF);
        byArray[9] = (byte)(n4 >> 16 & 0xFF);
        byArray[10] = (byte)(n3 >> 0 & 0xFF);
        byArray[11] = (byte)(n2 >> 8 & 0xFF);
        byArray[13] = (byte)(n4 >> 24 & 0xFF);
        String string = String.valueOf(l);
        return this.convertSessionIdBytesToSessionId(byArray) + (string.length() > 4 ? string.substring(string.length() - 4) : string);
    }

    String convertSessionIdBytesToSessionId(byte[] byArray) {
        int n = byArray.length * 8;
        int n2 = n / 5;
        if (n % 5 != 0) {
            ++n2;
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < byArray.length) {
            int n6 = 0;
            if (n4 <= 3) {
                n6 = byArray[n3] >> 3 - n4 & 0x1F;
            } else {
                n6 = byArray[n3] << 5 - (8 - n4);
                if (n3 + 1 < byArray.length) {
                    int n7 = byArray[n3 + 1] >> 8 - (5 - (8 - n4));
                    n6 |= (n7 &= currentTimeMillis[5 - (8 - n4)]);
                }
                n6 &= 0x1F;
            }
            cArray[n5++] = convertSessionIdBytesToSessionId[n6];
            if ((n4 += 5) < 8) continue;
            ++n3;
            n4 -= 8;
        }
        return new String(cArray);
    }
}

